/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.ActionContainerFactory;
import org.jdesktop.swingx.plaf.ColumnControlButtonAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.table.ColumnControlPopup;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnControlButton
extends JButton {
    public static final String COLUMN_CONTROL_MARKER = "column.";
    public static final String COLUMN_CONTROL_BUTTON_ICON_KEY = "ColumnControlButton.actionIcon";
    public static final String COLUMN_CONTROL_BUTTON_MARGIN_KEY = "ColumnControlButton.margin";
    protected ColumnControlPopup popup;
    private JXTable table;
    private PropertyChangeListener tablePropertyChangeListener;
    TableColumnModelListener columnModelListener;
    private List<ColumnVisibilityAction> columnVisibilityActions;

    public ColumnControlButton(JXTable jXTable) {
        this(jXTable, null);
    }

    public ColumnControlButton(JXTable jXTable, Icon icon) {
        this.init();
        this.setAction(this.createControlAction(icon));
        this.updateActionUI();
        this.updateButtonUI();
        this.installTable(jXTable);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateActionUI();
        this.updateButtonUI();
        this.getColumnControlPopup().updateUI();
    }

    protected void updateButtonUI() {
        if (this.getMargin() == null || this.getMargin() instanceof UIResource) {
            Insets insets = UIManager.getInsets(COLUMN_CONTROL_BUTTON_MARGIN_KEY);
            this.setMargin(insets);
        }
    }

    protected void updateActionUI() {
        if (this.getAction() == null) {
            return;
        }
        Icon icon = (Icon)this.getAction().getValue("SmallIcon");
        if (icon == null || icon instanceof UIResource) {
            icon = UIManager.getIcon(COLUMN_CONTROL_BUTTON_ICON_KEY);
            this.getAction().putValue("SmallIcon", icon);
        }
    }

    public void togglePopup() {
        this.getColumnControlPopup().toggleVisibility(this);
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        super.applyComponentOrientation(componentOrientation);
        this.getColumnControlPopup().applyComponentOrientation(componentOrientation);
    }

    protected ColumnControlPopup getColumnControlPopup() {
        if (this.popup == null) {
            this.popup = this.createColumnControlPopup();
        }
        return this.popup;
    }

    protected ColumnControlPopup createColumnControlPopup() {
        return new DefaultColumnControlPopup();
    }

    protected void updateFromColumnModelChange(TableColumnModel tableColumnModel) {
        if (tableColumnModel != null) {
            tableColumnModel.removeColumnModelListener(this.columnModelListener);
        }
        this.populatePopup();
        if (this.canControl()) {
            this.table.getColumnModel().addColumnModelListener(this.getColumnModelListener());
        }
    }

    protected void updateFromTableEnabledChanged() {
        this.getAction().setEnabled(this.table.isEnabled());
    }

    protected boolean canControl() {
        return this.table.getColumnModel() instanceof TableColumnModelExt;
    }

    protected void populatePopup() {
        this.clearAll();
        if (this.canControl()) {
            this.createVisibilityActions();
            this.addVisibilityActionItems();
        }
        this.addAdditionalActionItems();
    }

    protected void clearAll() {
        this.clearColumnVisibilityActions();
        this.getColumnControlPopup().removeAll();
    }

    protected void clearColumnVisibilityActions() {
        if (this.columnVisibilityActions == null) {
            return;
        }
        for (ColumnVisibilityAction columnVisibilityAction : this.columnVisibilityActions) {
            columnVisibilityAction.releaseColumn();
        }
        this.columnVisibilityActions.clear();
    }

    protected void addVisibilityActionItems() {
        this.getColumnControlPopup().addVisibilityActionItems(Collections.unmodifiableList(this.getColumnVisibilityActions()));
    }

    protected void addAdditionalActionItems() {
        this.getColumnControlPopup().addAdditionalActionItems(Collections.unmodifiableList(this.getAdditionalActions()));
    }

    protected void createVisibilityActions() {
        List<TableColumn> list = this.table.getColumns(true);
        for (TableColumn tableColumn : list) {
            ColumnVisibilityAction columnVisibilityAction = this.createColumnVisibilityAction(tableColumn);
            if (columnVisibilityAction == null) continue;
            this.getColumnVisibilityActions().add(columnVisibilityAction);
        }
    }

    protected ColumnVisibilityAction createColumnVisibilityAction(TableColumn tableColumn) {
        return new ColumnVisibilityAction(tableColumn);
    }

    protected List<ColumnVisibilityAction> getColumnVisibilityActions() {
        if (this.columnVisibilityActions == null) {
            this.columnVisibilityActions = new ArrayList<ColumnVisibilityAction>();
        }
        return this.columnVisibilityActions;
    }

    protected List<Action> getAdditionalActions() {
        List list = this.getColumnControlActionKeys();
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (Object e : list) {
            arrayList.add(this.table.getActionMap().get(e));
        }
        return arrayList;
    }

    protected List getColumnControlActionKeys() {
        Object[] objectArray = this.table.getActionMap().allKeys();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.isColumnControlActionKey(objectArray[i])) continue;
            arrayList.add(objectArray[i]);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    protected boolean isColumnControlActionKey(Object object) {
        return object instanceof String && ((String)object).startsWith(COLUMN_CONTROL_MARKER);
    }

    private void installTable(JXTable jXTable) {
        this.table = jXTable;
        jXTable.addPropertyChangeListener(this.getTablePropertyChangeListener());
        this.updateFromColumnModelChange(null);
        this.updateFromTableEnabledChanged();
    }

    private void init() {
        this.setFocusPainted(false);
        this.setFocusable(false);
        JComboBox jComboBox = new JComboBox();
        Object object = jComboBox.getClientProperty("doNotCancelPopup");
        this.putClientProperty("doNotCancelPopup", object);
    }

    private Action createControlAction(Icon icon) {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColumnControlButton.this.togglePopup();
            }
        };
        abstractAction.putValue("SmallIcon", icon);
        return abstractAction;
    }

    protected PropertyChangeListener getTablePropertyChangeListener() {
        if (this.tablePropertyChangeListener == null) {
            this.tablePropertyChangeListener = this.createTablePropertyChangeListener();
        }
        return this.tablePropertyChangeListener;
    }

    protected PropertyChangeListener createTablePropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("columnModel".equals(propertyChangeEvent.getPropertyName())) {
                    ColumnControlButton.this.updateFromColumnModelChange((TableColumnModel)propertyChangeEvent.getOldValue());
                } else if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                    ColumnControlButton.this.updateFromTableEnabledChanged();
                }
            }
        };
    }

    protected TableColumnModelListener getColumnModelListener() {
        if (this.columnModelListener == null) {
            this.columnModelListener = this.createColumnModelListener();
        }
        return this.columnModelListener;
    }

    protected TableColumnModelListener createColumnModelListener() {
        return new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                if (!this.isVisibilityChange(tableColumnModelEvent, true)) {
                    ColumnControlButton.this.populatePopup();
                }
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                if (!this.isVisibilityChange(tableColumnModelEvent, false)) {
                    ColumnControlButton.this.populatePopup();
                }
            }

            private boolean isVisibilityChange(TableColumnModelEvent tableColumnModelEvent, boolean bl) {
                if (!(tableColumnModelEvent.getSource() instanceof DefaultTableColumnModelExt)) {
                    return false;
                }
                DefaultTableColumnModelExt defaultTableColumnModelExt = (DefaultTableColumnModelExt)tableColumnModelEvent.getSource();
                if (bl) {
                    return defaultTableColumnModelExt.isAddedFromInvisibleEvent(tableColumnModelEvent.getToIndex());
                }
                return defaultTableColumnModelExt.isRemovedToInvisibleEvent(tableColumnModelEvent.getFromIndex());
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        };
    }

    static {
        LookAndFeelAddons.contribute(new ColumnControlButtonAddon());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DefaultColumnControlPopup
    implements ColumnControlPopup {
        private JPopupMenu popupMenu;

        @Override
        public void updateUI() {
            SwingUtilities.updateComponentTreeUI(this.getPopupMenu());
        }

        @Override
        public void toggleVisibility(JComponent jComponent) {
            JPopupMenu jPopupMenu = this.getPopupMenu();
            if (jPopupMenu.isVisible()) {
                jPopupMenu.setVisible(false);
            } else if (jPopupMenu.getComponentCount() > 0) {
                Dimension dimension = jComponent.getSize();
                int n = jComponent.getComponentOrientation().isLeftToRight() ? dimension.width - jPopupMenu.getPreferredSize().width : 0;
                jPopupMenu.show(jComponent, n, dimension.height);
            }
        }

        @Override
        public void applyComponentOrientation(ComponentOrientation componentOrientation) {
            this.getPopupMenu().applyComponentOrientation(componentOrientation);
        }

        @Override
        public void removeAll() {
            this.getPopupMenu().removeAll();
        }

        @Override
        public void addVisibilityActionItems(List<? extends AbstractActionExt> list) {
            this.addItems(new ArrayList<AbstractActionExt>(list));
        }

        @Override
        public void addAdditionalActionItems(List<? extends Action> list) {
            if (list.size() == 0) {
                return;
            }
            if (ColumnControlButton.this.canControl()) {
                this.addSeparator();
            }
            this.addItems(list);
        }

        protected void addItems(List<? extends Action> list) {
            ActionContainerFactory actionContainerFactory = new ActionContainerFactory(null);
            for (Action action : list) {
                this.addItem(actionContainerFactory.createMenuItem(action));
            }
        }

        protected void addSeparator() {
            this.getPopupMenu().addSeparator();
        }

        protected void addItem(JMenuItem jMenuItem) {
            this.getPopupMenu().add(jMenuItem);
        }

        protected JPopupMenu getPopupMenu() {
            if (this.popupMenu == null) {
                this.popupMenu = new JPopupMenu();
            }
            return this.popupMenu;
        }
    }

    public class ColumnVisibilityAction
    extends AbstractActionExt {
        private TableColumn column;
        private PropertyChangeListener columnListener;
        private boolean fromColumn;

        public ColumnVisibilityAction(TableColumn tableColumn) {
            super((String)null);
            this.setStateAction();
            this.installColumn(tableColumn);
        }

        public void releaseColumn() {
            this.column.removePropertyChangeListener(this.columnListener);
            this.column = null;
        }

        public boolean isEnabled() {
            return super.isEnabled() && this.canControlColumn();
        }

        protected boolean canControlColumn() {
            return this.column instanceof TableColumnExt;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (this.canControlColumn()) {
                if (itemEvent.getStateChange() == 2 && ColumnControlButton.this.table.getColumnCount() <= 1 && !this.fromColumn) {
                    this.reselect();
                } else {
                    this.setSelected(itemEvent.getStateChange() == 1);
                }
            }
        }

        public synchronized void setSelected(boolean bl) {
            super.setSelected(bl);
            if (this.canControlColumn()) {
                ((TableColumnExt)this.column).setVisible(bl);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        private void updateFromColumnVisible(boolean bl) {
            this.fromColumn = true;
            this.setSelected(bl);
            this.fromColumn = false;
        }

        private void updateFromColumnHeader(Object object) {
            this.setName(String.valueOf(object));
        }

        private void reselect() {
            this.firePropertyChange("selected", null, Boolean.TRUE);
        }

        private void installColumn(TableColumn tableColumn) {
            this.column = tableColumn;
            tableColumn.addPropertyChangeListener(this.getColumnListener());
            this.updateFromColumnHeader(tableColumn.getHeaderValue());
            if (tableColumn.getIdentifier() != null) {
                this.setActionCommand(tableColumn.getIdentifier().toString());
            }
            boolean bl = tableColumn instanceof TableColumnExt ? ((TableColumnExt)tableColumn).isVisible() : true;
            this.updateFromColumnVisible(bl);
        }

        protected PropertyChangeListener getColumnListener() {
            if (this.columnListener == null) {
                this.columnListener = this.createPropertyChangeListener();
            }
            return this.columnListener;
        }

        protected PropertyChangeListener createPropertyChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("visible".equals(propertyChangeEvent.getPropertyName())) {
                        ColumnVisibilityAction.this.updateFromColumnVisible((Boolean)propertyChangeEvent.getNewValue());
                    } else if ("headerValue".equals(propertyChangeEvent.getPropertyName())) {
                        ColumnVisibilityAction.this.updateFromColumnHeader(propertyChangeEvent.getNewValue());
                    }
                }
            };
        }
    }
}

