/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.sort;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import org.jdesktop.swingx.sort.SortController;
import org.jdesktop.swingx.sort.SortUtils;
import org.jdesktop.swingx.sort.StringValueProvider;
import org.jdesktop.swingx.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableSortController<M extends TableModel>
extends TableRowSorter<M>
implements SortController<M, Integer> {
    private static final SortOrder[] DEFAULT_CYCLE = new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING};
    private List<SortOrder> sortCycle;
    private boolean sortable;
    private StringValueProvider stringValueProvider;

    public TableSortController() {
        this(null);
    }

    public TableSortController(M m) {
        super(m);
        this.setSortable(true);
        this.setSortOrderCycle(DEFAULT_CYCLE);
        this.setSortsOnUpdates(true);
    }

    @Override
    public void setSortable(boolean bl) {
        this.sortable = bl;
    }

    @Override
    public boolean isSortable() {
        return this.sortable;
    }

    @Override
    public void setSortable(int n, boolean bl) {
        super.setSortable(n, bl);
    }

    @Override
    public boolean isSortable(int n) {
        if (!this.isSortable()) {
            return false;
        }
        return super.isSortable(n);
    }

    @Override
    public void toggleSortOrder(int n) {
        RowSorter.SortKey sortKey;
        this.checkColumn(n);
        if (!this.isSortable(n)) {
            return;
        }
        SortOrder sortOrder = this.getFirstInCycle();
        if (sortOrder == null) {
            return;
        }
        List<RowSorter.SortKey> list = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
        if (list.indexOf(sortKey = SortUtils.getFirstSortKeyForColumn(list, n)) == 0) {
            list.set(0, new RowSorter.SortKey(n, this.getNextInCycle(sortKey.getSortOrder())));
        } else {
            list.remove(sortKey);
            list.add(0, new RowSorter.SortKey(n, this.getFirstInCycle()));
        }
        if (list.size() > this.getMaxSortKeys()) {
            list = list.subList(0, this.getMaxSortKeys());
        }
        this.setSortKeys(list);
    }

    private SortOrder getNextInCycle(SortOrder sortOrder) {
        int n = this.sortCycle.indexOf((Object)sortOrder);
        if (n < 0) {
            return this.getFirstInCycle();
        }
        if (++n >= this.sortCycle.size()) {
            n = 0;
        }
        return this.sortCycle.get(n);
    }

    private SortOrder getFirstInCycle() {
        return this.sortCycle.size() > 0 ? this.sortCycle.get(0) : null;
    }

    private void checkColumn(int n) {
        if (n < 0 || n >= this.getModelWrapper().getColumnCount()) {
            throw new IndexOutOfBoundsException("column beyond range of TableModel");
        }
    }

    @Override
    public void setSortOrder(int n, SortOrder sortOrder) {
        if (!this.isSortable(n)) {
            return;
        }
        RowSorter.SortKey sortKey = new RowSorter.SortKey(n, sortOrder);
        ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
        SortUtils.removeFirstSortKeyForColumn(arrayList, n);
        arrayList.add(0, sortKey);
        this.setSortKeys(arrayList);
    }

    @Override
    public SortOrder getSortOrder(int n) {
        RowSorter.SortKey sortKey = SortUtils.getFirstSortKeyForColumn(this.getSortKeys(), n);
        return sortKey != null ? sortKey.getSortOrder() : SortOrder.UNSORTED;
    }

    @Override
    public void resetSortOrders() {
        if (!this.isSortable()) {
            return;
        }
        ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            RowSorter.SortKey sortKey = (RowSorter.SortKey)arrayList.get(i);
            if (!this.isSortable(sortKey.getColumn())) continue;
            arrayList.remove(sortKey);
        }
        this.setSortKeys(arrayList);
    }

    @Override
    public SortOrder[] getSortOrderCycle() {
        return this.sortCycle.toArray(new SortOrder[0]);
    }

    @Override
    public void setSortOrderCycle(SortOrder ... sortOrderArray) {
        Contract.asNotNull(sortOrderArray, "Elements of SortOrderCycle must not be null");
        this.sortCycle = Arrays.asList(sortOrderArray);
    }

    @Override
    public void setStringValueProvider(StringValueProvider stringValueProvider) {
        this.stringValueProvider = stringValueProvider;
        this.updateStringConverter();
    }

    @Override
    public StringValueProvider getStringValueProvider() {
        return this.stringValueProvider;
    }

    private void updateStringConverter() {
        StringValueBasedConverter stringValueBasedConverter = null;
        if (this.stringValueProvider != null) {
            stringValueBasedConverter = new StringValueBasedConverter();
        }
        this.setStringConverter(stringValueBasedConverter);
    }

    private class StringValueBasedConverter
    extends TableStringConverter {
        private StringValueBasedConverter() {
        }

        public String toString(TableModel tableModel, int n, int n2) {
            return TableSortController.this.stringValueProvider.getStringValue(n, n2).getString(tableModel.getValueAt(n, n2));
        }
    }
}

