/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.sort;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.RowFilter;
import org.jdesktop.swingx.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowFilters {
    public static <M, I> RowFilter<M, I> regexFilter(String string, int ... nArray) {
        return RowFilters.regexFilter(0, string, nArray);
    }

    public static <M, I> RowFilter<M, I> regexFilter(int n, String string, int ... nArray) {
        return RowFilters.regexFilter(Pattern.compile(string, n), nArray);
    }

    public static <M, I> RowFilter<M, I> regexFilter(Pattern pattern, int ... nArray) {
        return new RegexFilter(pattern, nArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegexFilter
    extends GeneralFilter {
        private Matcher matcher;

        RegexFilter(Pattern pattern, int[] nArray) {
            super(nArray);
            if (pattern == null) {
                Contract.asNotNull(pattern, "Pattern must be non-null");
            }
            this.matcher = pattern.matcher("");
        }

        @Override
        protected boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry, int n) {
            this.matcher.reset(entry.getStringValue(n));
            return this.matcher.find();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class GeneralFilter
    extends RowFilter<Object, Object> {
        private int[] columns;

        protected GeneralFilter(int[] nArray) {
            this.checkIndices(nArray);
            this.columns = nArray;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry) {
            int n = entry.getValueCount();
            if (this.columns.length > 0) {
                for (int i = this.columns.length - 1; i >= 0; --i) {
                    int n2 = this.columns[i];
                    if (n2 >= n || !this.include(entry, n2)) continue;
                    return true;
                }
            } else {
                while (--n >= 0) {
                    if (!this.include(entry, n)) continue;
                    return true;
                }
            }
            return false;
        }

        protected abstract boolean include(RowFilter.Entry<? extends Object, ? extends Object> var1, int var2);

        protected void checkIndices(int[] nArray) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] >= 0) continue;
                throw new IllegalArgumentException("Index must be >= 0");
            }
        }
    }
}

