/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.search;

import java.awt.Rectangle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.search.AbstractSearchable;

public class TableSearchable
extends AbstractSearchable {
    protected JXTable table;

    public TableSearchable(JXTable jXTable) {
        this.table = jXTable;
    }

    protected void findMatchAndUpdateState(Pattern pattern, int n, boolean bl) {
        AbstractSearchable.SearchResult searchResult = null;
        if (bl) {
            for (int i = n; i >= -1 && searchResult == null; --i) {
                searchResult = this.findMatchBackwardsInRow(pattern, i);
                this.updateState(searchResult);
            }
        } else {
            for (int i = n; i <= this.getSize() && searchResult == null; ++i) {
                searchResult = this.findMatchForwardInRow(pattern, i);
                this.updateState(searchResult);
            }
        }
    }

    protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int n) {
        return this.findMatchAt(pattern, n, this.lastSearchResult.foundColumn);
    }

    private AbstractSearchable.SearchResult findMatchForwardInRow(Pattern pattern, int n) {
        int n2;
        int n3 = n2 = this.lastSearchResult.foundColumn < 0 ? 0 : this.lastSearchResult.foundColumn;
        if (this.isValidIndex(n)) {
            for (int i = n2; i < this.table.getColumnCount(); ++i) {
                AbstractSearchable.SearchResult searchResult = this.findMatchAt(pattern, n, i);
                if (searchResult == null) continue;
                return searchResult;
            }
        }
        return null;
    }

    private AbstractSearchable.SearchResult findMatchBackwardsInRow(Pattern pattern, int n) {
        int n2;
        int n3 = n2 = this.lastSearchResult.foundColumn < 0 ? this.table.getColumnCount() - 1 : this.lastSearchResult.foundColumn;
        if (this.isValidIndex(n)) {
            for (int i = n2; i >= 0; --i) {
                AbstractSearchable.SearchResult searchResult = this.findMatchAt(pattern, n, i);
                if (searchResult == null) continue;
                return searchResult;
            }
        }
        return null;
    }

    protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int n, int n2) {
        Matcher matcher;
        String string = this.table.getStringAt(n, n2);
        if (string != null && string.length() > 0 && (matcher = pattern.matcher(string)).find()) {
            return this.createSearchResult(matcher, n, n2);
        }
        return null;
    }

    protected int adjustStartPosition(int n, boolean bl) {
        this.lastSearchResult.foundColumn = -1;
        return super.adjustStartPosition(n, bl);
    }

    protected int moveStartPosition(int n, boolean bl) {
        if (bl) {
            --this.lastSearchResult.foundColumn;
            if (this.lastSearchResult.foundColumn < 0) {
                --n;
            }
        } else {
            ++this.lastSearchResult.foundColumn;
            if (this.lastSearchResult.foundColumn >= this.table.getColumnCount()) {
                this.lastSearchResult.foundColumn = -1;
                ++n;
            }
        }
        return n;
    }

    protected boolean isEqualStartIndex(int n) {
        return super.isEqualStartIndex(n) && this.isValidColumn(this.lastSearchResult.foundColumn);
    }

    private boolean isValidColumn(int n) {
        return n >= 0 && n < this.table.getColumnCount();
    }

    protected int getSize() {
        return this.table.getRowCount();
    }

    public JXTable getTarget() {
        return this.table;
    }

    protected void moveMatchByHighlighter() {
        AbstractHighlighter abstractHighlighter = this.getConfiguredMatchHighlighter();
        if (!this.hasMatch()) {
            return;
        }
        this.ensureInsertedSearchHighlighters(abstractHighlighter);
        this.table.scrollCellToVisible(this.lastSearchResult.foundRow, this.lastSearchResult.foundColumn);
    }

    protected int convertColumnIndexToModel(int n) {
        return this.getTarget().convertColumnIndexToModel(n);
    }

    protected void moveMatchBySelection() {
        Rectangle rectangle;
        if (!this.hasMatch()) {
            return;
        }
        int n = this.lastSearchResult.foundRow;
        int n2 = this.lastSearchResult.foundColumn;
        this.table.changeSelection(n, n2, false, false);
        if (!this.table.getAutoscrolls() && (rectangle = this.table.getCellRect(n, n2, true)) != null) {
            this.table.scrollRectToVisible(rectangle);
        }
    }

    protected void moveMatchMarker() {
        if (this.markByHighlighter()) {
            this.moveMatchByHighlighter();
        } else {
            this.moveMatchBySelection();
        }
    }

    protected void removeHighlighter(Highlighter highlighter) {
        this.table.removeHighlighter(highlighter);
    }

    protected Highlighter[] getHighlighters() {
        return this.table.getHighlighters();
    }

    protected void addHighlighter(Highlighter highlighter) {
        this.table.addHighlighter(highlighter);
    }
}

