/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.rollover;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.rollover.RolloverController;
import org.jdesktop.swingx.rollover.RolloverRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRolloverController<T extends JTable>
extends RolloverController<T> {
    private Cursor oldCursor;

    @Override
    protected void rollover(Point point, Point point2) {
        Rectangle rectangle;
        if (point != null) {
            rectangle = ((JTable)this.component).getCellRect(point.y, point.x, false);
            rectangle.x = 0;
            rectangle.width = ((JTable)this.component).getWidth();
            ((JTable)this.component).repaint(rectangle);
        }
        if (point2 != null) {
            rectangle = ((JTable)this.component).getCellRect(point2.y, point2.x, false);
            rectangle.x = 0;
            rectangle.width = ((JTable)this.component).getWidth();
            ((JTable)this.component).repaint(rectangle);
        }
        this.setRolloverCursor(point2);
    }

    @Override
    protected boolean isClickable(Point point) {
        return super.isClickable(point) && !((JTable)this.component).isCellEditable(point.y, point.x);
    }

    @Override
    protected RolloverRenderer getRolloverRenderer(Point point, boolean bl) {
        RolloverRenderer rolloverRenderer;
        TableCellRenderer tableCellRenderer = ((JTable)this.component).getCellRenderer(point.y, point.x);
        RolloverRenderer rolloverRenderer2 = rolloverRenderer = tableCellRenderer instanceof RolloverRenderer ? (RolloverRenderer)((Object)tableCellRenderer) : null;
        if (rolloverRenderer != null && !rolloverRenderer.isEnabled()) {
            rolloverRenderer = null;
        }
        if (rolloverRenderer != null && bl) {
            ((JTable)this.component).prepareRenderer(tableCellRenderer, point.y, point.x);
        }
        return rolloverRenderer;
    }

    private void setRolloverCursor(Point point) {
        if (this.hasRollover(point)) {
            if (this.oldCursor == null) {
                this.oldCursor = ((JTable)this.component).getCursor();
                ((JTable)this.component).setCursor(Cursor.getPredefinedCursor(12));
            }
        } else if (this.oldCursor != null) {
            ((JTable)this.component).setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    @Override
    protected Point getFocusedCell() {
        int n = ((JTable)this.component).getSelectionModel().getLeadSelectionIndex();
        int n2 = ((JTable)this.component).getColumnModel().getSelectionModel().getLeadSelectionIndex();
        return new Point(n2, n);
    }
}

