/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.rollover;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jdesktop.swingx.rollover.RolloverRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RolloverController<T extends JComponent>
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(RolloverController.class.getName());
    public static final String EXECUTE_BUTTON_ACTIONCOMMAND = "executeButtonAction";
    protected T component;

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.component == null || this.component != propertyChangeEvent.getSource()) {
            return;
        }
        if ("swingx.rollover".equals(propertyChangeEvent.getPropertyName())) {
            this.rollover((Point)propertyChangeEvent.getOldValue(), (Point)propertyChangeEvent.getNewValue());
        } else if ("swingx.clicked".equals(propertyChangeEvent.getPropertyName())) {
            this.click((Point)propertyChangeEvent.getNewValue());
        }
    }

    public void install(T t) {
        this.release();
        this.component = t;
        ((Container)t).addPropertyChangeListener("swingx.clicked", this);
        ((Container)t).addPropertyChangeListener("swingx.rollover", this);
        this.registerExecuteButtonAction();
    }

    public void release() {
        if (this.component == null) {
            return;
        }
        ((Component)this.component).removePropertyChangeListener("swingx.clicked", this);
        ((Component)this.component).removePropertyChangeListener("swingx.rollover", this);
        this.unregisterExecuteButtonAction();
        this.component = null;
    }

    protected abstract void rollover(Point var1, Point var2);

    protected void click(Point point) {
        if (!this.isClickable(point)) {
            return;
        }
        RolloverRenderer rolloverRenderer = this.getRolloverRenderer(point, true);
        if (rolloverRenderer != null) {
            rolloverRenderer.doClick();
            ((Component)this.component).repaint();
        }
    }

    protected abstract RolloverRenderer getRolloverRenderer(Point var1, boolean var2);

    protected boolean isClickable(Point point) {
        return this.hasRollover(point);
    }

    protected boolean hasRollover(Point point) {
        if (point == null || point.x < 0 || point.y < 0) {
            return false;
        }
        return this.getRolloverRenderer(point, false) != null;
    }

    protected abstract Point getFocusedCell();

    protected void unregisterExecuteButtonAction() {
        ((JComponent)this.component).getActionMap().put(EXECUTE_BUTTON_ACTIONCOMMAND, null);
        KeyStroke keyStroke = KeyStroke.getKeyStroke("released SPACE");
        ((JComponent)this.component).getInputMap(1).put(keyStroke, null);
    }

    protected void registerExecuteButtonAction() {
        ((JComponent)this.component).getActionMap().put(EXECUTE_BUTTON_ACTIONCOMMAND, this.createExecuteButtonAction());
        KeyStroke keyStroke = KeyStroke.getKeyStroke("released SPACE");
        ((JComponent)this.component).getInputMap(1).put(keyStroke, EXECUTE_BUTTON_ACTIONCOMMAND);
    }

    protected Action createExecuteButtonAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                RolloverController.this.click(RolloverController.this.getFocusedCell());
            }

            public boolean isEnabled() {
                if (RolloverController.this.component == null || !((Component)RolloverController.this.component).isEnabled() || !((Component)RolloverController.this.component).hasFocus()) {
                    return false;
                }
                return RolloverController.this.isClickable(RolloverController.this.getFocusedCell());
            }
        };
    }
}

