/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Color;
import javax.swing.JTable;
import org.jdesktop.swingx.renderer.CellContext;

public class TableCellContext
extends CellContext {
    public void installContext(JTable jTable, Object object, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.component = jTable;
        this.installState(object, n, n2, bl, bl2, bl3, bl4);
        this.dropOn = this.checkDropOnState();
    }

    private boolean checkDropOnState() {
        if (this.getComponent() == null || !this.isValidRow() || !this.isValidColumn()) {
            return false;
        }
        JTable.DropLocation dropLocation = this.getComponent().getDropLocation();
        return dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == this.row && dropLocation.getColumn() == this.column;
    }

    public JTable getComponent() {
        return (JTable)super.getComponent();
    }

    public boolean isEditable() {
        if (this.getComponent() == null || !this.isValidRow() || !this.isValidColumn()) {
            return false;
        }
        return this.getComponent().isCellEditable(this.getRow(), this.getColumn());
    }

    protected Color getSelectionBackground() {
        Color color = null;
        if (this.isDropOn() && (color = this.getDropCellBackground()) != null) {
            return color;
        }
        return this.getComponent() != null ? this.getComponent().getSelectionBackground() : null;
    }

    protected Color getSelectionForeground() {
        Color color = null;
        if (this.isDropOn() && (color = this.getDropCellForeground()) != null) {
            return color;
        }
        return this.getComponent() != null ? this.getComponent().getSelectionForeground() : null;
    }

    protected String getUIPrefix() {
        return "Table.";
    }

    protected boolean isValidColumn() {
        return this.getColumn() >= 0 && this.getColumn() < this.getComponent().getColumnCount();
    }

    protected boolean isValidRow() {
        return this.getRow() >= 0 && this.getRow() < this.getComponent().getRowCount();
    }
}

