/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.io.File;
import java.text.DateFormat;
import java.text.NumberFormat;
import javax.swing.filechooser.FileSystemView;
import org.jdesktop.swingx.renderer.FormatStringValue;
import org.jdesktop.swingx.renderer.StringValue;

public final class StringValues {
    public static final StringValue EMPTY = new StringValue(){

        public String getString(Object object) {
            return "";
        }
    };
    public static final StringValue TO_STRING = new StringValue(){

        public String getString(Object object) {
            return object != null ? object.toString() : EMPTY.getString(object);
        }
    };
    public static final StringValue FILE_NAME = new StringValue(){

        public String getString(Object object) {
            if (object instanceof File) {
                FileSystemView fileSystemView = FileSystemView.getFileSystemView();
                return fileSystemView.getSystemDisplayName((File)object);
            }
            return TO_STRING.getString(object);
        }
    };
    public static final StringValue FILE_TYPE = new StringValue(){

        public String getString(Object object) {
            if (object instanceof File) {
                FileSystemView fileSystemView = FileSystemView.getFileSystemView();
                return fileSystemView.getSystemTypeDescription((File)object);
            }
            return TO_STRING.getString(object);
        }
    };
    public static final FormatStringValue DATE_TO_STRING = new FormatStringValue(){

        public String getString(Object object) {
            if (this.format == null) {
                this.format = DateFormat.getDateInstance();
            }
            return super.getString(object);
        }
    };
    public static final FormatStringValue NUMBER_TO_STRING = new FormatStringValue(){

        public String getString(Object object) {
            if (this.format == null) {
                this.format = NumberFormat.getNumberInstance();
            }
            return super.getString(object);
        }
    };
}

