/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JLabel;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.renderer.PainterAware;

public class JRendererLabel
extends JLabel
implements PainterAware {
    protected Painter painter;

    public JRendererLabel() {
        this.setOpaque(true);
    }

    public boolean isOpaque() {
        Color color = this.getBackground();
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        boolean bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
        return !bl && super.isOpaque();
    }

    public void setPainter(Painter painter) {
        Painter painter2 = this.getPainter();
        this.painter = painter;
        this.firePropertyChange("painter", painter2, this.getPainter());
    }

    public Painter getPainter() {
        return this.painter;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.painter != null) {
            if (this.isOpaque()) {
                this.paintComponentWithPainter((Graphics2D)graphics);
            } else {
                this.paintPainter(graphics);
                super.paintComponent(graphics);
            }
        } else {
            super.paintComponent(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintPainter(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            this.painter.paint(graphics2D, this, this.getWidth(), this.getHeight());
        }
        finally {
            graphics2D.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponentWithPainter(Graphics2D graphics2D) {
        if (this.ui != null) {
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            try {
                graphics2D2.setColor(this.getBackground());
                graphics2D2.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.paintPainter(graphics2D);
                this.ui.paint(graphics2D2, this);
            }
            finally {
                graphics2D2.dispose();
            }
        }
    }

    public void setToolTipText(String string) {
        this.putClientProperty("ToolTipText", string);
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    public void repaint() {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if ("text".equals(string)) {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

