/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Point;
import java.awt.event.ActionEvent;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.hyperlink.AbstractHyperlinkAction;
import org.jdesktop.swingx.renderer.CellContext;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.JXRendererHyperlink;
import org.jdesktop.swingx.rollover.RolloverRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperlinkProvider
extends ComponentProvider<JXHyperlink>
implements RolloverRenderer {
    private AbstractHyperlinkAction<Object> linkAction;
    protected Class<?> targetClass;

    public HyperlinkProvider() {
        this(null, null);
    }

    public HyperlinkProvider(AbstractHyperlinkAction abstractHyperlinkAction) {
        this(abstractHyperlinkAction, null);
    }

    public HyperlinkProvider(AbstractHyperlinkAction abstractHyperlinkAction, Class clazz) {
        this.setLinkAction(abstractHyperlinkAction, clazz);
    }

    public void setTargetClass(Class clazz) {
        this.targetClass = clazz;
    }

    public void setLinkAction(AbstractHyperlinkAction abstractHyperlinkAction) {
        this.setLinkAction(abstractHyperlinkAction, null);
    }

    public void setLinkAction(AbstractHyperlinkAction abstractHyperlinkAction, Class clazz) {
        if (abstractHyperlinkAction == null) {
            abstractHyperlinkAction = this.createDefaultLinkAction();
        }
        this.setTargetClass(clazz);
        this.linkAction = abstractHyperlinkAction;
        ((JXHyperlink)this.rendererComponent).setAction(abstractHyperlinkAction);
    }

    public boolean isTargetable(Object object) {
        if (this.targetClass == null) {
            return true;
        }
        if (object == null) {
            return true;
        }
        return this.targetClass.isAssignableFrom(object.getClass());
    }

    protected AbstractHyperlinkAction createDefaultLinkAction() {
        return new AbstractHyperlinkAction<Object>(null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void doClick() {
        ((JXHyperlink)this.rendererComponent).doClick();
    }

    @Override
    public String getString(Object object) {
        if (this.isTargetable(object)) {
            Object object2 = this.linkAction.getTarget();
            this.linkAction.setTarget(object);
            String string = this.linkAction.getName();
            this.linkAction.setTarget(object2);
            return string;
        }
        return super.getString(object);
    }

    @Override
    protected void configureState(CellContext cellContext) {
        if (cellContext.getComponent() != null) {
            Point point = (Point)cellContext.getComponent().getClientProperty("swingx.rollover");
            if (point != null && point.x >= 0 && point.x == cellContext.getColumn() && point.y == cellContext.getRow()) {
                if (!((JXHyperlink)this.rendererComponent).getModel().isRollover()) {
                    ((JXHyperlink)this.rendererComponent).getModel().setRollover(true);
                }
            } else if (((JXHyperlink)this.rendererComponent).getModel().isRollover()) {
                ((JXHyperlink)this.rendererComponent).getModel().setRollover(false);
            }
        }
    }

    @Override
    protected void format(CellContext cellContext) {
        Object object = cellContext.getValue();
        if (this.isTargetable(object)) {
            this.linkAction.setTarget(object);
        } else {
            this.linkAction.setTarget(null);
        }
        if (!cellContext.isSelected()) {
            ((JXHyperlink)this.rendererComponent).setForeground(this.linkAction.isVisited() ? ((JXHyperlink)this.rendererComponent).getClickedColor() : ((JXHyperlink)this.rendererComponent).getUnclickedColor());
        } else {
            ((JXHyperlink)this.rendererComponent).setForeground(cellContext.getSelectionForeground());
        }
    }

    @Override
    protected JXHyperlink createRendererComponent() {
        return new JXRendererHyperlink();
    }
}

