/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.windows;

import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI;

public class WindowsTaskPaneUI
extends BasicTaskPaneUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTaskPaneUI();
    }

    protected Border createPaneBorder() {
        return new XPPaneBorder();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getParent().getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, this.getRoundHeight(), jComponent.getWidth(), jComponent.getHeight() - this.getRoundHeight());
        }
        this.paint(graphics, jComponent);
    }

    class XPPaneBorder
    extends BasicTaskPaneUI.PaneBorder {
        XPPaneBorder() {
        }

        protected void paintTitleBackground(JXTaskPane jXTaskPane, Graphics graphics) {
            if (jXTaskPane.isSpecial()) {
                graphics.setColor(this.specialTitleBackground);
                graphics.fillRoundRect(0, 0, jXTaskPane.getWidth(), WindowsTaskPaneUI.this.getRoundHeight() * 2, WindowsTaskPaneUI.this.getRoundHeight(), WindowsTaskPaneUI.this.getRoundHeight());
                graphics.fillRect(0, WindowsTaskPaneUI.this.getRoundHeight(), jXTaskPane.getWidth(), WindowsTaskPaneUI.this.getTitleHeight(jXTaskPane) - WindowsTaskPaneUI.this.getRoundHeight());
            } else {
                Paint paint = ((Graphics2D)graphics).getPaint();
                GradientPaint gradientPaint = new GradientPaint(0.0f, jXTaskPane.getWidth() / 2, jXTaskPane.getComponentOrientation().isLeftToRight() ? this.titleBackgroundGradientStart : this.titleBackgroundGradientEnd, jXTaskPane.getWidth(), WindowsTaskPaneUI.this.getTitleHeight(jXTaskPane), jXTaskPane.getComponentOrientation().isLeftToRight() ? this.titleBackgroundGradientEnd : this.titleBackgroundGradientStart);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                ((Graphics2D)graphics).setPaint(gradientPaint);
                graphics.fillRoundRect(0, 0, jXTaskPane.getWidth(), WindowsTaskPaneUI.this.getRoundHeight() * 2, WindowsTaskPaneUI.this.getRoundHeight(), WindowsTaskPaneUI.this.getRoundHeight());
                graphics.fillRect(0, WindowsTaskPaneUI.this.getRoundHeight(), jXTaskPane.getWidth(), WindowsTaskPaneUI.this.getTitleHeight(jXTaskPane) - WindowsTaskPaneUI.this.getRoundHeight());
                ((Graphics2D)graphics).setPaint(paint);
            }
        }

        protected void paintExpandedControls(JXTaskPane jXTaskPane, Graphics graphics, int n, int n2, int n3, int n4) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintOvalAroundControls(jXTaskPane, graphics, n, n2, n3, n4);
            graphics.setColor(this.getPaintColor(jXTaskPane));
            this.paintChevronControls(jXTaskPane, graphics, n, n2, n3, n4);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }

        protected boolean isMouseOverBorder() {
            return true;
        }
    }
}

