/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.action.AbstractActionExt;

public abstract class CalendarHeaderHandler {
    private static final Logger LOG = Logger.getLogger(CalendarHeaderHandler.class.getName());
    public static final String uiControllerID = "CalendarHeaderHandler";
    protected JXMonthView monthView;
    private JComponent calendarHeader;
    protected Icon monthDownImage;
    protected Icon monthUpImage;
    private PropertyChangeListener monthViewPropertyChangeListener;

    public void install(JXMonthView jXMonthView) {
        this.monthView = jXMonthView;
        this.monthDownImage = UIManager.getIcon("JXMonthView.monthDownFileName");
        this.monthUpImage = UIManager.getIcon("JXMonthView.monthUpFileName");
        this.installNavigationActions();
        this.installListeners();
        this.componentOrientationChanged();
        this.monthStringBackgroundChanged();
        this.fontChanged();
    }

    public void uninstall(JXMonthView jXMonthView) {
        this.monthView.remove(this.getHeaderComponent());
        this.uninstallListeners();
        this.monthView = null;
    }

    public JComponent getHeaderComponent() {
        if (this.calendarHeader == null) {
            this.calendarHeader = this.createCalendarHeader();
        }
        return this.calendarHeader;
    }

    protected void installListeners() {
        this.monthView.addPropertyChangeListener(this.getMonthViewPropertyChangeListener());
    }

    protected void uninstallListeners() {
        this.monthView.removePropertyChangeListener(this.monthViewPropertyChangeListener);
    }

    private PropertyChangeListener getMonthViewPropertyChangeListener() {
        if (this.monthViewPropertyChangeListener == null) {
            this.monthViewPropertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("componentOrientation".equals(propertyChangeEvent.getPropertyName())) {
                        CalendarHeaderHandler.this.componentOrientationChanged();
                    } else if ("font".equals(propertyChangeEvent.getPropertyName())) {
                        CalendarHeaderHandler.this.fontChanged();
                    } else if ("monthStringBackground".equals(propertyChangeEvent.getPropertyName())) {
                        CalendarHeaderHandler.this.monthStringBackgroundChanged();
                    }
                }
            };
        }
        return this.monthViewPropertyChangeListener;
    }

    protected void monthStringBackgroundChanged() {
        this.getHeaderComponent().setBackground(this.getAsNotUIResource(this.monthView.getMonthStringBackground()));
    }

    protected void fontChanged() {
        this.getHeaderComponent().setFont(this.getAsNotUIResource(this.createDerivedFont()));
        this.monthView.revalidate();
    }

    protected void componentOrientationChanged() {
        this.getHeaderComponent().applyComponentOrientation(this.monthView.getComponentOrientation());
        if (this.monthView.getComponentOrientation().isLeftToRight()) {
            this.updateMonthNavigationIcons(this.monthDownImage, this.monthUpImage);
        } else {
            this.updateMonthNavigationIcons(this.monthUpImage, this.monthDownImage);
        }
    }

    private void updateMonthNavigationIcons(Icon icon, Icon icon2) {
        this.updateActionIcon("previousMonth", icon);
        this.updateActionIcon("nextMonth", icon2);
    }

    private void updateActionIcon(String string, Icon icon) {
        Action action = this.monthView.getActionMap().get(string);
        if (action != null) {
            action.putValue("SmallIcon", icon);
        }
    }

    protected abstract JComponent createCalendarHeader();

    protected void installNavigationActions() {
        this.installWrapper("scrollToPreviousMonth", "previousMonth", this.monthView.getComponentOrientation().isLeftToRight() ? this.monthDownImage : this.monthUpImage);
        this.installWrapper("scrollToNextMonth", "nextMonth", this.monthView.getComponentOrientation().isLeftToRight() ? this.monthUpImage : this.monthDownImage);
    }

    private void installWrapper(final String string, String string2, Icon icon) {
        AbstractActionExt abstractActionExt = new AbstractActionExt(null, icon){

            public void actionPerformed(ActionEvent actionEvent) {
                Action action = CalendarHeaderHandler.this.monthView.getActionMap().get(string);
                if (action != null) {
                    action.actionPerformed(actionEvent);
                }
            }
        };
        this.monthView.getActionMap().put(string2, abstractActionExt);
    }

    private Font getAsNotUIResource(Font font) {
        if (!(font instanceof UIResource)) {
            return font;
        }
        return font.deriveFont(font.getAttributes());
    }

    private Color getAsNotUIResource(Color color) {
        if (!(color instanceof UIResource)) {
            return color;
        }
        float[] fArray = color.getRGBComponents(null);
        return new Color(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    protected Font createDerivedFont() {
        return this.monthView.getFont().deriveFont(1);
    }
}

