/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.util.Calendar;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.plaf.basic.CalendarState;

class CalendarAdapter
extends ComponentAdapter {
    Calendar calendar;
    CalendarState dayState;

    public CalendarAdapter(JXMonthView jXMonthView) {
        super(jXMonthView);
    }

    public CalendarAdapter install(Calendar calendar, CalendarState calendarState) {
        this.calendar = calendar;
        this.dayState = calendarState;
        return this;
    }

    public JXMonthView getComponent() {
        return (JXMonthView)super.getComponent();
    }

    public CalendarState getCalendarState() {
        return this.dayState;
    }

    public boolean isFlagged() {
        if (this.getComponent() == null || this.calendar == null) {
            return false;
        }
        return this.getComponent().isFlaggedDate(this.calendar.getTime());
    }

    public boolean isUnselectable() {
        if (this.getComponent() == null || this.calendar == null || !this.isSelectable()) {
            return false;
        }
        return this.getComponent().isUnselectableDate(this.calendar.getTime());
    }

    private boolean isSelectable() {
        return CalendarState.IN_MONTH == this.getCalendarState() || CalendarState.TODAY == this.getCalendarState();
    }

    public boolean isSelected() {
        if (this.getComponent() == null || this.calendar == null) {
            return false;
        }
        return this.getComponent().isSelected(this.calendar.getTime());
    }

    public Object getFilteredValueAt(int n, int n2) {
        return this.getValueAt(n, n2);
    }

    public Object getValueAt(int n, int n2) {
        return this.calendar;
    }

    public boolean hasFocus() {
        return false;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public boolean isEditable() {
        return false;
    }
}

