/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.plaf.StatusBarUI;
import org.jdesktop.swingx.plaf.UIManagerExt;

public class BasicStatusBarUI
extends StatusBarUI {
    public static final String AUTO_ADD_SEPARATOR = new StringBuffer("auto-add-separator").toString();
    private static Insets TEMP_INSETS;
    protected JXStatusBar statusBar;
    protected MouseListener mouseListener;
    protected MouseMotionListener mouseMotionListener;
    protected PropertyChangeListener propertyChangeListener;
    private Handler handler;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicStatusBarUI();
    }

    public void installUI(JComponent jComponent) {
        assert (jComponent instanceof JXStatusBar);
        this.statusBar = (JXStatusBar)jComponent;
        this.installDefaults(this.statusBar);
        this.installListeners(this.statusBar);
        LayoutManager layoutManager = this.statusBar.getLayout();
        if (layoutManager == null || layoutManager instanceof UIResource) {
            this.statusBar.setLayout(this.createLayout());
        }
    }

    protected void installDefaults(JXStatusBar jXStatusBar) {
        Border border = this.statusBar.getBorder();
        if (border == null || border instanceof UIResource) {
            this.statusBar.setBorder(this.createBorder());
        }
        LookAndFeel.installProperty(jXStatusBar, "opaque", Boolean.TRUE);
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected void installListeners(JXStatusBar jXStatusBar) {
        this.mouseListener = this.createMouseListener();
        if (this.mouseListener != null) {
            this.statusBar.addMouseListener(this.mouseListener);
        }
        if ((this.mouseMotionListener = this.createMouseMotionListener()) != null) {
            this.statusBar.addMouseMotionListener(this.mouseMotionListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener()) != null) {
            this.statusBar.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        assert (jComponent instanceof JXStatusBar);
        this.uninstallDefaults(this.statusBar);
        this.uninstallListeners(this.statusBar);
        if (this.statusBar.getLayout() instanceof UIResource) {
            this.statusBar.setLayout(null);
        }
    }

    protected void uninstallDefaults(JXStatusBar jXStatusBar) {
        if (jXStatusBar.getBorder() instanceof UIResource) {
            jXStatusBar.setBorder(null);
        }
    }

    protected void uninstallListeners(JXStatusBar jXStatusBar) {
        if (this.mouseListener != null) {
            this.statusBar.removeMouseListener(this.mouseListener);
        }
        if (this.mouseMotionListener != null) {
            this.statusBar.removeMouseMotionListener(this.mouseMotionListener);
        }
        if (this.propertyChangeListener != null) {
            this.statusBar.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.statusBar.isOpaque()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.paintBackground(graphics2D, this.statusBar);
        }
        if (this.includeSeparators()) {
            TEMP_INSETS = this.getSeparatorInsets(TEMP_INSETS);
            for (int i = 0; i < this.statusBar.getComponentCount() - 1; ++i) {
                Component component = this.statusBar.getComponent(i);
                int n = component.getX() + component.getWidth() + BasicStatusBarUI.TEMP_INSETS.left;
                int n2 = BasicStatusBarUI.TEMP_INSETS.top;
                int n3 = this.getSeparatorWidth() - BasicStatusBarUI.TEMP_INSETS.left - BasicStatusBarUI.TEMP_INSETS.right;
                int n4 = jComponent.getHeight() - BasicStatusBarUI.TEMP_INSETS.top - BasicStatusBarUI.TEMP_INSETS.bottom;
                this.paintSeparator((Graphics2D)graphics, this.statusBar, n, n2, n3, n4);
            }
        }
    }

    protected void paintBackground(Graphics2D graphics2D, JXStatusBar jXStatusBar) {
        if (jXStatusBar.isOpaque()) {
            graphics2D.setColor(jXStatusBar.getBackground());
            graphics2D.fillRect(0, 0, jXStatusBar.getWidth(), jXStatusBar.getHeight());
        }
    }

    protected void paintSeparator(Graphics2D graphics2D, JXStatusBar jXStatusBar, int n, int n2, int n3, int n4) {
        Color color = UIManagerExt.getSafeColor("Separator.foreground", Color.BLACK);
        Color color2 = UIManagerExt.getSafeColor("Separator.background", Color.WHITE);
        graphics2D.setColor(color);
        graphics2D.drawLine(n += n3 / 2, n2, n, n4);
        graphics2D.setColor(color2);
        graphics2D.drawLine(n + 1, n2, n + 1, n4);
    }

    protected Insets getSeparatorInsets(Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.top = 4;
        insets.left = 4;
        insets.bottom = 2;
        insets.right = 4;
        return insets;
    }

    protected int getSeparatorWidth() {
        return 10;
    }

    protected boolean includeSeparators() {
        Boolean bl = (Boolean)this.statusBar.getClientProperty(AUTO_ADD_SEPARATOR);
        return bl == null || bl != false;
    }

    protected BorderUIResource createBorder() {
        return new BorderUIResource(BorderFactory.createEmptyBorder(4, 5, 4, 22));
    }

    protected LayoutManager createLayout() {
        return new LayoutManager2(){
            private Map<Component, JXStatusBar.Constraint> constraints = new HashMap<Component, JXStatusBar.Constraint>();

            public void addLayoutComponent(String string, Component component) {
                this.addLayoutComponent(component, null);
            }

            public void removeLayoutComponent(Component component) {
                this.constraints.remove(component);
            }

            public Dimension minimumLayoutSize(Container container) {
                return this.preferredLayoutSize(container);
            }

            public Dimension maximumLayoutSize(Container container) {
                return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }

            public float getLayoutAlignmentX(Container container) {
                return 0.5f;
            }

            public float getLayoutAlignmentY(Container container) {
                return 0.5f;
            }

            public void invalidateLayout(Container container) {
            }

            public void addLayoutComponent(Component component, Object object) {
                if (object instanceof Insets) {
                    object = new JXStatusBar.Constraint((Insets)object);
                } else if (object instanceof JXStatusBar.Constraint.ResizeBehavior) {
                    object = new JXStatusBar.Constraint((JXStatusBar.Constraint.ResizeBehavior)((Object)object));
                }
                this.constraints.put(component, (JXStatusBar.Constraint)object);
            }

            public Dimension preferredLayoutSize(Container container) {
                Dimension dimension = new Dimension();
                int n = 0;
                for (Component component : this.constraints.keySet()) {
                    JXStatusBar.Constraint constraint = this.constraints.get(component);
                    Dimension dimension2 = component.getPreferredSize();
                    int n2 = 0;
                    if (constraint != null) {
                        Insets insets = constraint.getInsets();
                        dimension2.width += insets.left + insets.right;
                        dimension2.height += insets.top + insets.bottom;
                        n2 = constraint.getFixedWidth();
                    }
                    dimension.height = Math.max(dimension.height, dimension2.height);
                    dimension.width += Math.max(dimension2.width, n2);
                    if (!BasicStatusBarUI.this.includeSeparators() || this.constraints.size() >= ++n) continue;
                    dimension.width += BasicStatusBarUI.this.getSeparatorWidth();
                }
                Insets insets = container.getInsets();
                dimension.height += insets.top + insets.bottom;
                dimension.width += insets.left + insets.right;
                return dimension;
            }

            public void layoutContainer(Container container) {
                int n;
                int n2;
                Insets insets = container.getInsets();
                int n3 = container.getWidth() - insets.left - insets.right;
                if (BasicStatusBarUI.this.includeSeparators()) {
                    n3 -= (container.getComponentCount() - 1) * BasicStatusBarUI.this.getSeparatorWidth();
                }
                int[] nArray = new int[container.getComponentCount()];
                int n4 = 0;
                for (n2 = 0; n2 < nArray.length; ++n2) {
                    nArray[n2] = this.getPreferredWidth(container.getComponent(n2));
                    n4 += nArray[n2];
                }
                if (n3 > n4) {
                    int n5;
                    n2 = 0;
                    Component[] componentArray = container.getComponents();
                    n = componentArray.length;
                    for (n5 = 0; n5 < n; ++n5) {
                        Component component = componentArray[n5];
                        JXStatusBar.Constraint constraint = this.constraints.get(component);
                        if (constraint == null || constraint.getResizeBehavior() != JXStatusBar.Constraint.ResizeBehavior.FILL) continue;
                        ++n2;
                    }
                    if (n2 > 0) {
                        double d = 1.0 / (double)n2;
                        n5 = (int)((double)(n3 -= n4) * d);
                        int n6 = n2;
                        for (int i = 0; i < container.getComponentCount(); ++i) {
                            Component component = container.getComponent(i);
                            JXStatusBar.Constraint constraint = this.constraints.get(component);
                            if (constraint == null || constraint.getResizeBehavior() != JXStatusBar.Constraint.ResizeBehavior.FILL) continue;
                            if (n6 > 1) {
                                int n7 = i;
                                nArray[n7] = nArray[n7] + n5;
                                n3 -= n5;
                            } else {
                                int n8 = i;
                                nArray[n8] = nArray[n8] + n3;
                            }
                            --n6;
                        }
                    }
                }
                n2 = insets.left;
                int n9 = container.getHeight() - insets.top - insets.bottom;
                for (n = 0; n < container.getComponentCount(); ++n) {
                    Component component = container.getComponent(n);
                    JXStatusBar.Constraint constraint = this.constraints.get(component);
                    Insets insets2 = constraint == null ? new Insets(0, 0, 0, 0) : constraint.getInsets();
                    int n10 = nArray[n] - (insets2.left + insets2.right);
                    int n11 = n2 + insets2.left;
                    int n12 = insets.top + insets2.top;
                    component.setSize(n10, n9);
                    component.setLocation(n11, n12);
                    n2 = n11 + n10 + insets2.right;
                    if (!BasicStatusBarUI.this.includeSeparators() || n >= container.getComponentCount() - 1) continue;
                    n2 += BasicStatusBarUI.this.getSeparatorWidth();
                }
            }

            private int getPreferredWidth(Component component) {
                JXStatusBar.Constraint constraint = this.constraints.get(component);
                if (constraint == null) {
                    return component.getPreferredSize().width;
                }
                Insets insets = constraint.getInsets();
                assert (insets != null);
                if (constraint.getFixedWidth() <= 0) {
                    return component.getPreferredSize().width + insets.left + insets.right;
                }
                return constraint.getFixedWidth() + insets.left + insets.right;
            }
        };
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener,
    PropertyChangeListener {
        private Window window;
        private int handleBoundary;
        private boolean validPress;
        private Point startingPoint;

        private Handler() {
            this.window = SwingUtilities.getWindowAncestor(BasicStatusBarUI.this.statusBar);
            this.handleBoundary = this.getHandleBoundary();
            this.validPress = false;
        }

        private int getHandleBoundary() {
            Border border = BasicStatusBarUI.this.statusBar.getBorder();
            if (border == null || !BasicStatusBarUI.this.statusBar.isResizeHandleEnabled()) {
                return 0;
            }
            if (BasicStatusBarUI.this.statusBar.getComponentOrientation().isLeftToRight()) {
                return border.getBorderInsets((Component)BasicStatusBarUI.this.statusBar).right;
            }
            return border.getBorderInsets((Component)BasicStatusBarUI.this.statusBar).left;
        }

        private boolean isHandleAreaPoint(Point point) {
            if (this.window == null || this.window.isMaximumSizeSet()) {
                return false;
            }
            if (BasicStatusBarUI.this.statusBar.getComponentOrientation().isLeftToRight()) {
                return point.x >= BasicStatusBarUI.this.statusBar.getWidth() - this.handleBoundary;
            }
            return point.x <= this.handleBoundary;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.isHandleAreaPoint(mouseEvent.getPoint())) {
                if (BasicStatusBarUI.this.statusBar.getComponentOrientation().isLeftToRight()) {
                    this.window.setCursor(Cursor.getPredefinedCursor(5));
                } else {
                    this.window.setCursor(Cursor.getPredefinedCursor(4));
                }
            } else {
                this.window.setCursor(null);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.validPress) {
                this.window.setCursor(null);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.validPress = SwingUtilities.isLeftMouseButton(mouseEvent) && this.isHandleAreaPoint(mouseEvent.getPoint());
            this.startingPoint = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(this.startingPoint, BasicStatusBarUI.this.statusBar);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.validPress = !SwingUtilities.isLeftMouseButton(mouseEvent);
            this.window.validate();
            this.window.setCursor(null);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.validPress) {
                Rectangle rectangle = this.window.getBounds();
                Point point = mouseEvent.getPoint();
                SwingUtilities.convertPointToScreen(point, BasicStatusBarUI.this.statusBar);
                rectangle.height += point.y - this.startingPoint.y;
                if (BasicStatusBarUI.this.statusBar.getComponentOrientation().isLeftToRight()) {
                    rectangle.width += point.x - this.startingPoint.x;
                } else {
                    rectangle.x += point.x - this.startingPoint.x;
                    rectangle.width += this.startingPoint.x - point.x;
                }
                this.window.setBounds(rectangle);
                this.window.validate();
                this.startingPoint = point;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.isHandleAreaPoint(mouseEvent.getPoint())) {
                if (BasicStatusBarUI.this.statusBar.getComponentOrientation().isLeftToRight()) {
                    this.window.setCursor(Cursor.getPredefinedCursor(5));
                } else {
                    this.window.setCursor(Cursor.getPredefinedCursor(4));
                }
            } else {
                this.window.setCursor(null);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("ancestor".equals(propertyChangeEvent.getPropertyName())) {
                this.window = SwingUtilities.getWindowAncestor(BasicStatusBarUI.this.statusBar);
                boolean bl = BasicStatusBarUI.this.statusBar.getParent() != null && BasicStatusBarUI.this.statusBar.getRootPane() != null && (BasicStatusBarUI.this.statusBar.getParent() == BasicStatusBarUI.this.statusBar.getRootPane() || BasicStatusBarUI.this.statusBar.getParent() == BasicStatusBarUI.this.statusBar.getRootPane().getContentPane());
                BasicStatusBarUI.this.statusBar.setResizeHandleEnabled(bl);
            } else if ("border".equals(propertyChangeEvent.getPropertyName())) {
                this.handleBoundary = this.getHandleBoundary();
            } else if ("componentOrientation".equals(propertyChangeEvent.getPropertyName())) {
                this.handleBoundary = this.getHandleBoundary();
            } else if ("resizeHandleEnabled".equals(propertyChangeEvent.getPropertyName())) {
                this.handleBoundary = this.getHandleBoundary();
            }
        }
    }
}

