/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.multislider.ThumbRenderer;
import org.jdesktop.swingx.multislider.TrackRenderer;
import org.jdesktop.swingx.plaf.MultiThumbSliderUI;

public class BasicMultiThumbSliderUI
extends MultiThumbSliderUI {
    protected JXMultiThumbSlider<?> slider;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMultiThumbSliderUI();
    }

    public void installUI(JComponent jComponent) {
        this.slider = (JXMultiThumbSlider)jComponent;
        this.slider.setThumbRenderer(new BasicThumbRenderer());
        this.slider.setTrackRenderer(new BasicTrackRenderer());
    }

    public void uninstallUI(JComponent jComponent) {
        this.slider = null;
    }

    private class BasicTrackRenderer
    extends JComponent
    implements TrackRenderer {
        private JXMultiThumbSlider<?> slider;

        private BasicTrackRenderer() {
        }

        public void paintComponent(Graphics graphics) {
            graphics.setColor(this.slider.getBackground());
            graphics.fillRect(0, 0, this.slider.getWidth(), this.slider.getHeight());
            graphics.setColor(Color.black);
            graphics.drawLine(0, this.slider.getHeight() / 2, this.slider.getWidth(), this.slider.getHeight() / 2);
            graphics.drawLine(0, this.slider.getHeight() / 2 + 1, this.slider.getWidth(), this.slider.getHeight() / 2 + 1);
        }

        public JComponent getRendererComponent(JXMultiThumbSlider jXMultiThumbSlider) {
            this.slider = jXMultiThumbSlider;
            return this;
        }
    }

    private class BasicThumbRenderer
    extends JComponent
    implements ThumbRenderer {
        public BasicThumbRenderer() {
            this.setPreferredSize(new Dimension(14, 14));
        }

        protected void paintComponent(Graphics graphics) {
            graphics.setColor(Color.green);
            Polygon polygon = new Polygon();
            BasicThumbRenderer basicThumbRenderer = this;
            polygon.addPoint(basicThumbRenderer.getWidth() / 2, 0);
            polygon.addPoint(0, basicThumbRenderer.getHeight() / 2);
            polygon.addPoint(basicThumbRenderer.getWidth() / 2, basicThumbRenderer.getHeight());
            polygon.addPoint(basicThumbRenderer.getWidth(), basicThumbRenderer.getHeight() / 2);
            graphics.fillPolygon(polygon);
        }

        public JComponent getThumbRendererComponent(JXMultiThumbSlider jXMultiThumbSlider, int n, boolean bl) {
            return this;
        }
    }
}

