/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;
import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.plaf.HeaderUI;
import org.jdesktop.swingx.plaf.PainterUIResource;
import org.jdesktop.swingx.plaf.UIManagerExt;

public class BasicHeaderUI
extends HeaderUI {
    private static final Logger LOG = Logger.getLogger(BasicHeaderUI.class.getName());
    protected JLabel titleLabel;
    protected DescriptionPane descriptionPane;
    protected JLabel imagePanel;
    private PropertyChangeListener propListener;
    private HierarchyBoundsListener boundsListener;
    private Color gradientLightColor;
    private Color gradientDarkColor;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicHeaderUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        assert (jComponent instanceof JXHeader);
        JXHeader jXHeader = (JXHeader)jComponent;
        this.installDefaults(jXHeader);
        this.installComponents(jXHeader);
        this.installListeners(jXHeader);
    }

    public void uninstallUI(JComponent jComponent) {
        assert (jComponent instanceof JXHeader);
        JXHeader jXHeader = (JXHeader)jComponent;
        this.uninstallListeners(jXHeader);
        this.uninstallComponents(jXHeader);
        this.uninstallDefaults(jXHeader);
    }

    protected void installDefaults(JXHeader jXHeader) {
        Serializable serializable;
        this.gradientLightColor = UIManagerExt.getColor("JXHeader.startBackground");
        if (this.gradientLightColor == null) {
            this.gradientLightColor = Color.WHITE;
        }
        this.gradientDarkColor = UIManagerExt.getColor("JXHeader.background");
        if (this.gradientDarkColor == null) {
            this.gradientDarkColor = UIManagerExt.getColor("control");
        }
        if (this.isUIInstallable(jXHeader.getBackgroundPainter())) {
            jXHeader.setBackgroundPainter(this.createBackgroundPainter());
        }
        if (this.isUIInstallable(jXHeader.getTitleFont())) {
            serializable = UIManager.getFont("JXHeader.titleFont");
            jXHeader.setTitleFont((Font)(serializable != null ? serializable : UIManager.getFont("Label.font")));
        }
        if (this.isUIInstallable(jXHeader.getTitleForeground())) {
            serializable = UIManagerExt.getColor("JXHeader.titleForeground");
            jXHeader.setTitleForeground((Color)(serializable != null ? serializable : UIManagerExt.getColor("Label.foreground")));
        }
        if (this.isUIInstallable(jXHeader.getDescriptionFont())) {
            serializable = UIManager.getFont("JXHeader.descriptionFont");
            jXHeader.setDescriptionFont((Font)(serializable != null ? serializable : UIManager.getFont("Label.font")));
        }
        if (this.isUIInstallable(jXHeader.getDescriptionForeground())) {
            serializable = UIManagerExt.getColor("JXHeader.descriptionForeground");
            jXHeader.setDescriptionForeground((Color)(serializable != null ? serializable : UIManagerExt.getColor("Label.foreground")));
        }
        if (this.isUIInstallable(jXHeader.getIcon())) {
            jXHeader.setIcon(UIManager.getIcon("Header.defaultIcon"));
        }
    }

    protected void uninstallDefaults(JXHeader jXHeader) {
    }

    protected void installComponents(JXHeader jXHeader) {
        this.titleLabel = new JLabel();
        this.descriptionPane = new DescriptionPane();
        this.imagePanel = new JLabel();
        this.installComponentDefaults(jXHeader);
        jXHeader.setLayout(new GridBagLayout());
        this.resetLayout(jXHeader);
    }

    protected void uninstallComponents(JXHeader jXHeader) {
        this.uninstallComponentDefaults(jXHeader);
        jXHeader.remove(this.titleLabel);
        jXHeader.remove(this.descriptionPane);
        jXHeader.remove(this.imagePanel);
        this.titleLabel = null;
        this.descriptionPane = null;
        this.imagePanel = null;
    }

    protected void installComponentDefaults(JXHeader jXHeader) {
        this.titleLabel.setFont(this.getAsNotUIResource(jXHeader.getTitleFont()));
        this.titleLabel.setForeground(this.getAsNotUIResource(jXHeader.getTitleForeground()));
        this.titleLabel.setText(jXHeader.getTitle());
        this.descriptionPane.setFont(this.getAsNotUIResource(jXHeader.getDescriptionFont()));
        this.descriptionPane.setForeground(this.getAsNotUIResource(jXHeader.getDescriptionForeground()));
        this.descriptionPane.setOpaque(false);
        this.descriptionPane.setText(jXHeader.getDescription());
        this.descriptionPane.setLineWrap(true);
        this.imagePanel.setIcon(jXHeader.getIcon());
    }

    private Font getAsNotUIResource(Font font) {
        if (!(font instanceof UIResource)) {
            return font;
        }
        return font.deriveFont(font.getAttributes());
    }

    private Color getAsNotUIResource(Color color) {
        if (!(color instanceof UIResource)) {
            return color;
        }
        float[] fArray = color.getRGBComponents(null);
        return new Color(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    private boolean isUIInstallable(Object object) {
        return object == null || object instanceof UIResource;
    }

    protected void uninstallComponentDefaults(JXHeader jXHeader) {
    }

    protected void installListeners(final JXHeader jXHeader) {
        this.propListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BasicHeaderUI.this.onPropertyChange(jXHeader, propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        };
        this.boundsListener = new HierarchyBoundsAdapter(){

            public void ancestorResized(HierarchyEvent hierarchyEvent) {
                if (jXHeader == hierarchyEvent.getComponent()) {
                    View view = (View)BasicHeaderUI.this.descriptionPane.getClientProperty("html");
                    if (view == null) {
                        DescriptionPane descriptionPane = BasicHeaderUI.this.descriptionPane;
                        BasicHeaderUI.this.descriptionPane.getMultiLineSupport();
                        descriptionPane.putClientProperty("html", JXLabel.MultiLineSupport.createView(BasicHeaderUI.this.descriptionPane));
                        view = (View)BasicHeaderUI.this.descriptionPane.getClientProperty("html");
                    }
                    if (view != null) {
                        Container container = jXHeader.getTopLevelAncestor();
                        if (container == null) {
                            container = jXHeader.getParent();
                            while (container.getParent() != null) {
                                container = container.getParent();
                            }
                        }
                        int n = Math.max(BasicHeaderUI.this.descriptionPane.getHeight(), container.getHeight());
                        int n2 = Math.min(container.getWidth(), jXHeader.getParent().getWidth());
                        view.setSize(n2 -= 35 + jXHeader.getInsets().left + jXHeader.getInsets().right + BasicHeaderUI.this.descriptionPane.getInsets().left + BasicHeaderUI.this.descriptionPane.getInsets().right + BasicHeaderUI.this.imagePanel.getInsets().left + BasicHeaderUI.this.imagePanel.getInsets().right + BasicHeaderUI.this.imagePanel.getWidth() + BasicHeaderUI.this.descriptionPane.getBounds().x, n);
                        BasicHeaderUI.this.descriptionPane.setSize(n2, (int)Math.ceil(view.getPreferredSpan(1)));
                    }
                }
            }
        };
        jXHeader.addPropertyChangeListener(this.propListener);
        jXHeader.addHierarchyBoundsListener(this.boundsListener);
    }

    protected void uninstallListeners(JXHeader jXHeader) {
        jXHeader.removePropertyChangeListener(this.propListener);
        jXHeader.removeHierarchyBoundsListener(this.boundsListener);
    }

    protected void onPropertyChange(JXHeader jXHeader, String string, Object object, Object object2) {
        if ("title".equals(string)) {
            this.titleLabel.setText(jXHeader.getTitle());
        } else if ("description".equals(string)) {
            this.descriptionPane.setText(jXHeader.getDescription());
        } else if ("icon".equals(string)) {
            this.imagePanel.setIcon(jXHeader.getIcon());
        } else if ("enabled".equals(string)) {
            boolean bl = jXHeader.isEnabled();
            this.titleLabel.setEnabled(bl);
            this.descriptionPane.setEnabled(bl);
            this.imagePanel.setEnabled(bl);
        } else if ("titleFont".equals(string)) {
            this.titleLabel.setFont((Font)object2);
        } else if ("descriptionFont".equals(string)) {
            this.descriptionPane.setFont((Font)object2);
        } else if ("titleForeground".equals(string)) {
            this.titleLabel.setForeground((Color)object2);
        } else if ("descriptionForeground".equals(string)) {
            this.descriptionPane.setForeground((Color)object2);
        } else if ("iconPosition".equals(string)) {
            this.resetLayout(jXHeader);
        }
    }

    private void resetLayout(JXHeader jXHeader) {
        jXHeader.remove(this.titleLabel);
        jXHeader.remove(this.descriptionPane);
        jXHeader.remove(this.imagePanel);
        if (jXHeader.getIconPosition() == null || jXHeader.getIconPosition() == JXHeader.IconPosition.RIGHT) {
            jXHeader.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(12, 12, 0, 11), 0, 0));
            jXHeader.add((Component)this.descriptionPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 24, 12, 11), 0, 0));
            jXHeader.add((Component)this.imagePanel, new GridBagConstraints(1, 0, 1, 2, 0.0, 1.0, 24, 0, new Insets(12, 0, 11, 11), 0, 0));
        } else {
            jXHeader.add((Component)this.titleLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(12, 12, 0, 11), 0, 0));
            jXHeader.add((Component)this.descriptionPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 24, 12, 11), 0, 0));
            jXHeader.add((Component)this.imagePanel, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 24, 0, new Insets(12, 11, 0, 11), 0, 0));
        }
    }

    protected Painter createBackgroundPainter() {
        MattePainter mattePainter = new MattePainter(new GradientPaint(0.0f, 0.0f, this.gradientLightColor, 1.0f, 0.0f, this.gradientDarkColor));
        mattePainter.setPaintStretched(true);
        return new PainterUIResource<Object>(mattePainter);
    }

    protected class DescriptionPane
    extends JXLabel {
        protected DescriptionPane() {
        }

        public void paint(Graphics graphics) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            super.paint(graphics);
        }

        public JXLabel.MultiLineSupport getMultiLineSupport() {
            return super.getMultiLineSupport();
        }
    }
}

