/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLEditorKit;
import org.jdesktop.swingx.JXEditorPane;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorLevel;
import org.jdesktop.swingx.error.ErrorReporter;
import org.jdesktop.swingx.plaf.ErrorPaneUI;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.util.WindowUtils;

public class BasicErrorPaneUI
extends ErrorPaneUI {
    protected static final String CLASS_NAME = "JXErrorPane";
    protected JXErrorPane pane;
    protected JEditorPane errorMessage;
    protected JScrollPane errorScrollPane;
    protected JXEditorPane details;
    protected AbstractButton detailButton;
    protected JButton closeButton;
    protected JLabel iconLabel;
    protected AbstractButton reportButton;
    protected JPanel detailsPanel;
    protected JScrollPane detailsScrollPane;
    protected JButton copyToClipboardButton;
    protected PropertyChangeListener errorPaneListener;
    protected ActionListener detailListener;
    protected ActionListener copyToClipboardListener;
    private int collapsedHeight = 0;
    private int expandedHeight = 0;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicErrorPaneUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.pane = (JXErrorPane)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        Action action = jComponent.getActionMap().get("report-action");
        if (action == null) {
            final JXErrorPane jXErrorPane = (JXErrorPane)jComponent;
            AbstractActionExt abstractActionExt = new AbstractActionExt(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ErrorReporter errorReporter = jXErrorPane.getErrorReporter();
                    if (errorReporter != null) {
                        errorReporter.reportError(jXErrorPane.getErrorInfo());
                    }
                }
            };
            this.configureReportAction(abstractActionExt);
            jComponent.getActionMap().put("report-action", abstractActionExt);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
    }

    protected void installDefaults() {
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.pane);
    }

    protected void installListeners() {
        this.errorPaneListener = new ErrorPaneListener();
        this.pane.addPropertyChangeListener(this.errorPaneListener);
    }

    protected void uninstallListeners() {
        this.pane.removePropertyChangeListener(this.errorPaneListener);
    }

    protected void installComponents() {
        this.iconLabel = new JLabel(this.pane.getIcon());
        this.errorMessage = new JEditorPane();
        this.errorMessage.setEditable(false);
        this.errorMessage.setContentType("text/html");
        this.errorMessage.setEditorKitForContentType("text/plain", new StyledEditorKit());
        this.errorMessage.setEditorKitForContentType("text/html", new HTMLEditorKit());
        this.errorMessage.setOpaque(false);
        this.errorMessage.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.closeButton = new JButton(UIManagerExt.getString("JXErrorPane.ok_button_text", this.errorMessage.getLocale()));
        this.reportButton = new EqualSizeJButton(this.pane.getActionMap().get("report-action"));
        this.detailButton = new EqualSizeJButton(UIManagerExt.getString("JXErrorPane.details_expand_text", this.errorMessage.getLocale()));
        this.details = new JXEditorPane();
        this.details.setContentType("text/html");
        this.details.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.details.setTransferHandler(this.createDetailsTransferHandler(this.details));
        this.detailsScrollPane = new JScrollPane(this.details);
        this.detailsScrollPane.setPreferredSize(new Dimension(10, 250));
        this.details.setEditable(false);
        this.detailsPanel = new JPanel();
        this.detailsPanel.setVisible(false);
        this.copyToClipboardButton = new JButton(UIManagerExt.getString("JXErrorPane.copy_to_clipboard_button_text", this.errorMessage.getLocale()));
        this.copyToClipboardListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicErrorPaneUI.this.details.copy();
            }
        };
        this.copyToClipboardButton.addActionListener(this.copyToClipboardListener);
        this.detailsPanel.setLayout(this.createDetailPanelLayout());
        this.detailsPanel.add(this.detailsScrollPane);
        this.detailsPanel.add(this.copyToClipboardButton);
        this.errorScrollPane = new JScrollPane(this.errorMessage);
        this.errorScrollPane.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.errorScrollPane.setOpaque(false);
        this.errorScrollPane.getViewport().setOpaque(false);
        this.pane.setLayout(this.createErrorPaneLayout());
        Insets insets = new Insets(16, 24, 16, 17);
        this.pane.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        this.pane.add(this.iconLabel);
        this.pane.add(this.errorScrollPane);
        this.pane.add(this.closeButton);
        this.pane.add(this.reportButton);
        this.reportButton.setVisible(false);
        this.pane.add(this.detailButton);
        this.pane.add(this.detailsPanel);
        EqualSizeJButton[] equalSizeJButtonArray = new EqualSizeJButton[]{(EqualSizeJButton)this.detailButton, (EqualSizeJButton)this.reportButton};
        ((EqualSizeJButton)this.reportButton).setGroup(equalSizeJButtonArray);
        ((EqualSizeJButton)this.detailButton).setGroup(equalSizeJButtonArray);
        this.reportButton.setMinimumSize(this.reportButton.getPreferredSize());
        this.detailButton.setMinimumSize(this.detailButton.getPreferredSize());
        this.detailListener = new DetailsClickEvent();
        this.detailButton.addActionListener(this.detailListener);
    }

    protected void uninstallComponents() {
        this.iconLabel = null;
        this.errorMessage = null;
        this.closeButton = null;
        this.reportButton = null;
        this.detailButton.removeActionListener(this.detailListener);
        this.detailButton = null;
        this.details.setTransferHandler(null);
        this.details = null;
        this.detailsScrollPane.removeAll();
        this.detailsScrollPane = null;
        this.detailsPanel.setLayout(null);
        this.detailsPanel.removeAll();
        this.detailsPanel = null;
        this.copyToClipboardButton.removeActionListener(this.copyToClipboardListener);
        this.copyToClipboardButton = null;
        this.pane.removeAll();
        this.pane.setLayout(null);
        this.pane.setBorder(null);
    }

    public JFrame getErrorFrame(Component component) {
        this.reinit();
        this.expandedHeight = 0;
        this.collapsedHeight = 0;
        JXErrorFrame jXErrorFrame = new JXErrorFrame(this.pane);
        BasicErrorPaneUI.centerWindow(jXErrorFrame, component);
        return jXErrorFrame;
    }

    public JDialog getErrorDialog(Component component) {
        this.reinit();
        this.expandedHeight = 0;
        this.collapsedHeight = 0;
        Window window = WindowUtils.findWindow(component);
        JXErrorDialog jXErrorDialog = null;
        jXErrorDialog = window instanceof Dialog ? new JXErrorDialog((Dialog)window, this.pane) : (window instanceof Frame ? new JXErrorDialog((Frame)window, this.pane) : new JXErrorDialog(JOptionPane.getRootFrame(), this.pane));
        BasicErrorPaneUI.centerWindow(jXErrorDialog, component);
        return jXErrorDialog;
    }

    public JInternalFrame getErrorInternalFrame(Component component) {
        this.reinit();
        this.expandedHeight = 0;
        this.collapsedHeight = 0;
        JXInternalErrorFrame jXInternalErrorFrame = new JXInternalErrorFrame(this.pane);
        BasicErrorPaneUI.centerWindow(jXInternalErrorFrame, component);
        return jXInternalErrorFrame;
    }

    protected LayoutManager createErrorPaneLayout() {
        return new ErrorPaneLayout();
    }

    protected LayoutManager createDetailPanelLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.addLayoutComponent(this.detailsScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 0, 0, 0), 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        gridBagLayout.addLayoutComponent(this.copyToClipboardButton, gridBagConstraints);
        return gridBagLayout;
    }

    public Dimension calculatePreferredSize() {
        return new Dimension(this.iconLabel.getPreferredSize().width + this.errorMessage.getPreferredSize().width, 206);
    }

    protected int getDetailsHeight() {
        return 300;
    }

    protected void configureReportAction(AbstractActionExt abstractActionExt) {
        abstractActionExt.setName(UIManagerExt.getString("JXErrorPane.report_button_text", this.pane.getLocale()));
    }

    private TransferHandler createDetailsTransferHandler(JTextComponent jTextComponent) {
        return new DetailsTransferHandler(jTextComponent);
    }

    protected Icon getDefaultErrorIcon() {
        try {
            Icon icon = UIManager.getIcon("JXErrorPane.errorIcon");
            return icon == null ? UIManager.getIcon("OptionPane.errorIcon") : icon;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Icon getDefaultWarningIcon() {
        try {
            Icon icon = UIManager.getIcon("JXErrorPane.warningIcon");
            return icon == null ? UIManager.getIcon("OptionPane.warningIcon") : icon;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void setDetails(String string) {
        if (string == null || string.equals("")) {
            this.detailButton.setVisible(false);
        } else {
            this.details.setText(string);
            this.detailButton.setVisible(true);
        }
    }

    protected void configureDetailsButton(boolean bl) {
        if (bl) {
            this.detailButton.setText(UIManagerExt.getString("JXErrorPane.details_contract_text", this.detailButton.getLocale()));
        } else {
            this.detailButton.setText(UIManagerExt.getString("JXErrorPane.details_expand_text", this.detailButton.getLocale()));
        }
    }

    private void setDetailsVisible(boolean bl) {
        if (bl) {
            this.collapsedHeight = this.pane.getHeight();
            this.pane.setSize(this.pane.getWidth(), this.expandedHeight == 0 ? this.collapsedHeight + this.getDetailsHeight() : this.expandedHeight);
            this.detailsPanel.setVisible(true);
            this.configureDetailsButton(true);
            this.detailsPanel.applyComponentOrientation(this.detailButton.getComponentOrientation());
            this.details.setText(this.details.getText());
            this.details.setCaretPosition(0);
        } else if (this.collapsedHeight != 0) {
            this.expandedHeight = this.pane.getHeight();
            this.detailsPanel.setVisible(false);
            this.configureDetailsButton(false);
            this.errorMessage.setSize(0, 0);
            this.errorMessage.setSize(this.errorMessage.getPreferredSize());
            this.pane.setSize(this.pane.getWidth(), this.collapsedHeight);
        } else {
            this.detailsPanel.setVisible(false);
        }
        this.pane.doLayout();
    }

    private void setErrorMessage(String string) {
        if (BasicHTML.isHTMLString(string)) {
            this.errorMessage.setContentType("text/html");
        } else {
            this.errorMessage.setContentType("text/plain");
        }
        this.errorMessage.setText(string);
        this.errorMessage.setCaretPosition(0);
    }

    protected void reinit() {
        this.setDetailsVisible(false);
        Action action = this.pane.getActionMap().get("report-action");
        this.reportButton.setAction(action);
        this.reportButton.setVisible(action != null && action.isEnabled() && this.pane.getErrorReporter() != null);
        this.reportButton.setEnabled(this.reportButton.isVisible());
        ErrorInfo errorInfo = this.pane.getErrorInfo();
        if (errorInfo == null) {
            this.iconLabel.setIcon(this.pane.getIcon());
            this.setErrorMessage("");
            this.closeButton.setText(UIManagerExt.getString("JXErrorPane.ok_button_text", this.closeButton.getLocale()));
            this.setDetails("");
        } else {
            if (errorInfo.getErrorLevel() == ErrorLevel.FATAL) {
                this.closeButton.setText(UIManagerExt.getString("JXErrorPane.fatal_button_text", this.closeButton.getLocale()));
            } else {
                this.closeButton.setText(UIManagerExt.getString("JXErrorPane.ok_button_text", this.closeButton.getLocale()));
            }
            Icon icon = this.pane.getIcon();
            if (icon == null || icon instanceof UIResource) {
                icon = errorInfo.getErrorLevel().intValue() <= Level.WARNING.intValue() ? this.getDefaultWarningIcon() : this.getDefaultErrorIcon();
            }
            this.iconLabel.setIcon(icon);
            this.setErrorMessage(errorInfo.getBasicErrorMessage());
            String string = errorInfo.getDetailedErrorMessage();
            if (string == null) {
                string = this.getDetailsAsHTML(errorInfo);
            }
            this.setDetails(string);
        }
    }

    protected String getDetailsAsHTML(ErrorInfo errorInfo) {
        if (errorInfo.getErrorException() != null) {
            StringBuffer stringBuffer = new StringBuffer("<html>");
            stringBuffer.append("<h2>" + BasicErrorPaneUI.escapeXml(errorInfo.getTitle()) + "</h2>");
            stringBuffer.append("<HR size='1' noshade>");
            stringBuffer.append("<div></div>");
            stringBuffer.append("<b>Message:</b>");
            stringBuffer.append("<pre>");
            stringBuffer.append("    " + BasicErrorPaneUI.escapeXml(errorInfo.getErrorException().toString()));
            stringBuffer.append("</pre>");
            stringBuffer.append("<b>Level:</b>");
            stringBuffer.append("<pre>");
            stringBuffer.append("    " + errorInfo.getErrorLevel());
            stringBuffer.append("</pre>");
            stringBuffer.append("<b>Stack Trace:</b>");
            for (Throwable throwable = errorInfo.getErrorException(); throwable != null; throwable = throwable.getCause()) {
                stringBuffer.append("<h4>" + throwable.getMessage() + "</h4>");
                stringBuffer.append("<pre>");
                for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                    stringBuffer.append("    " + stackTraceElement.toString().replace("<init>", "&lt;init&gt;") + "\n");
                }
                stringBuffer.append("</pre>");
            }
            stringBuffer.append("</html>");
            return stringBuffer.toString();
        }
        return null;
    }

    private void initWindow(Window window, JXErrorPane jXErrorPane) {
        Object object;
        window.setLayout(new BorderLayout());
        window.add((Component)jXErrorPane, "Center");
        final CloseAction closeAction = new CloseAction(window);
        this.closeButton.addActionListener(closeAction);
        final ResizeWindow resizeWindow = new ResizeWindow(window);
        ActionListener[] actionListenerArray = this.detailButton.getActionListeners();
        for (ActionListener actionListener : actionListenerArray) {
            this.detailButton.removeActionListener(actionListener);
        }
        this.detailButton.addActionListener(resizeWindow);
        for (ActionListener actionListener : actionListenerArray) {
            this.detailButton.addActionListener(actionListener);
        }
        if (window instanceof JFrame) {
            object = (JFrame)window;
            ((JFrame)object).getRootPane().setDefaultButton(this.closeButton);
            ((Frame)object).setResizable(true);
            ((JFrame)object).setDefaultCloseOperation(2);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            ((JFrame)object).getRootPane().registerKeyboardAction(closeAction, keyStroke, 2);
        } else if (window instanceof JDialog) {
            object = (JDialog)window;
            ((JDialog)object).getRootPane().setDefaultButton(this.closeButton);
            ((Dialog)object).setResizable(true);
            ((JDialog)object).setDefaultCloseOperation(2);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            ((JDialog)object).getRootPane().registerKeyboardAction(closeAction, keyStroke, 2);
        }
        window.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                BasicErrorPaneUI.this.closeButton.removeActionListener(closeAction);
                BasicErrorPaneUI.this.detailButton.removeActionListener(resizeWindow);
                BasicErrorPaneUI.this.exitIfFatal();
            }
        });
        window.pack();
    }

    private void exitIfFatal() {
        ErrorInfo errorInfo = this.pane.getErrorInfo();
        if (errorInfo != null && errorInfo.getErrorLevel() == ErrorLevel.FATAL) {
            Action action = this.pane.getActionMap().get("fatal-action");
            if (action == null) {
                System.exit(1);
            } else {
                ActionEvent actionEvent = new ActionEvent(this.closeButton, -1, "fatal");
                action.actionPerformed(actionEvent);
            }
        }
    }

    private static void centerWindow(Window window, Component component) {
        if (component != null) {
            Point point = component.getLocation();
            point.x += component.getWidth() / 2;
            point.y += component.getHeight() / 2;
            SwingUtilities.convertPointToScreen(point, component);
            window.setLocation(point);
        } else {
            window.setLocation(WindowUtils.getPointForCentering(window));
        }
    }

    private static void centerWindow(JInternalFrame jInternalFrame, Component component) {
        if (component != null) {
            Point point = component.getLocation();
            point.x += component.getWidth() / 2;
            point.y += component.getHeight() / 2;
            SwingUtilities.convertPointToScreen(point, component);
            jInternalFrame.setLocation(point);
        } else {
            jInternalFrame.setLocation(WindowUtils.getPointForCentering(jInternalFrame));
        }
    }

    private static String escapeXml(String string) {
        String string2 = string == null ? "" : string.replace("&", "&amp;");
        string2 = string2.replace("<", "&lt;");
        string2 = string2.replace(">", "&gt;");
        return string2;
    }

    private final class ErrorPaneLayout
    implements LayoutManager {
        private JEditorPane dummy = new JEditorPane();

        private ErrorPaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = container.getWidth();
            int n2 = container.getHeight();
            Insets insets = container.getInsets();
            int n3 = BasicErrorPaneUI.this.detailButton.isVisible() ? BasicErrorPaneUI.this.detailButton.getPreferredSize().width : 0;
            n3 += BasicErrorPaneUI.this.detailButton.isVisible() ? BasicErrorPaneUI.this.detailButton.getPreferredSize().width : 0;
            n3 += BasicErrorPaneUI.this.reportButton.isVisible() ? 5 + BasicErrorPaneUI.this.reportButton.getPreferredSize().width : 0;
            n = Math.max(n, n3 += BasicErrorPaneUI.this.closeButton.isVisible() ? 5 + BasicErrorPaneUI.this.closeButton.getPreferredSize().width : 0) + insets.left + insets.right;
            if (BasicErrorPaneUI.this.errorMessage != null) {
                this.dummy.setContentType(BasicErrorPaneUI.this.errorMessage.getContentType());
                this.dummy.setEditorKit(BasicErrorPaneUI.this.errorMessage.getEditorKit());
                this.dummy.setText(BasicErrorPaneUI.this.errorMessage.getText());
                this.dummy.setSize(n, 20);
                int n4 = this.dummy.getPreferredSize().height;
                n2 = Math.max(n4, BasicErrorPaneUI.this.iconLabel.getPreferredSize().height) + 10 + BasicErrorPaneUI.this.closeButton.getPreferredSize().height;
                if (BasicErrorPaneUI.this.detailsPanel.isVisible()) {
                    n2 += BasicErrorPaneUI.this.getDetailsHeight();
                }
            }
            if (BasicErrorPaneUI.this.iconLabel != null && BasicErrorPaneUI.this.iconLabel.getIcon() != null) {
                n += BasicErrorPaneUI.this.iconLabel.getIcon().getIconWidth();
                n2 += 10;
            }
            return new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            if (BasicErrorPaneUI.this.iconLabel != null) {
                int n3;
                Dimension dimension = BasicErrorPaneUI.this.iconLabel.getPreferredSize();
                BasicErrorPaneUI.this.iconLabel.setBounds(n, n2, dimension.width, dimension.height);
                int n4 = n += dimension.width + 17;
                this.dummy.setContentType(BasicErrorPaneUI.this.errorMessage.getContentType());
                this.dummy.setText(BasicErrorPaneUI.this.errorMessage.getText());
                this.dummy.setSize(container.getWidth() - n4 - insets.right, 20);
                dimension = this.dummy.getPreferredSize();
                int n5 = n;
                int n6 = n2;
                Dimension dimension2 = new Dimension(container.getWidth() - n4 - insets.right, dimension.height);
                n = n3 = container.getWidth() - insets.right;
                dimension = BasicErrorPaneUI.this.detailButton.getPreferredSize();
                int n7 = (n2 += dimension.height + 10) + 5;
                if (BasicErrorPaneUI.this.detailButton.isVisible()) {
                    dimension = BasicErrorPaneUI.this.detailButton.getPreferredSize();
                    BasicErrorPaneUI.this.detailButton.setBounds(n -= dimension.width, n7, dimension.width, dimension.height);
                }
                if (BasicErrorPaneUI.this.detailButton.isVisible()) {
                    BasicErrorPaneUI.this.detailButton.setBounds(n, n7, dimension.width, dimension.height);
                }
                BasicErrorPaneUI.this.errorScrollPane.setBounds(n5, n6, dimension2.width, n7 - n6);
                if (BasicErrorPaneUI.this.reportButton.isVisible()) {
                    dimension = BasicErrorPaneUI.this.reportButton.getPreferredSize();
                    n -= dimension.width;
                    BasicErrorPaneUI.this.reportButton.setBounds(n -= 5, n7, dimension.width, dimension.height);
                }
                dimension = BasicErrorPaneUI.this.closeButton.getPreferredSize();
                n -= dimension.width;
                BasicErrorPaneUI.this.closeButton.setBounds(n -= 5, n7, dimension.width, dimension.height);
                if (BasicErrorPaneUI.this.detailsPanel.isVisible()) {
                    n2 = n7 + dimension.height + 6;
                    n = n4;
                    int n8 = n3 - n;
                    BasicErrorPaneUI.this.detailsPanel.setBounds(n, n2, n8, container.getHeight() - (n2 + insets.bottom));
                }
            }
        }
    }

    private final class ErrorPaneListener
    implements PropertyChangeListener {
        private ErrorPaneListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicErrorPaneUI.this.reinit();
        }
    }

    private final class JXInternalErrorFrame
    extends JInternalFrame {
        public JXInternalErrorFrame(JXErrorPane jXErrorPane) {
            this.setTitle(jXErrorPane.getErrorInfo().getTitle());
            this.setLayout(new BorderLayout());
            this.add((Component)jXErrorPane, "Center");
            final AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JXInternalErrorFrame.this.setVisible(false);
                    JXInternalErrorFrame.this.dispose();
                }
            };
            BasicErrorPaneUI.this.closeButton.addActionListener(abstractAction);
            this.addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent componentEvent) {
                    BasicErrorPaneUI.this.closeButton.removeActionListener(abstractAction);
                    BasicErrorPaneUI.this.exitIfFatal();
                }
            });
            this.getRootPane().setDefaultButton(BasicErrorPaneUI.this.closeButton);
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            this.getRootPane().registerKeyboardAction(abstractAction, keyStroke, 2);
        }
    }

    private final class JXErrorFrame
    extends JFrame {
        public JXErrorFrame(JXErrorPane jXErrorPane) {
            this.setTitle(jXErrorPane.getErrorInfo().getTitle());
            BasicErrorPaneUI.this.initWindow(this, jXErrorPane);
        }
    }

    private final class JXErrorDialog
    extends JDialog {
        public JXErrorDialog(Frame frame, JXErrorPane jXErrorPane) {
            super(frame, true);
            this.init(jXErrorPane);
        }

        public JXErrorDialog(Dialog dialog, JXErrorPane jXErrorPane) {
            super(dialog, true);
            this.init(jXErrorPane);
        }

        protected void init(JXErrorPane jXErrorPane) {
            this.setTitle(jXErrorPane.getErrorInfo() == null ? null : jXErrorPane.getErrorInfo().getTitle());
            BasicErrorPaneUI.this.initWindow(this, jXErrorPane);
        }
    }

    private static final class DetailsTransferHandler
    extends TransferHandler {
        private JTextComponent details;

        private DetailsTransferHandler(JTextComponent jTextComponent) {
            if (jTextComponent == null) {
                throw new NullPointerException("detail component cannot be null");
            }
            this.details = jTextComponent;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            String string = this.details.getSelectedText();
            if (string == null || string.equals("")) {
                this.details.selectAll();
                string = this.details.getSelectedText();
                this.details.select(-1, -1);
            }
            return new StringSelection(string);
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }
    }

    private static final class EqualSizeJButton
    extends JButton {
        private EqualSizeJButton[] group;

        public EqualSizeJButton() {
        }

        public EqualSizeJButton(String string) {
            super(string);
        }

        public EqualSizeJButton(Action action) {
            super(action);
        }

        public void setGroup(EqualSizeJButton[] equalSizeJButtonArray) {
            this.group = equalSizeJButtonArray;
        }

        private Dimension getRealPreferredSize() {
            return super.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.group.length; ++i) {
                Dimension dimension = this.group[i].getRealPreferredSize();
                n = Math.max(dimension.width, n);
                n2 = Math.max(dimension.height, n2);
            }
            return new Dimension(n, n2);
        }
    }

    private final class ResizeWindow
    implements ActionListener {
        private Window w;

        private ResizeWindow(Window window) {
            if (window == null) {
                throw new NullPointerException();
            }
            this.w = window;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Dimension dimension = null;
            dimension = this.w instanceof JDialog ? ((JDialog)this.w).getContentPane().getSize() : ((JFrame)this.w).getContentPane().getSize();
            Dimension dimension2 = this.w.getSize();
            int n = dimension2.height - dimension.height;
            Dimension dimension3 = BasicErrorPaneUI.this.pane.getSize();
            this.w.setSize(new Dimension(dimension2.width, dimension3.height + n));
            this.w.validate();
            this.w.repaint();
        }
    }

    private final class DetailsClickEvent
    implements ActionListener {
        private DetailsClickEvent() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicErrorPaneUI.this.setDetailsVisible(!BasicErrorPaneUI.this.detailsPanel.isVisible());
        }
    }

    private static final class CloseAction
    extends AbstractAction {
        private Window w;

        private CloseAction(Window window) {
            if (window == null) {
                throw new NullPointerException("Window cannot be null");
            }
            this.w = window;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.w.setVisible(false);
            this.w.dispose();
        }
    }
}

