/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import org.jdesktop.swingx.painter.AbstractPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PinstripePainter
extends AbstractPainter<Object> {
    private double angle = 45.0;
    private double spacing = 8.0;
    private double stripeWidth = 1.0;
    private Paint paint;

    public PinstripePainter() {
    }

    public PinstripePainter(Paint paint) {
        this(paint, 45.0);
    }

    public PinstripePainter(Paint paint, double d) {
        this.paint = paint;
        this.angle = d;
    }

    public PinstripePainter(double d) {
        this.angle = d;
    }

    public PinstripePainter(Paint paint, double d, double d2, double d3) {
        this.paint = paint;
        this.angle = d;
        this.stripeWidth = d2;
        this.spacing = d3;
    }

    public void setPaint(Paint paint) {
        Paint paint2 = this.getPaint();
        this.paint = paint;
        this.firePropertyChange("paint", paint2, this.getPaint());
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setAngle(double d) {
        if (d > 360.0) {
            d %= 360.0;
        }
        if (d < 0.0) {
            d = 360.0 - d * -1.0 % 360.0;
        }
        double d2 = this.getAngle();
        this.angle = d;
        this.firePropertyChange("angle", d2, this.getAngle());
    }

    public double getAngle() {
        return this.angle;
    }

    public void setSpacing(double d) {
        double d2 = this.getSpacing();
        this.spacing = d;
        this.firePropertyChange("spacing", d2, this.getSpacing());
    }

    public double getSpacing() {
        return this.spacing;
    }

    @Override
    protected void doPaint(Graphics2D graphics2D, Object object, int n, int n2) {
        Shape shape = graphics2D.getClip();
        Area area = new Area(new Rectangle(0, 0, n, n2));
        if (shape != null) {
            area = new Area(shape);
        }
        area.intersect(new Area(new Rectangle(0, 0, n, n2)));
        graphics2D.setClip(area);
        Paint paint = this.getPaint();
        if (paint == null) {
            if (object instanceof JComponent) {
                graphics2D.setColor(((JComponent)object).getForeground());
            }
        } else {
            graphics2D.setPaint(paint);
        }
        graphics2D.setStroke(new BasicStroke((float)this.getStripeWidth()));
        double d = Math.sqrt(n * n + n2 * n2);
        double d2 = Math.toRadians(this.getAngle());
        graphics2D.rotate(d2);
        double d3 = this.getSpacing();
        int n3 = (int)(d / (d3 += this.getStripeWidth()));
        for (int i = 0; i < n3; ++i) {
            double d4 = (double)i * d3;
            Line2D.Double double_ = new Line2D.Double(d4, -d, d4, d);
            graphics2D.draw(double_);
        }
        graphics2D.setClip(shape);
    }

    public double getStripeWidth() {
        return this.stripeWidth;
    }

    public void setStripeWidth(double d) {
        double d2 = this.getStripeWidth();
        this.stripeWidth = d;
        this.firePropertyChange("stripeWidth", new Double(d2), new Double(d));
    }
}

