/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.painter.Painter;

public class PainterGlasspane
extends JComponent {
    private Painter painter;
    private List<JComponent> targets = new ArrayList<JComponent>();

    public void addTarget(JComponent jComponent) {
        this.targets.add(jComponent);
        this.repaint();
    }

    public void removeTarget(JComponent jComponent) {
        this.targets.remove(jComponent);
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getPainter() != null) {
            for (JComponent jComponent : this.targets) {
                Point point = this.calcOffset(jComponent);
                graphics2D.translate(point.x, point.y);
                this.getPainter().paint(graphics2D, jComponent, jComponent.getWidth(), jComponent.getHeight());
                graphics2D.translate(-point.x, -point.y);
            }
        }
    }

    private Point calcOffset(JComponent jComponent) {
        if (jComponent == null) {
            return new Point(0, 0);
        }
        if (jComponent.getParent() == SwingUtilities.getWindowAncestor(jComponent)) {
            return new Point(0, 0);
        }
        Point point = this.calcOffset((JComponent)jComponent.getParent());
        Point point2 = jComponent.getLocation();
        return new Point(point.x + point2.x, point.y + point2.y);
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        Painter painter2 = this.getPainter();
        this.painter = painter;
        this.firePropertyChange("painter", painter2, this.getPainter());
        this.repaint();
    }
}

