/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.painter.AbstractPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusyPainter
extends AbstractPainter<Object> {
    private int frame = -1;
    private int points = 8;
    private Color baseColor = new Color(200, 200, 200);
    private Color highlightColor = Color.BLACK;
    private int trailLength = 4;
    private Shape pointShape;
    private Shape trajectory;
    private JXBusyLabel.Direction direction = JXBusyLabel.Direction.RIGHT;
    private boolean paintCentered;

    public BusyPainter() {
        this(26);
    }

    public BusyPainter(int n) {
        this(BusyPainter.getScaledDefaultPoint(n), BusyPainter.getScaledDefaultTrajectory(n));
    }

    protected static Shape getScaledDefaultTrajectory(int n) {
        return new Ellipse2D.Float(n * 8 / 26 / 2, n * 8 / 26 / 2, n - n * 8 / 26, n - n * 8 / 26);
    }

    protected static Shape getScaledDefaultPoint(int n) {
        return new RoundRectangle2D.Float(0.0f, 0.0f, n * 8 / 26, 4.0f, 4.0f, 4.0f);
    }

    public BusyPainter(Shape shape, Shape shape2) {
        this.init(shape, shape2, Color.LIGHT_GRAY, Color.BLACK);
    }

    protected void init(Shape shape, Shape shape2, Color color, Color color2) {
        this.baseColor = color;
        this.highlightColor = color2;
        this.pointShape = shape;
        this.trajectory = shape2;
    }

    @Override
    protected void doPaint(Graphics2D graphics2D, Object object, int n, int n2) {
        int n3;
        float f;
        Rectangle rectangle = this.getTrajectory().getBounds();
        int n4 = n - rectangle.width - 2 * rectangle.x;
        int n5 = n2 - rectangle.height - 2 * rectangle.y;
        if (this.isPaintCentered()) {
            graphics2D.translate(n4 / 2, n5 / 2);
        }
        PathIterator pathIterator = this.trajectory.getPathIterator(null);
        float[] fArray = new float[6];
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        float f2 = 0.0f;
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        do {
            int n6;
            try {
                n6 = pathIterator.currentSegment(fArray);
            }
            catch (NoSuchElementException noSuchElementException) {
                return;
            }
            if (n6 == 1 || n6 == 4 && (float_2.x != float_.x || float_2.y != float_.y)) {
                f = this.calcLine(fArray, float_);
                f2 += f;
                arrayList.add(new float[]{f, 0.0f, 0.0f, 0.0f, 0.0f, fArray[0], fArray[1], n6});
                float_.x = fArray[0];
                float_.y = fArray[1];
            }
            if (n6 == 0) {
                float_2.x = float_.x = fArray[0];
                float_2.y = float_.y = fArray[1];
            }
            if (n6 == 3) {
                f = this.calcCube(fArray, float_);
                f2 += f;
                arrayList.add(new float[]{f, fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], n6});
                float_.x = fArray[4];
                float_.y = fArray[5];
            }
            if (n6 == 2) {
                f = this.calcLengthOfQuad(fArray, float_);
                f2 += f;
                arrayList.add(new float[]{f, fArray[0], fArray[1], 0.0f, 0.0f, fArray[2], fArray[3], n6});
                float_.x = fArray[2];
                float_.y = fArray[3];
            }
            pathIterator.next();
        } while (!pathIterator.isDone());
        f = f2 / (float)this.getPoints();
        ArrayList<Point2D.Float> arrayList2 = new ArrayList<Point2D.Float>();
        arrayList2.add(new Point2D.Float(float_2.x, float_2.y));
        int n7 = 0;
        float[] fArray2 = (float[])arrayList.get(n7);
        float f3 = fArray2[0];
        float f4 = f;
        Point2D.Float float_3 = new Point2D.Float(float_2.x, float_2.y);
        for (n3 = 1; n3 < this.getPoints(); ++n3) {
            while (f3 < f) {
                float_2.x = fArray2[5];
                float_2.y = fArray2[6];
                fArray2 = (float[])arrayList.get(++n7);
                f4 = f - f3;
                f3 += fArray2[0];
            }
            f3 -= f;
            Point2D.Float float_4 = this.calcPoint(f4, float_2, fArray2, n, n2);
            arrayList2.add(float_4);
            float_3.x += float_4.x;
            float_3.y += float_4.y;
            f4 += f;
        }
        float_3.x = (float)n / 2.0f;
        float_3.y = (float)n2 / 2.0f;
        n3 = 0;
        graphics2D.translate(float_3.x, float_3.y);
        for (Point2D.Float float_5 : arrayList2) {
            this.drawAt(graphics2D, n3++, float_5, float_3);
        }
        graphics2D.translate(-float_3.x, -float_3.y);
        if (this.isPaintCentered()) {
            graphics2D.translate(-n4 / 2, -n5 / 2);
        }
    }

    public boolean isPaintCentered() {
        return this.paintCentered;
    }

    private void drawAt(Graphics2D graphics2D, int n, Point2D.Float float_, Point2D.Float float_2) {
        graphics2D.setColor(this.calcFrameColor(n));
        this.paintRotatedCenteredShapeAtPoint(float_, float_2, graphics2D);
    }

    private void paintRotatedCenteredShapeAtPoint(Point2D.Float float_, Point2D.Float float_2, Graphics2D graphics2D) {
        Shape shape = this.getPointShape();
        double d = shape.getBounds().getHeight() / 2.0;
        double d2 = shape.getBounds().getWidth() / 2.0;
        double d3 = float_2.y - float_.y;
        double d4 = float_.x - float_2.x;
        double d5 = Math.signum(d3);
        double d6 = Math.signum(d4);
        d5 = d5 == 0.0 ? 1.0 : d5;
        d6 = d6 == 0.0 ? 1.0 : d6;
        d3 = Math.abs(d3);
        d4 = Math.abs(d4);
        double d7 = Math.atan(d3 / d4);
        d7 = d5 > 0.0 ? (d6 > 0.0 ? -d7 : -Math.PI + d7) : (d6 > 0.0 ? d7 : Math.PI - d7);
        double d8 = Math.sqrt(d3 * d3 + d4 * d4) - d2;
        double d9 = -d;
        graphics2D.rotate(d7);
        graphics2D.translate(d8, d9);
        graphics2D.fill(shape);
        graphics2D.translate(-d8, -d9);
        graphics2D.rotate(-d7);
    }

    private Point2D.Float calcPoint(float f, Point2D.Float float_, float[] fArray, int n, int n2) {
        Point2D.Float float_2 = new Point2D.Float();
        if (fArray[7] == 1.0f) {
            float f2 = fArray[5] - float_.x;
            float f3 = fArray[6] - float_.y;
            float f4 = fArray[0];
            float_2.x = float_.x + f2 * f / f4;
            float_2.y = float_.y + f3 * f / f4;
        } else if (fArray[7] == 2.0f) {
            Point2D.Float float_3 = new Point2D.Float(fArray[1] / (float)n, fArray[2] / (float)n2);
            Point2D.Float float_4 = new Point2D.Float(fArray[5] / (float)n, fArray[6] / (float)n2);
            Point2D.Float float_5 = new Point2D.Float(float_.x / (float)n, float_.y / (float)n2);
            float_2 = BusyPainter.getXY(f / fArray[0], float_5, float_3, float_4);
            float_2.x *= (float)n;
            float_2.y *= (float)n2;
        } else if (fArray[7] == 3.0f) {
            float f5 = Math.abs(float_.x - fArray[5]);
            float f6 = Math.abs(float_.y - fArray[6]);
            float f7 = Math.abs(float_.x - fArray[1]) / f5;
            float f8 = Math.abs(float_.y - fArray[2]) / f6;
            float f9 = Math.abs(float_.x - fArray[3]) / f5;
            float f10 = Math.abs(float_.y - fArray[4]) / f6;
            float_2 = this.getXY(f / fArray[0], f7, f8, f9, f10);
            float f11 = float_.x - fArray[5];
            float f12 = float_.y - fArray[6];
            float_2.x = float_.x - float_2.x * f11;
            float_2.y = float_.y - float_2.y * f12;
        }
        return float_2;
    }

    private float calcLine(float[] fArray, Point2D.Float float_) {
        float f = float_.x - fArray[0];
        float f2 = float_.y - fArray[1];
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        return f3;
    }

    private float calcCube(float[] fArray, Point2D.Float float_) {
        float f;
        float f2 = Math.abs(float_.x - fArray[4]);
        float f3 = Math.abs(float_.y - fArray[5]);
        float f4 = Math.abs(float_.x - fArray[0]) / f2;
        float f5 = Math.abs(float_.y - fArray[1]) / f3;
        float f6 = Math.abs(float_.x - fArray[2]) / f2;
        float f7 = Math.abs(float_.y - fArray[3]) / f3;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        for (f = 0.01f; f <= 1.0f; f += 0.01f) {
            Point2D.Float float_2 = this.getXY(f, f4, f5, f6, f7);
            f8 += (float)Math.sqrt((float_2.x - f9) * (float_2.x - f9) + (float_2.y - f10) * (float_2.y - f10));
            f9 = float_2.x;
            f10 = float_2.y;
        }
        f = (Math.abs(f2) + Math.abs(f3)) / 2.0f * f8;
        return f;
    }

    private float calcLengthOfQuad(float[] fArray, Point2D.Float float_) {
        float f;
        Point2D.Float float_2 = new Point2D.Float(fArray[0], fArray[1]);
        Point2D.Float float_3 = new Point2D.Float(fArray[2], fArray[3]);
        float f2 = Math.abs(float_.x - float_2.x);
        float f3 = Math.abs(float_.y - float_2.y);
        float f4 = Math.abs(float_.x - float_3.x);
        float f5 = Math.abs(float_.y - float_3.y);
        float f6 = Math.max(f2, f4);
        float f7 = Math.max(f3, f5);
        float_2.x = f2 / f6;
        float_2.y = f3 / f7;
        float_3.x = f4 / f6;
        float_3.y = f5 / f7;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        for (f = 0.01f; f <= 1.0f; f += 0.01f) {
            Point2D.Float float_4 = BusyPainter.getXY(f, new Point2D.Float(0.0f, 0.0f), float_2, float_3);
            f8 += (float)Math.sqrt((float_4.x - f9) * (float_4.x - f9) + (float_4.y - f10) * (float_4.y - f10));
            f9 = float_4.x;
            f10 = float_4.y;
        }
        f = Math.abs(fArray[2] - float_.x);
        float f11 = Math.abs(fArray[3] - float_.y);
        float f12 = (float)Math.sqrt(f * f + f11 * f11);
        return f8 * f12;
    }

    private Point2D.Float getXY(float f, float f2, float f3, float f4, float f5) {
        float f6 = 1.0f - f;
        float f7 = 3.0f * f * (f6 * f6);
        float f8 = 3.0f * (f * f) * f6;
        float f9 = f * f * f;
        Point2D.Float float_ = new Point2D.Float(f7 * f2 + f8 * f4 + f9, f7 * f3 + f8 * f5 + f9);
        return float_;
    }

    public static Point2D.Float getXY(float f, Point2D.Float float_, Point2D.Float float_2, Point2D.Float float_3) {
        float f2 = 1.0f - f;
        float f3 = f2 * f2;
        float f4 = 2.0f * f * f2;
        float f5 = f * f;
        Point2D.Float float_4 = new Point2D.Float(f3 * float_.x + f4 * float_2.x + f5 * float_3.x, f3 * float_.y + f4 * float_2.y + f5 * float_3.y);
        return float_4;
    }

    private Color calcFrameColor(int n) {
        if (this.frame == -1) {
            return this.getBaseColor();
        }
        for (int i = 0; i < this.getTrailLength(); ++i) {
            if (this.direction == JXBusyLabel.Direction.RIGHT && n == (this.frame - i + this.getPoints()) % this.getPoints()) {
                float f = 1.0f - (float)(this.getTrailLength() - i) / (float)this.getTrailLength();
                return ColorUtil.interpolate(this.getBaseColor(), this.getHighlightColor(), f);
            }
            if (this.direction != JXBusyLabel.Direction.LEFT || n != (this.frame + i) % this.getPoints()) continue;
            float f = (float)i / (float)this.getTrailLength();
            return ColorUtil.interpolate(this.getBaseColor(), this.getHighlightColor(), f);
        }
        return this.getBaseColor();
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int n) {
        int n2 = this.getFrame();
        this.frame = n;
        this.firePropertyChange("frame", n2, this.getFrame());
    }

    public Color getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(Color color) {
        Color color2 = this.getBaseColor();
        this.baseColor = color;
        this.firePropertyChange("baseColor", color2, this.getBaseColor());
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        Color color2 = this.getHighlightColor();
        this.highlightColor = color;
        this.firePropertyChange("highlightColor", color2, this.getHighlightColor());
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int n) {
        int n2 = this.getPoints();
        this.points = n;
        this.firePropertyChange("points", n2, this.getPoints());
    }

    public int getTrailLength() {
        return this.trailLength;
    }

    public void setTrailLength(int n) {
        int n2 = this.getTrailLength();
        this.trailLength = n;
        this.firePropertyChange("trailLength", n2, this.getTrailLength());
    }

    public final Shape getPointShape() {
        return this.pointShape;
    }

    public final void setPointShape(Shape shape) {
        Shape shape2 = this.getPointShape();
        this.pointShape = shape;
        if (this.getPointShape() != shape2 && this.getPointShape() != null && !this.getPointShape().equals(shape2)) {
            this.firePropertyChange("pointShape", shape2, this.getPointShape());
        }
    }

    public final Shape getTrajectory() {
        return this.trajectory;
    }

    public final void setTrajectory(Shape shape) {
        Shape shape2 = this.getTrajectory();
        this.trajectory = shape;
        if (this.getTrajectory() != shape2 && this.getTrajectory() != null && !this.getTrajectory().equals(shape2)) {
            this.firePropertyChange("trajectory", shape2, this.getTrajectory());
        }
    }

    public void setDirection(JXBusyLabel.Direction direction) {
        JXBusyLabel.Direction direction2 = this.getDirection();
        this.direction = direction;
        if (this.getDirection() != direction2 && this.getDirection() != null && !this.getDirection().equals((Object)direction2)) {
            this.firePropertyChange("direction", (Object)direction2, (Object)this.getDirection());
        }
    }

    public JXBusyLabel.Direction getDirection() {
        return this.direction;
    }

    protected Shape provideShape(Graphics2D graphics2D, Object object, int n, int n2) {
        return new Rectangle(0, 0, n, n2);
    }

    public void setPaintCentered(boolean bl) {
        boolean bl2 = this.isPaintCentered();
        this.paintCentered = bl;
        this.firePropertyChange("paintCentered", bl2, this.isPaintCentered());
    }
}

