/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.image;

import java.awt.image.BufferedImage;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.image.AbstractFilter;
import org.jdesktop.swingx.image.FastBlurFilter;

public class StackBlurFilter
extends AbstractFilter {
    private final int radius;
    private final int iterations;

    public StackBlurFilter() {
        this(3, 3);
    }

    public StackBlurFilter(int n) {
        this(n, 3);
    }

    public StackBlurFilter(int n, int n2) {
        if (n < 1) {
            n = 1;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        this.radius = n;
        this.iterations = n2;
    }

    public int getEffectiveRadius() {
        return this.getIterations() * this.getRadius();
    }

    public int getRadius() {
        return this.radius;
    }

    public int getIterations() {
        return this.iterations;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        int[] nArray = new int[n * n2];
        int[] nArray2 = new int[n * n2];
        GraphicsUtilities.getPixels(bufferedImage, 0, 0, n, n2, nArray);
        for (int i = 0; i < this.iterations; ++i) {
            FastBlurFilter.blur(nArray, nArray2, n, n2, this.radius);
            FastBlurFilter.blur(nArray2, nArray, n2, n, this.radius);
        }
        GraphicsUtilities.setPixels(bufferedImage2, 0, 0, n, n2, nArray);
        return bufferedImage2;
    }
}

