/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.image;

import java.awt.image.BufferedImage;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.image.AbstractFilter;

public class FastBlurFilter
extends AbstractFilter {
    private final int radius;

    public FastBlurFilter() {
        this(3);
    }

    public FastBlurFilter(int n) {
        if (n < 1) {
            n = 1;
        }
        this.radius = n;
    }

    public int getRadius() {
        return this.radius;
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
        }
        int[] nArray = new int[n * n2];
        int[] nArray2 = new int[n * n2];
        GraphicsUtilities.getPixels(bufferedImage, 0, 0, n, n2, nArray);
        FastBlurFilter.blur(nArray, nArray2, n, n2, this.radius);
        FastBlurFilter.blur(nArray2, nArray, n2, n, this.radius);
        GraphicsUtilities.setPixels(bufferedImage2, 0, 0, n, n2, nArray);
        return bufferedImage2;
    }

    static void blur(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        int n4;
        int n5 = n3 * 2 + 1;
        int n6 = n3 + 1;
        int n7 = 0;
        int[] nArray3 = new int[256 * n5];
        for (int i = 0; i < nArray3.length; ++i) {
            nArray3[i] = i / n5;
        }
        int[] nArray4 = new int[n6];
        if (n3 < n) {
            for (n4 = 0; n4 < nArray4.length; ++n4) {
                nArray4[n4] = n4;
            }
        } else {
            for (n4 = 0; n4 < n; ++n4) {
                nArray4[n4] = n4;
            }
            for (n4 = n; n4 < nArray4.length; ++n4) {
                nArray4[n4] = n - 1;
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            int n8;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = n4;
            int n14 = nArray[n7];
            n12 += n6 * (n14 >> 24 & 0xFF);
            n11 += n6 * (n14 >> 16 & 0xFF);
            n10 += n6 * (n14 >> 8 & 0xFF);
            n9 += n6 * (n14 & 0xFF);
            for (n8 = 1; n8 <= n3; ++n8) {
                n14 = nArray[n7 + nArray4[n8]];
                n12 += n14 >> 24 & 0xFF;
                n11 += n14 >> 16 & 0xFF;
                n10 += n14 >> 8 & 0xFF;
                n9 += n14 & 0xFF;
            }
            for (n8 = 0; n8 < n; ++n8) {
                int n15;
                nArray2[n13] = nArray3[n12] << 24 | nArray3[n11] << 16 | nArray3[n10] << 8 | nArray3[n9];
                n13 += n2;
                int n16 = n8 + n6;
                if (n16 >= n) {
                    n16 = n - 1;
                }
                if ((n15 = n8 - n3) < 0) {
                    n15 = 0;
                }
                int n17 = nArray[n7 + n16];
                int n18 = nArray[n7 + n15];
                n12 += n17 >> 24 & 0xFF;
                n12 -= n18 >> 24 & 0xFF;
                n11 += n17 >> 16 & 0xFF;
                n11 -= n18 >> 16 & 0xFF;
                n10 += n17 >> 8 & 0xFF;
                n10 -= n18 >> 8 & 0xFF;
                n9 += n17 & 0xFF;
                n9 -= n18 & 0xFF;
            }
            n7 += n;
        }
    }
}

