/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Morphing2D
implements Shape {
    private double morph;
    private Geometry startGeometry;
    private Geometry endGeometry;

    public Morphing2D(Shape shape, Shape shape2) {
        this.startGeometry = new Geometry(shape);
        this.endGeometry = new Geometry(shape2);
        if (this.startGeometry.getWindingRule() != this.endGeometry.getWindingRule()) {
            throw new IllegalPathStateException("shapes must use same winding rule");
        }
        double[] dArray = this.startGeometry.getTvals();
        double[] dArray2 = this.endGeometry.getTvals();
        double[] dArray3 = Morphing2D.mergeTvals(dArray, dArray2);
        this.startGeometry.setTvals(dArray3);
        this.endGeometry.setTvals(dArray3);
    }

    public double getMorphing() {
        return this.morph;
    }

    public void setMorphing(double d) {
        if (d > 1.0) {
            d = 1.0;
        } else if (!(d >= 0.0)) {
            d = 0.0;
        }
        this.morph = d;
    }

    private static double interp(double d, double d2, double d3) {
        return d + (d2 - d) * d3;
    }

    private static double[] mergeTvals(double[] dArray, double[] dArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n < dArray.length && n2 < dArray2.length) {
            double d = dArray[n];
            double d2 = dArray2[n2];
            if (d <= d2) {
                ++n;
            }
            if (d2 <= d) {
                ++n2;
            }
            ++n3;
        }
        double[] dArray3 = new double[n3];
        n = 0;
        n2 = 0;
        n3 = 0;
        while (n < dArray.length && n2 < dArray2.length) {
            double d = dArray[n];
            double d3 = dArray2[n2];
            if (d <= d3) {
                dArray3[n3] = d;
                ++n;
            }
            if (d3 <= d) {
                dArray3[n3] = d3;
                ++n2;
            }
            ++n3;
        }
        return dArray3;
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public Rectangle2D getBounds2D() {
        double d;
        double d2;
        int n = this.startGeometry.getNumCoords();
        double d3 = d2 = Morphing2D.interp(this.startGeometry.getCoord(0), this.endGeometry.getCoord(0), this.morph);
        double d4 = d = Morphing2D.interp(this.startGeometry.getCoord(1), this.endGeometry.getCoord(1), this.morph);
        for (int i = 2; i < n; i += 2) {
            double d5 = Morphing2D.interp(this.startGeometry.getCoord(i), this.endGeometry.getCoord(i), this.morph);
            double d6 = Morphing2D.interp(this.startGeometry.getCoord(i + 1), this.endGeometry.getCoord(i + 1), this.morph);
            if (d3 > d5) {
                d3 = d5;
            }
            if (d4 > d6) {
                d4 = d6;
            }
            if (d2 < d5) {
                d2 = d5;
            }
            if (!(d < d6)) continue;
            d = d6;
        }
        return new Rectangle2D.Double(d3, d4, d2 - d3, d - d4);
    }

    public boolean contains(double d, double d2) {
        throw new InternalError("unimplemented");
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        throw new InternalError("unimplemented");
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        throw new InternalError("unimplemented");
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new Iterator(affineTransform, this.startGeometry, this.endGeometry, this.morph);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }

    private static class Iterator
    implements PathIterator {
        AffineTransform at;
        Geometry g0;
        Geometry g1;
        double t;
        int cindex;
        double[] dcoords;

        public Iterator(AffineTransform affineTransform, Geometry geometry, Geometry geometry2, double d) {
            this.at = affineTransform;
            this.g0 = geometry;
            this.g1 = geometry2;
            this.t = d;
        }

        public int getWindingRule() {
            return this.g0.getWindingRule();
        }

        public boolean isDone() {
            return this.cindex > this.g0.getNumCoords();
        }

        public void next() {
            this.cindex = this.cindex == 0 ? 2 : (this.cindex += 6);
        }

        public int currentSegment(float[] fArray) {
            int n;
            if (this.dcoords == null) {
                this.dcoords = new double[6];
            }
            if ((n = this.currentSegment(this.dcoords)) != 4) {
                fArray[0] = (float)this.dcoords[0];
                fArray[1] = (float)this.dcoords[1];
                if (n != 0) {
                    fArray[2] = (float)this.dcoords[2];
                    fArray[3] = (float)this.dcoords[3];
                    fArray[4] = (float)this.dcoords[4];
                    fArray[5] = (float)this.dcoords[5];
                }
            }
            return n;
        }

        public int currentSegment(double[] dArray) {
            int n;
            int n2;
            if (this.cindex == 0) {
                n2 = 0;
                n = 2;
            } else if (this.cindex >= this.g0.getNumCoords()) {
                n2 = 4;
                n = 0;
            } else {
                n2 = 3;
                n = 6;
            }
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    dArray[i] = Morphing2D.interp(this.g0.getCoord(this.cindex + i), this.g1.getCoord(this.cindex + i), this.t);
                }
                if (this.at != null) {
                    this.at.transform(dArray, 0, dArray, 0, n / 2);
                }
            }
            return n2;
        }
    }

    private static class Geometry {
        double[] bezierCoords = new double[20];
        int numCoords;
        int windingrule;
        double[] myTvals;

        public Geometry(Shape shape) {
            int n;
            double d;
            double d2;
            int n2;
            PathIterator pathIterator = shape.getPathIterator(null);
            this.windingrule = pathIterator.getWindingRule();
            if (pathIterator.isDone()) {
                this.numCoords = 8;
            }
            double[] dArray = new double[6];
            int n3 = pathIterator.currentSegment(dArray);
            pathIterator.next();
            if (n3 != 0) {
                throw new IllegalPathStateException("missing initial moveto");
            }
            double d3 = this.bezierCoords[0] = dArray[0];
            double d4 = this.bezierCoords[1] = dArray[1];
            this.numCoords = 2;
            while (!pathIterator.isDone()) {
                if (this.numCoords + 6 > this.bezierCoords.length) {
                    n2 = (this.numCoords - 2) * 2 + 2;
                    double[] dArray2 = new double[n2];
                    System.arraycopy(this.bezierCoords, 0, dArray2, 0, this.numCoords);
                    this.bezierCoords = dArray2;
                }
                switch (pathIterator.currentSegment(dArray)) {
                    case 0: {
                        throw new InternalError("Cannot handle multiple subpaths");
                    }
                    case 4: {
                        if (d3 == this.bezierCoords[0] && d4 == this.bezierCoords[1]) break;
                        dArray[0] = this.bezierCoords[0];
                        dArray[1] = this.bezierCoords[1];
                    }
                    case 1: {
                        d2 = dArray[0];
                        d = dArray[1];
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(d3, d2, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(d4, d, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(d2, d3, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(d, d4, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = d3 = d2;
                        this.bezierCoords[this.numCoords++] = d4 = d;
                        break;
                    }
                    case 2: {
                        double d5 = dArray[0];
                        double d6 = dArray[1];
                        d2 = dArray[2];
                        d = dArray[3];
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(d5, d3, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(d6, d4, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(d5, d2, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = Morphing2D.interp(d6, d, 0.3333333333333333);
                        this.bezierCoords[this.numCoords++] = d3 = d2;
                        this.bezierCoords[this.numCoords++] = d4 = d;
                        break;
                    }
                    case 3: {
                        this.bezierCoords[this.numCoords++] = dArray[0];
                        this.bezierCoords[this.numCoords++] = dArray[1];
                        this.bezierCoords[this.numCoords++] = dArray[2];
                        this.bezierCoords[this.numCoords++] = dArray[3];
                        this.bezierCoords[this.numCoords++] = d3 = dArray[4];
                        this.bezierCoords[this.numCoords++] = d4 = dArray[5];
                    }
                }
                pathIterator.next();
            }
            if (this.numCoords < 8 || d3 != this.bezierCoords[0] || d4 != this.bezierCoords[1]) {
                d2 = this.bezierCoords[0];
                d = this.bezierCoords[1];
                this.bezierCoords[this.numCoords++] = Morphing2D.interp(d3, d2, 0.3333333333333333);
                this.bezierCoords[this.numCoords++] = Morphing2D.interp(d4, d, 0.3333333333333333);
                this.bezierCoords[this.numCoords++] = Morphing2D.interp(d2, d3, 0.3333333333333333);
                this.bezierCoords[this.numCoords++] = Morphing2D.interp(d, d4, 0.3333333333333333);
                this.bezierCoords[this.numCoords++] = d2;
                this.bezierCoords[this.numCoords++] = d;
            }
            n2 = 0;
            double d7 = this.bezierCoords[0];
            double d8 = this.bezierCoords[1];
            for (int i = 6; i < this.numCoords; i += 6) {
                double d9 = this.bezierCoords[i];
                double d10 = this.bezierCoords[i + 1];
                if (!(d10 < d8) && (d10 != d8 || !(d9 < d7))) continue;
                n2 = i;
                d7 = d9;
                d8 = d10;
            }
            if (n2 > 0) {
                double[] dArray3 = new double[this.numCoords];
                System.arraycopy(this.bezierCoords, n2, dArray3, 0, this.numCoords - n2);
                System.arraycopy(this.bezierCoords, 2, dArray3, this.numCoords - n2, n2);
                this.bezierCoords = dArray3;
            }
            double d11 = 0.0;
            d3 = this.bezierCoords[0];
            d4 = this.bezierCoords[1];
            for (n = 2; n < this.numCoords; n += 2) {
                d2 = this.bezierCoords[n];
                d = this.bezierCoords[n + 1];
                d11 += d3 * d - d2 * d4;
                d3 = d2;
                d4 = d;
            }
            if (d11 < 0.0) {
                n = 2;
                for (int i = this.numCoords - 4; n < i; n += 2, i -= 2) {
                    d3 = this.bezierCoords[n];
                    d4 = this.bezierCoords[n + 1];
                    this.bezierCoords[n] = this.bezierCoords[i];
                    this.bezierCoords[n + 1] = this.bezierCoords[i + 1];
                    this.bezierCoords[i] = d3;
                    this.bezierCoords[i + 1] = d4;
                }
            }
        }

        public int getWindingRule() {
            return this.windingrule;
        }

        public int getNumCoords() {
            return this.numCoords;
        }

        public double getCoord(int n) {
            return this.bezierCoords[n];
        }

        public double[] getTvals() {
            double d;
            double d2;
            if (this.myTvals != null) {
                return this.myTvals;
            }
            double[] dArray = new double[(this.numCoords - 2) / 6 + 1];
            double d3 = this.bezierCoords[0];
            double d4 = this.bezierCoords[1];
            double d5 = 0.0;
            int n = 2;
            int n2 = 0;
            while (n < this.numCoords) {
                d2 = d3;
                d = d4;
                double d6 = this.bezierCoords[n++];
                double d7 = this.bezierCoords[n++];
                double d8 = Math.sqrt((d2 -= d6) * d2 + (d -= d7) * d);
                d2 = d6;
                d = d7;
                d6 = this.bezierCoords[n++];
                d7 = this.bezierCoords[n++];
                d8 += Math.sqrt((d2 -= d6) * d2 + (d -= d7) * d);
                d2 = d6;
                d = d7;
                d6 = this.bezierCoords[n++];
                d7 = this.bezierCoords[n++];
                d8 += Math.sqrt((d2 -= d6) * d2 + (d -= d7) * d);
                d8 += Math.sqrt((d3 -= d6) * d3 + (d4 -= d7) * d4);
                if ((d8 /= 2.0) < 0.001) {
                    d8 = 0.001;
                }
                dArray[n2++] = d5 += d8;
                d3 = d6;
                d4 = d7;
            }
            d2 = dArray[0];
            dArray[0] = 0.0;
            for (n2 = 1; n2 < dArray.length - 1; ++n2) {
                d = dArray[n2];
                dArray[n2] = d2 / d5;
                d2 = d;
            }
            dArray[n2] = 1.0;
            this.myTvals = dArray;
            return dArray;
        }

        public void setTvals(double[] dArray) {
            double d;
            double d2;
            double[] dArray2 = this.bezierCoords;
            double[] dArray3 = new double[2 + (dArray.length - 1) * 6];
            double[] dArray4 = this.getTvals();
            int n = 0;
            double d3 = d2 = dArray2[n++];
            double d4 = d2;
            double d5 = d2;
            double d6 = d = dArray2[n++];
            double d7 = d;
            double d8 = d;
            int n2 = 0;
            dArray3[n2++] = d5;
            dArray3[n2++] = d8;
            double d9 = 0.0;
            double d10 = 0.0;
            int n3 = 1;
            int n4 = 1;
            while (n4 < dArray.length) {
                if (d9 >= d10) {
                    d5 = d2;
                    d8 = d;
                    d4 = dArray2[n++];
                    d7 = dArray2[n++];
                    d3 = dArray2[n++];
                    d6 = dArray2[n++];
                    d2 = dArray2[n++];
                    d = dArray2[n++];
                    d10 = dArray4[n3++];
                }
                int n5 = n4++;
                double d11 = dArray[n5];
                if (d11 < d10) {
                    double d12 = (d11 - d9) / (d10 - d9);
                    dArray3[n2++] = d5 = Morphing2D.interp(d5, d4, d12);
                    dArray3[n2++] = d8 = Morphing2D.interp(d8, d7, d12);
                    d4 = Morphing2D.interp(d4, d3, d12);
                    d7 = Morphing2D.interp(d7, d6, d12);
                    d3 = Morphing2D.interp(d3, d2, d12);
                    d6 = Morphing2D.interp(d6, d, d12);
                    dArray3[n2++] = d5 = Morphing2D.interp(d5, d4, d12);
                    dArray3[n2++] = d8 = Morphing2D.interp(d8, d7, d12);
                    d4 = Morphing2D.interp(d4, d3, d12);
                    d7 = Morphing2D.interp(d7, d6, d12);
                    dArray3[n2++] = d5 = Morphing2D.interp(d5, d4, d12);
                    dArray3[n2++] = d8 = Morphing2D.interp(d8, d7, d12);
                } else {
                    dArray3[n2++] = d4;
                    dArray3[n2++] = d7;
                    dArray3[n2++] = d3;
                    dArray3[n2++] = d6;
                    dArray3[n2++] = d2;
                    dArray3[n2++] = d;
                }
                d9 = d11;
            }
            this.bezierCoords = dArray3;
            this.numCoords = dArray3.length;
            this.myTvals = dArray;
        }
    }
}

