/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.event;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.util.Contract;

public class CompoundFocusListener
extends AbstractBean {
    private JComponent root;
    private PropertyChangeListener managerListener;
    private boolean focused;

    public CompoundFocusListener(JComponent jComponent) {
        this.root = Contract.asNotNull(jComponent, "root must not be null");
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.addManagerListener(keyboardFocusManager);
        this.permanentFocusOwnerChanged(keyboardFocusManager.getPermanentFocusOwner());
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void release() {
        this.removeManagerListener(KeyboardFocusManager.getCurrentKeyboardFocusManager());
        this.removeAllListeners();
        this.root = null;
    }

    private void removeAllListeners() {
        for (PropertyChangeListener propertyChangeListener : this.getPropertyChangeListeners()) {
            this.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected void permanentFocusOwnerChanged(Component component) {
        if (component == null) {
            return;
        }
        this.setFocused(SwingXUtilities.isDescendingFrom(component, this.root));
    }

    private void setFocused(boolean bl) {
        boolean bl2 = this.isFocused();
        this.focused = bl;
        this.firePropertyChange("focused", bl2, this.isFocused());
    }

    private void addManagerListener(KeyboardFocusManager keyboardFocusManager) {
        keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this.getManagerListener());
    }

    private void removeManagerListener(KeyboardFocusManager keyboardFocusManager) {
        keyboardFocusManager.removePropertyChangeListener("permanentFocusOwner", this.getManagerListener());
    }

    private PropertyChangeListener getManagerListener() {
        if (this.managerListener == null) {
            this.managerListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("permanentFocusOwner".equals(propertyChangeEvent.getPropertyName())) {
                        CompoundFocusListener.this.permanentFocusOwnerChanged((Component)propertyChangeEvent.getNewValue());
                    }
                }
            };
        }
        return this.managerListener;
    }
}

