/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Color;
import java.awt.Component;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

public class ColorHighlighter
extends AbstractHighlighter {
    private Color background;
    private Color foreground;
    private Color selectedBackground;
    private Color selectedForeground;

    public ColorHighlighter() {
        this(null);
    }

    public ColorHighlighter(HighlightPredicate highlightPredicate) {
        this(highlightPredicate, null, null);
    }

    public ColorHighlighter(Color color, Color color2) {
        this(null, color, color2);
    }

    public ColorHighlighter(HighlightPredicate highlightPredicate, Color color, Color color2) {
        this(highlightPredicate, color, color2, null, null);
    }

    public ColorHighlighter(Color color, Color color2, Color color3, Color color4) {
        this(null, color, color2, color3, color4);
    }

    public ColorHighlighter(HighlightPredicate highlightPredicate, Color color, Color color2, Color color3, Color color4) {
        super(highlightPredicate);
        this.background = color;
        this.foreground = color2;
        this.selectedBackground = color3;
        this.selectedForeground = color4;
    }

    protected Component doHighlight(Component component, ComponentAdapter componentAdapter) {
        this.applyBackground(component, componentAdapter);
        this.applyForeground(component, componentAdapter);
        return component;
    }

    protected void applyBackground(Component component, ComponentAdapter componentAdapter) {
        Color color;
        Color color2 = color = componentAdapter.isSelected() ? this.getSelectedBackground() : this.getBackground();
        if (color != null) {
            component.setBackground(color);
        }
    }

    protected void applyForeground(Component component, ComponentAdapter componentAdapter) {
        Color color;
        Color color2 = color = componentAdapter.isSelected() ? this.getSelectedForeground() : this.getForeground();
        if (color != null) {
            component.setForeground(color);
        }
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        if (this.areEqual(color, this.getBackground())) {
            return;
        }
        this.background = color;
        this.fireStateChanged();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        if (this.areEqual(color, this.getForeground())) {
            return;
        }
        this.foreground = color;
        this.fireStateChanged();
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setSelectedBackground(Color color) {
        if (this.areEqual(color, this.getSelectedBackground())) {
            return;
        }
        this.selectedBackground = color;
        this.fireStateChanged();
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }

    public void setSelectedForeground(Color color) {
        if (this.areEqual(color, this.getSelectedForeground())) {
            return;
        }
        this.selectedForeground = color;
        this.fireStateChanged();
    }
}

