/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.swingx.JXGradientChooser;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.multislider.MultiThumbModel;
import org.jdesktop.swingx.multislider.Thumb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradientPreviewPanel
extends JXPanel {
    private Paint checker_texture = null;
    private Point2D start;
    private Point2D end;
    public JXGradientChooser picker;
    boolean moving_start = false;
    boolean moving_end = false;
    private boolean radial = false;
    private boolean reversed = false;
    private boolean reflected = false;
    private boolean repeated = false;
    private MultipleGradientPaint gradient;
    private MultiThumbModel model;
    private Logger log = Logger.getLogger(GradientPreviewPanel.class.getName());

    public GradientPreviewPanel() {
        this.start = new Point2D.Float(10.0f, 10.0f);
        this.end = new Point2D.Float(80.0f, 10.0f);
        this.checker_texture = ColorUtil.getCheckerPaint();
        GradientMouseHandler gradientMouseHandler = new GradientMouseHandler();
        this.addMouseListener(gradientMouseHandler);
        this.addMouseMotionListener(gradientMouseHandler);
    }

    public void setGradient() {
        this.repaint();
    }

    public void setGradient(MultipleGradientPaint multipleGradientPaint) {
        MultipleGradientPaint multipleGradientPaint2 = this.getGradient();
        if (multipleGradientPaint instanceof LinearGradientPaint) {
            LinearGradientPaint linearGradientPaint = (LinearGradientPaint)multipleGradientPaint;
            this.start = linearGradientPaint.getStartPoint();
            this.end = linearGradientPaint.getEndPoint();
        } else {
            RadialGradientPaint radialGradientPaint = (RadialGradientPaint)multipleGradientPaint;
            this.start = radialGradientPaint.getCenterPoint();
            this.end = new Point2D.Double(this.start.getX(), this.start.getY() + (double)radialGradientPaint.getRadius());
        }
        this.gradient = multipleGradientPaint;
        this.firePropertyChange("gradient", multipleGradientPaint2, this.getGradient());
        this.repaint();
    }

    public MultipleGradientPaint getGradient() {
        return this.gradient;
    }

    public MultipleGradientPaint calculateGradient() {
        List<Thumb<Color>> list = this.getStops();
        int n = list.size();
        float[] fArray = new float[n];
        Color[] colorArray = new Color[n];
        int n2 = 0;
        for (Thumb<Color> thumb : list) {
            colorArray[n2] = thumb.getObject();
            fArray[n2] = thumb.getPosition();
            ++n2;
        }
        this.setGradient(this.calculateGradient(fArray, colorArray));
        return this.getGradient();
    }

    private List<Thumb<Color>> getStops() {
        return this.model == null ? null : this.model.getSortedThumbs();
    }

    public void setMultiThumbModel(MultiThumbModel multiThumbModel) {
        MultiThumbModel multiThumbModel2 = this.getMultiThumbModel();
        this.model = multiThumbModel;
        this.firePropertyChange("multiThumbModel", multiThumbModel2, this.getMultiThumbModel());
    }

    public MultiThumbModel getMultiThumbModel() {
        return this.model;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(this.checker_texture);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            MultipleGradientPaint multipleGradientPaint = this.getGradient();
            if (multipleGradientPaint != null) {
                graphics2D.setPaint(multipleGradientPaint);
            } else {
                graphics2D.setPaint(Color.black);
            }
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.drawHandles(graphics2D);
        }
        catch (Exception exception) {
            this.log.severe("ex: " + exception);
        }
    }

    private MultipleGradientPaint calculateGradient(float[] fArray, Color[] colorArray) {
        Point2D point2D = this.start;
        Point2D point2D2 = this.end;
        if (this.isReversed()) {
            point2D = this.end;
            point2D2 = this.start;
        }
        MultipleGradientPaint.CycleMethod cycleMethod = MultipleGradientPaint.CycleMethod.NO_CYCLE;
        if (this.isRepeated()) {
            cycleMethod = MultipleGradientPaint.CycleMethod.REPEAT;
        }
        if (this.isReflected()) {
            cycleMethod = MultipleGradientPaint.CycleMethod.REFLECT;
        }
        MultipleGradientPaint multipleGradientPaint = null;
        multipleGradientPaint = this.isRadial() ? new RadialGradientPaint(point2D, (float)point2D.distance(point2D2), point2D, fArray, colorArray, cycleMethod, MultipleGradientPaint.ColorSpaceType.SRGB, null) : new LinearGradientPaint((float)point2D.getX(), (float)point2D.getY(), (float)point2D2.getX(), (float)point2D2.getY(), fArray, colorArray, cycleMethod);
        return multipleGradientPaint;
    }

    private void drawHandles(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.black);
        graphics2D.drawOval((int)this.start.getX() - 5, (int)this.start.getY() - 5, 10, 10);
        graphics2D.setColor(Color.white);
        graphics2D.drawOval((int)this.start.getX() - 4, (int)this.start.getY() - 4, 8, 8);
        graphics2D.setColor(Color.black);
        graphics2D.drawOval((int)this.end.getX() - 5, (int)this.end.getY() - 5, 10, 10);
        graphics2D.setColor(Color.white);
        graphics2D.drawOval((int)this.end.getX() - 4, (int)this.end.getY() - 4, 8, 8);
        graphics2D.setColor(Color.darkGray);
        graphics2D.drawLine((int)this.start.getX(), (int)this.start.getY(), (int)this.end.getX(), (int)this.end.getY());
        graphics2D.setColor(Color.gray);
        graphics2D.drawLine((int)this.start.getX() - 1, (int)this.start.getY() - 1, (int)this.end.getX() - 1, (int)this.end.getY() - 1);
    }

    public boolean isRadial() {
        return this.radial;
    }

    public void setRadial(boolean bl) {
        boolean bl2 = this.isRadial();
        this.radial = bl;
        this.firePropertyChange("radial", bl2, this.isRadial());
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean bl) {
        boolean bl2 = this.isReversed();
        this.reversed = bl;
        this.firePropertyChange("reversed", bl2, this.isReversed());
    }

    public boolean isReflected() {
        return this.reflected;
    }

    public void setReflected(boolean bl) {
        boolean bl2 = this.isReflected();
        this.reflected = bl;
        this.firePropertyChange("reflected", bl2, this.isReflected());
    }

    public boolean isRepeated() {
        return this.repeated;
    }

    public void setRepeated(boolean bl) {
        boolean bl2 = this.isRepeated();
        this.repeated = bl;
        this.firePropertyChange("repeated", bl2, this.isRepeated());
    }

    private class GradientMouseHandler
    extends MouseInputAdapter {
        private GradientMouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            GradientPreviewPanel.this.moving_start = false;
            GradientPreviewPanel.this.moving_end = false;
            if (mouseEvent.getPoint().distance(GradientPreviewPanel.this.start) < 5.0) {
                GradientPreviewPanel.this.moving_start = true;
                GradientPreviewPanel.this.start = mouseEvent.getPoint();
                return;
            }
            if (mouseEvent.getPoint().distance(GradientPreviewPanel.this.end) < 5.0) {
                GradientPreviewPanel.this.moving_end = true;
                GradientPreviewPanel.this.end = mouseEvent.getPoint();
                return;
            }
            GradientPreviewPanel.this.start = mouseEvent.getPoint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (GradientPreviewPanel.this.moving_start) {
                GradientPreviewPanel.this.start = mouseEvent.getPoint();
            } else {
                GradientPreviewPanel.this.end = mouseEvent.getPoint();
            }
            GradientPreviewPanel.this.calculateGradient();
            GradientPreviewPanel.this.repaint();
        }
    }
}

