/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete.workarounds;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class MacOSXPopupLocationFix {
    private final JComboBox comboBox;
    private final JPopupMenu popupMenu;
    private final Listener listener = new Listener();

    private MacOSXPopupLocationFix(JComboBox jComboBox) {
        this.comboBox = jComboBox;
        this.popupMenu = (JPopupMenu)jComboBox.getUI().getAccessibleChild(jComboBox, 0);
        this.popupMenu.addPopupMenuListener(this.listener);
    }

    public static MacOSXPopupLocationFix install(JComboBox jComboBox) {
        if (jComboBox == null) {
            throw new IllegalArgumentException();
        }
        return new MacOSXPopupLocationFix(jComboBox);
    }

    public void uninstall() {
        this.popupMenu.removePopupMenuListener(this.listener);
    }

    private void fixPopupLocation(JComponent jComponent) {
        if (jComponent.getClass().getName().indexOf("apple.laf") != 0) {
            return;
        }
        Point point = this.comboBox.getLocationOnScreen();
        int n = this.comboBox.getHeight();
        int n2 = point.y + n;
        Rectangle rectangle = new ScreenGeometry(this.comboBox).getScreenBounds();
        int n3 = jComponent.getPreferredSize().height;
        if (point.y + n + n3 > rectangle.x + rectangle.height) {
            n2 = point.y - n3;
        }
        jComponent.setLocation(point.x, n2);
    }

    private static final class ScreenGeometry {
        final GraphicsConfiguration graphicsConfiguration;
        final boolean aqua = UIManager.getLookAndFeel().getName().indexOf("Aqua") != -1;

        public ScreenGeometry(JComponent jComponent) {
            this.graphicsConfiguration = this.graphicsConfigurationForComponent(jComponent);
        }

        private GraphicsConfiguration graphicsConfigurationForComponent(Component component) {
            Point point = component.getLocationOnScreen();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            for (int i = 0; i < graphicsDeviceArray.length; ++i) {
                GraphicsConfiguration graphicsConfiguration;
                if (graphicsDeviceArray[i].getType() != 0 || !(graphicsConfiguration = graphicsDeviceArray[i].getDefaultConfiguration()).getBounds().contains(point)) continue;
                return graphicsConfiguration;
            }
            return component.getGraphicsConfiguration();
        }

        public Rectangle getScreenBounds() {
            Rectangle rectangle = this.getScreenSize();
            Insets insets = this.getScreenInsets();
            return new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
        }

        public Rectangle getScreenSize() {
            if (this.graphicsConfiguration != null) {
                return this.graphicsConfiguration.getBounds();
            }
            return new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        }

        public Insets getScreenInsets() {
            Insets insets = this.graphicsConfiguration != null ? Toolkit.getDefaultToolkit().getScreenInsets(this.graphicsConfiguration) : new Insets(0, 0, 0, 0);
            if (this.aqua) {
                int n = 21;
                int n2 = 22;
                insets.bottom = Math.max(insets.bottom, n);
                insets.top = Math.max(insets.top, n2);
            }
            return insets;
        }
    }

    private class Listener
    implements PopupMenuListener {
        private Listener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            JComponent jComponent = (JComponent)popupMenuEvent.getSource();
            MacOSXPopupLocationFix.this.fixPopupLocation(jComponent);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }
}

