/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.rollover.RolloverProducer;
import org.jdesktop.swingx.rollover.RolloverRenderer;
import org.jdesktop.swingx.tree.DefaultXTreeCellRenderer;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableCellEditor;
import org.jdesktop.swingx.treetable.TreeTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXTreeTable
extends JXTable {
    private static final Logger LOG = Logger.getLogger(JXTreeTable.class.getName());
    public static final String DRAG_HACK_FLAG_KEY = "treeTable.dragHackFlag";
    public static final String DROP_HACK_FLAG_KEY = "treeTable.dropHackFlag";
    private TreeTableCellRenderer renderer;
    private TreeTableCellEditor hierarchicalEditor;
    private TreeTableHacker treeTableHacker;
    private boolean consumedOnPress;

    public JXTreeTable() {
        this(new DefaultTreeTableModel());
    }

    public JXTreeTable(TreeTableModel treeTableModel) {
        this(new TreeTableCellRenderer(treeTableModel));
    }

    private JXTreeTable(TreeTableCellRenderer treeTableCellRenderer) {
        super(new TreeTableModelAdapter(treeTableCellRenderer));
        this.init(treeTableCellRenderer);
        this.initActions();
        super.setSortable(false);
        super.setAutoCreateRowSorter(false);
        super.setRowSorter(null);
        this.setShowGrid(false, false);
        this.hierarchicalEditor = new TreeTableCellEditor(treeTableCellRenderer);
    }

    private void init(TreeTableCellRenderer treeTableCellRenderer) {
        this.renderer = treeTableCellRenderer;
        assert (((TreeTableModelAdapter)this.getModel()).tree == this.renderer);
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        if (treeTableCellRenderer != null) {
            treeTableCellRenderer.bind(this);
            treeTableCellRenderer.setSelectionModel(listToTreeSelectionModelWrapper);
        }
        this.adjustTreeRowHeight(this.getRowHeight());
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JXTreeTable.this.renderer.putClientProperty(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue());
            }
        };
        this.addPropertyChangeListener("JTree.lineStyle", propertyChangeListener);
    }

    private void initActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("expand-all", new Actions("expand-all"));
        actionMap.put("collapse-all", new Actions("collapse-all"));
    }

    @Override
    public void setSortable(boolean bl) {
    }

    @Override
    public void setAutoCreateRowSorter(boolean bl) {
    }

    @Override
    public void setRowSorter(RowSorter<? extends TableModel> rowSorter) {
    }

    @Override
    public void setEnabled(boolean bl) {
        this.renderer.setEnabled(bl);
        super.setEnabled(bl);
    }

    @Override
    public void setSelectionBackground(Color color) {
        if (this.renderer != null) {
            this.renderer.setSelectionBackground(color);
        }
        super.setSelectionBackground(color);
    }

    @Override
    public void setSelectionForeground(Color color) {
        if (this.renderer != null) {
            this.renderer.setSelectionForeground(color);
        }
        super.setSelectionForeground(color);
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        this.getTreeTableHacker().hitHandleDetectionFromEditCell(n2, eventObject);
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl && this.isHierarchical(n2)) {
            this.repaint(this.getCellRect(n, n2, false));
        }
        return bl;
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 502 && this.consumedOnPress) {
            this.consumedOnPress = false;
            mouseEvent.consume();
            return;
        }
        if (this.getTreeTableHacker().hitHandleDetectionFromProcessMouse(mouseEvent)) {
            this.consumedOnPress = true;
            mouseEvent.consume();
            return;
        }
        this.consumedOnPress = false;
        super.processMouseEvent(mouseEvent);
    }

    protected TreeTableHacker getTreeTableHacker() {
        if (this.treeTableHacker == null) {
            this.treeTableHacker = this.createTreeTableHacker();
        }
        return this.treeTableHacker;
    }

    protected TreeTableHacker createTreeTableHacker() {
        return new TreeTableHackerExt();
    }

    protected boolean hackAroundDragEnabled(MouseEvent mouseEvent) {
        Boolean bl = (Boolean)this.getClientProperty(DRAG_HACK_FLAG_KEY);
        if (bl == null) {
            String string = null;
            try {
                string = System.getProperty("sun.swing.enableImprovedDragGesture");
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl = string == null;
            this.putClientProperty(DRAG_HACK_FLAG_KEY, bl);
        }
        return this.getDragEnabled() && bl != false;
    }

    @Override
    public int getEditingRow() {
        return this.isHierarchical(this.editingColumn) ? -1 : this.editingRow;
    }

    private int realEditingRow() {
        return this.editingRow;
    }

    public void setTreeTableModel(TreeTableModel treeTableModel) {
        TreeTableModel treeTableModel2 = this.getTreeTableModel();
        this.renderer.setModel(treeTableModel);
        this.firePropertyChange("treeTableModel", treeTableModel2, this.getTreeTableModel());
    }

    public TreeTableModel getTreeTableModel() {
        return (TreeTableModel)this.renderer.getModel();
    }

    @Override
    public final void setModel(TableModel tableModel) {
        if (tableModel instanceof TreeTableModelAdapter) {
            if (((TreeTableModelAdapter)tableModel).getTreeTable() != null) {
                throw new IllegalArgumentException("model already bound");
            }
        } else {
            throw new IllegalArgumentException("unsupported model type");
        }
        super.setModel(tableModel);
        ((TreeTableModelAdapter)tableModel).bind(this);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.isStructureChanged(tableModelEvent) || this.isUpdate(tableModelEvent)) {
            super.tableChanged(tableModelEvent);
        } else {
            this.resizeAndRepaint();
        }
    }

    @Override
    public final void setRowHeight(int n, int n2) {
        throw new UnsupportedOperationException("variable height rows not supported");
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        this.adjustTreeRowHeight(this.getRowHeight());
    }

    protected void adjustTreeRowHeight(int n) {
        if (this.renderer != null && this.renderer.getRowHeight() != n) {
            this.renderer.setRowHeight(n);
        }
    }

    protected void adjustTableRowHeight(int n) {
        if (this.getRowHeight() != n) {
            this.adminSetRowHeight(n);
        }
    }

    @Override
    public void setSelectionMode(int n) {
        if (this.renderer != null) {
            switch (n) {
                case 1: {
                    this.renderer.getSelectionModel().setSelectionMode(2);
                    break;
                }
                case 2: {
                    this.renderer.getSelectionModel().setSelectionMode(4);
                    break;
                }
                default: {
                    this.renderer.getSelectionModel().setSelectionMode(1);
                }
            }
        }
        super.setSelectionMode(n);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        return this.applyRenderer(component, this.getComponentAdapter(n, n2));
    }

    protected Component applyRenderer(Component component, ComponentAdapter componentAdapter) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (componentAdapter == null) {
            throw new IllegalArgumentException("null component data adapter");
        }
        if (this.isHierarchical(componentAdapter.column)) {
            TreeCellRenderer treeCellRenderer = this.renderer.getCellRenderer();
            if (treeCellRenderer instanceof JXTree.DelegatingRenderer) {
                treeCellRenderer = ((JXTree.DelegatingRenderer)treeCellRenderer).getDelegateRenderer();
            }
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                if (componentAdapter.isSelected()) {
                    defaultTreeCellRenderer.setTextSelectionColor(component.getForeground());
                    defaultTreeCellRenderer.setBackgroundSelectionColor(component.getBackground());
                } else {
                    defaultTreeCellRenderer.setTextNonSelectionColor(component.getForeground());
                    defaultTreeCellRenderer.setBackgroundNonSelectionColor(component.getBackground());
                }
            }
        }
        return component;
    }

    public void setTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        if (this.renderer != null) {
            this.renderer.setCellRenderer(treeCellRenderer);
        }
    }

    public TreeCellRenderer getTreeCellRenderer() {
        return this.renderer.getCellRenderer();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.columnAtPoint(mouseEvent.getPoint());
        if (this.isHierarchical(n)) {
            int n2 = this.rowAtPoint(mouseEvent.getPoint());
            return this.renderer.getToolTipText(mouseEvent, n2, n);
        }
        return super.getToolTipText(mouseEvent);
    }

    public void setCollapsedIcon(Icon icon) {
        this.renderer.setCollapsedIcon(icon);
    }

    public void setExpandedIcon(Icon icon) {
        this.renderer.setExpandedIcon(icon);
    }

    public void setOpenIcon(Icon icon) {
        this.renderer.setOpenIcon(icon);
    }

    public void setClosedIcon(Icon icon) {
        this.renderer.setClosedIcon(icon);
    }

    public void setLeafIcon(Icon icon) {
        this.renderer.setLeafIcon(icon);
    }

    public void setOverwriteRendererIcons(boolean bl) {
        this.renderer.setOverwriteRendererIcons(bl);
    }

    public boolean isOverwriteRendererIcons() {
        return this.renderer.isOverwriteRendererIcons();
    }

    @Override
    public void clearSelection() {
        if (this.renderer != null) {
            this.renderer.clearSelection();
        }
        super.clearSelection();
    }

    public void collapseAll() {
        this.renderer.collapseAll();
    }

    public void expandAll() {
        this.renderer.expandAll();
    }

    public void collapsePath(TreePath treePath) {
        this.renderer.collapsePath(treePath);
    }

    public void expandPath(TreePath treePath) {
        this.renderer.expandPath(treePath);
    }

    public void scrollPathToVisible(TreePath treePath) {
        this.renderer.scrollPathToVisible(treePath);
    }

    public void collapseRow(int n) {
        this.renderer.collapseRow(n);
    }

    public void expandRow(int n) {
        this.renderer.expandRow(n);
    }

    public boolean isVisible(TreePath treePath) {
        return this.renderer.isVisible(treePath);
    }

    public boolean isExpanded(TreePath treePath) {
        return this.renderer.isExpanded(treePath);
    }

    public boolean isExpanded(int n) {
        return this.renderer.isExpanded(n);
    }

    public boolean isCollapsed(TreePath treePath) {
        return this.renderer.isCollapsed(treePath);
    }

    public boolean isCollapsed(int n) {
        return this.renderer.isCollapsed(n);
    }

    public Enumeration<?> getExpandedDescendants(TreePath treePath) {
        return this.renderer.getExpandedDescendants(treePath);
    }

    public TreePath getPathForLocation(int n, int n2) {
        int n3 = this.rowAtPoint(new Point(n, n2));
        if (n3 == -1) {
            return null;
        }
        return this.renderer.getPathForRow(n3);
    }

    public TreePath getPathForRow(int n) {
        return this.renderer.getPathForRow(n);
    }

    public int getRowForPath(TreePath treePath) {
        return this.renderer.getRowForPath(treePath);
    }

    public void setRootVisible(boolean bl) {
        this.renderer.setRootVisible(bl);
        this.revalidate();
        this.repaint();
    }

    public boolean isRootVisible() {
        return this.renderer.isRootVisible();
    }

    public void setScrollsOnExpand(boolean bl) {
        this.renderer.setScrollsOnExpand(bl);
    }

    public boolean getScrollsOnExpand() {
        return this.renderer.getScrollsOnExpand();
    }

    public void setShowsRootHandles(boolean bl) {
        this.renderer.setShowsRootHandles(bl);
        this.repaint();
    }

    public boolean getShowsRootHandles() {
        return this.renderer.getShowsRootHandles();
    }

    public void setExpandsSelectedPaths(boolean bl) {
        this.renderer.setExpandsSelectedPaths(bl);
    }

    public boolean getExpandsSelectedPaths() {
        return this.renderer.getExpandsSelectedPaths();
    }

    public int getToggleClickCount() {
        return this.renderer.getToggleClickCount();
    }

    public void setToggleClickCount(int n) {
        this.renderer.setToggleClickCount(n);
    }

    public boolean isLargeModel() {
        return this.renderer.isLargeModel();
    }

    public void setLargeModel(boolean bl) {
        this.renderer.setLargeModel(bl);
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.renderer.addTreeExpansionListener(treeExpansionListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.renderer.removeTreeExpansionListener(treeExpansionListener);
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.renderer.addTreeSelectionListener(treeSelectionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.renderer.removeTreeSelectionListener(treeSelectionListener);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.renderer.addTreeWillExpandListener(treeWillExpandListener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.renderer.removeTreeWillExpandListener(treeWillExpandListener);
    }

    public TreeSelectionModel getTreeSelectionModel() {
        return this.renderer.getSelectionModel();
    }

    @Override
    public void sizeColumnsToFit(int n) {
        super.sizeColumnsToFit(n);
        if (this.getEditingColumn() != -1 && this.isHierarchical(this.editingColumn)) {
            Rectangle rectangle = this.getCellRect(this.realEditingRow(), this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        }
    }

    public boolean isHierarchical(int n) {
        if (n < 0 || n >= this.getColumnCount()) {
            throw new IllegalArgumentException("column must be valid, was" + n);
        }
        return this.getHierarchicalColumn() == n;
    }

    public int getHierarchicalColumn() {
        return this.convertColumnIndexToView(((TreeTableModel)this.renderer.getModel()).getHierarchicalColumn());
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (this.isHierarchical(n2)) {
            return this.renderer;
        }
        return super.getCellRenderer(n, n2);
    }

    @Override
    public TableCellEditor getCellEditor(int n, int n2) {
        if (this.isHierarchical(n2)) {
            return this.hierarchicalEditor;
        }
        return super.getCellEditor(n, n2);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateHierarchicalRendererEditor();
    }

    protected void updateHierarchicalRendererEditor() {
        if (this.renderer != null) {
            SwingUtilities.updateComponentTreeUI(this.renderer);
        }
    }

    @Override
    public String getStringAt(int n, int n2) {
        if (this.isHierarchical(n2)) {
            return this.getHierarchicalStringAt(n);
        }
        return super.getStringAt(n, n2);
    }

    private String getHierarchicalStringAt(int n) {
        return this.renderer.getStringAt(n);
    }

    @Override
    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new TreeTableDataAdapter(this);
        }
        return this.dataAdapter;
    }

    protected static class TreeTableDataAdapter
    extends JXTable.TableAdapter {
        private final JXTreeTable table;

        public TreeTableDataAdapter(JXTreeTable jXTreeTable) {
            super(jXTreeTable);
            this.table = jXTreeTable;
        }

        public JXTreeTable getTreeTable() {
            return this.table;
        }

        public boolean isExpanded() {
            return this.table.isExpanded(this.row);
        }

        public int getDepth() {
            return this.table.getPathForRow(this.row).getPathCount() - 1;
        }

        public boolean isLeaf() {
            TreePath treePath = this.table.getPathForRow(this.row);
            if (treePath != null) {
                return this.table.getTreeTableModel().isLeaf(treePath.getLastPathComponent());
            }
            return true;
        }

        public boolean isHierarchical() {
            return this.table.isHierarchical(this.column);
        }

        public String getFilteredStringAt(int n, int n2) {
            if (this.table.getTreeTableModel().getHierarchicalColumn() == n2) {
                if (this.modelToView(n2) < 0) {
                    // empty if block
                }
                return this.table.getHierarchicalStringAt(n);
            }
            return super.getFilteredStringAt(n, n2);
        }

        public String getStringAt(int n, int n2) {
            if (this.table.getTreeTableModel().getHierarchicalColumn() == n2) {
                if (this.modelToView(n2) < 0) {
                    // empty if block
                }
                return this.table.getHierarchicalStringAt(n);
            }
            return super.getStringAt(n, n2);
        }
    }

    static class TreeTableCellRenderer
    extends JXTree
    implements TableCellRenderer {
        protected Border highlightBorder = null;
        protected JXTreeTable treeTable = null;
        protected int visibleRow = 0;
        private int hierarchicalColumnWidth = 0;

        public TreeTableCellRenderer(TreeTableModel treeTableModel) {
            super(treeTableModel);
            this.putClientProperty("JTree.lineStyle", "None");
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            this.setCellRenderer(new ClippedTreeCellRenderer());
        }

        public boolean isVisible() {
            return this.shouldApplyDropHack() ? false : super.isVisible();
        }

        protected boolean shouldApplyDropHack() {
            return !Boolean.FALSE.equals(this.treeTable.getClientProperty(JXTreeTable.DROP_HACK_FLAG_KEY));
        }

        private String getToolTipText(MouseEvent mouseEvent, int n, int n2) {
            TreePath treePath;
            Object object;
            if (n < 0) {
                return null;
            }
            String string = null;
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            Component component = treeCellRenderer.getTreeCellRendererComponent(this, object = (treePath = this.getPathForRow(n)).getLastPathComponent(), this.isRowSelected(n), this.isExpanded(n), this.getModel().isLeaf(object), n, true);
            if (component instanceof JComponent) {
                Rectangle rectangle = this.getPathBounds(treePath);
                Rectangle rectangle2 = this.treeTable.getCellRect(n, n2, false);
                Point point = mouseEvent.getPoint();
                point.translate(-rectangle2.x, -rectangle2.y);
                point.translate(-rectangle.x, 0);
                MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                string = ((JComponent)component).getToolTipText(mouseEvent2);
            }
            if (string != null) {
                return string;
            }
            return this.getToolTipText();
        }

        public void setToolTipText(String string) {
            this.putClientProperty("ToolTipText", string);
        }

        public final void bind(JXTreeTable jXTreeTable) {
            if (jXTreeTable == null) {
                throw new IllegalArgumentException("null treeTable");
            }
            if (this.treeTable != null) {
                throw new IllegalArgumentException("renderer already bound");
            }
            this.treeTable = jXTreeTable;
        }

        protected PropertyChangeListener createRolloverListener() {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){
                Point rollover = new Point(-1, -1);

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (TreeTableCellRenderer.this.treeTable == null || TreeTableCellRenderer.this.treeTable != propertyChangeEvent.getSource()) {
                        return;
                    }
                    if ("rolloverEnabled".equals(propertyChangeEvent.getPropertyName())) {
                        TreeTableCellRenderer.this.setRolloverEnabled((Boolean)propertyChangeEvent.getNewValue());
                    }
                    if ("swingx.rollover".equals(propertyChangeEvent.getPropertyName())) {
                        this.rollover(propertyChangeEvent);
                    }
                }

                private void rollover(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = this.isHierarchical((Point)propertyChangeEvent.getNewValue());
                    TreeTableCellRenderer.this.putClientProperty(propertyChangeEvent.getPropertyName(), bl ? new Point((Point)propertyChangeEvent.getNewValue()) : null);
                }

                private boolean isHierarchical(Point point) {
                    int n;
                    if (point != null && (n = point.x) >= 0) {
                        return TreeTableCellRenderer.this.treeTable.isHierarchical(n);
                    }
                    return false;
                }
            };
            return propertyChangeListener;
        }

        protected RolloverProducer createRolloverProducer() {
            return new RolloverProducer(){

                protected void updateRollover(MouseEvent mouseEvent, String string, boolean bl) {
                    if ("swingx.clicked".equals(string)) {
                        super.updateRollover(mouseEvent, string, bl);
                    }
                }

                protected void updateRolloverPoint(JComponent jComponent, Point point) {
                    int n;
                    JXTree jXTree = (JXTree)jComponent;
                    int n2 = jXTree.getClosestRowForLocation(point.x, point.y);
                    Rectangle rectangle = jXTree.getRowBounds(n2);
                    if (rectangle == null) {
                        n2 = -1;
                    } else if (rectangle.y + rectangle.height < point.y || rectangle.x > point.x) {
                        n2 = -1;
                    }
                    this.rollover.x = n = n2 < 0 ? -1 : 0;
                    this.rollover.y = n2;
                }
            };
        }

        public void scrollRectToVisible(Rectangle rectangle) {
            this.treeTable.scrollRectToVisible(rectangle);
        }

        protected void setExpandedState(TreePath treePath, boolean bl) {
            this.treeTable.getTreeTableHacker().completeEditing();
            super.setExpandedState(treePath, bl);
            this.treeTable.getTreeTableHacker().expansionChanged();
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setBorderSelectionColor(null);
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int n) {
            super.setRowHeight(n);
            if (n > 0 && this.treeTable != null) {
                this.treeTable.adjustTableRowHeight(n);
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            if (this.treeTable != null) {
                n2 = 0;
                n4 = this.treeTable.getRowCount() * this.getRowHeight();
            }
            super.setBounds(n, n2, n3, n4);
        }

        public void paint(Graphics graphics) {
            Rectangle rectangle = this.treeTable.getCellRect(this.visibleRow, 0, false);
            graphics.translate(0, -rectangle.y);
            this.hierarchicalColumnWidth = this.getWidth();
            super.paint(graphics);
            if (this.highlightBorder != null) {
                this.highlightBorder.paintBorder(this, graphics, 0, rectangle.y, this.getWidth(), rectangle.height);
            }
        }

        public void doClick() {
            if (this.getCellRenderer() instanceof RolloverRenderer && ((RolloverRenderer)((Object)this.getCellRenderer())).isEnabled()) {
                ((RolloverRenderer)((Object)this.getCellRenderer())).doClick();
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            assert (jTable == this.treeTable);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.highlightBorder = null;
            if (this.treeTable != null && (this.treeTable.realEditingRow() != n || this.treeTable.getEditingColumn() != n2) && bl2) {
                this.highlightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.visibleRow = n;
            return this;
        }

        private class ClippedTreeCellRenderer
        extends DefaultXTreeCellRenderer
        implements StringValue {
            private boolean inpainting;
            private String shortText;
            private final Rectangle iconRect = new Rectangle();
            private final Rectangle textRect = new Rectangle();
            private final Rectangle itemRect = new Rectangle();

            private ClippedTreeCellRenderer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paint(Graphics graphics) {
                String string = super.getText();
                this.shortText = SwingUtilities.layoutCompoundLabel(this, graphics.getFontMetrics(), string, this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.getItemRect(this.itemRect), this.iconRect, this.textRect, this.getIconTextGap());
                try {
                    this.inpainting = true;
                    this.setText(this.shortText);
                    super.paint(graphics);
                }
                finally {
                    this.inpainting = false;
                    this.setText(string);
                }
            }

            private Rectangle getItemRect(Rectangle rectangle) {
                this.getBounds(rectangle);
                rectangle.width = TreeTableCellRenderer.this.hierarchicalColumnWidth - rectangle.x;
                return rectangle;
            }

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                return super.getTreeCellRendererComponent(jTree, this.getHierarchicalTableValue(object), bl, bl2, bl3, n, bl4);
            }

            private Object getHierarchicalTableValue(Object object) {
                Object object2 = object;
                if (TreeTableCellRenderer.this.treeTable != null) {
                    int n = TreeTableCellRenderer.this.treeTable.getTreeTableModel().getHierarchicalColumn();
                    Object object3 = null;
                    if (n >= 0) {
                        object3 = TreeTableCellRenderer.this.treeTable.getTreeTableModel().getValueAt(object, n);
                    }
                    object2 = object3;
                }
                return object2;
            }

            public String getString(Object object) {
                return StringValues.TO_STRING.getString(this.getHierarchicalTableValue(object));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TreeTableModelAdapter
    extends AbstractTableModel {
        private TreeModelListener treeModelListener;
        private final JTree tree;
        private JXTreeTable treeTable = null;

        TreeTableModelAdapter(JTree jTree) {
            assert (jTree != null);
            this.tree = jTree;
            jTree.getModel().addTreeModelListener(this.getTreeModelListener());
            jTree.addTreeExpansionListener(new TreeExpansionListener(){

                public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                    TreeTableModelAdapter.this.updateAfterExpansionEvent(treeExpansionEvent);
                }

                public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                    TreeTableModelAdapter.this.updateAfterExpansionEvent(treeExpansionEvent);
                }
            });
            jTree.addPropertyChangeListener("model", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    TreeTableModel treeTableModel = (TreeTableModel)propertyChangeEvent.getOldValue();
                    treeTableModel.removeTreeModelListener(TreeTableModelAdapter.this.getTreeModelListener());
                    treeTableModel = (TreeTableModel)propertyChangeEvent.getNewValue();
                    treeTableModel.addTreeModelListener(TreeTableModelAdapter.this.getTreeModelListener());
                    TreeTableModelAdapter.this.fireTableStructureChanged();
                }
            });
        }

        protected void updateAfterExpansionEvent(TreeExpansionEvent treeExpansionEvent) {
            this.fireTableDataChanged();
        }

        protected JXTreeTable getTreeTable() {
            return this.treeTable;
        }

        protected final void bind(JXTreeTable jXTreeTable) {
            if (jXTreeTable == null) {
                throw new IllegalArgumentException("null treeTable");
            }
            if (this.treeTable != null) {
                throw new IllegalArgumentException("adapter already bound");
            }
            this.treeTable = jXTreeTable;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return ((TreeTableModel)this.tree.getModel()).getColumnClass(n);
        }

        @Override
        public int getColumnCount() {
            return ((TreeTableModel)this.tree.getModel()).getColumnCount();
        }

        @Override
        public String getColumnName(int n) {
            return ((TreeTableModel)this.tree.getModel()).getColumnName(n);
        }

        @Override
        public int getRowCount() {
            return this.tree.getRowCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = this.nodeForRow(n);
            return object != null ? ((TreeTableModel)this.tree.getModel()).getValueAt(object, n2) : null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            Object object = this.nodeForRow(n);
            return object != null ? ((TreeTableModel)this.tree.getModel()).isCellEditable(object, n2) : false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Object object2 = this.nodeForRow(n);
            if (object2 != null) {
                ((TreeTableModel)this.tree.getModel()).setValueAt(object, object2, n2);
            }
        }

        protected Object nodeForRow(int n) {
            TreePath treePath = this.tree.getPathForRow(n);
            return treePath != null ? treePath.getLastPathComponent() : null;
        }

        private TreeModelListener getTreeModelListener() {
            if (this.treeModelListener == null) {
                this.treeModelListener = new TreeModelListener(){

                    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                        TreeTableModelAdapter.this.delayedFireTableDataUpdated(treeModelEvent);
                    }

                    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                        TreeTableModelAdapter.this.delayedFireTableDataChanged(treeModelEvent, 1);
                    }

                    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                        TreeTableModelAdapter.this.delayedFireTableDataChanged(treeModelEvent, 2);
                    }

                    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                        if (TreeTableModelAdapter.this.isTableStructureChanged(treeModelEvent)) {
                            TreeTableModelAdapter.this.delayedFireTableStructureChanged();
                        } else {
                            TreeTableModelAdapter.this.delayedFireTableDataChanged();
                        }
                    }
                };
            }
            return this.treeModelListener;
        }

        private boolean isTableStructureChanged(TreeModelEvent treeModelEvent) {
            return treeModelEvent.getTreePath() == null || treeModelEvent.getTreePath().getParentPath() == null;
        }

        private void delayedFireTableStructureChanged() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeTableModelAdapter.this.fireTableStructureChanged();
                }
            });
        }

        private void delayedFireTableDataChanged() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
        }

        private void delayedFireTableDataChanged(final TreeModelEvent treeModelEvent, final int n) {
            if (n < 1 || n > 2) {
                throw new IllegalArgumentException("Event type must be 1 or 2, was " + n);
            }
            final boolean bl = this.tree.isExpanded(treeModelEvent.getTreePath());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int[] nArray = treeModelEvent.getChildIndices();
                    TreePath treePath = treeModelEvent.getTreePath();
                    if (nArray != null) {
                        if (bl) {
                            int n4 = nArray[0];
                            int n2 = nArray[nArray.length - 1];
                            int n3 = TreeTableModelAdapter.this.tree.getRowForPath(treePath) + 1;
                            n4 = n3 + n4;
                            n2 = n3 + n2;
                            switch (n) {
                                case 1: {
                                    TreeTableModelAdapter.this.fireTableRowsInserted(n4, n2);
                                    break;
                                }
                                case 2: {
                                    TreeTableModelAdapter.this.fireTableRowsDeleted(n4, n2);
                                }
                            }
                        } else {
                            int n5 = TreeTableModelAdapter.this.tree.getRowForPath(treePath);
                            if (n5 >= 0) {
                                TreeTableModelAdapter.this.fireTableRowsUpdated(n5, n5);
                            }
                        }
                    } else {
                        TreeTableModelAdapter.this.fireTableDataChanged();
                    }
                }
            });
        }

        protected void delayedFireTableDataUpdated(final TreeModelEvent treeModelEvent) {
            final boolean bl = this.tree.isExpanded(treeModelEvent.getTreePath());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int[] nArray = treeModelEvent.getChildIndices();
                    TreePath treePath = treeModelEvent.getTreePath();
                    if (nArray != null) {
                        if (bl) {
                            Object[] objectArray = treeModelEvent.getChildren();
                            int n = Integer.MAX_VALUE;
                            int n2 = Integer.MIN_VALUE;
                            for (int i = 0; i < nArray.length; ++i) {
                                Object object = objectArray[i];
                                TreePath treePath2 = treePath.pathByAddingChild(object);
                                int n3 = TreeTableModelAdapter.this.tree.getRowForPath(treePath2);
                                if (n3 < n) {
                                    n = n3;
                                }
                                if (n3 <= n2) continue;
                                n2 = n3;
                            }
                            TreeTableModelAdapter.this.fireTableRowsUpdated(Math.max(0, n), Math.max(0, n2));
                        } else {
                            int n = TreeTableModelAdapter.this.tree.getRowForPath(treePath);
                            if (n >= 0) {
                                TreeTableModelAdapter.this.fireTableRowsUpdated(n, n);
                            }
                        }
                    } else {
                        TreeTableModelAdapter.this.fireTableDataChanged();
                    }
                }
            });
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    if (this.listSelectionModel.isSelectionEmpty()) {
                        this.clearSelection();
                    } else {
                        int n = this.listSelectionModel.getMinSelectionIndex();
                        int n2 = this.listSelectionModel.getMaxSelectionIndex();
                        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
                        for (int i = n; i <= n2; ++i) {
                            TreePath treePath;
                            if (!this.listSelectionModel.isSelectedIndex(i) || (treePath = JXTreeTable.this.renderer.getPathForRow(i)) == null) continue;
                            arrayList.add(treePath);
                        }
                        this.setSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
                        this.leadRow = this.leadIndex;
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
                }
            }
        }
    }

    public class TreeTableHackerExt2
    extends TreeTableHackerExt {
        protected boolean expandOrCollapseNode(int n, EventObject eventObject) {
            if (!JXTreeTable.this.isHierarchical(n)) {
                return false;
            }
            if (!this.mightBeExpansionTrigger(eventObject)) {
                return false;
            }
            boolean bl = false;
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            if (JXTreeTable.this.hackAroundDragEnabled(mouseEvent)) {
                mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), 501, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            }
            if (mouseEvent.getModifiers() == 0 || mouseEvent.getModifiers() == 16) {
                Serializable serializable;
                Point point = this.getTreeMousePoint(n, mouseEvent);
                int n2 = JXTreeTable.this.renderer.getRowForLocation(point.x, point.y);
                int n3 = 0;
                if (n2 < 0) {
                    n3 = JXTreeTable.this.renderer.getClosestRowForLocation(point.x, point.y);
                    serializable = JXTreeTable.this.renderer.getRowBounds(n3);
                    if (serializable == null) {
                        n3 = -1;
                    } else if (((Rectangle)serializable).y + ((Rectangle)serializable).height < point.y || ((Rectangle)serializable).x > point.x) {
                        n3 = -1;
                    }
                    this.expansionChangedFlag = false;
                }
                if (n2 >= 0 || n2 < 0 && n3 < 0) {
                    serializable = new MouseEvent(JXTreeTable.this.renderer, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    JXTreeTable.this.renderer.dispatchEvent((AWTEvent)serializable);
                    MouseEvent mouseEvent2 = new MouseEvent(JXTreeTable.this.renderer, 502, ((InputEvent)serializable).getWhen(), ((InputEvent)serializable).getModifiers(), ((MouseEvent)serializable).getX(), ((MouseEvent)serializable).getY(), ((MouseEvent)serializable).getClickCount(), ((MouseEvent)serializable).isPopupTrigger());
                    JXTreeTable.this.renderer.dispatchEvent(mouseEvent2);
                }
                if (this.expansionChangedFlag) {
                    bl = true;
                }
            }
            this.expansionChangedFlag = false;
            return bl;
        }

        protected Point getTreeMousePoint(int n, MouseEvent mouseEvent) {
            Rectangle rectangle = JXTreeTable.this.getCellRect(0, n, false);
            if (JXTreeTable.this.getComponentOrientation().isLeftToRight()) {
                return new Point(mouseEvent.getX() - rectangle.x, mouseEvent.getY());
            }
            int n2 = mouseEvent.getX() - rectangle.x - rectangle.width - 10;
            return new Point(n2, mouseEvent.getY());
        }
    }

    public class TreeTableHackerExt
    extends TreeTableHacker {
        protected boolean isHitDetectionFromProcessMouse() {
            return true;
        }
    }

    public class TreeTableHacker {
        protected boolean expansionChangedFlag;

        protected boolean isHitDetectionFromProcessMouse() {
            return false;
        }

        public void hitHandleDetectionFromEditCell(int n, EventObject eventObject) {
            if (!this.isHitDetectionFromProcessMouse()) {
                this.expandOrCollapseNode(n, eventObject);
            }
        }

        public boolean hitHandleDetectionFromProcessMouse(MouseEvent mouseEvent) {
            if (!this.isHitDetectionFromProcessMouse()) {
                return false;
            }
            int n = JXTreeTable.this.columnAtPoint(mouseEvent.getPoint());
            return n >= 0 && this.expandOrCollapseNode(JXTreeTable.this.columnAtPoint(mouseEvent.getPoint()), mouseEvent);
        }

        protected void completeEditing() {
            boolean bl;
            if (JXTreeTable.this.isEditing() && !(bl = JXTreeTable.this.getCellEditor().stopCellEditing())) {
                JXTreeTable.this.getCellEditor().cancelCellEditing();
            }
        }

        protected boolean expandOrCollapseNode(int n, EventObject eventObject) {
            if (!JXTreeTable.this.isHierarchical(n)) {
                return false;
            }
            if (!this.mightBeExpansionTrigger(eventObject)) {
                return false;
            }
            boolean bl = false;
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            if (JXTreeTable.this.hackAroundDragEnabled(mouseEvent)) {
                mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), 501, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            }
            if (mouseEvent.getModifiers() == 0 || mouseEvent.getModifiers() == 16) {
                MouseEvent mouseEvent2 = new MouseEvent(JXTreeTable.this.renderer, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - JXTreeTable.this.getCellRect((int)0, (int)n, (boolean)false).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                JXTreeTable.this.renderer.dispatchEvent(mouseEvent2);
                MouseEvent mouseEvent3 = new MouseEvent(JXTreeTable.this.renderer, 502, mouseEvent2.getWhen(), mouseEvent2.getModifiers(), mouseEvent2.getX(), mouseEvent2.getY(), mouseEvent2.getClickCount(), mouseEvent2.isPopupTrigger());
                JXTreeTable.this.renderer.dispatchEvent(mouseEvent3);
                if (this.expansionChangedFlag) {
                    bl = true;
                }
            }
            this.expansionChangedFlag = false;
            return bl;
        }

        protected boolean mightBeExpansionTrigger(EventObject eventObject) {
            if (!(eventObject instanceof MouseEvent)) {
                return false;
            }
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return false;
            }
            return mouseEvent.getID() == 501;
        }

        protected void expansionChanged() {
            this.expansionChangedFlag = true;
        }
    }

    private class Actions
    extends UIAction {
        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("expand-all".equals(this.getName())) {
                JXTreeTable.this.expandAll();
            } else if ("collapse-all".equals(this.getName())) {
                JXTreeTable.this.collapseAll();
            }
        }
    }
}

