/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.swingx.multislider.DefaultMultiThumbModel;
import org.jdesktop.swingx.multislider.MultiThumbModel;
import org.jdesktop.swingx.multislider.ThumbDataEvent;
import org.jdesktop.swingx.multislider.ThumbDataListener;
import org.jdesktop.swingx.multislider.ThumbListener;
import org.jdesktop.swingx.multislider.ThumbRenderer;
import org.jdesktop.swingx.multislider.TrackRenderer;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.MultiThumbSliderAddon;
import org.jdesktop.swingx.plaf.MultiThumbSliderUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXMultiThumbSlider<E>
extends JComponent {
    public static final String uiClassID = "MultiThumbSliderUI";
    private ThumbDataListener tdl;
    private List<ThumbComp> thumbs;
    private ThumbRenderer thumbRenderer;
    private TrackRenderer trackRenderer;
    private MultiThumbModel<E> model;
    private List<ThumbListener> listeners = new ArrayList<ThumbListener>();
    private ThumbComp selected;

    public JXMultiThumbSlider() {
        this.thumbs = new ArrayList<ThumbComp>();
        this.setLayout(null);
        this.tdl = new ThumbHandler();
        this.setModel(new DefaultMultiThumbModel());
        MultiThumbMouseListener multiThumbMouseListener = new MultiThumbMouseListener();
        this.addMouseListener(multiThumbMouseListener);
        this.addMouseMotionListener(multiThumbMouseListener);
        Dimension dimension = new Dimension(60, 16);
        this.setPreferredSize(dimension);
        this.setSize(dimension);
        this.setMinimumSize(new Dimension(30, 16));
        this.updateUI();
    }

    @Override
    public MultiThumbSliderUI getUI() {
        return (MultiThumbSliderUI)this.ui;
    }

    public void setUI(MultiThumbSliderUI multiThumbSliderUI) {
        super.setUI(multiThumbSliderUI);
    }

    @Override
    public void updateUI() {
        this.setUI((MultiThumbSliderUI)LookAndFeelAddons.getUI(this, MultiThumbSliderUI.class));
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.isVisible()) {
            if (this.trackRenderer != null) {
                JComponent jComponent = this.trackRenderer.getRendererComponent(this);
                this.add(jComponent);
                jComponent.paint(graphics);
                this.remove(jComponent);
            } else {
                this.paintRange((Graphics2D)graphics);
            }
        }
    }

    private void paintRange(Graphics2D graphics2D) {
        graphics2D.setColor(Color.blue);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private float getThumbValue(int n) {
        return this.getModel().getThumbAt(n).getPosition();
    }

    private float getThumbValue(ThumbComp thumbComp) {
        return this.getThumbValue(this.thumbs.indexOf(thumbComp));
    }

    private int getThumbIndex(ThumbComp thumbComp) {
        return this.thumbs.indexOf(thumbComp);
    }

    private void clipThumbPosition(ThumbComp thumbComp) {
        if (this.getThumbValue(thumbComp) < this.getModel().getMinimumValue()) {
            this.getModel().getThumbAt(this.getThumbIndex(thumbComp)).setPosition(this.getModel().getMinimumValue());
        }
        if (this.getThumbValue(thumbComp) > this.getModel().getMaximumValue()) {
            this.getModel().getThumbAt(this.getThumbIndex(thumbComp)).setPosition(this.getModel().getMaximumValue());
        }
    }

    public ThumbRenderer getThumbRenderer() {
        return this.thumbRenderer;
    }

    public void setThumbRenderer(ThumbRenderer thumbRenderer) {
        this.thumbRenderer = thumbRenderer;
    }

    public TrackRenderer getTrackRenderer() {
        return this.trackRenderer;
    }

    public void setTrackRenderer(TrackRenderer trackRenderer) {
        this.trackRenderer = trackRenderer;
    }

    public float getMinimumValue() {
        return this.getModel().getMinimumValue();
    }

    public void setMinimumValue(float f) {
        this.getModel().setMinimumValue(f);
    }

    public float getMaximumValue() {
        return this.getModel().getMaximumValue();
    }

    public void setMaximumValue(float f) {
        this.getModel().setMaximumValue(f);
    }

    private void setThumbPositionByX(ThumbComp thumbComp) {
        float f = this.getModel().getMaximumValue() - this.getModel().getMinimumValue();
        int n = thumbComp.getX();
        n += thumbComp.getWidth() / 2;
        int n2 = this.getWidth();
        float f2 = (float)(n -= thumbComp.getWidth() / 2) / (float)(n2 -= thumbComp.getWidth());
        int n3 = this.getThumbIndex(thumbComp);
        float f3 = f2 * f;
        this.getModel().getThumbAt(n3).setPosition(f3);
        this.clipThumbPosition(thumbComp);
    }

    private void setThumbXByPosition(ThumbComp thumbComp, float f) {
        float f2 = this.getWidth() - thumbComp.getWidth();
        float f3 = this.getModel().getMaximumValue() - this.getModel().getMinimumValue();
        float f4 = f * f2 / f3;
        thumbComp.setLocation((int)f4 - thumbComp.getWidth() / 2 + thumbComp.getWidth() / 2, thumbComp.getY());
    }

    private void recalc() {
        for (ThumbComp thumbComp : this.thumbs) {
            this.setThumbXByPosition(thumbComp, this.getModel().getThumbAt(this.getThumbIndex(thumbComp)).getPosition());
        }
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.recalc();
    }

    public JComponent getSelectedThumb() {
        return this.selected;
    }

    public int getSelectedIndex() {
        return this.getThumbIndex(this.selected);
    }

    public MultiThumbModel<E> getModel() {
        return this.model;
    }

    public void setModel(MultiThumbModel<E> multiThumbModel) {
        if (this.model != null) {
            this.model.removeThumbDataListener(this.tdl);
        }
        this.model = multiThumbModel;
        this.model.addThumbDataListener(this.tdl);
    }

    public void addMultiThumbListener(ThumbListener thumbListener) {
        this.listeners.add(thumbListener);
    }

    static {
        LookAndFeelAddons.contribute(new MultiThumbSliderAddon());
    }

    private class ThumbHandler
    implements ThumbDataListener {
        private ThumbHandler() {
        }

        public void positionChanged(ThumbDataEvent thumbDataEvent) {
            ThumbComp thumbComp = (ThumbComp)JXMultiThumbSlider.this.thumbs.get(thumbDataEvent.getIndex());
            JXMultiThumbSlider.this.clipThumbPosition(thumbComp);
            JXMultiThumbSlider.this.setThumbXByPosition(thumbComp, thumbDataEvent.getThumb().getPosition());
            JXMultiThumbSlider.this.repaint();
        }

        public void thumbAdded(ThumbDataEvent thumbDataEvent) {
            ThumbComp thumbComp = new ThumbComp(JXMultiThumbSlider.this);
            thumbComp.setLocation(0, 0);
            JXMultiThumbSlider.this.add(thumbComp);
            JXMultiThumbSlider.this.thumbs.add(thumbDataEvent.getIndex(), thumbComp);
            JXMultiThumbSlider.this.clipThumbPosition(thumbComp);
            JXMultiThumbSlider.this.setThumbXByPosition(thumbComp, thumbDataEvent.getThumb().getPosition());
            JXMultiThumbSlider.this.repaint();
        }

        public void thumbRemoved(ThumbDataEvent thumbDataEvent) {
            ThumbComp thumbComp = (ThumbComp)JXMultiThumbSlider.this.thumbs.get(thumbDataEvent.getIndex());
            JXMultiThumbSlider.this.remove(thumbComp);
            JXMultiThumbSlider.this.thumbs.remove(thumbComp);
            JXMultiThumbSlider.this.repaint();
        }

        public void valueChanged(ThumbDataEvent thumbDataEvent) {
            JXMultiThumbSlider.this.repaint();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThumbComp
    extends JComponent {
        private JXMultiThumbSlider<?> slider;
        private boolean selected;

        public ThumbComp(JXMultiThumbSlider<?> jXMultiThumbSlider) {
            this.slider = jXMultiThumbSlider;
            Dimension dimension = new Dimension(10, 10);
            this.setSize(dimension);
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            this.setMaximumSize(dimension);
            this.setBackground(Color.white);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (this.slider.getThumbRenderer() != null) {
                JComponent jComponent = this.getRenderer();
                jComponent.setSize(this.getSize());
                jComponent.paint(graphics);
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.isSelected()) {
                    graphics.setColor(Color.black);
                    graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
            }
        }

        private JComponent getRenderer() {
            return this.slider.getThumbRenderer().getThumbRendererComponent(this.slider, ((JXMultiThumbSlider)this.slider).getThumbIndex(this), this.isSelected());
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }
    }

    private class MultiThumbMouseListener
    extends MouseInputAdapter {
        private MultiThumbMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ThumbComp thumbComp = this.findHandle(mouseEvent);
            if (thumbComp != null) {
                JXMultiThumbSlider.this.selected = thumbComp;
                JXMultiThumbSlider.this.selected.setSelected(true);
                int n = JXMultiThumbSlider.this.getThumbIndex(JXMultiThumbSlider.this.selected);
                for (ThumbListener thumbListener : JXMultiThumbSlider.this.listeners) {
                    thumbListener.thumbSelected(n);
                }
                JXMultiThumbSlider.this.repaint();
            } else {
                JXMultiThumbSlider.this.selected = null;
                for (Object object : JXMultiThumbSlider.this.listeners) {
                    object.thumbSelected(-1);
                }
                JXMultiThumbSlider.this.repaint();
            }
            for (Object object : JXMultiThumbSlider.this.listeners) {
                object.mousePressed(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (JXMultiThumbSlider.this.selected != null) {
                JXMultiThumbSlider.this.selected.setSelected(false);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (JXMultiThumbSlider.this.selected != null) {
                int n = (int)mouseEvent.getPoint().getX() - JXMultiThumbSlider.this.selected.getWidth() / 2;
                if (n < 0) {
                    n = 0;
                }
                if (n > JXMultiThumbSlider.this.getWidth() - JXMultiThumbSlider.this.selected.getWidth()) {
                    n = JXMultiThumbSlider.this.getWidth() - JXMultiThumbSlider.this.selected.getWidth();
                }
                JXMultiThumbSlider.this.selected.setLocation(n, (int)JXMultiThumbSlider.this.selected.getLocation().getY());
                JXMultiThumbSlider.this.setThumbPositionByX(JXMultiThumbSlider.this.selected);
                int n2 = JXMultiThumbSlider.this.getThumbIndex(JXMultiThumbSlider.this.selected);
                for (ThumbListener thumbListener : JXMultiThumbSlider.this.listeners) {
                    thumbListener.thumbMoved(n2, JXMultiThumbSlider.this.getModel().getThumbAt(n2).getPosition());
                }
                JXMultiThumbSlider.this.repaint();
            }
        }

        private ThumbComp findHandle(MouseEvent mouseEvent) {
            for (ThumbComp thumbComp : JXMultiThumbSlider.this.thumbs) {
                Point point = new Point();
                point.setLocation(mouseEvent.getPoint().getX() - (double)thumbComp.getX(), mouseEvent.getPoint().getY() - (double)thumbComp.getY());
                if (!thumbComp.contains(point)) continue;
                return thumbComp;
            }
            return null;
        }
    }
}

