/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.View;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXImagePanel;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.VerticalLayout;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.auth.DefaultUserNameStore;
import org.jdesktop.swingx.auth.LoginAdapter;
import org.jdesktop.swingx.auth.LoginEvent;
import org.jdesktop.swingx.auth.LoginListener;
import org.jdesktop.swingx.auth.LoginService;
import org.jdesktop.swingx.auth.PasswordStore;
import org.jdesktop.swingx.auth.UserNameStore;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.plaf.LoginPaneAddon;
import org.jdesktop.swingx.plaf.LoginPaneUI;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.util.WindowUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXLoginPane
extends JXPanel {
    private static final Logger LOG = Logger.getLogger(JXLoginPane.class.getName());
    public static final String uiClassID = "LoginPaneUI";
    public static final String LOGIN_ACTION_COMMAND = "login";
    public static final String CANCEL_LOGIN_ACTION_COMMAND = "cancel-login";
    private static String CLASS_NAME = JXLoginPane.class.getSimpleName();
    private Status status = Status.NOT_STARTED;
    private JXImagePanel banner;
    private String bannerText;
    private JLabel messageLabel;
    private JXLabel errorMessageLabel;
    private JXPanel loginPanel;
    private JXPanel contentPanel;
    private NameComponent namePanel;
    private JPasswordField passwordField;
    private JComboBox serverCombo;
    private JCheckBox saveCB;
    private JLabel capsOn;
    private JXPanel progressPanel;
    private JLabel progressMessageLabel;
    private LoginService loginService;
    private PasswordStore passwordStore;
    private UserNameStore userNameStore;
    private List<String> servers;
    private SaveMode saveMode;
    private Cursor oldCursor;
    private boolean namePanelEnabled = true;
    private LoginListener defaultLoginListener;
    private final CapsOnTest capsOnTest;
    private boolean caps;
    private boolean isTestingCaps;
    private final KeyEventDispatcher capsOnListener;
    private boolean capsLockSupport = true;
    private JXBtnPanel buttonPanel;
    private final CapsOnWinListener capsOnWinListener;
    private JPanel contentCardPane;
    private boolean isErrorMessageSet;

    private void reinitLocales(Locale locale) {
        Container container;
        this.setBannerText(UIManagerExt.getString(CLASS_NAME + ".bannerString", this.getLocale()));
        this.banner.setImage(this.createLoginBanner());
        if (!this.isErrorMessageSet) {
            this.errorMessageLabel.setText(UIManager.getString((Object)(CLASS_NAME + ".errorMessage"), this.getLocale()));
        }
        this.progressMessageLabel.setText(UIManagerExt.getString(CLASS_NAME + ".pleaseWait", this.getLocale()));
        this.recreateLoginPanel();
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof JXLoginFrame) {
            container = (JXLoginFrame)window;
            ((Frame)container).setTitle(UIManagerExt.getString(CLASS_NAME + ".titleString", this.getLocale()));
            if (this.buttonPanel != null) {
                this.buttonPanel.getOk().setText(UIManagerExt.getString(CLASS_NAME + ".loginString", this.getLocale()));
                this.buttonPanel.getCancel().setText(UIManagerExt.getString(CLASS_NAME + ".cancelString", this.getLocale()));
            }
        }
        if ((container = (JLabel)this.passwordField.getClientProperty("labeledBy")) != null) {
            ((JLabel)container).setText(UIManagerExt.getString(CLASS_NAME + ".passwordString", this.getLocale()));
        }
        if ((container = (JLabel)this.namePanel.getComponent().getClientProperty("labeledBy")) != null) {
            ((JLabel)container).setText(UIManagerExt.getString(CLASS_NAME + ".nameString", this.getLocale()));
        }
        if (this.serverCombo != null && (container = (JLabel)this.serverCombo.getClientProperty("labeledBy")) != null) {
            ((JLabel)container).setText(UIManagerExt.getString(CLASS_NAME + ".serverString", this.getLocale()));
        }
        this.saveCB.setText(UIManagerExt.getString(CLASS_NAME + ".rememberPasswordString", this.getLocale()));
        this.capsOn.setText(this.isCapsLockOn() ? UIManagerExt.getString(CLASS_NAME + ".capsOnWarning", this.getLocale()) : " ");
        this.getActionMap().get(LOGIN_ACTION_COMMAND).putValue("Name", UIManagerExt.getString(CLASS_NAME + ".loginString", this.getLocale()));
        this.getActionMap().get(CANCEL_LOGIN_ACTION_COMMAND).putValue("Name", UIManagerExt.getString(CLASS_NAME + ".cancelString", this.getLocale()));
    }

    public JXLoginPane() {
        this((LoginService)null);
    }

    public JXLoginPane(LoginService loginService) {
        this(loginService, null, null);
    }

    public JXLoginPane(LoginService loginService, PasswordStore passwordStore, UserNameStore userNameStore) {
        this(loginService, passwordStore, userNameStore, null);
    }

    public JXLoginPane(LoginService loginService, PasswordStore passwordStore, UserNameStore userNameStore, List<String> list) {
        if (Boolean.parseBoolean(System.getProperty("swingx.enableCapslockTesting"))) {
            this.capsOnTest = new CapsOnTest();
            this.capsOnListener = new KeyEventDispatcher(){

                public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                    if (keyEvent.getID() != 401) {
                        return false;
                    }
                    if (keyEvent.getKeyCode() == 20) {
                        JXLoginPane.this.setCapsLock(!JXLoginPane.this.isCapsLockOn());
                    }
                    return false;
                }
            };
            this.capsOnWinListener = new CapsOnWinListener(this.capsOnTest);
        } else {
            this.capsOnTest = null;
            this.capsOnListener = null;
            this.capsOnWinListener = null;
            this.capsLockSupport = false;
        }
        this.setLoginService(loginService);
        this.setPasswordStore(passwordStore);
        this.setUserNameStore(userNameStore);
        this.setServers(list);
        this.getActionMap().put(LOGIN_ACTION_COMMAND, this.createLoginAction());
        this.getActionMap().put(CANCEL_LOGIN_ACTION_COMMAND, this.createCancelAction());
        this.saveMode = passwordStore != null && userNameStore != null ? SaveMode.BOTH : (passwordStore != null ? SaveMode.PASSWORD : (userNameStore != null ? SaveMode.USER_NAME : SaveMode.NONE));
        this.setOpaque(false);
        this.initComponents();
    }

    private void setCapsLock(boolean bl) {
        this.caps = bl;
        this.capsOn.setText(this.caps ? UIManagerExt.getString(CLASS_NAME + ".capsOnWarning", this.getLocale()) : " ");
    }

    public boolean isCapsLockOn() {
        return this.caps;
    }

    public boolean isCapsLockDetectionSupported() {
        return this.capsLockSupport;
    }

    @Override
    public LoginPaneUI getUI() {
        return (LoginPaneUI)super.getUI();
    }

    public void setUI(LoginPaneUI loginPaneUI) {
        if (this.banner == null) {
            this.banner = new JXImagePanel();
        }
        if (this.errorMessageLabel == null) {
            this.errorMessageLabel = new JXLabel(UIManagerExt.getString(CLASS_NAME + ".errorMessage", this.getLocale()));
        }
        super.setUI(loginPaneUI);
        this.banner.setImage(this.createLoginBanner());
    }

    @Override
    public void updateUI() {
        this.setUI((LoginPaneUI)LookAndFeelAddons.getUI(this, LoginPaneUI.class));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    protected void recreateLoginPanel() {
        JXPanel jXPanel = this.loginPanel;
        this.loginPanel = this.createLoginPanel();
        this.loginPanel.setBorder(BorderFactory.createEmptyBorder(0, 36, 7, 11));
        this.contentPanel.remove(jXPanel);
        this.contentPanel.add((Component)this.loginPanel, 1);
    }

    private JXPanel createLoginPanel() {
        JXPanel jXPanel = new JXPanel();
        JPasswordField jPasswordField = this.passwordField;
        this.passwordField = new JPasswordField("", 15);
        JLabel jLabel = new JLabel(UIManagerExt.getString(CLASS_NAME + ".passwordString", this.getLocale()));
        jLabel.setLabelFor(this.passwordField);
        if (jPasswordField != null) {
            this.passwordField.setText(new String(jPasswordField.getPassword()));
        }
        NameComponent nameComponent = this.namePanel;
        this.namePanel = this.saveMode == SaveMode.NONE ? new SimpleNamePanel() : new ComboNamePanel();
        if (nameComponent != null) {
            this.namePanel.setUserName(nameComponent.getUserName());
            this.namePanel.setEnabled(nameComponent.isEnabled());
            this.namePanel.setEditable(nameComponent.isEditable());
        } else {
            this.namePanel.setEnabled(this.namePanelEnabled);
            this.namePanel.setEditable(this.namePanelEnabled);
        }
        JLabel jLabel2 = new JLabel(UIManagerExt.getString(CLASS_NAME + ".nameString", this.getLocale()));
        jLabel2.setLabelFor(this.namePanel.getComponent());
        JLabel jLabel3 = new JLabel(UIManagerExt.getString(CLASS_NAME + ".serverString", this.getLocale()));
        if (this.servers.size() > 1) {
            this.serverCombo = new JComboBox<Object>(this.servers.toArray());
            jLabel3.setLabelFor(this.serverCombo);
        } else {
            this.serverCombo = null;
        }
        this.saveCB = new JCheckBox(UIManagerExt.getString(CLASS_NAME + ".rememberPasswordString", this.getLocale()));
        this.saveCB.setIconTextGap(10);
        this.saveCB.setSelected(false);
        this.saveCB.setVisible(this.saveMode == SaveMode.PASSWORD || this.saveMode == SaveMode.BOTH);
        this.saveCB.setOpaque(false);
        this.capsOn = new JLabel(" ");
        int n = 3;
        GridLayout gridLayout = new GridLayout(2, 1);
        gridLayout.setVgap(5);
        JPanel jPanel = new JPanel(gridLayout);
        jPanel.setOpaque(false);
        jPanel.add(this.namePanel.getComponent());
        jPanel.add(this.passwordField);
        jXPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(4, n, 5, 11);
        jXPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jXPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, n, 5, 11);
        jXPanel.add((Component)jLabel, gridBagConstraints);
        if (this.serverCombo != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(0, n, 5, 11);
            jXPanel.add((Component)jLabel3, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            jXPanel.add((Component)this.serverCombo, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 4, 0);
            jXPanel.add((Component)this.saveCB, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, n, 0, 11);
            jXPanel.add((Component)this.capsOn, gridBagConstraints);
        } else {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 4, 0);
            jXPanel.add((Component)this.saveCB, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, n, 0, 11);
            jXPanel.add((Component)this.capsOn, gridBagConstraints);
        }
        jXPanel.setOpaque(false);
        return jXPanel;
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        if (componentOrientation != super.getComponentOrientation()) {
            super.setComponentOrientation(componentOrientation);
            this.banner.setImage(this.createLoginBanner());
            this.progressPanel.applyComponentOrientation(componentOrientation);
        }
    }

    private void initComponents() {
        this.banner.setImage(this.createLoginBanner());
        this.messageLabel = new JLabel(" ");
        this.messageLabel.setOpaque(false);
        this.messageLabel.setFont(this.messageLabel.getFont().deriveFont(1));
        this.loginPanel = this.createLoginPanel();
        this.errorMessageLabel.setIcon(UIManager.getIcon(CLASS_NAME + ".errorIcon", this.getLocale()));
        this.errorMessageLabel.setVerticalTextPosition(1);
        this.errorMessageLabel.setLineWrap(true);
        this.errorMessageLabel.setPaintBorderInsets(false);
        this.errorMessageLabel.setBackgroundPainter(new MattePainter(UIManager.getColor(CLASS_NAME + ".errorBackground", this.getLocale()), true));
        this.errorMessageLabel.setMaxLineSpan(320);
        this.errorMessageLabel.setVisible(false);
        this.contentPanel = new JXPanel(new LoginPaneLayout());
        this.contentPanel.setOpaque(false);
        this.messageLabel.setBorder(BorderFactory.createEmptyBorder(12, 12, 7, 11));
        this.contentPanel.add(this.messageLabel);
        this.loginPanel.setBorder(BorderFactory.createEmptyBorder(0, 36, 7, 11));
        this.contentPanel.add(this.loginPanel);
        this.errorMessageLabel.setBorder(UIManager.getBorder(CLASS_NAME + ".errorBorder", this.getLocale()));
        this.contentPanel.add(this.errorMessageLabel);
        this.progressPanel = new JXPanel(new GridBagLayout());
        this.progressPanel.setOpaque(false);
        this.progressMessageLabel = new JLabel(UIManagerExt.getString(CLASS_NAME + ".pleaseWait", this.getLocale()));
        this.progressMessageLabel.setFont(UIManager.getFont(CLASS_NAME + ".pleaseWaitFont", this.getLocale()));
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setIndeterminate(true);
        JButton jButton = new JButton(this.getActionMap().get(CANCEL_LOGIN_ACTION_COMMAND));
        this.progressPanel.add((Component)this.progressMessageLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 21, 2, new Insets(12, 12, 11, 11), 0, 0));
        this.progressPanel.add((Component)jProgressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 24, 11, 7), 0, 0));
        this.progressPanel.add((Component)jButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 11, 11), 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)this.banner, "North");
        this.contentCardPane = new JPanel(new CardLayout());
        this.contentCardPane.setOpaque(false);
        this.contentCardPane.add((Component)this.contentPanel, "0");
        this.contentCardPane.add((Component)this.progressPanel, "1");
        this.add((Component)this.contentCardPane, "Center");
    }

    protected Image createLoginBanner() {
        return this.getUI() == null ? null : this.getUI().getBanner();
    }

    protected Action createLoginAction() {
        return new LoginAction(this);
    }

    protected Action createCancelAction() {
        return new CancelAction(this);
    }

    public SaveMode getSaveMode() {
        return this.saveMode;
    }

    public void setSaveMode(SaveMode saveMode) {
        if (this.saveMode != saveMode) {
            SaveMode saveMode2 = this.getSaveMode();
            this.saveMode = saveMode;
            this.recreateLoginPanel();
            this.firePropertyChange("saveMode", (Object)saveMode2, (Object)this.getSaveMode());
        }
    }

    public boolean isRememberPassword() {
        return this.saveCB.isVisible() && this.saveCB.isSelected();
    }

    public List<String> getServers() {
        return Collections.unmodifiableList(this.servers);
    }

    public void setServers(List<String> arrayList) {
        if (this.servers == null) {
            this.servers = arrayList == null ? new ArrayList() : arrayList;
        } else if (this.servers != arrayList) {
            List<String> list = this.getServers();
            this.servers = arrayList == null ? new ArrayList() : arrayList;
            this.recreateLoginPanel();
            this.firePropertyChange("servers", list, this.getServers());
        }
    }

    private LoginListener getDefaultLoginListener() {
        if (this.defaultLoginListener == null) {
            this.defaultLoginListener = new LoginListenerImpl();
        }
        return this.defaultLoginListener;
    }

    public void setLoginService(LoginService loginService) {
        LoginService loginService2;
        LoginService loginService3 = this.getLoginService();
        LoginService loginService4 = loginService2 = loginService == null ? new NullLoginService() : loginService;
        if (!loginService2.equals(loginService3)) {
            if (loginService3 != null) {
                loginService3.removeLoginListener(this.getDefaultLoginListener());
            }
            this.loginService = loginService2;
            this.loginService.addLoginListener(this.getDefaultLoginListener());
            this.firePropertyChange("loginService", loginService3, this.getLoginService());
        }
    }

    public LoginService getLoginService() {
        return this.loginService;
    }

    public void setPasswordStore(PasswordStore passwordStore) {
        PasswordStore passwordStore2;
        PasswordStore passwordStore3 = this.getPasswordStore();
        PasswordStore passwordStore4 = passwordStore2 = passwordStore == null ? new NullPasswordStore() : passwordStore;
        if (!passwordStore2.equals(passwordStore3)) {
            this.passwordStore = passwordStore2;
            this.firePropertyChange("passwordStore", passwordStore3, this.getPasswordStore());
        }
    }

    public UserNameStore getUserNameStore() {
        return this.userNameStore;
    }

    public void setUserNameStore(UserNameStore userNameStore) {
        UserNameStore userNameStore2;
        UserNameStore userNameStore3 = this.getUserNameStore();
        UserNameStore userNameStore4 = userNameStore2 = userNameStore == null ? new DefaultUserNameStore() : userNameStore;
        if (!userNameStore2.equals(userNameStore3)) {
            this.userNameStore = userNameStore2;
            this.firePropertyChange("userNameStore", userNameStore3, this.getUserNameStore());
        }
    }

    public PasswordStore getPasswordStore() {
        return this.passwordStore;
    }

    public void setUserName(String string) {
        if (this.namePanel != null) {
            String string2 = this.getUserName();
            this.namePanel.setUserName(string);
            this.firePropertyChange("userName", string2, this.getUserName());
        }
    }

    public void setUserNameEnabled(boolean bl) {
        boolean bl2 = this.isUserNameEnabled();
        this.namePanelEnabled = bl;
        if (this.namePanel != null) {
            this.namePanel.setEnabled(bl);
            this.namePanel.setEditable(bl);
        }
        this.firePropertyChange("userNameEnabled", bl2, this.isUserNameEnabled());
    }

    public boolean isUserNameEnabled() {
        return this.namePanelEnabled;
    }

    public String getUserName() {
        return this.namePanel == null ? null : this.namePanel.getUserName();
    }

    public void setPassword(char[] cArray) {
        this.passwordField.setText(new String(cArray));
    }

    public char[] getPassword() {
        return this.passwordField.getPassword();
    }

    public Image getBanner() {
        return this.banner.getImage();
    }

    public void setBanner(Image image) {
        Image image2 = this.getBanner();
        if (image2 != image) {
            this.banner.setImage(image);
            this.firePropertyChange("banner", image2, this.getBanner());
        }
    }

    public void setBannerText(String string) {
        if (string == null) {
            string = "";
        }
        if (!string.equals(this.bannerText)) {
            String string2 = this.bannerText;
            this.bannerText = string;
            this.banner.setImage(this.createLoginBanner());
            this.firePropertyChange("bannerText", string2, string);
        }
    }

    public String getBannerText() {
        return this.bannerText;
    }

    public String getMessage() {
        return this.messageLabel.getText();
    }

    public void setMessage(String string) {
        String string2 = this.messageLabel.getText();
        this.messageLabel.setText(string);
        this.firePropertyChange("message", string2, this.messageLabel.getText());
    }

    public String getErrorMessage() {
        return this.errorMessageLabel.getText();
    }

    public void setErrorMessage(String string) {
        this.isErrorMessageSet = true;
        String string2 = this.errorMessageLabel.getText();
        this.errorMessageLabel.setText(string);
        this.firePropertyChange("errorMessage", string2, this.errorMessageLabel.getText());
    }

    public Status getStatus() {
        return this.status;
    }

    protected void setStatus(Status status) {
        if (this.status != status) {
            Status status2 = this.status;
            this.status = status;
            this.firePropertyChange("status", (Object)status2, (Object)status);
        }
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.reinitLocales(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startLogin() {
        this.oldCursor = this.getCursor();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.progressMessageLabel.setText(UIManagerExt.getString(CLASS_NAME + ".pleaseWait", this.getLocale()));
            String string = this.getUserName();
            char[] cArray = this.getPassword();
            String string2 = this.servers.size() == 1 ? this.servers.get(0) : (this.serverCombo == null ? null : (String)this.serverCombo.getSelectedItem());
            this.loginService.startAuthentication(string, cArray, string2);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Authentication exception while logging in", exception);
        }
        finally {
            this.setCursor(this.oldCursor);
        }
    }

    protected void cancelLogin() {
        this.progressMessageLabel.setText(UIManagerExt.getString(CLASS_NAME + ".cancelWait", this.getLocale()));
        this.getActionMap().get(CANCEL_LOGIN_ACTION_COMMAND).setEnabled(false);
        this.loginService.cancelAuthentication();
        this.setCursor(this.oldCursor);
    }

    protected void savePassword() {
        if (this.saveCB.isSelected() && (this.saveMode == SaveMode.BOTH || this.saveMode == SaveMode.PASSWORD) && this.passwordStore != null) {
            this.passwordStore.set(this.getUserName(), this.getLoginService().getServer(), this.getPassword());
        }
    }

    @Override
    public void removeNotify() {
        try {
            Window window;
            if (this.capsLockSupport) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.capsOnListener);
            }
            if ((window = this.getTLA()) instanceof Window) {
                Window window2 = window;
                window2.removeWindowFocusListener(this.capsOnWinListener);
                window2.removeWindowListener(this.capsOnWinListener);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.removeNotify();
    }

    private Window getTLA() {
        Container container = this;
        while (container.getParent() != null && !(container instanceof Window)) {
            container = container.getParent();
        }
        return (Window)container;
    }

    @Override
    public void addNotify() {
        try {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.capsOnListener);
            Window window = this.getTLA();
            if (window instanceof Window) {
                Window window2 = window;
                window2.addWindowFocusListener(this.capsOnWinListener);
                window2.addWindowListener(this.capsOnWinListener);
            }
        }
        catch (Exception exception) {
            this.capsLockSupport = false;
        }
        super.addNotify();
    }

    private void updatePassword(String string) {
        String string2 = "";
        if (string != null) {
            char[] cArray = this.passwordStore.get(string, null);
            string2 = cArray == null ? "" : new String(cArray);
            this.saveCB.setSelected(this.userNameStore.containsUserName(string));
        }
        this.passwordField.setText(string2);
    }

    public static Status showLoginDialog(Component component, LoginService loginService) {
        return JXLoginPane.showLoginDialog(component, loginService, null, null);
    }

    public static Status showLoginDialog(Component component, LoginService loginService, PasswordStore passwordStore, UserNameStore userNameStore) {
        return JXLoginPane.showLoginDialog(component, loginService, passwordStore, userNameStore, null);
    }

    public static Status showLoginDialog(Component component, LoginService loginService, PasswordStore passwordStore, UserNameStore userNameStore, List<String> list) {
        JXLoginPane jXLoginPane = new JXLoginPane(loginService, passwordStore, userNameStore, list);
        return JXLoginPane.showLoginDialog(component, jXLoginPane);
    }

    public static Status showLoginDialog(Component component, JXLoginPane jXLoginPane) {
        Window window = WindowUtils.findWindow(component);
        JXLoginDialog jXLoginDialog = null;
        if (window == null) {
            jXLoginDialog = new JXLoginDialog((Frame)null, jXLoginPane);
        } else if (window instanceof Dialog) {
            jXLoginDialog = new JXLoginDialog((Dialog)window, jXLoginPane);
        } else if (window instanceof Frame) {
            jXLoginDialog = new JXLoginDialog((Frame)window, jXLoginPane);
        } else {
            throw new AssertionError((Object)"Shouldn't be able to happen");
        }
        jXLoginDialog.setVisible(true);
        return jXLoginDialog.getStatus();
    }

    public static JXLoginFrame showLoginFrame(LoginService loginService) {
        return JXLoginPane.showLoginFrame(loginService, null, null);
    }

    public static JXLoginFrame showLoginFrame(LoginService loginService, PasswordStore passwordStore, UserNameStore userNameStore) {
        return JXLoginPane.showLoginFrame(loginService, passwordStore, userNameStore, null);
    }

    public static JXLoginFrame showLoginFrame(LoginService loginService, PasswordStore passwordStore, UserNameStore userNameStore, List<String> list) {
        JXLoginPane jXLoginPane = new JXLoginPane(loginService, passwordStore, userNameStore, list);
        return JXLoginPane.showLoginFrame(jXLoginPane);
    }

    public static JXLoginFrame showLoginFrame(JXLoginPane jXLoginPane) {
        return new JXLoginFrame(jXLoginPane);
    }

    static void initWindow(final Window window, final JXLoginPane jXLoginPane) {
        window.setLayout(new BorderLayout());
        window.add((Component)jXLoginPane, "Center");
        JButton jButton = new JButton(jXLoginPane.getActionMap().get(LOGIN_ACTION_COMMAND));
        final JButton jButton2 = new JButton(UIManagerExt.getString(CLASS_NAME + ".cancelString", jXLoginPane.getLocale()));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jXLoginPane.status = Status.CANCELLED;
                window.setVisible(false);
                window.dispose();
            }
        });
        jXLoginPane.addPropertyChangeListener("status", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Status status = (Status)((Object)propertyChangeEvent.getNewValue());
                switch (status) {
                    case NOT_STARTED: {
                        break;
                    }
                    case IN_PROGRESS: {
                        jButton2.setEnabled(false);
                        break;
                    }
                    case CANCELLED: {
                        jButton2.setEnabled(true);
                        window.pack();
                        break;
                    }
                    case FAILED: {
                        jButton2.setEnabled(true);
                        jXLoginPane.passwordField.requestFocusInWindow();
                        window.pack();
                        break;
                    }
                    case SUCCEEDED: {
                        window.setVisible(false);
                        window.dispose();
                    }
                }
                for (PropertyChangeListener propertyChangeListener : window.getPropertyChangeListeners("status")) {
                    PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(window, "status", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                    propertyChangeListener.propertyChange(propertyChangeEvent2);
                }
            }
        });
        JXBtnPanel jXBtnPanel = new JXBtnPanel(jButton, jButton2);
        jXBtnPanel.setOpaque(false);
        jXLoginPane.setButtonPanel(jXBtnPanel);
        JXPanel jXPanel = new JXPanel(new FlowLayout(2));
        jXPanel.setOpaque(false);
        new BoxLayout(jXPanel, 0);
        jXPanel.add(Box.createHorizontalGlue());
        jXPanel.add(jXBtnPanel);
        window.add((Component)jXPanel, "South");
        window.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jXLoginPane.cancelLogin();
            }
        });
        if (window instanceof JFrame) {
            final JFrame jFrame = (JFrame)window;
            jFrame.getRootPane().setDefaultButton(jButton);
            jFrame.setResizable(false);
            jFrame.setDefaultCloseOperation(2);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jFrame.setVisible(false);
                    jFrame.dispose();
                }
            };
            jFrame.getRootPane().registerKeyboardAction(actionListener, keyStroke, 2);
        } else if (window instanceof JDialog) {
            final JDialog jDialog = (JDialog)window;
            jDialog.getRootPane().setDefaultButton(jButton);
            jDialog.setResizable(false);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.setVisible(false);
                }
            };
            jDialog.getRootPane().registerKeyboardAction(actionListener, keyStroke, 2);
        }
        window.pack();
        window.setLocation(WindowUtils.getPointForCentering(window));
    }

    private void setButtonPanel(JXBtnPanel jXBtnPanel) {
        this.buttonPanel = jXBtnPanel;
    }

    static {
        LookAndFeelAddons.contribute(new LoginPaneAddon());
    }

    private class RemovableKeyEventDispatcher
    implements KeyEventDispatcher {
        private CapsOnTest cot;
        private boolean tested = false;
        private int retry = 0;

        public RemovableKeyEventDispatcher(CapsOnTest capsOnTest) {
            this.cot = capsOnTest;
        }

        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            this.tested = true;
            if (keyEvent.getID() != 401) {
                return true;
            }
            if (JXLoginPane.this.isTestingCaps && keyEvent.getKeyCode() > 64 && keyEvent.getKeyCode() < 91) {
                JXLoginPane.this.setCapsLock(!keyEvent.isShiftDown() && Character.isUpperCase(keyEvent.getKeyChar()));
            }
            if (JXLoginPane.this.isTestingCaps && keyEvent.getKeyCode() == 8) {
                this.uninstall();
                this.retry = 0;
            }
            return true;
        }

        void uninstall() {
            JXLoginPane.this.isTestingCaps = false;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
            if (this.cot.ked == this) {
                this.cot.ked = null;
            }
        }

        void cleanOnBogusFocus() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (!RemovableKeyEventDispatcher.this.tested) {
                        RemovableKeyEventDispatcher.this.uninstall();
                        if (RemovableKeyEventDispatcher.this.retry < 3) {
                            Window window = JXLoginPane.this.getTLA();
                            if (window != null) {
                                window.toFront();
                            }
                            RemovableKeyEventDispatcher.this.cot.runTest();
                            RemovableKeyEventDispatcher.this.retry++;
                        }
                    }
                }
            });
        }
    }

    private final class CapsOnWinListener
    extends WindowAdapter
    implements WindowFocusListener,
    WindowListener {
        private CapsOnTest cot;
        private long stamp;

        public CapsOnWinListener(CapsOnTest capsOnTest) {
            this.cot = capsOnTest;
        }

        public void windowActivated(WindowEvent windowEvent) {
            this.cot.runTest();
            this.stamp = System.currentTimeMillis();
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
            if (this.stamp + 20L < System.currentTimeMillis()) {
                this.cot.runTest();
            }
        }

        public void windowOpened(WindowEvent windowEvent) {
            this.cot.clean();
        }
    }

    private final class CapsOnTest {
        RemovableKeyEventDispatcher ked;

        private CapsOnTest() {
        }

        public void runTest() {
            boolean bl = false;
            if (!bl) {
                try {
                    KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    if (this.ked != null) {
                        keyboardFocusManager.removeKeyEventDispatcher(this.ked);
                    }
                    this.ked = new RemovableKeyEventDispatcher(this);
                    keyboardFocusManager.addKeyEventDispatcher(this.ked);
                    Robot robot = new Robot();
                    JXLoginPane.this.isTestingCaps = true;
                    robot.keyPress(65);
                    robot.keyRelease(65);
                    robot.keyPress(8);
                    robot.keyRelease(8);
                }
                catch (Exception exception) {
                    this.ked.uninstall();
                }
            }
        }

        public void clean() {
            if (this.ked != null) {
                this.ked.cleanOnBogusFocus();
            }
        }
    }

    private static class JXBtnPanel
    extends JXPanel {
        private JButton cancel;
        private JButton ok;

        public JXBtnPanel(JButton jButton, JButton jButton2) {
            GridLayout gridLayout = new GridLayout(1, 2);
            gridLayout.setHgap(5);
            this.setLayout(gridLayout);
            this.ok = jButton;
            this.cancel = jButton2;
            this.add(jButton);
            this.add(jButton2);
            this.setBorder(new EmptyBorder(0, 0, 7, 11));
        }

        public JButton getCancel() {
            return this.cancel;
        }

        public JButton getOk() {
            return this.ok;
        }
    }

    public static final class JXLoginFrame
    extends JXFrame {
        private JXLoginPane panel;

        public JXLoginFrame(JXLoginPane jXLoginPane) {
            super(UIManagerExt.getString(CLASS_NAME + ".titleString", jXLoginPane.getLocale()));
            JXPanel jXPanel = new JXPanel();
            jXPanel.setOpaque(true);
            this.setContentPane(jXPanel);
            this.panel = jXLoginPane;
            JXLoginPane.initWindow(this, this.panel);
        }

        public JXPanel getContentPane() {
            return (JXPanel)super.getContentPane();
        }

        public Status getStatus() {
            return this.panel.getStatus();
        }

        public JXLoginPane getPanel() {
            return this.panel;
        }
    }

    public static final class JXLoginDialog
    extends JDialog {
        private JXLoginPane panel;

        public JXLoginDialog(Frame frame, JXLoginPane jXLoginPane) {
            super(frame, true);
            this.init(jXLoginPane);
        }

        public JXLoginDialog(Dialog dialog, JXLoginPane jXLoginPane) {
            super(dialog, true);
            this.init(jXLoginPane);
        }

        protected void init(JXLoginPane jXLoginPane) {
            this.setTitle(UIManagerExt.getString(CLASS_NAME + ".titleString", this.getLocale()));
            this.panel = jXLoginPane;
            JXLoginPane.initWindow(this, this.panel);
        }

        public Status getStatus() {
            return this.panel.getStatus();
        }
    }

    private final class ComboNamePanel
    extends JComboBox
    implements NameComponent {
        public ComboNamePanel() {
            this.setModel(new NameComboBoxModel());
            this.setEditable(true);
            AutoCompleteDecorator.decorate(this);
            if (JXLoginPane.this.passwordStore != null && JXLoginPane.this.passwordField != null) {
                final JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
                jTextField.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent keyEvent) {
                        JXLoginPane.this.updatePassword(jTextField.getText());
                    }
                });
                super.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        JXLoginPane.this.updatePassword((String)ComboNamePanel.this.getSelectedItem());
                    }
                });
            }
        }

        public String getUserName() {
            Object object = this.getModel().getSelectedItem();
            return object == null ? null : object.toString();
        }

        public void setUserName(String string) {
            this.getModel().setSelectedItem(string);
        }

        public void setUserNames(String[] stringArray) {
            this.setModel(new DefaultComboBoxModel<String>(stringArray));
        }

        public JComponent getComponent() {
            return this;
        }

        private final class NameComboBoxModel
        extends AbstractListModel
        implements ComboBoxModel {
            private Object selectedItem;

            private NameComboBoxModel() {
            }

            public void setSelectedItem(Object object) {
                this.selectedItem = object;
                this.fireContentsChanged(this, -1, -1);
            }

            public Object getSelectedItem() {
                return this.selectedItem;
            }

            public Object getElementAt(int n) {
                return JXLoginPane.this.userNameStore.getUserNames()[n];
            }

            public int getSize() {
                return JXLoginPane.this.userNameStore.getUserNames().length;
            }
        }
    }

    private final class SimpleNamePanel
    extends JTextField
    implements NameComponent {
        public SimpleNamePanel() {
            super("", 15);
            if (JXLoginPane.this.passwordStore != null && JXLoginPane.this.passwordField != null) {
                this.addKeyListener(new KeyAdapter(){

                    public void keyReleased(KeyEvent keyEvent) {
                        JXLoginPane.this.updatePassword(SimpleNamePanel.this.getText());
                    }
                });
            }
        }

        public String getUserName() {
            return this.getText();
        }

        public void setUserName(String string) {
            this.setText(string);
        }

        public JComponent getComponent() {
            return this;
        }
    }

    private static interface NameComponent {
        public String getUserName();

        public boolean isEnabled();

        public boolean isEditable();

        public void setEditable(boolean var1);

        public void setEnabled(boolean var1);

        public void setUserName(String var1);

        public JComponent getComponent();
    }

    private static final class NullPasswordStore
    extends PasswordStore {
        private NullPasswordStore() {
        }

        public boolean set(String string, String string2, char[] cArray) {
            return false;
        }

        public char[] get(String string, String string2) {
            return new char[0];
        }

        public void removeUserPassword(String string) {
        }

        public boolean equals(Object object) {
            return object instanceof NullPasswordStore;
        }

        public int hashCode() {
            return 7;
        }
    }

    private static final class NullLoginService
    extends LoginService {
        private NullLoginService() {
        }

        public boolean authenticate(String string, char[] cArray, String string2) throws Exception {
            return true;
        }

        public boolean equals(Object object) {
            return object instanceof NullLoginService;
        }

        public int hashCode() {
            return 7;
        }
    }

    private static final class CancelAction
    extends AbstractActionExt {
        private JXLoginPane panel;

        public CancelAction(JXLoginPane jXLoginPane) {
            super(UIManagerExt.getString(CLASS_NAME + ".cancelLogin", jXLoginPane.getLocale()), JXLoginPane.CANCEL_LOGIN_ACTION_COMMAND);
            this.panel = jXLoginPane;
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.panel.cancelLogin();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }
    }

    private static final class LoginAction
    extends AbstractActionExt {
        private JXLoginPane panel;

        public LoginAction(JXLoginPane jXLoginPane) {
            super(UIManagerExt.getString(CLASS_NAME + ".loginString", jXLoginPane.getLocale()), JXLoginPane.LOGIN_ACTION_COMMAND);
            this.panel = jXLoginPane;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.panel.startLogin();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }
    }

    protected class LoginListenerImpl
    extends LoginAdapter {
        protected LoginListenerImpl() {
        }

        public void loginSucceeded(LoginEvent loginEvent) {
            String string = JXLoginPane.this.namePanel.getUserName();
            if (!(JXLoginPane.this.getSaveMode() != SaveMode.USER_NAME && JXLoginPane.this.getSaveMode() != SaveMode.BOTH || string == null || string.trim().equals(""))) {
                JXLoginPane.this.userNameStore.addUserName(string);
                JXLoginPane.this.userNameStore.saveUserNames();
            }
            if (JXLoginPane.this.saveCB.isSelected()) {
                JXLoginPane.this.savePassword();
            } else if (JXLoginPane.this.passwordStore != null) {
                JXLoginPane.this.passwordStore.removeUserPassword(string);
            }
            JXLoginPane.this.setStatus(Status.SUCCEEDED);
        }

        public void loginStarted(LoginEvent loginEvent) {
            assert (EventQueue.isDispatchThread());
            JXLoginPane.this.getActionMap().get(JXLoginPane.LOGIN_ACTION_COMMAND).setEnabled(false);
            JXLoginPane.this.getActionMap().get(JXLoginPane.CANCEL_LOGIN_ACTION_COMMAND).setEnabled(true);
            ((CardLayout)JXLoginPane.this.contentCardPane.getLayout()).last(JXLoginPane.this.contentCardPane);
            JXLoginPane.this.revalidate();
            JXLoginPane.this.repaint();
            JXLoginPane.this.setStatus(Status.IN_PROGRESS);
        }

        public void loginFailed(LoginEvent loginEvent) {
            assert (EventQueue.isDispatchThread());
            ((CardLayout)JXLoginPane.this.contentCardPane.getLayout()).first(JXLoginPane.this.contentCardPane);
            JXLoginPane.this.getActionMap().get(JXLoginPane.LOGIN_ACTION_COMMAND).setEnabled(true);
            JXLoginPane.this.errorMessageLabel.setVisible(true);
            JXLoginPane.this.revalidate();
            JXLoginPane.this.repaint();
            JXLoginPane.this.setStatus(Status.FAILED);
        }

        public void loginCanceled(LoginEvent loginEvent) {
            assert (EventQueue.isDispatchThread());
            ((CardLayout)JXLoginPane.this.contentCardPane.getLayout()).first(JXLoginPane.this.contentCardPane);
            JXLoginPane.this.getActionMap().get(JXLoginPane.LOGIN_ACTION_COMMAND).setEnabled(true);
            JXLoginPane.this.errorMessageLabel.setVisible(false);
            JXLoginPane.this.revalidate();
            JXLoginPane.this.repaint();
            JXLoginPane.this.setStatus(Status.CANCELLED);
        }
    }

    private final class LoginPaneLayout
    extends VerticalLayout
    implements LayoutManager {
        private LoginPaneLayout() {
        }

        public Dimension preferredLayoutSize(Container container) {
            Insets insets = container.getInsets();
            Dimension dimension = new Dimension(0, 0);
            int n = this.getGap();
            int n2 = container.getComponentCount();
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.getPreferredSize();
                if (component instanceof JLabel) {
                    View view = (View)((JLabel)component).getClientProperty("html");
                    if (view != null) {
                        view.setSize(dimension.width, component.getHeight());
                        dimension2 = component.getPreferredSize();
                    }
                } else {
                    dimension.width = Math.max(dimension.width, dimension2.width);
                }
                dimension.height += dimension2.height + n;
            }
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            return dimension;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NOT_STARTED,
        IN_PROGRESS,
        FAILED,
        CANCELLED,
        SUCCEEDED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SaveMode {
        NONE,
        USER_NAME,
        PASSWORD,
        BOTH;

    }
}

