/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXImagePanel
extends JXPanel {
    private static final Logger LOG = Logger.getLogger(JXImagePanel.class.getName());
    private SoftReference<Image> img = new SoftReference<Object>(null);
    private boolean editable = false;
    private MouseHandler mhandler = new MouseHandler();
    private Style style = Style.CENTERED;
    private Image defaultImage;
    private Callable<Image> imageLoader;
    private static final ExecutorService service = Executors.newFixedThreadPool(5);

    public JXImagePanel() {
    }

    public JXImagePanel(URL uRL) {
        try {
            this.setImage(ImageIO.read(uRL));
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "", exception);
        }
    }

    public void setImage(Image image) {
        if (image != this.img.get()) {
            Image image2 = this.img.get();
            this.img = new SoftReference<Image>(image);
            this.firePropertyChange("image", image2, this.img);
            this.invalidate();
            this.repaint();
        }
    }

    public Image getImage() {
        Image image = this.img.get();
        if (image == null && this.imageLoader != null) {
            try {
                image = this.imageLoader.call();
                this.img = new SoftReference<Image>(image);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "", exception);
            }
        }
        return image;
    }

    public void setEditable(boolean bl) {
        if (bl != this.editable) {
            if (this.editable) {
                this.removeMouseListener(this.mhandler);
            }
            this.editable = bl;
            if (this.editable) {
                this.addMouseListener(this.mhandler);
            }
            this.setToolTipText(bl ? "<html><i><b>Click here<br>to set the image</b></i></html>" : "");
            this.firePropertyChange("editable", !bl, bl);
            this.repaint();
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setStyle(Style style) {
        if (this.style != style) {
            Style style2 = this.style;
            this.style = style;
            this.firePropertyChange("style", (Object)style2, (Object)style);
            this.repaint();
        }
    }

    public Style getStyle() {
        return this.style;
    }

    @Override
    public Dimension getPreferredSize() {
        Image image;
        if (!this.isPreferredSizeSet() && this.img != null && (image = this.img.get()) != null) {
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            if (n == -1 || n2 == -1) {
                return super.getPreferredSize();
            }
            Insets insets = this.getInsets();
            return new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
        }
        return super.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Image image = this.img.get();
        if (image == null && this.imageLoader != null) {
            service.execute(new FutureTask<Image>(this.imageLoader){

                @Override
                protected void done() {
                    super.done();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                JXImagePanel.this.setImage((Image)this.get());
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (ExecutionException executionException) {
                                LOG.log(Level.WARNING, "", executionException);
                            }
                        }
                    });
                }
            });
            image = this.defaultImage;
        }
        if (image != null) {
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            if (n == -1 || n2 == -1) {
                return;
            }
            Insets insets = this.getInsets();
            int n3 = this.getWidth() - insets.left - insets.right;
            int n4 = this.getHeight() - insets.top - insets.bottom;
            switch (this.style) {
                case CENTERED: {
                    Rectangle rectangle = graphics2D.getClipBounds();
                    int n5 = (n3 - n) / 2 + insets.left;
                    int n6 = (n4 - n2) / 2 + insets.top;
                    Rectangle rectangle2 = SwingUtilities.computeIntersection(n5, n6, n, n2, rectangle);
                    if (rectangle2.x == 0 && rectangle2.y == 0 && (rectangle2.width == 0 || rectangle2.height == 0)) {
                        return;
                    }
                    rectangle = rectangle2;
                    int n7 = rectangle.x - n5;
                    int n8 = rectangle.y - n6;
                    int n9 = rectangle.width;
                    int n10 = rectangle.height;
                    graphics2D.drawImage(image, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, n7, n8, n7 + n9, n8 + n10, null);
                    break;
                }
                case TILED: {
                    graphics2D.translate(insets.left, insets.top);
                    Rectangle rectangle = graphics2D.getClipBounds();
                    graphics2D.setClip(0, 0, n3, n4);
                    for (int i = 0; i < n4; i += image.getHeight(null)) {
                        for (int j = 0; j < n3; j += image.getWidth(null)) {
                            graphics2D.drawImage(image, j, i, null);
                        }
                    }
                    graphics2D.setClip(rectangle);
                    graphics2D.translate(-insets.left, -insets.top);
                    break;
                }
                case SCALED: {
                    graphics2D.drawImage(image, insets.left, insets.top, n3, n4, null);
                    break;
                }
                case SCALED_KEEP_ASPECT_RATIO: {
                    int n11 = n3;
                    int n12 = n4;
                    float f = (float)n11 / (float)n;
                    float f2 = (float)n12 / (float)n2;
                    if (f < f2) {
                        n12 = (int)((float)n2 * f);
                    } else {
                        n11 = (int)((float)n * f2);
                    }
                    int n13 = (n3 - n11) / 2 + insets.left;
                    int n14 = (n4 - n12) / 2 + insets.top;
                    graphics2D.drawImage(image, n13, n14, n11, n12, null);
                    break;
                }
                default: {
                    LOG.fine("unimplemented");
                    graphics2D.drawImage(image, insets.left, insets.top, this);
                }
            }
        }
    }

    public void setDefaultImage(Image image) {
        this.defaultImage = image;
    }

    public void setImageLoader(Callable<Image> callable) {
        this.imageLoader = callable;
    }

    private class MouseHandler
    extends MouseAdapter {
        private Cursor oldCursor;
        private JFileChooser chooser;

        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (this.chooser == null) {
                this.chooser = new JFileChooser();
            }
            if ((n = this.chooser.showOpenDialog(JXImagePanel.this)) == 0) {
                File file = this.chooser.getSelectedFile();
                try {
                    JXImagePanel.this.setImage(new ImageIcon(file.toURI().toURL()).getImage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.oldCursor == null) {
                this.oldCursor = JXImagePanel.this.getCursor();
                JXImagePanel.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (this.oldCursor != null) {
                JXImagePanel.this.setCursor(this.oldCursor);
                this.oldCursor = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        CENTERED,
        TILED,
        SCALED,
        SCALED_KEEP_ASPECT_RATIO;

    }
}

