/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.Painter;

public class JXGraph
extends JXPanel {
    private PropertyChangeListener plotChangeListener;
    private Color majorGridColor = Color.GRAY.brighter();
    private Color minorGridColor = new Color(220, 220, 220);
    private Color axisColor = Color.BLACK;
    private List<DrawablePlot> plots;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private Rectangle2D defaultView;
    private double originX;
    private double originY;
    private double majorX;
    private double defaultMajorX;
    private int minorCountX;
    private double majorY;
    private double defaultMajorY;
    private int minorCountY;
    private boolean textPainted = true;
    private boolean gridPainted = true;
    private boolean axisPainted = true;
    private boolean backPainted = true;
    private Point dragStart;
    private NumberFormat mainFormatter;
    private NumberFormat secondFormatter;
    private boolean inputEnabled = true;
    private ZoomHandler zoomHandler;
    private PanMotionHandler panMotionHandler;
    private PanHandler panHandler;
    private ResetHandler resetHandler;

    public JXGraph() {
        this(0.0, 0.0, -1.0, 1.0, -1.0, 1.0, 0.2, 4, 0.2, 4);
    }

    public JXGraph(Rectangle2D rectangle2D) {
        this(new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY()), rectangle2D, 0.2, 4, 0.2, 4);
    }

    public JXGraph(Rectangle2D rectangle2D, double d, int n, double d2, int n2) {
        this(new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY()), rectangle2D, d, n, d2, n2);
    }

    public JXGraph(Point2D point2D, Rectangle2D rectangle2D) {
        this(point2D, rectangle2D, 0.2, 4, 0.2, 4);
    }

    public JXGraph(Point2D point2D, Rectangle2D rectangle2D, double d, int n, double d2, int n2) {
        this(point2D.getX(), point2D.getY(), rectangle2D.getMinX(), rectangle2D.getMaxX(), rectangle2D.getMinY(), rectangle2D.getMaxY(), d, n, d2, n2);
    }

    public JXGraph(double d, double d2, double d3, double d4, double d5, double d6, double d7, int n, double d8, int n2) {
        if (d3 >= d4) {
            throw new IllegalArgumentException("minX must be < to maxX");
        }
        if (d5 >= d6) {
            throw new IllegalArgumentException("minY must be < to maxY");
        }
        if (n < 0) {
            throw new IllegalArgumentException("minorCountX must be >= 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("minorCountY must be >= 0");
        }
        if (d7 <= 0.0) {
            throw new IllegalArgumentException("majorX must be > 0.0");
        }
        if (d8 <= 0.0) {
            throw new IllegalArgumentException("majorY must be > 0.0");
        }
        this.originX = d;
        this.originY = d2;
        this.minX = d3;
        this.maxX = d4;
        this.minY = d5;
        this.maxY = d6;
        this.defaultView = new Rectangle2D.Double(d3, d5, d4 - d3, d6 - d5);
        this.defaultMajorX = d7;
        this.setMajorX(this.defaultMajorX);
        this.setMinorCountX(n);
        this.defaultMajorY = d8;
        this.setMajorY(this.defaultMajorY);
        this.setMinorCountY(n2);
        this.plots = new LinkedList<DrawablePlot>();
        this.mainFormatter = NumberFormat.getInstance();
        this.mainFormatter.setMaximumFractionDigits(2);
        this.secondFormatter = new DecimalFormat("0.##E0");
        this.resetHandler = new ResetHandler();
        this.addMouseListener(this.resetHandler);
        this.panHandler = new PanHandler();
        this.addMouseListener(this.panHandler);
        this.panMotionHandler = new PanMotionHandler();
        this.addMouseMotionListener(this.panMotionHandler);
        this.zoomHandler = new ZoomHandler();
        this.addMouseWheelListener(this.zoomHandler);
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.plotChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JXGraph.this.repaint();
            }
        };
    }

    public boolean isOpaque() {
        if (!this.isBackgroundPainted()) {
            return false;
        }
        return super.isOpaque();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setInputEnabled(bl);
    }

    public void setInputEnabled(boolean bl) {
        if (this.inputEnabled != bl) {
            boolean bl2 = this.isInputEnabled();
            this.inputEnabled = bl;
            if (bl) {
                this.addMouseListener(this.resetHandler);
                this.addMouseListener(this.panHandler);
                this.addMouseMotionListener(this.panMotionHandler);
                this.addMouseWheelListener(this.zoomHandler);
            } else {
                this.removeMouseListener(this.resetHandler);
                this.removeMouseListener(this.panHandler);
                this.removeMouseMotionListener(this.panMotionHandler);
                this.removeMouseWheelListener(this.zoomHandler);
            }
            this.firePropertyChange("inputEnabled", bl2, this.isInputEnabled());
        }
    }

    public boolean isInputEnabled() {
        return this.inputEnabled;
    }

    public boolean isTextPainted() {
        return this.textPainted;
    }

    public void setTextPainted(boolean bl) {
        boolean bl2 = this.isTextPainted();
        this.textPainted = bl;
        this.firePropertyChange("textPainted", bl2, this.textPainted);
    }

    public boolean isGridPainted() {
        return this.gridPainted;
    }

    public void setGridPainted(boolean bl) {
        boolean bl2 = this.isGridPainted();
        this.gridPainted = bl;
        this.firePropertyChange("gridPainted", bl2, this.isGridPainted());
    }

    public boolean isAxisPainted() {
        return this.axisPainted;
    }

    public void setAxisPainted(boolean bl) {
        boolean bl2 = this.isAxisPainted();
        this.axisPainted = bl;
        this.firePropertyChange("axisPainted", bl2, this.isAxisPainted());
    }

    public boolean isBackgroundPainted() {
        return this.backPainted;
    }

    public void setBackgroundPainted(boolean bl) {
        boolean bl2 = this.isBackgroundPainted();
        this.backPainted = bl;
        this.firePropertyChange("backgroundPainted", bl2, this.isBackgroundPainted());
    }

    public Color getMajorGridColor() {
        return this.majorGridColor;
    }

    public void setMajorGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Color cannot be null.");
        }
        Color color2 = this.getMajorGridColor();
        this.majorGridColor = color;
        this.firePropertyChange("majorGridColor", color2, this.getMajorGridColor());
    }

    public Color getMinorGridColor() {
        return this.minorGridColor;
    }

    public void setMinorGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Color cannot be null.");
        }
        Color color2 = this.getMinorGridColor();
        this.minorGridColor = color;
        this.firePropertyChange("minorGridColor", color2, this.getMinorGridColor());
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public void setAxisColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Color cannot be null.");
        }
        Color color2 = this.getAxisColor();
        this.axisColor = color;
        this.firePropertyChange("axisColor", color2, this.getAxisColor());
    }

    public double getMajorX() {
        return this.majorX;
    }

    public void setMajorX(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("majorX must be > 0.0");
        }
        double d2 = this.getMajorX();
        this.majorX = d;
        this.defaultMajorX = d;
        this.repaint();
        this.firePropertyChange("majorX", d2, this.getMajorX());
    }

    public int getMinorCountX() {
        return this.minorCountX;
    }

    public void setMinorCountX(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("minorCountX must be >= 0");
        }
        int n2 = this.getMinorCountX();
        this.minorCountX = n;
        this.repaint();
        this.firePropertyChange("minorCountX", n2, this.getMinorCountX());
    }

    public double getMajorY() {
        return this.majorY;
    }

    public void setMajorY(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("majorY must be > 0.0");
        }
        double d2 = this.getMajorY();
        this.majorY = d;
        this.defaultMajorY = d;
        this.repaint();
        this.firePropertyChange("majorY", d2, this.getMajorY());
    }

    public int getMinorCountY() {
        return this.minorCountY;
    }

    public void setMinorCountY(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("minorCountY must be >= 0");
        }
        int n2 = this.getMinorCountY();
        this.minorCountY = n;
        this.repaint();
        this.firePropertyChange("minorCountY", n2, this.getMinorCountY());
    }

    public void setViewAndOrigin(Rectangle2D rectangle2D) {
        this.setView(rectangle2D);
        this.setOrigin(new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY()));
    }

    public void setView(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return;
        }
        Rectangle2D rectangle2D2 = this.getView();
        this.defaultView = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        this.minX = this.defaultView.getMinX();
        this.maxX = this.defaultView.getMaxX();
        this.minY = this.defaultView.getMinY();
        this.maxY = this.defaultView.getMaxY();
        this.majorX = this.defaultMajorX;
        this.majorY = this.defaultMajorY;
        this.firePropertyChange("view", rectangle2D2, this.getView());
        this.repaint();
    }

    public Rectangle2D getView() {
        return new Rectangle2D.Double(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
    }

    public void resetView() {
        this.setView(this.defaultView);
    }

    public void setOrigin(Point2D point2D) {
        if (point2D == null) {
            return;
        }
        Point2D point2D2 = this.getOrigin();
        this.originX = point2D.getX();
        this.originY = point2D.getY();
        this.firePropertyChange("origin", point2D2, this.getOrigin());
        this.repaint();
    }

    public Point2D getOrigin() {
        return new Point2D.Double(this.originX, this.originY);
    }

    public void addPlots(Color color, Plot ... plotArray) {
        if (color == null) {
            throw new IllegalArgumentException("Plots color cannot be null.");
        }
        if (plotArray == null) {
            return;
        }
        for (Plot plot : plotArray) {
            DrawablePlot drawablePlot = new DrawablePlot(plot, color);
            if (plot == null || this.plots.contains(drawablePlot)) continue;
            plot.addPropertyChangeListener(this.plotChangeListener);
            this.plots.add(drawablePlot);
        }
        this.repaint();
    }

    public void removePlots(Plot ... plotArray) {
        if (plotArray == null) {
            return;
        }
        for (Plot plot : plotArray) {
            if (plot == null) continue;
            DrawablePlot drawablePlot = null;
            for (DrawablePlot drawablePlot2 : this.plots) {
                if (drawablePlot2.getEquation() != plot) continue;
                drawablePlot = drawablePlot2;
                break;
            }
            if (drawablePlot == null) continue;
            plot.removePropertyChangeListener(this.plotChangeListener);
            this.plots.remove(drawablePlot);
        }
        this.repaint();
    }

    public void removeAllPlots() {
        this.plots.clear();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 400);
    }

    protected double yPositionToPixel(double d) {
        double d2 = this.getHeight();
        return d2 - (d - this.minY) * d2 / (this.maxY - this.minY);
    }

    protected double xPositionToPixel(double d) {
        return (d - this.minX) * (double)this.getWidth() / (this.maxX - this.minX);
    }

    protected double xPixelToPosition(double d) {
        return this.minX + d * (this.maxX - this.minX) / (double)this.getWidth();
    }

    protected double yPixelToPosition(double d) {
        return this.minY + ((double)this.getHeight() - d) * (this.maxY - this.minY) / (double)this.getHeight();
    }

    protected void paintComponent(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.setupGraphics(graphics2D);
        this.paintBackground(graphics2D);
        this.drawGrid(graphics2D);
        this.drawAxis(graphics2D);
        this.drawPlots(graphics2D);
        this.drawLabels(graphics2D);
        this.paintExtra(graphics2D);
    }

    protected void paintExtra(Graphics2D graphics2D) {
    }

    private void drawPlots(Graphics2D graphics2D) {
        for (DrawablePlot drawablePlot : this.plots) {
            graphics2D.setColor(drawablePlot.getColor());
            this.drawPlot(graphics2D, drawablePlot.getEquation());
        }
    }

    private void drawPlot(Graphics2D graphics2D, Plot plot) {
        float f = 0.0f;
        float f2 = (float)this.yPositionToPixel(plot.compute(this.xPixelToPosition(0.0)));
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        float f3 = this.getWidth();
        for (f = 0.0f; f < f3; f += 1.0f) {
            double d = this.xPixelToPosition(f);
            f2 = (float)this.yPositionToPixel(plot.compute(d));
            generalPath.lineTo(f, f2);
        }
        graphics2D.draw(generalPath);
    }

    private void drawGrid(Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        if (this.isGridPainted()) {
            this.drawVerticalGrid(graphics2D);
            this.drawHorizontalGrid(graphics2D);
        }
        graphics2D.setStroke(stroke);
    }

    private void drawLabels(Graphics2D graphics2D) {
        if (this.isTextPainted()) {
            Object object;
            double d = this.yPositionToPixel(this.originY);
            double d2 = this.xPositionToPixel(this.originX);
            if (!this.isAxisPainted()) {
                object = graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke(1.2f));
                graphics2D.setColor(this.getAxisColor());
                graphics2D.drawLine((int)d2 - 3, (int)d, (int)d2 + 3, (int)d);
                graphics2D.drawLine((int)d2, (int)d - 3, (int)d2, (int)d + 3);
                graphics2D.setStroke((Stroke)object);
            }
            graphics2D.setColor(this.getForeground());
            object = graphics2D.getFontMetrics();
            graphics2D.drawString(this.format(this.originX) + "; " + this.format(this.originY), (int)d2 + 5, (int)d + ((FontMetrics)object).getHeight());
            this.drawHorizontalAxisLabels(graphics2D);
            this.drawVerticalAxisLabels(graphics2D);
        }
    }

    private void drawVerticalAxisLabels(Graphics2D graphics2D) {
        double d;
        double d2 = this.xPositionToPixel(this.originX);
        for (double d3 = d = Math.floor(this.minY / this.majorY) * this.majorY; d3 < this.maxY + this.majorY; d3 += this.majorY) {
            if (d3 - this.majorY / 2.0 < this.originY && d3 + this.majorY / 2.0 > this.originY) continue;
            int n = (int)this.yPositionToPixel(d3);
            graphics2D.drawString(this.format(d3), (int)d2 + 5, n);
        }
    }

    private void drawHorizontalGrid(Graphics2D graphics2D) {
        double d;
        int n;
        double d2 = this.majorY / (double)this.getMinorCountY();
        double d3 = this.xPositionToPixel(this.originX);
        BasicStroke basicStroke = new BasicStroke(1.0f);
        BasicStroke basicStroke2 = new BasicStroke(1.2f);
        Rectangle rectangle = graphics2D.getClipBounds();
        if (!this.isAxisPainted() && (n = (int)this.xPositionToPixel(this.originX)) >= rectangle.x && n <= rectangle.x + rectangle.width) {
            graphics2D.setColor(this.getMajorGridColor());
            graphics2D.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height);
        }
        for (double d4 = d = Math.floor(this.minY / this.majorY) * this.majorY; d4 < this.maxY + this.majorY; d4 += this.majorY) {
            graphics2D.setStroke(basicStroke);
            graphics2D.setColor(this.getMinorGridColor());
            for (int i = 0; i < this.getMinorCountY(); ++i) {
                n = (int)this.yPositionToPixel(d4 - (double)i * d2);
                if (n < rectangle.y || n > rectangle.y + rectangle.height) continue;
                graphics2D.drawLine(rectangle.x, n, rectangle.x + rectangle.width, n);
            }
            n = (int)this.yPositionToPixel(d4);
            if (n < rectangle.y || n > rectangle.y + rectangle.height) continue;
            graphics2D.setColor(this.getMajorGridColor());
            graphics2D.drawLine(rectangle.x, n, rectangle.x + rectangle.width, n);
            graphics2D.setStroke(basicStroke2);
            graphics2D.setColor(this.getAxisColor());
            graphics2D.drawLine((int)d3 - 3, n, (int)d3 + 3, n);
        }
    }

    private void drawHorizontalAxisLabels(Graphics2D graphics2D) {
        double d;
        double d2 = this.yPositionToPixel(this.originY);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        for (double d3 = d = Math.floor(this.minX / this.majorX) * this.majorX; d3 < this.maxX + this.majorX; d3 += this.majorX) {
            if (d3 - this.majorX / 2.0 < this.originX && d3 + this.majorX / 2.0 > this.originX) continue;
            int n = (int)this.xPositionToPixel(d3);
            graphics2D.drawString(this.format(d3), n, (int)d2 + fontMetrics.getHeight());
        }
    }

    private void drawVerticalGrid(Graphics2D graphics2D) {
        double d;
        int n;
        double d2 = this.majorX / (double)this.getMinorCountX();
        double d3 = this.yPositionToPixel(this.originY);
        BasicStroke basicStroke = new BasicStroke(1.0f);
        BasicStroke basicStroke2 = new BasicStroke(1.2f);
        Rectangle rectangle = graphics2D.getClipBounds();
        if (!this.isAxisPainted() && (n = (int)this.yPositionToPixel(this.originY)) >= rectangle.y && n <= rectangle.y + rectangle.height) {
            graphics2D.setColor(this.getMajorGridColor());
            graphics2D.drawLine(rectangle.x, n, rectangle.x + rectangle.width, n);
        }
        for (double d4 = d = Math.floor(this.minX / this.majorX) * this.majorX; d4 < this.maxX + this.majorX; d4 += this.majorX) {
            graphics2D.setStroke(basicStroke);
            graphics2D.setColor(this.getMinorGridColor());
            for (int i = 0; i < this.getMinorCountX(); ++i) {
                n = (int)this.xPositionToPixel(d4 - (double)i * d2);
                if (n < rectangle.x || n > rectangle.x + rectangle.width) continue;
                graphics2D.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height);
            }
            n = (int)this.xPositionToPixel(d4);
            if (n < rectangle.x || n > rectangle.x + rectangle.width) continue;
            graphics2D.setColor(this.getMajorGridColor());
            graphics2D.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height);
            graphics2D.setStroke(basicStroke2);
            graphics2D.setColor(this.getAxisColor());
            graphics2D.drawLine(n, (int)d3 - 3, n, (int)d3 + 3);
        }
    }

    private void drawAxis(Graphics2D graphics2D) {
        if (!this.isAxisPainted()) {
            return;
        }
        double d = this.yPositionToPixel(this.originY);
        double d2 = this.xPositionToPixel(this.originX);
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.setColor(this.getAxisColor());
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(1.2f));
        if (d >= (double)rectangle.y && d <= (double)(rectangle.y + rectangle.height)) {
            graphics2D.drawLine(rectangle.x, (int)d, rectangle.x + rectangle.width, (int)d);
        }
        if (d2 >= (double)rectangle.x && d2 <= (double)(rectangle.x + rectangle.width)) {
            graphics2D.drawLine((int)d2, rectangle.y, (int)d2, rectangle.y + rectangle.height);
        }
        graphics2D.setStroke(stroke);
    }

    protected void setupGraphics(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    protected void paintBackground(Graphics2D graphics2D) {
        if (this.isBackgroundPainted()) {
            Painter painter = this.getBackgroundPainter();
            if (painter != null) {
                painter.paint(graphics2D, this, this.getWidth(), this.getHeight());
            } else {
                graphics2D.setColor(this.getBackground());
                graphics2D.fill(graphics2D.getClipBounds());
            }
        }
    }

    private String format(double d) {
        boolean bl = d != 0.0 && Math.abs(d) < 0.01 || Math.abs(d) > 99.0;
        return (bl ? this.secondFormatter : this.mainFormatter).format(d);
    }

    private class PanMotionHandler
    extends MouseMotionAdapter {
        private PanMotionHandler() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            double d = JXGraph.this.xPixelToPosition(point.getX()) - JXGraph.this.xPixelToPosition(JXGraph.this.dragStart.getX());
            JXGraph.this.minX = JXGraph.this.minX - d;
            JXGraph.this.maxX = JXGraph.this.maxX - d;
            d = JXGraph.this.yPixelToPosition(point.getY()) - JXGraph.this.yPixelToPosition(JXGraph.this.dragStart.getY());
            JXGraph.this.minY = JXGraph.this.minY - d;
            JXGraph.this.maxY = JXGraph.this.maxY - d;
            JXGraph.this.repaint();
            JXGraph.this.dragStart = point;
        }
    }

    private class PanHandler
    extends MouseAdapter {
        private PanHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() != 1) {
                return;
            }
            JXGraph.this.dragStart = mouseEvent.getPoint();
            JXGraph.this.setCursor(Cursor.getPredefinedCursor(13));
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() != 1) {
                return;
            }
            JXGraph.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private class ResetHandler
    extends MouseAdapter {
        private ResetHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() != 2) {
                return;
            }
            JXGraph.this.resetView();
        }
    }

    private class ZoomHandler
    implements MouseWheelListener {
        private ZoomHandler() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            double d = JXGraph.this.maxX - JXGraph.this.minX;
            double d2 = JXGraph.this.maxY - JXGraph.this.minY;
            double d3 = JXGraph.this.minX + d / 2.0;
            double d4 = JXGraph.this.minY + d2 / 2.0;
            int n = mouseWheelEvent.getWheelRotation();
            if (n < 0) {
                d /= (double)1.1f;
                d2 /= (double)1.1f;
                JXGraph.this.majorX /= 1.1f;
                JXGraph.this.majorY /= 1.1f;
            } else {
                d *= (double)1.1f;
                d2 *= (double)1.1f;
                JXGraph.this.majorX *= 1.1f;
                JXGraph.this.majorY *= 1.1f;
            }
            JXGraph.this.minX = d3 - d / 2.0;
            JXGraph.this.maxX = d3 + d / 2.0;
            JXGraph.this.minY = d4 - d2 / 2.0;
            JXGraph.this.maxY = d4 + d2 / 2.0;
            JXGraph.this.repaint();
        }
    }

    private static class DrawablePlot {
        private final Plot equation;
        private final Color color;

        private DrawablePlot(Plot plot, Color color) {
            this.equation = plot;
            this.color = color;
        }

        private Plot getEquation() {
            return this.equation;
        }

        private Color getColor() {
            return this.color;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DrawablePlot drawablePlot = (DrawablePlot)object;
            if (!this.color.equals(drawablePlot.color)) {
                return false;
            }
            return this.equation.equals(drawablePlot.equation);
        }

        public int hashCode() {
            int n = this.equation.hashCode();
            n = 29 * n + this.color.hashCode();
            return n;
        }
    }

    public static abstract class Plot
    extends AbstractBean {
        protected Plot() {
        }

        public abstract double compute(double var1);
    }
}

