/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.Timer;
import org.jdesktop.swingx.JXRootPane;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.util.WindowUtils;

public class JXFrame
extends JFrame {
    private Component waitPane = null;
    private Component glassPane = null;
    private boolean waitPaneVisible = false;
    private Cursor realCursor = null;
    private boolean waitCursorVisible = false;
    private boolean waiting = false;
    private StartPosition startPosition;
    private boolean hasBeenVisible = false;
    private AWTEventListener keyEventListener;
    private boolean keyPreview = false;
    private AWTEventListener idleListener;
    private Timer idleTimer;
    private long idleThreshold = 0L;
    private boolean idle;

    public JXFrame() {
        this(null, false);
    }

    public JXFrame(String string) {
        this(string, false);
    }

    public JXFrame(String string, boolean bl) {
        super(string);
        if (bl) {
            this.setDefaultCloseOperation(3);
        }
        this.keyEventListener = new AWTEventListener(){

            public void eventDispatched(AWTEvent aWTEvent) {
                if (aWTEvent instanceof KeyEvent) {
                    KeyEvent keyEvent = (KeyEvent)aWTEvent;
                    block5: for (KeyListener keyListener : JXFrame.this.getKeyListeners()) {
                        int n = aWTEvent.getID();
                        switch (n) {
                            case 401: {
                                keyListener.keyPressed(keyEvent);
                                continue block5;
                            }
                            case 402: {
                                keyListener.keyReleased(keyEvent);
                                continue block5;
                            }
                            case 400: {
                                keyListener.keyTyped(keyEvent);
                                continue block5;
                            }
                            default: {
                                System.err.println("Unhandled Key ID: " + n);
                            }
                        }
                    }
                }
            }
        };
        this.idleTimer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JXFrame.this.setIdle(true);
            }
        });
        this.idleListener = new AWTEventListener(){

            public void eventDispatched(AWTEvent aWTEvent) {
                JXFrame.this.idleTimer.stop();
                if (JXFrame.this.isIdle()) {
                    JXFrame.this.setIdle(false);
                }
                JXFrame.this.idleTimer.restart();
            }
        };
    }

    public void setCancelButton(JButton jButton) {
        this.getRootPaneExt().setCancelButton(jButton);
    }

    public JButton getCancelButton() {
        return this.getRootPaneExt().getCancelButton();
    }

    public void setDefaultButton(JButton jButton) {
        JButton jButton2 = this.getDefaultButton();
        this.getRootPane().setDefaultButton(jButton);
        this.firePropertyChange("defaultButton", jButton2, this.getDefaultButton());
    }

    public JButton getDefaultButton() {
        return this.getRootPane().getDefaultButton();
    }

    public void setKeyPreview(boolean bl) {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.keyEventListener);
        if (bl) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.keyEventListener, 8L);
        }
        boolean bl2 = this.keyPreview;
        this.keyPreview = bl;
        this.firePropertyChange("keyPreview", bl2, this.keyPreview);
    }

    public final boolean getKeyPreview() {
        return this.keyPreview;
    }

    public void setStartPosition(StartPosition startPosition) {
        StartPosition startPosition2 = this.getStartPosition();
        this.startPosition = startPosition;
        this.firePropertyChange("startPosition", (Object)startPosition2, (Object)this.getStartPosition());
    }

    public StartPosition getStartPosition() {
        return this.startPosition == null ? StartPosition.Manual : this.startPosition;
    }

    public void setWaitCursorVisible(boolean bl) {
        boolean bl2 = this.isWaitCursorVisible();
        if (bl != bl2) {
            this.waitCursorVisible = bl;
            if (this.isWaitCursorVisible()) {
                this.realCursor = this.getCursor();
                super.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                super.setCursor(this.realCursor);
            }
            this.firePropertyChange("waitCursorVisible", bl2, this.isWaitCursorVisible());
        }
    }

    public boolean isWaitCursorVisible() {
        return this.waitCursorVisible;
    }

    public void setCursor(Cursor cursor) {
        if (!this.isWaitCursorVisible()) {
            super.setCursor(cursor);
        } else {
            this.realCursor = cursor;
        }
    }

    public void setWaitPane(Component component) {
        Component component2 = this.getWaitPane();
        this.waitPane = component;
        this.firePropertyChange("waitPane", component2, this.getWaitPane());
    }

    public Component getWaitPane() {
        return this.waitPane;
    }

    public void setWaitPaneVisible(boolean bl) {
        boolean bl2 = this.isWaitPaneVisible();
        if (bl != bl2) {
            this.waitPaneVisible = bl;
            Component component = this.getWaitPane();
            if (this.isWaitPaneVisible()) {
                this.glassPane = this.getRootPane().getGlassPane();
                if (component != null) {
                    this.getRootPane().setGlassPane(component);
                    component.setVisible(true);
                }
            } else {
                if (component != null) {
                    component.setVisible(false);
                }
                this.getRootPane().setGlassPane(this.glassPane);
            }
            this.firePropertyChange("waitPaneVisible", bl2, this.isWaitPaneVisible());
        }
    }

    public boolean isWaitPaneVisible() {
        return this.waitPaneVisible;
    }

    public void setWaiting(boolean bl) {
        boolean bl2 = this.isWaiting();
        this.waiting = bl;
        this.firePropertyChange("waiting", bl2, this.isWaiting());
        this.setWaitPaneVisible(bl);
        this.setWaitCursorVisible(bl);
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public void setVisible(boolean bl) {
        if (!this.hasBeenVisible && bl) {
            StartPosition startPosition = this.getStartPosition();
            switch (startPosition) {
                case CenterInParent: {
                    this.setLocationRelativeTo(this.getParent());
                    break;
                }
                case CenterInScreen: {
                    this.setLocation(WindowUtils.getPointForCentering(this));
                    break;
                }
            }
        }
        super.setVisible(bl);
    }

    public boolean isIdle() {
        return this.idle;
    }

    public void setIdle(boolean bl) {
        boolean bl2 = this.isIdle();
        this.idle = bl;
        this.firePropertyChange("idle", bl2, this.isIdle());
    }

    public void setIdleThreshold(long l) {
        long l2 = this.getIdleThreshold();
        this.idleThreshold = l;
        this.firePropertyChange("idleThreshold", l2, this.getIdleThreshold());
        l = this.getIdleThreshold();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.idleListener);
        if (l > 0L) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.idleListener, 131128L);
        }
        this.idleTimer.stop();
        this.idleTimer.setInitialDelay((int)l);
        this.idleTimer.restart();
    }

    public long getIdleThreshold() {
        return this.idleThreshold;
    }

    public void setStatusBar(JXStatusBar jXStatusBar) {
        this.getRootPaneExt().setStatusBar(jXStatusBar);
    }

    public JXStatusBar getStatusBar() {
        return this.getRootPaneExt().getStatusBar();
    }

    public void setToolBar(JToolBar jToolBar) {
        this.getRootPaneExt().setToolBar(jToolBar);
    }

    public JToolBar getToolBar() {
        return this.getRootPaneExt().getToolBar();
    }

    protected JRootPane createRootPane() {
        return new JXRootPane();
    }

    public void setRootPane(JRootPane jRootPane) {
        super.setRootPane(jRootPane);
    }

    public JXRootPane getRootPaneExt() {
        if (this.rootPane instanceof JXRootPane) {
            return (JXRootPane)this.rootPane;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StartPosition {
        CenterInScreen,
        CenterInParent,
        Manual;

    }
}

