/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.action.ActionManager;
import org.jdesktop.swingx.action.Targetable;
import org.jdesktop.swingx.action.TargetableSupport;
import org.jdesktop.swingx.search.SearchFactory;
import org.jdesktop.swingx.search.Searchable;

public class JXEditorPane
extends JEditorPane
implements Targetable {
    private static final Logger LOG = Logger.getLogger(JXEditorPane.class.getName());
    private UndoableEditListener undoHandler;
    private UndoManager undoManager;
    private CaretListener caretHandler;
    private JComboBox selector;
    private TargetableSupport targetSupport = new TargetableSupport(this);
    private Searchable searchable;

    public JXEditorPane() {
        this.init();
    }

    public JXEditorPane(String string) throws IOException {
        super(string);
        this.init();
    }

    public JXEditorPane(String string, String string2) {
        super(string, string2);
        this.init();
    }

    public JXEditorPane(URL uRL) throws IOException {
        super(uRL);
        this.init();
    }

    private void init() {
        this.setEditorKitForContentType("text/html", new SloppyHTMLEditorKit());
        this.addPropertyChangeListener(new PropertyHandler());
        this.getDocument().addUndoableEditListener(this.getUndoableEditListener());
        this.initActions();
    }

    UndoableEditListener getUndoableEditListener() {
        if (this.undoHandler == null) {
            this.undoHandler = new UndoHandler();
            this.undoManager = new UndoManager();
        }
        return this.undoHandler;
    }

    public void setEditorKit(EditorKit editorKit) {
        super.setEditorKit(editorKit);
        if (editorKit instanceof StyledEditorKit) {
            if (this.caretHandler == null) {
                this.caretHandler = new CaretHandler();
            }
            this.addCaretListener(this.caretHandler);
        }
    }

    protected void initActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("find", new Actions("find"));
        actionMap.put("undo", new Actions("undo"));
        actionMap.put("redo", new Actions("redo"));
        actionMap.put("cut", new Actions("cut"));
        actionMap.put("copy", new Actions("copy"));
        actionMap.put("paste", new Actions("paste"));
        KeyStroke keyStroke = SearchFactory.getInstance().getSearchAccelerator();
        this.getInputMap(1).put(keyStroke, "find");
    }

    private void updateActionState() {
        Runnable runnable = new Runnable(){

            public void run() {
                ActionManager actionManager = ActionManager.getInstance();
                actionManager.setEnabled("undo", JXEditorPane.this.undoManager.canUndo());
                actionManager.setEnabled("redo", JXEditorPane.this.undoManager.canRedo());
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public JComboBox getParagraphSelector() {
        if (this.selector == null) {
            this.selector = new ParagraphSelector();
        }
        return this.selector;
    }

    protected void applyTag(HTML.Tag tag) {
        Document document = this.getDocument();
        if (!(document instanceof HTMLDocument)) {
            return;
        }
        HTMLDocument hTMLDocument = (HTMLDocument)document;
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        Element element = hTMLDocument.getParagraphElement(n);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(element.getAttributes());
        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, tag);
        hTMLDocument.setParagraphAttributes(n, n2 - n, simpleAttributeSet, true);
    }

    public void paste() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            try {
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    if (!String.class.equals(dataFlavorArray[i].getRepresentationClass())) continue;
                    Object object = transferable.getTransferData(dataFlavorArray[i]);
                    if (!dataFlavorArray[i].isMimeTypeEqual("text/plain")) continue;
                    this.replaceSelection(object.toString());
                    break;
                }
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "What can produce a problem with data flavor?", exception);
            }
        }
    }

    private void find() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new DocumentSearchable();
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    public boolean hasCommand(Object object) {
        return this.targetSupport.hasCommand(object);
    }

    public Object[] getCommands() {
        return this.targetSupport.getCommands();
    }

    public boolean doCommand(Object object, Object object2) {
        return this.targetSupport.doCommand(object, object2);
    }

    private static final class SloppyHTMLEditorKit
    extends HTMLEditorKit {
        private SloppyHTMLEditorKit() {
        }

        public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[1024];
            while ((n2 = reader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n2);
            }
            StringReader stringReader = new StringReader(stringBuffer.toString().replaceAll("/>", ">"));
            super.read(stringReader, document, n);
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            StyledDocument styledDocument = (StyledDocument)JXEditorPane.this.getDocument();
            int n = caretEvent.getDot();
            n = n > 0 ? n - 1 : n;
            Element element = styledDocument.getCharacterElement(n);
            AttributeSet attributeSet = element.getAttributes();
            ActionManager actionManager = ActionManager.getInstance();
            actionManager.setSelected("font-bold", StyleConstants.isBold(attributeSet));
            actionManager.setSelected("font-italic", StyleConstants.isItalic(attributeSet));
            actionManager.setSelected("font-underline", StyleConstants.isUnderline(attributeSet));
            element = styledDocument.getParagraphElement(n);
            attributeSet = element.getAttributes();
            if (JXEditorPane.this.selector != null) {
                JXEditorPane.this.selector.setSelectedItem(attributeSet.getAttribute(StyleConstants.NameAttribute));
            }
            switch (StyleConstants.getAlignment(attributeSet)) {
                case 0: {
                    actionManager.setSelected("left-justify", true);
                    break;
                }
                case 1: {
                    actionManager.setSelected("center-justify", true);
                    break;
                }
                case 2: {
                    actionManager.setSelected("right-justify", true);
                }
            }
        }
    }

    public class DocumentSearchable
    implements Searchable {
        int lastFoundIndex = -1;
        MatchResult lastMatchResult;
        String lastRegEx;

        public int search(String string) {
            return this.search(string, -1);
        }

        public int search(String string, int n) {
            return this.search(string, n, false);
        }

        public int search(String string, int n, boolean bl) {
            Pattern pattern = null;
            if (!this.isEmpty(string)) {
                pattern = Pattern.compile(string, 0);
            }
            return this.search(pattern, n, bl);
        }

        protected boolean isEmpty(String string) {
            return string == null || string.length() == 0;
        }

        public int search(Pattern pattern) {
            return this.search(pattern, -1);
        }

        public int search(Pattern pattern, int n) {
            return this.search(pattern, n, false);
        }

        public int search(Pattern pattern, int n, boolean bl) {
            int n2;
            if (pattern == null || JXEditorPane.this.getDocument().getLength() == 0 || n > -1 && JXEditorPane.this.getDocument().getLength() < n) {
                this.updateStateAfterNotFound();
                return -1;
            }
            int n3 = n;
            if (this.maybeExtendedMatch(n)) {
                if (this.foundExtendedMatch(pattern, n3)) {
                    return this.lastFoundIndex;
                }
                ++n3;
            }
            if (bl) {
                n3 = 0;
                n2 = n < 0 ? JXEditorPane.this.getDocument().getLength() - 1 : -1 + n;
            } else {
                if (n3 < 0) {
                    n3 = 0;
                }
                n2 = JXEditorPane.this.getDocument().getLength() - n3;
            }
            Segment segment = new Segment();
            try {
                JXEditorPane.this.getDocument().getText(n3, n2, segment);
            }
            catch (BadLocationException badLocationException) {
                LOG.log(Level.FINE, "this should not happen (calculated the valid start/length) ", badLocationException);
            }
            Matcher matcher = pattern.matcher(segment.toString());
            MatchResult matchResult = this.getMatchResult(matcher, !bl);
            if (matchResult != null) {
                this.updateStateAfterFound(matchResult, n3);
            } else {
                this.updateStateAfterNotFound();
            }
            return this.lastFoundIndex;
        }

        private boolean foundExtendedMatch(Pattern pattern, int n) {
            if (pattern.pattern().equals(this.lastRegEx)) {
                return false;
            }
            int n2 = JXEditorPane.this.getDocument().getLength() - n;
            Segment segment = new Segment();
            try {
                JXEditorPane.this.getDocument().getText(n, n2, segment);
            }
            catch (BadLocationException badLocationException) {
                LOG.log(Level.FINE, "this should not happen (calculated the valid start/length) ", badLocationException);
            }
            Matcher matcher = pattern.matcher(segment.toString());
            MatchResult matchResult = this.getMatchResult(matcher, true);
            if (matchResult != null && matchResult.start() == 0 && !this.lastMatchResult.group().equals(matchResult.group())) {
                this.updateStateAfterFound(matchResult, n);
                return true;
            }
            return false;
        }

        private boolean maybeExtendedMatch(int n) {
            return n >= 0 && n == this.lastFoundIndex;
        }

        private int updateStateAfterFound(MatchResult matchResult, int n) {
            int n2 = matchResult.end() + n;
            int n3 = matchResult.start() + n;
            JXEditorPane.this.select(n3, n2);
            JXEditorPane.this.getCaret().setSelectionVisible(true);
            this.lastFoundIndex = n3;
            this.lastMatchResult = matchResult;
            this.lastRegEx = ((Matcher)this.lastMatchResult).pattern().pattern();
            return n3;
        }

        private MatchResult getMatchResult(Matcher matcher, boolean bl) {
            MatchResult matchResult = null;
            while (matcher.find()) {
                matchResult = matcher.toMatchResult();
                if (!bl) continue;
                break;
            }
            return matchResult;
        }

        private void updateStateAfterNotFound() {
            this.lastFoundIndex = -1;
            this.lastMatchResult = null;
            this.lastRegEx = null;
            JXEditorPane.this.setCaretPosition(JXEditorPane.this.getSelectionEnd());
        }
    }

    private class ParagraphSelector
    extends JComboBox
    implements ItemListener {
        private Map<HTML.Tag, String> itemMap = new HashMap<HTML.Tag, String>();

        public ParagraphSelector() {
            this.itemMap.put(HTML.Tag.P, "Paragraph");
            this.itemMap.put(HTML.Tag.H1, "Heading 1");
            this.itemMap.put(HTML.Tag.H2, "Heading 2");
            this.itemMap.put(HTML.Tag.H3, "Heading 3");
            this.itemMap.put(HTML.Tag.H4, "Heading 4");
            this.itemMap.put(HTML.Tag.H5, "Heading 5");
            this.itemMap.put(HTML.Tag.H6, "Heading 6");
            this.itemMap.put(HTML.Tag.PRE, "Preformatted");
            Vector<HTML.Tag> vector = new Vector<HTML.Tag>();
            vector.addElement(HTML.Tag.P);
            vector.addElement(HTML.Tag.H1);
            vector.addElement(HTML.Tag.H2);
            vector.addElement(HTML.Tag.H3);
            vector.addElement(HTML.Tag.H4);
            vector.addElement(HTML.Tag.H5);
            vector.addElement(HTML.Tag.H6);
            vector.addElement(HTML.Tag.PRE);
            this.setModel(new DefaultComboBoxModel(vector));
            this.setRenderer(new ParagraphRenderer());
            this.addItemListener(this);
            this.setFocusable(false);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                JXEditorPane.this.applyTag((HTML.Tag)itemEvent.getItem());
            }
        }

        private class ParagraphRenderer
        extends DefaultListCellRenderer {
            public ParagraphRenderer() {
                this.setOpaque(true);
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                this.setText((String)ParagraphSelector.this.itemMap.get(object));
                return this;
            }
        }
    }

    private class Actions
    extends UIAction {
        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getName();
            if ("find".equals(string)) {
                JXEditorPane.this.find();
            } else if ("undo".equals(string)) {
                try {
                    JXEditorPane.this.undoManager.undo();
                }
                catch (CannotUndoException cannotUndoException) {
                    LOG.info("Could not undo");
                }
                JXEditorPane.this.updateActionState();
            } else if ("redo".equals(string)) {
                try {
                    JXEditorPane.this.undoManager.redo();
                }
                catch (CannotRedoException cannotRedoException) {
                    LOG.info("Could not redo");
                }
                JXEditorPane.this.updateActionState();
            } else if ("cut".equals(string)) {
                ActionMap actionMap = JXEditorPane.this.getActionMap();
                actionMap.remove("cut");
                JXEditorPane.this.cut();
                actionMap.put("cut", this);
            } else if ("copy".equals(string)) {
                ActionMap actionMap = JXEditorPane.this.getActionMap();
                actionMap.remove("copy");
                JXEditorPane.this.copy();
                actionMap.put("copy", this);
            } else if ("paste".equals(string)) {
                ActionMap actionMap = JXEditorPane.this.getActionMap();
                actionMap.remove("paste");
                JXEditorPane.this.paste();
                actionMap.put("paste", this);
            } else {
                LOG.fine("ActionHandled: " + string);
            }
        }

        public boolean isEnabled(Object object) {
            boolean bl;
            String string = this.getName();
            if ("undo".equals(string)) {
                return JXEditorPane.this.isEditable() && JXEditorPane.this.undoManager.canUndo();
            }
            if ("redo".equals(string)) {
                return JXEditorPane.this.isEditable() && JXEditorPane.this.undoManager.canRedo();
            }
            if ("paste".equals(string)) {
                if (!JXEditorPane.this.isEditable()) {
                    return false;
                }
                boolean bl2 = false;
                try {
                    bl2 = JXEditorPane.this.getToolkit().getSystemClipboard().getContents(null) != null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return bl2;
            }
            boolean bl3 = bl = JXEditorPane.this.getSelectionEnd() - JXEditorPane.this.getSelectionStart() > 0;
            if ("cut".equals(string)) {
                return JXEditorPane.this.isEditable() && bl;
            }
            if ("copy".equals(string)) {
                return bl;
            }
            if ("find".equals(string)) {
                return JXEditorPane.this.getDocument().getLength() > 0;
            }
            return true;
        }
    }

    private class UndoHandler
    implements UndoableEditListener {
        private UndoHandler() {
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            JXEditorPane.this.undoManager.addEdit(undoableEditEvent.getEdit());
            JXEditorPane.this.updateActionState();
        }
    }

    private class PropertyHandler
    implements PropertyChangeListener {
        private PropertyHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("document")) {
                Document document = (Document)propertyChangeEvent.getOldValue();
                if (document != null) {
                    document.removeUndoableEditListener(JXEditorPane.this.getUndoableEditListener());
                }
                if ((document = (Document)propertyChangeEvent.getNewValue()) != null) {
                    document.addUndoableEditListener(JXEditorPane.this.getUndoableEditListener());
                }
            }
        }
    }
}

