/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.calendar.DatePickerFormatter;
import org.jdesktop.swingx.event.EventListenerMap;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.plaf.DatePickerAddon;
import org.jdesktop.swingx.plaf.DatePickerUI;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXDatePicker
extends JComponent {
    private static final Logger LOG = Logger.getLogger(JXDatePicker.class.getName());
    public static final String uiClassID = "DatePickerUI";
    public static final String EDITOR = "editor";
    public static final String MONTH_VIEW = "monthView";
    public static final String LINK_PANEL = "linkPanel";
    public static final String COMMIT_KEY = "datePickerCommit";
    public static final String CANCEL_KEY = "datePickerCancel";
    public static final String HOME_NAVIGATE_KEY = "navigateHome";
    public static final String HOME_COMMIT_KEY = "commitHome";
    private static final DateFormat[] EMPTY_DATE_FORMATS;
    private JFormattedTextField _dateField;
    private JPanel _linkPanel;
    private MessageFormat _linkFormat;
    private Date linkDate;
    private JXMonthView _monthView;
    private boolean editable = true;
    private EventListenerMap listenerMap;
    protected boolean lightWeightPopupEnabled = JPopupMenu.getDefaultLightWeightPopupEnabled();
    private Date date;
    private PropertyChangeListener monthViewListener;

    public JXDatePicker() {
        this(null, null);
    }

    public JXDatePicker(Date date) {
        this(date, null);
    }

    public JXDatePicker(Locale locale) {
        this(null, locale);
    }

    public JXDatePicker(Date date, Locale locale) {
        this.init();
        if (locale != null) {
            this.setLocale(locale);
        }
        this.updateUI();
        this.setDate(date);
    }

    public void setDate(Date date) {
        try {
            date = this.getUI().getSelectableDate(date);
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
        Date date2 = this.getDate();
        this.date = date;
        this.firePropertyChange("date", date2, this.getDate());
    }

    public Date getDate() {
        return this.date;
    }

    private void init() {
        this.listenerMap = new EventListenerMap();
        this.initMonthView();
        this.updateLinkFormat();
        this.linkDate = this._monthView.getToday();
        this._linkPanel = new TodayPanel();
    }

    private void initMonthView() {
        this._monthView = new JXMonthView();
        this._monthView.setTraversable(true);
        this._monthView.addPropertyChangeListener(this.getMonthViewListener());
    }

    private PropertyChangeListener getMonthViewListener() {
        if (this.monthViewListener == null) {
            this.monthViewListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("timeZone".equals(propertyChangeEvent.getPropertyName())) {
                        JXDatePicker.this.updateTimeZone((TimeZone)propertyChangeEvent.getOldValue(), (TimeZone)propertyChangeEvent.getNewValue());
                    }
                }
            };
        }
        return this.monthViewListener;
    }

    protected void updateTimeZone(TimeZone timeZone, TimeZone timeZone2) {
        this.firePropertyChange("timeZone", timeZone, timeZone2);
    }

    @Override
    public DatePickerUI getUI() {
        return (DatePickerUI)this.ui;
    }

    public void setUI(DatePickerUI datePickerUI) {
        super.setUI(datePickerUI);
    }

    @Override
    public void updateUI() {
        this.setUI((DatePickerUI)LookAndFeelAddons.getUI(this, DatePickerUI.class));
        SwingUtilities.updateComponentTreeUI(this.getMonthView());
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setFormats(String ... stringArray) {
        DateFormat[] dateFormatArray = null;
        if (stringArray != null) {
            Contract.asNotNull(stringArray, "the array of format strings must not must not contain null elements");
            dateFormatArray = new DateFormat[stringArray.length];
            for (int i = stringArray.length - 1; i >= 0; --i) {
                dateFormatArray[i] = new SimpleDateFormat(stringArray[i], this.getLocale());
            }
        }
        this.setFormats(dateFormatArray);
    }

    public void setFormats(DateFormat ... dateFormatArray) {
        if (dateFormatArray != null) {
            Contract.asNotNull(dateFormatArray, "the array of formats must not contain null elements");
        }
        DateFormat[] dateFormatArray2 = this.getFormats();
        this._dateField.setFormatterFactory(new DefaultFormatterFactory(new DatePickerFormatter(dateFormatArray, this.getLocale())));
        this.firePropertyChange("formats", dateFormatArray2, this.getFormats());
    }

    public DateFormat[] getFormats() {
        JFormattedTextField.AbstractFormatter abstractFormatter;
        JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory = this._dateField.getFormatterFactory();
        if (abstractFormatterFactory != null && (abstractFormatter = abstractFormatterFactory.getFormatter(this._dateField)) instanceof DatePickerFormatter) {
            return ((DatePickerFormatter)abstractFormatter).getFormats();
        }
        return EMPTY_DATE_FORMATS;
    }

    public JXMonthView getMonthView() {
        return this._monthView;
    }

    public void setMonthView(JXMonthView jXMonthView) {
        Contract.asNotNull(jXMonthView, "monthView must not be null");
        JXMonthView jXMonthView2 = this.getMonthView();
        TimeZone timeZone = this.getTimeZone();
        jXMonthView2.removePropertyChangeListener(this.getMonthViewListener());
        this._monthView = jXMonthView;
        this.getMonthView().addPropertyChangeListener(this.getMonthViewListener());
        this.firePropertyChange(MONTH_VIEW, jXMonthView2, this.getMonthView());
        this.firePropertyChange("timeZone", timeZone, this.getTimeZone());
    }

    public TimeZone getTimeZone() {
        return this._monthView.getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        this._monthView.setTimeZone(timeZone);
    }

    public Date getLinkDay() {
        return this.linkDate;
    }

    public void setLinkDay(Date date, String string) {
        this.setLinkFormat(new MessageFormat(string));
        this.setLinkDay(date);
    }

    public void setLinkDay(Date date) {
        Format[] formatArray;
        this.linkDate = date;
        for (Format format : formatArray = this.getLinkFormat().getFormatsByArgumentIndex()) {
            if (!(format instanceof DateFormat)) continue;
            ((DateFormat)format).setTimeZone(this.getTimeZone());
        }
        this.setLinkPanel(new TodayPanel());
    }

    protected void setLinkFormat(MessageFormat messageFormat) {
        this._linkFormat = messageFormat;
    }

    protected MessageFormat getLinkFormat() {
        return this._linkFormat;
    }

    private void updateLinkFormat() {
        String string = UIManagerExt.getString("JXDatePicker.linkFormat", this.getLocale());
        if (string != null) {
            this.setLinkFormat(new MessageFormat(string));
        } else {
            this.setLinkFormat(new MessageFormat("{0,date, dd MMMM yyyy}"));
        }
    }

    public JPanel getLinkPanel() {
        return this._linkPanel;
    }

    public void setLinkPanel(JPanel jPanel) {
        JPanel jPanel2 = this._linkPanel;
        this._linkPanel = jPanel;
        this.firePropertyChange(LINK_PANEL, jPanel2, this._linkPanel);
    }

    public JFormattedTextField getEditor() {
        return this._dateField;
    }

    public void setEditor(JFormattedTextField jFormattedTextField) {
        Contract.asNotNull(jFormattedTextField, "editor must not be null");
        JFormattedTextField jFormattedTextField2 = this._dateField;
        this._dateField = jFormattedTextField;
        this.firePropertyChange(EDITOR, jFormattedTextField2, this._dateField);
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        this._monthView.setComponentOrientation(componentOrientation);
    }

    public boolean isEditValid() {
        return this._dateField.isEditValid();
    }

    public void commitEdit() throws ParseException {
        this._dateField.commitEdit();
        this.fireActionPerformed(COMMIT_KEY);
    }

    public void cancelEdit() {
        this._dateField.setValue(this._dateField.getValue());
        this.fireActionPerformed(CANCEL_KEY);
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.isEditable();
        this.editable = bl;
        this.firePropertyChange("editable", bl2, this.editable);
        if (this.editable != bl2) {
            this.repaint();
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public Font getFont() {
        return this.getEditor().getFont();
    }

    @Override
    public void setFont(Font font) {
        this.getEditor().setFont(font);
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        boolean bl2 = this.lightWeightPopupEnabled;
        this.lightWeightPopupEnabled = bl;
        this.firePropertyChange("lightWeightPopupEnabled", bl2, this.lightWeightPopupEnabled);
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    @Override
    public int getBaseline(int n, int n2) {
        return ((DatePickerUI)this.ui).getBaseline(n, n2);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerMap.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerMap.remove(ActionListener.class, actionListener);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        EventListener[] eventListenerArray;
        List<EventListener> list = this.listenerMap.getListeners(clazz);
        if (!list.isEmpty()) {
            eventListenerArray = (EventListener[])Array.newInstance(clazz, list.size());
            eventListenerArray = list.toArray(eventListenerArray);
        } else {
            eventListenerArray = super.getListeners(clazz);
        }
        return eventListenerArray;
    }

    protected void fireActionPerformed(String string) {
        ActionListener[] actionListenerArray = (ActionListener[])this.getListeners(ActionListener.class);
        ActionEvent actionEvent = null;
        for (ActionListener actionListener : actionListenerArray) {
            if (actionEvent == null) {
                actionEvent = new ActionEvent(this, 1001, string);
            }
            actionListener.actionPerformed(actionEvent);
        }
    }

    static {
        LookAndFeelAddons.contribute(new DatePickerAddon());
        EMPTY_DATE_FORMATS = new DateFormat[0];
    }

    private final class TodayPanel
    extends JXPanel {
        private TodayAction todayAction;
        private JXHyperlink todayLink;

        TodayPanel() {
            super(new FlowLayout());
            this.setBackgroundPainter(new MattePainter(new GradientPaint(0.0f, 0.0f, new Color(238, 238, 238), 0.0f, 1.0f, Color.WHITE)));
            this.todayAction = new TodayAction();
            this.todayLink = new JXHyperlink(this.todayAction);
            this.todayLink.addMouseListener(this.createDoubleClickListener());
            Color color = new Color(16, 66, 104);
            this.todayLink.setUnclickedColor(color);
            this.todayLink.setClickedColor(color);
            this.add(this.todayLink);
        }

        private MouseListener createDoubleClickListener() {
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() != 2) {
                        return;
                    }
                    ((TodayPanel)TodayPanel.this).todayAction.select = true;
                }
            };
            return mouseAdapter;
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(new Color(187, 187, 187));
            graphics.drawLine(0, 0, this.getWidth(), 0);
            graphics.setColor(new Color(221, 221, 221));
            graphics.drawLine(0, 1, this.getWidth(), 1);
        }

        public void setLocale(Locale locale) {
            super.setLocale(locale);
            JXDatePicker.this.updateLinkFormat();
            this.todayLink.setText(JXDatePicker.this.getLinkFormat().format(new Object[]{JXDatePicker.this.getLinkDay()}));
        }

        private final class TodayAction
        extends AbstractAction {
            boolean select;

            TodayAction() {
                super(JXDatePicker.this.getLinkFormat().format(new Object[]{JXDatePicker.this.getLinkDay()}));
                Calendar calendar = JXDatePicker.this._monthView.getCalendar();
                calendar.setTime(JXDatePicker.this.getLinkDay());
                this.putValue("Name", JXDatePicker.this.getLinkFormat().format(new Object[]{calendar.getTime()}));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = this.select ? JXDatePicker.HOME_COMMIT_KEY : JXDatePicker.HOME_NAVIGATE_KEY;
                this.select = false;
                Action action = TodayPanel.this.getActionMap().get(string);
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(null);
                }
            }
        }
    }
}

