/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.plaf.LabelUI;
import org.jdesktop.swingx.painter.BusyPainter;
import org.jdesktop.swingx.painter.PainterIcon;
import org.jdesktop.swingx.plaf.BusyLabelAddon;
import org.jdesktop.swingx.plaf.BusyLabelUI;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class JXBusyLabel
extends JLabel {
    private BusyPainter busyPainter;
    private Timer busy;
    private int delay;
    private boolean wasBusyOnNotify = false;
    public static final String uiClassID = "BusyLabelUI";
    private Direction direction;

    public void setDirection(Direction direction) {
        this.direction = direction;
        this.getBusyPainter().setDirection(direction);
    }

    public JXBusyLabel() {
        this((Dimension)null);
    }

    public JXBusyLabel(Dimension dimension) {
        BusyLabelUI busyLabelUI = (BusyLabelUI)((Object)this.getUI());
        if (busyLabelUI != null) {
            this.delay = busyLabelUI.getDelay();
        }
        this.setPreferredSize(dimension);
        this.getBusyPainter();
    }

    protected void initPainter(Dimension dimension) {
        BusyPainter busyPainter = this.getBusyPainter();
        if (null != busyPainter) {
            busyPainter.setCacheable(false);
        }
        PainterIcon painterIcon = new PainterIcon(dimension);
        painterIcon.setPainter(busyPainter);
        this.setIcon(painterIcon);
    }

    protected BusyPainter createBusyPainter(Dimension dimension) {
        BusyPainter busyPainter = null;
        BusyLabelUI busyLabelUI = (BusyLabelUI)((Object)this.getUI());
        if (busyLabelUI != null) {
            busyPainter = busyLabelUI.getBusyPainter(dimension);
        }
        return busyPainter;
    }

    public boolean isBusy() {
        return this.busy != null;
    }

    public void setBusy(boolean bl) {
        boolean bl2 = this.isBusy();
        if (!bl2 && bl) {
            this.startAnimation();
            this.firePropertyChange("busy", bl2, this.isBusy());
        } else if (bl2 && !bl) {
            this.stopAnimation();
            this.firePropertyChange("busy", bl2, this.isBusy());
        }
    }

    private void startAnimation() {
        if (this.busy != null) {
            this.stopAnimation();
        }
        this.busy = new Timer(this.delay, new ActionListener(){
            BusyPainter busyPainter;
            int frame;
            {
                this.busyPainter = JXBusyLabel.this.getBusyPainter();
                this.frame = this.busyPainter.getPoints();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.frame = (this.frame + 1) % this.busyPainter.getPoints();
                this.busyPainter.setFrame(JXBusyLabel.this.direction == Direction.LEFT ? this.busyPainter.getPoints() - this.frame : this.frame);
                JXBusyLabel.this.frameChanged();
            }
        });
        this.busy.start();
    }

    private void stopAnimation() {
        if (this.busy != null) {
            this.busy.stop();
            this.getBusyPainter().setFrame(-1);
            this.repaint();
            this.busy = null;
        }
    }

    public void removeNotify() {
        this.wasBusyOnNotify = this.isBusy();
        this.stopAnimation();
        super.removeNotify();
    }

    public void addNotify() {
        super.addNotify();
        if (this.wasBusyOnNotify) {
            this.startAnimation();
        }
    }

    protected void frameChanged() {
        this.repaint();
    }

    public final BusyPainter getBusyPainter() {
        if (null == this.busyPainter) {
            Dimension dimension = this.getPreferredSize();
            this.busyPainter = this.createBusyPainter((Dimension)(dimension.width == 0 && dimension.height == 0 && !this.isPreferredSizeSet() ? null : dimension));
            if (null != this.busyPainter) {
                if (!(this.isPreferredSizeSet() || null != dimension && dimension.width != 0 && dimension.height != 0)) {
                    Rectangle rectangle = this.busyPainter.getTrajectory().getBounds();
                    Rectangle rectangle2 = this.busyPainter.getPointShape().getBounds();
                    int n = Math.max(rectangle2.width, rectangle2.height);
                    dimension = new Dimension(rectangle.width + n, rectangle.height + n);
                }
                this.initPainter(dimension);
            }
        }
        return this.busyPainter;
    }

    public final void setBusyPainter(BusyPainter busyPainter) {
        this.busyPainter = busyPainter;
        this.initPainter(new Dimension(this.getIcon().getIconWidth(), this.getIcon().getIconHeight()));
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        int n2 = this.getDelay();
        this.delay = n;
        if (n2 != this.getDelay()) {
            if (this.busy != null && this.busy.isRunning()) {
                this.busy.setDelay(this.getDelay());
            }
            this.firePropertyChange("delay", n2, this.getDelay());
        }
    }

    public void updateUI() {
        this.setUI((LabelUI)LookAndFeelAddons.getUI(this, BusyLabelUI.class));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    static {
        LookAndFeelAddons.contribute(new BusyLabelAddon());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        RIGHT,
        LEFT;

    }
}

