/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class ButtonStackBuilder
extends PanelBuilder {
    private static final ColumnSpec[] COL_SPECS = new ColumnSpec[]{FormFactory.BUTTON_COLSPEC};
    private static final RowSpec[] ROW_SPECS = new RowSpec[0];
    private static final String NARROW_KEY = "jgoodies.isNarrow";

    public ButtonStackBuilder() {
        this(new JPanel(null));
    }

    public ButtonStackBuilder(JPanel jPanel) {
        this(new FormLayout(COL_SPECS, ROW_SPECS), jPanel);
    }

    public ButtonStackBuilder(FormLayout formLayout, JPanel jPanel) {
        super(formLayout, jPanel);
    }

    public void addButtons(JButton[] jButtonArray) {
        for (int i = 0; i < jButtonArray.length; ++i) {
            this.addGridded(jButtonArray[i]);
            if (i >= jButtonArray.length - 1) continue;
            this.addRelatedGap();
        }
    }

    public void addFixed(JComponent jComponent) {
        this.getLayout().appendRow(FormFactory.PREF_ROWSPEC);
        this.add(jComponent);
        this.nextRow();
    }

    public void addGridded(JComponent jComponent) {
        this.getLayout().appendRow(FormFactory.PREF_ROWSPEC);
        this.getLayout().addGroupedRow(this.getRow());
        jComponent.putClientProperty(NARROW_KEY, Boolean.TRUE);
        this.add(jComponent);
        this.nextRow();
    }

    public void addGlue() {
        this.appendGlueRow();
        this.nextRow();
    }

    public void addRelatedGap() {
        this.appendRelatedComponentsGapRow();
        this.nextRow();
    }

    public void addUnrelatedGap() {
        this.appendUnrelatedComponentsGapRow();
        this.nextRow();
    }

    public void addStrut(ConstantSize constantSize) {
        this.getLayout().appendRow(new RowSpec(RowSpec.TOP, constantSize, 0.0));
        this.nextRow();
    }
}

