/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.DecorationHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.acryl.AcrylLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import javax.swing.JRootPane;
import javax.swing.plaf.ColorUIResource;

public class AcrylTitlePane
extends BaseTitlePane {
    public AcrylTitlePane(JRootPane jRootPane, BaseRootPaneUI baseRootPaneUI) {
        super(jRootPane, baseRootPaneUI);
    }

    public LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    protected int getHorSpacing() {
        return 1;
    }

    protected int getVerSpacing() {
        return 3;
    }

    public void paintBorder(Graphics graphics) {
        if (this.isActive()) {
            graphics.setColor(AcrylLookAndFeel.getWindowBorderColor());
        } else {
            graphics.setColor(AcrylLookAndFeel.getWindowInactiveBorderColor());
        }
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        if (this.getFrame() != null) {
            this.setState(DecorationHelper.getExtendedState(this.getFrame()));
        }
        this.paintBackground(graphics);
        boolean bl = this.isLeftToRight();
        boolean bl2 = this.window == null ? true : JTattooUtilities.isWindowActive(this.window);
        ColorUIResource colorUIResource = AbstractLookAndFeel.getWindowInactiveTitleForegroundColor();
        if (bl2) {
            colorUIResource = AbstractLookAndFeel.getWindowTitleForegroundColor();
        }
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = n2 - this.buttonsWidth - 4;
        int n5 = n = bl ? 4 : n2 - 4;
        if (this.getWindowDecorationStyle() == 1) {
            n += bl ? n3 : -n3;
            n4 -= n3;
        }
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = JTattooUtilities.getClippedText(this.getTitle(), fontMetrics, n4);
        if (string != null) {
            int n6 = fontMetrics.stringWidth(string);
            int n7 = (n3 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() - 1;
            if (!bl) {
                n -= n6;
            }
            if (bl2) {
                graphics.setColor(ColorHelper.darker(AcrylLookAndFeel.getWindowTitleColorDark(), 30.0));
                JTattooUtilities.drawString(this.rootPane, graphics, string, n - 1, n7 - 1);
                JTattooUtilities.drawString(this.rootPane, graphics, string, n - 1, n7 + 1);
                JTattooUtilities.drawString(this.rootPane, graphics, string, n + 1, n7 - 1);
                JTattooUtilities.drawString(this.rootPane, graphics, string, n + 1, n7 + 1);
                JTattooUtilities.drawString(this.rootPane, graphics, string, n + 1, n7 + 1);
            }
            graphics.setColor(colorUIResource);
            JTattooUtilities.drawString(this.rootPane, graphics, string, n, n7);
            this.paintText(graphics, n, n7, string);
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = this.computeHeight();
            return new Dimension(n, n);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        protected int computeHeight() {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(AcrylTitlePane.this.getFont());
            return fontMetrics.getHeight() + 6;
        }

        public void layoutContainer(Container container) {
            boolean bl = AcrylTitlePane.this.isLeftToRight();
            int n = AcrylTitlePane.this.getHorSpacing();
            int n2 = AcrylTitlePane.this.getWidth();
            int n3 = AcrylTitlePane.this.getHeight();
            int n4 = n3 - AcrylTitlePane.this.getVerSpacing();
            int n5 = n4 + 10;
            int n6 = bl ? n : n2 - n5 - n;
            int n7 = Math.max(0, (n3 - n4) / 2 - 1);
            if (AcrylTitlePane.this.menuBar != null) {
                if (bl) {
                    AcrylTitlePane.this.menuBar.setBounds(2, n7, AcrylTitlePane.this.getHeight() - 2, AcrylTitlePane.this.getHeight() - 2);
                } else {
                    AcrylTitlePane.this.menuBar.setBounds(AcrylTitlePane.this.getWidth() - AcrylTitlePane.this.getHeight() - 2, n7, AcrylTitlePane.this.getHeight() - 2, AcrylTitlePane.this.getHeight() - 2);
                }
            }
            int n8 = n6 = bl ? n2 - n : 0;
            if (AcrylTitlePane.this.closeButton != null) {
                AcrylTitlePane.this.closeButton.setBounds(n6 += bl ? -n5 : n, n7, n5, n4);
                if (!bl) {
                    n6 += n5;
                }
            }
            if (AcrylTitlePane.this.maxButton != null && AcrylTitlePane.this.maxButton.getParent() != null && DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                AcrylTitlePane.this.maxButton.setBounds(n6 += bl ? -n - n5 : n, n7, n5, n4);
                if (!bl) {
                    n6 += n5;
                }
            }
            if (AcrylTitlePane.this.iconifyButton != null && AcrylTitlePane.this.iconifyButton.getParent() != null) {
                AcrylTitlePane.this.iconifyButton.setBounds(n6 += bl ? -n - n5 : n, n7, n5, n4);
                if (!bl) {
                    n6 += n5;
                }
            }
            AcrylTitlePane.this.buttonsWidth = bl ? n2 - n6 : n6;
        }
    }
}

