/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import java.awt.Color;

public class ColorHelper {
    private ColorHelper() {
    }

    public static final Color createColor(int n, int n2, int n3) {
        return new Color((n & 0xFF) << 16 | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 0);
    }

    public static Color[] createColorArr(Color color, Color color2, int n) {
        Color[] colorArray = new Color[n];
        double d = color.getRed();
        double d2 = color.getGreen();
        double d3 = color.getBlue();
        double d4 = ((double)color2.getRed() - d) / (double)n;
        double d5 = ((double)color2.getGreen() - d2) / (double)n;
        double d6 = ((double)color2.getBlue() - d3) / (double)n;
        colorArray[0] = color;
        for (int i = 1; i < n - 1; ++i) {
            colorArray[i] = ColorHelper.createColor((int)(d += d4), (int)(d2 += d5), (int)(d3 += d6));
        }
        colorArray[n - 1] = color2;
        return colorArray;
    }

    public static Color brighter(Color color, double d) {
        double d2 = color.getRed();
        double d3 = color.getGreen();
        double d4 = color.getBlue();
        double d5 = 255.0 - d2;
        double d6 = 255.0 - d3;
        double d7 = 255.0 - d4;
        return ColorHelper.createColor((int)(d2 += d5 * d / 100.0), (int)(d3 += d6 * d / 100.0), (int)(d4 += d7 * d / 100.0));
    }

    public static Color darker(Color color, double d) {
        double d2 = color.getRed();
        double d3 = color.getGreen();
        double d4 = color.getBlue();
        d2 -= d2 * d / 100.0;
        d3 -= d3 * d / 100.0;
        d4 -= d4 * d / 100.0;
        return ColorHelper.createColor((int)d2, (int)d3, (int)d4);
    }

    public static Color median(Color color, Color color2) {
        int n = (color.getRed() + color2.getRed()) / 2;
        int n2 = (color.getGreen() + color2.getGreen()) / 2;
        int n3 = (color.getBlue() + color2.getBlue()) / 2;
        return ColorHelper.createColor(n, n2, n3);
    }

    public static int getGrayValue(Color color) {
        double d = color.getRed();
        double d2 = color.getGreen();
        double d3 = color.getBlue();
        return Math.min(255, (int)(d * 0.28 + d2 * 0.59 + d3 * 0.13));
    }

    public static Color toGray(Color color) {
        int n = ColorHelper.getGrayValue(color);
        return new Color(n, n, n, color.getAlpha());
    }
}

