/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseScrollButton;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class BaseScrollBarUI
extends BasicScrollBarUI {
    protected int scrollBarWidth = 17;
    protected boolean isRollover = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseScrollBarUI();
    }

    protected void installDefaults() {
        UIManager.put("ScrollBar.width", new Integer(this.scrollBarWidth));
        super.installDefaults();
    }

    protected JButton createDecreaseButton(int n) {
        return new BaseScrollButton(n, this.scrollBarWidth);
    }

    protected JButton createIncreaseButton(int n) {
        return new BaseScrollButton(n, this.scrollBarWidth);
    }

    public BasicScrollBarUI.TrackListener createTrackListener() {
        return new MyTrackListener();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, this.scrollBarWidth * 3 + 16);
        }
        return new Dimension(this.scrollBarWidth * 3 + 16, this.scrollBarWidth);
    }

    protected Dimension getMinimumThumbSize() {
        return new Dimension(this.scrollBarWidth, this.scrollBarWidth);
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        if (this.scrollbar.getOrientation() == 1) {
            JTattooUtilities.fillVerGradient(graphics, AbstractLookAndFeel.getTheme().getTrackColors(), 0, 0, n, n2);
        } else {
            JTattooUtilities.fillHorGradient(graphics, AbstractLookAndFeel.getTheme().getTrackColors(), 0, 0, n, n2);
        }
    }

    protected Color[] getThumbColors() {
        if (this.isRollover) {
            return AbstractLookAndFeel.getTheme().getRolloverColors();
        }
        if (!JTattooUtilities.isActive(this.scrollbar)) {
            return AbstractLookAndFeel.getTheme().getInActiveColors();
        }
        return AbstractLookAndFeel.getTheme().getThumbColors();
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (!jComponent.isEnabled()) {
            return;
        }
        graphics.translate(rectangle.x, rectangle.y);
        Color[] colorArray = this.getThumbColors();
        Color color = ColorHelper.brighter(colorArray[1], 30.0);
        Color color2 = ColorHelper.darker(colorArray[colorArray.length - 1], 10.0);
        if (this.scrollbar.getOrientation() == 1) {
            JTattooUtilities.fillVerGradient(graphics, colorArray, 1, 1, rectangle.width - 1, rectangle.height - 1);
            JTattooUtilities.draw3DBorder(graphics, color2, ColorHelper.darker(color2, 15.0), 0, 0, rectangle.width, rectangle.height);
            graphics.setColor(color);
            graphics.drawLine(1, 1, rectangle.width - 2, 1);
            graphics.drawLine(1, 1, 1, rectangle.height - 2);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);
            graphics2D.setComposite(alphaComposite);
            int n = 5;
            int n2 = rectangle.height / 2 - 3;
            int n3 = rectangle.width - 11;
            Color color3 = Color.white;
            Color color4 = Color.darkGray;
            for (int i = 0; i < 4; ++i) {
                graphics.setColor(color3);
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.setColor(color4);
                graphics.drawLine(n, ++n2, n + n3, n2);
                ++n2;
            }
            graphics2D.setComposite(composite);
        } else {
            JTattooUtilities.fillHorGradient(graphics, colorArray, 1, 1, rectangle.width - 1, rectangle.height - 1);
            JTattooUtilities.draw3DBorder(graphics, color2, ColorHelper.darker(color2, 10.0), 0, 0, rectangle.width, rectangle.height);
            graphics.setColor(color);
            graphics.drawLine(1, 1, rectangle.width - 2, 1);
            graphics.drawLine(1, 1, 1, rectangle.height - 2);
            int n = rectangle.width / 2 - 3;
            int n4 = 5;
            int n5 = rectangle.height - 11;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);
            graphics2D.setComposite(alphaComposite);
            Color color5 = Color.white;
            Color color6 = Color.darkGray;
            for (int i = 0; i < 4; ++i) {
                graphics.setColor(color5);
                graphics.drawLine(n, n4, n, n4 + n5);
                graphics.setColor(color6);
                graphics.drawLine(++n, n4, n, n4 + n5);
                ++n;
            }
            graphics2D.setComposite(composite);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    protected class MyTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected MyTrackListener() {
            super(BaseScrollBarUI.this);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            BaseScrollBarUI.this.isRollover = true;
            Rectangle rectangle = BaseScrollBarUI.this.getTrackBounds();
            BaseScrollBarUI.this.scrollbar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            BaseScrollBarUI.this.isRollover = false;
            Rectangle rectangle = BaseScrollBarUI.this.getTrackBounds();
            BaseScrollBarUI.this.scrollbar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            Rectangle rectangle = BaseScrollBarUI.this.getTrackBounds();
            BaseScrollBarUI.this.scrollbar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            Rectangle rectangle = BaseScrollBarUI.this.getTrackBounds();
            BaseScrollBarUI.this.scrollbar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

