/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceTextUtilities;
import org.jvnet.substance.utils.border.SubstanceBorder;

public class SubstancePasswordFieldUI
extends BasicPasswordFieldUI {
    protected FadeStateListener substanceFadeStateListener;
    protected JPasswordField passwordField;
    protected PropertyChangeListener substancePropertyChangeListener;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstancePasswordFieldUI(comp);
    }

    public SubstancePasswordFieldUI(JComponent c) {
        this.passwordField = (JPasswordField)c;
    }

    @Override
    public View create(Element elem) {
        return new SubstancePasswordView(this.passwordField, elem);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceFadeStateListener = new FadeStateListener(this.passwordField, null, null);
        this.substanceFadeStateListener.registerListeners(false);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int caretPos = SubstancePasswordFieldUI.this.passwordField.getCaretPosition();
                            SubstancePasswordFieldUI.this.passwordField.updateUI();
                            SubstancePasswordFieldUI.this.passwordField.setCaretPosition(caretPos);
                        }
                    });
                }
            }
        };
        this.passwordField.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        this.passwordField.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        Color foregr;
        super.installDefaults();
        Border b = this.passwordField.getBorder();
        if (b == null || b instanceof UIResource) {
            BorderUIResource.CompoundBorderUIResource newB = new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(SubstanceSizeUtils.getTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.passwordField))), new BasicBorders.MarginBorder());
            this.passwordField.setBorder(newB);
        }
        if ((foregr = this.passwordField.getForeground()) == null || foregr instanceof UIResource) {
            this.passwordField.setForeground(SubstanceColorUtilities.getForegroundColor(SubstanceLookAndFeel.getCurrentSkin(this.passwordField).getMainDefaultColorScheme()));
        }
    }

    @Override
    protected void paintBackground(Graphics g) {
        SubstanceTextUtilities.paintTextCompBackground(g, this.passwordField);
    }

    private static class SubstancePasswordView
    extends FieldView {
        private JPasswordField field;

        public SubstancePasswordView(JPasswordField field, Element element) {
            super(element);
            this.field = field;
        }

        protected int drawEchoCharacter(Graphics g, int x, int y, char c, boolean isSelected) {
            Container container = this.getContainer();
            Graphics2D graphics = (Graphics2D)g;
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            JPasswordField field = (JPasswordField)container;
            int fontSize = SubstanceSizeUtils.getComponentFontSize(this.field);
            int dotDiameter = SubstanceSizeUtils.getPasswordDotDiameter(fontSize);
            int dotGap = SubstanceSizeUtils.getPasswordDotGap(fontSize);
            ComponentState state = field.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
            SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(field, state);
            Color topColor = isSelected ? scheme.getSelectionForegroundColor() : SubstanceColorUtilities.getForegroundColor(scheme);
            Color bottomColor = topColor.brighter();
            graphics.setPaint(new GradientPaint(x, y - dotDiameter, topColor, x, y, bottomColor));
            int echoPerChar = SubstanceCoreUtilities.getEchoPerChar(field);
            for (int i = 0; i < echoPerChar; ++i) {
                graphics.fillOval(x + dotGap / 2, y - dotDiameter, dotDiameter, dotDiameter);
                x += dotDiameter + dotGap;
            }
            return x;
        }

        protected int getEchoCharAdvance() {
            int fontSize = SubstanceSizeUtils.getComponentFontSize(this.field);
            int dotDiameter = SubstanceSizeUtils.getPasswordDotDiameter(fontSize);
            int dotGap = SubstanceSizeUtils.getPasswordDotGap(fontSize);
            int echoPerChar = SubstanceCoreUtilities.getEchoPerChar(this.field);
            return echoPerChar * (dotDiameter + dotGap);
        }

        @Override
        protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
            Container c = this.getContainer();
            if (c instanceof JPasswordField) {
                JPasswordField f = (JPasswordField)c;
                if (!f.echoCharIsSet()) {
                    return super.drawSelectedText(g, x, y, p0, p1);
                }
                int n = p1 - p0;
                char echoChar = f.getEchoChar();
                int currPos = x;
                for (int i = 0; i < n; ++i) {
                    currPos = this.drawEchoCharacter(g, currPos, y, echoChar, true);
                }
                return x + n * this.getEchoCharAdvance();
            }
            return x;
        }

        @Override
        protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
            Container c = this.getContainer();
            if (c instanceof JPasswordField) {
                JPasswordField f = (JPasswordField)c;
                if (!f.echoCharIsSet()) {
                    return super.drawUnselectedText(g, x, y, p0, p1);
                }
                int n = p1 - p0;
                char echoChar = f.getEchoChar();
                int currPos = x;
                for (int i = 0; i < n; ++i) {
                    currPos = this.drawEchoCharacter(g, currPos, y, echoChar, false);
                }
                return x + n * this.getEchoCharAdvance();
            }
            return x;
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            Container c = this.getContainer();
            if (c instanceof JPasswordField) {
                JPasswordField f = (JPasswordField)c;
                if (!f.echoCharIsSet()) {
                    return super.modelToView(pos, a, b);
                }
                Rectangle alloc = this.adjustAllocation(a).getBounds();
                int echoPerChar = SubstanceCoreUtilities.getEchoPerChar(f);
                int fontSize = SubstanceSizeUtils.getComponentFontSize(this.field);
                int dotWidth = SubstanceSizeUtils.getPasswordDotDiameter(fontSize) + SubstanceSizeUtils.getPasswordDotGap(fontSize);
                int dx = (pos - this.getStartOffset()) * echoPerChar * dotWidth;
                alloc.x += dx;
                alloc.width = 1;
                return alloc;
            }
            return null;
        }

        @Override
        public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
            bias[0] = Position.Bias.Forward;
            int n = 0;
            Container c = this.getContainer();
            if (c instanceof JPasswordField) {
                int fontSize;
                int dotWidth;
                JPasswordField f = (JPasswordField)c;
                if (!f.echoCharIsSet()) {
                    return super.viewToModel(fx, fy, a, bias);
                }
                Rectangle alloc = (a = this.adjustAllocation(a)) instanceof Rectangle ? (Rectangle)a : a.getBounds();
                int echoPerChar = SubstanceCoreUtilities.getEchoPerChar(f);
                n = ((int)fx - alloc.x) / (echoPerChar * (dotWidth = SubstanceSizeUtils.getPasswordDotDiameter(fontSize = SubstanceSizeUtils.getComponentFontSize(this.field)) + SubstanceSizeUtils.getPasswordDotGap(fontSize)));
                if (n < 0) {
                    n = 0;
                } else if (n > this.getStartOffset() + this.getDocument().getLength()) {
                    n = this.getDocument().getLength() - this.getStartOffset();
                }
            }
            return this.getStartOffset() + n;
        }

        @Override
        public float getPreferredSpan(int axis) {
            switch (axis) {
                case 0: {
                    JPasswordField f;
                    Container c = this.getContainer();
                    if (!(c instanceof JPasswordField) || !(f = (JPasswordField)c).echoCharIsSet()) break;
                    int echoPerChar = SubstanceCoreUtilities.getEchoPerChar(f);
                    int fontSize = SubstanceSizeUtils.getComponentFontSize(this.field);
                    int dotWidth = SubstanceSizeUtils.getPasswordDotDiameter(fontSize) + SubstanceSizeUtils.getPasswordDotGap(fontSize);
                    return echoPerChar * dotWidth * this.getDocument().getLength();
                }
            }
            return super.getPreferredSpan(axis);
        }
    }
}

