/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDesktopPaneUI;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.painter.utils.BackgroundPaintingUtils;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.border.SubstanceBorder;

public class SubstanceDesktopPaneUI
extends BasicDesktopPaneUI {
    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceDesktopPaneUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Border curr = this.desktop.getBorder();
        if (curr == null || curr instanceof UIResource) {
            this.desktop.setBorder(new SubstanceBorder());
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (!c.isShowing()) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(TransitionLayout.getAlphaComposite((Component)c, g));
        if (TransitionLayout.isOpaque(c)) {
            Color back = c.getBackground();
            if (back instanceof UIResource) {
                graphics.setColor(UIManager.getColor("Panel.background"));
                graphics.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
            BackgroundPaintingUtils.updateIfOpaque(graphics, c);
            super.paint(graphics, c);
        } else {
            super.paint(graphics, c);
        }
        graphics.dispose();
    }
}

