/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TextToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemovedTokenList<T extends TokenId>
implements TokenList<T> {
    private final LanguagePath languagePath;
    private Object[] tokensOrBranches;
    private int removedTokensStartOffset;

    public RemovedTokenList(LanguagePath languagePath, Object[] objectArray) {
        this.languagePath = languagePath;
        this.tokensOrBranches = objectArray;
    }

    @Override
    public LanguagePath languagePath() {
        return this.languagePath;
    }

    @Override
    public Object tokenOrEmbeddingContainer(int n) {
        return n < this.tokensOrBranches.length ? this.tokensOrBranches[n] : null;
    }

    @Override
    public int lookahead(int n) {
        return -1;
    }

    @Override
    public Object state(int n) {
        return null;
    }

    @Override
    public int tokenOffset(int n) {
        Token<T> token = this.existingToken(n);
        if (token.isFlyweight()) {
            int n2 = 0;
            while (--n >= 0) {
                token = this.existingToken(n);
                n2 += token.length();
                if (token.isFlyweight()) continue;
                return n2 + token.offset(null);
            }
            return this.removedTokensStartOffset + n2;
        }
        return token.offset(null);
    }

    private Token<T> existingToken(int n) {
        return LexerUtilsConstants.token(this.tokensOrBranches[n]);
    }

    @Override
    public synchronized AbstractToken<T> replaceFlyToken(int n, AbstractToken<T> abstractToken, int n2) {
        TextToken textToken;
        this.tokensOrBranches[n] = textToken = ((TextToken)abstractToken).createCopy(this, n2);
        return textToken;
    }

    @Override
    public int tokenCount() {
        return this.tokenCountCurrent();
    }

    @Override
    public int tokenCountCurrent() {
        return this.tokensOrBranches.length;
    }

    @Override
    public int modCount() {
        return -1;
    }

    @Override
    public int childTokenOffset(int n) {
        return n;
    }

    @Override
    public char childTokenCharAt(int n, int n2) {
        throw new IllegalStateException("Querying of text for removed tokens not supported");
    }

    @Override
    public void wrapToken(int n, EmbeddingContainer embeddingContainer) {
        throw new IllegalStateException("Branching of removed tokens not supported");
    }

    @Override
    public TokenList<?> root() {
        return this;
    }

    @Override
    public TokenHierarchyOperation<?, ?> tokenHierarchyOperation() {
        return null;
    }

    @Override
    public InputAttributes inputAttributes() {
        return null;
    }

    @Override
    public int startOffset() {
        if (this.tokenCountCurrent() > 0 || this.tokenCount() > 0) {
            return this.tokenOffset(0);
        }
        return 0;
    }

    @Override
    public int endOffset() {
        int n = this.tokenCount() - 1;
        if (n >= 0) {
            return this.tokenOffset(n) + LexerUtilsConstants.token(this, n).length();
        }
        return 0;
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public Set<T> skipTokenIds() {
        return null;
    }
}

