/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import mondrian.olap.Category;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.FunTable;
import mondrian.olap.Hierarchy;
import mondrian.olap.HierarchyBase;
import mondrian.olap.Level;
import mondrian.olap.LevelType;
import mondrian.olap.Member;
import mondrian.olap.MemberBase;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Role;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.FunInfo;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.Enumeration;
import mondrian.xmla.PropertyDefinition;
import mondrian.xmla.Rowset;
import mondrian.xmla.SaxWriter;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequest;
import mondrian.xmla.XmlaResponse;
import mondrian.xmla.XmlaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum RowsetDefinition {
    DISCOVER_DATASOURCES("DISCOVER_DATASOURCES", 0, "Returns a list of XML for Analysis data sources available on the server or Web Service.", new Column[]{DiscoverDatasourcesRowset.access$000(), DiscoverDatasourcesRowset.access$100(), DiscoverDatasourcesRowset.access$200(), DiscoverDatasourcesRowset.access$300(), DiscoverDatasourcesRowset.access$400(), DiscoverDatasourcesRowset.access$500(), DiscoverDatasourcesRowset.access$600()}, null){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverDatasourcesRowset(request, handler);
        }
    }
    ,
    DISCOVER_SCHEMA_ROWSETS("DISCOVER_SCHEMA_ROWSETS", 2, "Returns the names, values, and other information of all supported RequestType enumeration values.", new Column[]{DiscoverSchemaRowsetsRowset.access$800(), DiscoverSchemaRowsetsRowset.access$900(), DiscoverSchemaRowsetsRowset.access$1000(), DiscoverSchemaRowsetsRowset.access$1100()}, null){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverSchemaRowsetsRowset(request, handler);
        }

        protected void writeRowsetXmlSchemaRowDef(SaxWriter writer) {
            writer.startElement("xsd:complexType", new String[]{"name", "row"});
            writer.startElement("xsd:sequence");
            for (Column column : this.columnDefinitions) {
                String name = XmlaUtil.encodeElementName(column.name);
                if (column == DiscoverSchemaRowsetsRowset.Restrictions) {
                    writer.startElement("xsd:element", new String[]{"sql:field", column.name, "name", name, "minOccurs", "0", "maxOccurs", "unbounded"});
                    writer.startElement("xsd:complexType");
                    writer.startElement("xsd:sequence");
                    writer.element("xsd:element", new String[]{"name", "Name", "type", "xsd:string", "sql:field", "Name"});
                    writer.element("xsd:element", new String[]{"name", "Type", "type", "xsd:string", "sql:field", "Type"});
                    writer.endElement();
                    writer.endElement();
                    writer.endElement();
                    continue;
                }
                String xsdType = column.type.columnType;
                String[] attrs = column.nullable ? (column.unbounded ? new String[]{"sql:field", column.name, "name", name, "type", xsdType, "minOccurs", "0", "maxOccurs", "unbounded"} : new String[]{"sql:field", column.name, "name", name, "type", xsdType, "minOccurs", "0"}) : (column.unbounded ? new String[]{"sql:field", column.name, "name", name, "type", xsdType, "maxOccurs", "unbounded"} : new String[]{"sql:field", column.name, "name", name, "type", xsdType});
                writer.element("xsd:element", attrs);
            }
            writer.endElement();
            writer.endElement();
        }
    }
    ,
    DISCOVER_ENUMERATORS("DISCOVER_ENUMERATORS", 3, "Returns a list of names, data types, and enumeration values for enumerators supported by the provider of a specific data source.", new Column[]{DiscoverEnumeratorsRowset.access$1200(), DiscoverEnumeratorsRowset.access$1300(), DiscoverEnumeratorsRowset.access$1400(), DiscoverEnumeratorsRowset.access$1500(), DiscoverEnumeratorsRowset.access$1600(), DiscoverEnumeratorsRowset.access$1700()}, null){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverEnumeratorsRowset(request, handler);
        }
    }
    ,
    DISCOVER_PROPERTIES("DISCOVER_PROPERTIES", 1, "Returns a list of information and values about the requested properties that are supported by the specified data source provider.", new Column[]{DiscoverPropertiesRowset.access$1800(), DiscoverPropertiesRowset.access$1900(), DiscoverPropertiesRowset.access$2000(), DiscoverPropertiesRowset.access$2100(), DiscoverPropertiesRowset.access$2200(), DiscoverPropertiesRowset.access$2300()}, null){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverPropertiesRowset(request, handler);
        }
    }
    ,
    DISCOVER_KEYWORDS("DISCOVER_KEYWORDS", 4, "Returns an XML list of keywords reserved by the provider.", new Column[]{DiscoverKeywordsRowset.access$2400()}, null){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverKeywordsRowset(request, handler);
        }
    }
    ,
    DISCOVER_LITERALS("DISCOVER_LITERALS", 5, "Returns information about literals supported by the provider.", new Column[]{DiscoverLiteralsRowset.access$2500(), DiscoverLiteralsRowset.access$2600(), DiscoverLiteralsRowset.access$2700(), DiscoverLiteralsRowset.access$2800(), DiscoverLiteralsRowset.access$2900()}, null){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverLiteralsRowset(request, handler);
        }
    }
    ,
    DBSCHEMA_CATALOGS("DBSCHEMA_CATALOGS", 6, "Returns information about literals supported by the provider.", new Column[]{DbschemaCatalogsRowset.access$3000(), DbschemaCatalogsRowset.access$3100(), DbschemaCatalogsRowset.access$3200(), DbschemaCatalogsRowset.access$3300()}, new Column[]{DbschemaCatalogsRowset.access$3000()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DbschemaCatalogsRowset(request, handler);
        }
    }
    ,
    DBSCHEMA_COLUMNS("DBSCHEMA_COLUMNS", 7, null, new Column[]{DbschemaColumnsRowset.access$3400(), DbschemaColumnsRowset.access$3500(), DbschemaColumnsRowset.access$3600(), DbschemaColumnsRowset.access$3700(), DbschemaColumnsRowset.access$3800(), DbschemaColumnsRowset.access$3900(), DbschemaColumnsRowset.access$4000(), DbschemaColumnsRowset.access$4100(), DbschemaColumnsRowset.access$4200(), DbschemaColumnsRowset.access$4300(), DbschemaColumnsRowset.access$4400(), DbschemaColumnsRowset.access$4500(), DbschemaColumnsRowset.access$4600()}, new Column[]{DbschemaColumnsRowset.access$3400(), DbschemaColumnsRowset.access$3500(), DbschemaColumnsRowset.access$3600()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DbschemaColumnsRowset(request, handler);
        }
    }
    ,
    DBSCHEMA_PROVIDER_TYPES("DBSCHEMA_PROVIDER_TYPES", 8, null, new Column[]{DbschemaProviderTypesRowset.access$4700(), DbschemaProviderTypesRowset.access$4800(), DbschemaProviderTypesRowset.access$4900(), DbschemaProviderTypesRowset.access$5000(), DbschemaProviderTypesRowset.access$5100(), DbschemaProviderTypesRowset.access$5200(), DbschemaProviderTypesRowset.access$5300(), DbschemaProviderTypesRowset.access$5400(), DbschemaProviderTypesRowset.access$5500(), DbschemaProviderTypesRowset.access$5600(), DbschemaProviderTypesRowset.access$5700(), DbschemaProviderTypesRowset.access$5800(), DbschemaProviderTypesRowset.access$5900()}, new Column[]{DbschemaProviderTypesRowset.access$4800()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DbschemaProviderTypesRowset(request, handler);
        }
    }
    ,
    DBSCHEMA_TABLES("DBSCHEMA_TABLES", 9, null, new Column[]{DbschemaTablesRowset.access$6000(), DbschemaTablesRowset.access$6100(), DbschemaTablesRowset.access$6200(), DbschemaTablesRowset.access$6300(), DbschemaTablesRowset.access$6400(), DbschemaTablesRowset.access$6500(), DbschemaTablesRowset.access$6600(), DbschemaTablesRowset.access$6700(), DbschemaTablesRowset.access$6800()}, new Column[]{DbschemaTablesRowset.access$6300(), DbschemaTablesRowset.access$6000(), DbschemaTablesRowset.access$6100(), DbschemaTablesRowset.access$6200()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DbschemaTablesRowset(request, handler);
        }
    }
    ,
    DBSCHEMA_TABLES_INFO("DBSCHEMA_TABLES_INFO", 10, null, new Column[]{DbschemaTablesInfoRowset.access$6900(), DbschemaTablesInfoRowset.access$7000(), DbschemaTablesInfoRowset.access$7100(), DbschemaTablesInfoRowset.access$7200(), DbschemaTablesInfoRowset.access$7300(), DbschemaTablesInfoRowset.access$7400(), DbschemaTablesInfoRowset.access$7500(), DbschemaTablesInfoRowset.access$7600(), DbschemaTablesInfoRowset.access$7700(), DbschemaTablesInfoRowset.access$7800(), DbschemaTablesInfoRowset.access$7900(), DbschemaTablesInfoRowset.access$8000(), DbschemaTablesInfoRowset.access$8100(), DbschemaTablesInfoRowset.access$8200()}, null){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DbschemaTablesInfoRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_ACTIONS("MDSCHEMA_ACTIONS", 11, null, new Column[]{MdschemaActionsRowset.access$8300(), MdschemaActionsRowset.access$8400(), MdschemaActionsRowset.access$8500()}, new Column[]{MdschemaActionsRowset.access$8300()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaActionsRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_CUBES("MDSCHEMA_CUBES", 12, null, new Column[]{MdschemaCubesRowset.access$8600(), MdschemaCubesRowset.access$8700(), MdschemaCubesRowset.access$8800(), MdschemaCubesRowset.access$8900(), MdschemaCubesRowset.access$9000(), MdschemaCubesRowset.access$9100(), MdschemaCubesRowset.access$9200(), MdschemaCubesRowset.access$9300(), MdschemaCubesRowset.access$9400(), MdschemaCubesRowset.access$9500(), MdschemaCubesRowset.access$9600(), MdschemaCubesRowset.access$9700(), MdschemaCubesRowset.access$9800(), MdschemaCubesRowset.access$9900(), MdschemaCubesRowset.access$10000()}, new Column[]{MdschemaCubesRowset.access$8600(), MdschemaCubesRowset.access$8700(), MdschemaCubesRowset.access$8800()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaCubesRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_DIMENSIONS("MDSCHEMA_DIMENSIONS", 13, null, new Column[]{MdschemaDimensionsRowset.access$10100(), MdschemaDimensionsRowset.access$10200(), MdschemaDimensionsRowset.access$10300(), MdschemaDimensionsRowset.access$10400(), MdschemaDimensionsRowset.access$10500(), MdschemaDimensionsRowset.access$10600(), MdschemaDimensionsRowset.access$10700(), MdschemaDimensionsRowset.access$10800(), MdschemaDimensionsRowset.access$10900(), MdschemaDimensionsRowset.access$11000(), MdschemaDimensionsRowset.access$11100(), MdschemaDimensionsRowset.access$11200(), MdschemaDimensionsRowset.access$11300(), MdschemaDimensionsRowset.access$11400(), MdschemaDimensionsRowset.access$11500(), MdschemaDimensionsRowset.access$11600(), MdschemaDimensionsRowset.access$11700()}, new Column[]{MdschemaDimensionsRowset.access$10100(), MdschemaDimensionsRowset.access$10200(), MdschemaDimensionsRowset.access$10300(), MdschemaDimensionsRowset.access$10400()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaDimensionsRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_FUNCTIONS("MDSCHEMA_FUNCTIONS", 14, null, new Column[]{MdschemaFunctionsRowset.access$11800(), MdschemaFunctionsRowset.access$11900(), MdschemaFunctionsRowset.access$12000(), MdschemaFunctionsRowset.access$12100(), MdschemaFunctionsRowset.access$12200(), MdschemaFunctionsRowset.access$12300(), MdschemaFunctionsRowset.access$12400(), MdschemaFunctionsRowset.access$12500()}, new Column[]{MdschemaFunctionsRowset.access$12400(), MdschemaFunctionsRowset.access$12300(), MdschemaFunctionsRowset.access$11800(), MdschemaFunctionsRowset.access$12200()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaFunctionsRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_HIERARCHIES("MDSCHEMA_HIERARCHIES", 15, null, new Column[]{MdschemaHierarchiesRowset.access$12600(), MdschemaHierarchiesRowset.access$12700(), MdschemaHierarchiesRowset.access$12800(), MdschemaHierarchiesRowset.access$12900(), MdschemaHierarchiesRowset.access$13000(), MdschemaHierarchiesRowset.access$13100(), MdschemaHierarchiesRowset.access$13200(), MdschemaHierarchiesRowset.access$13300(), MdschemaHierarchiesRowset.access$13400(), MdschemaHierarchiesRowset.access$13500(), MdschemaHierarchiesRowset.access$13600(), MdschemaHierarchiesRowset.access$13700(), MdschemaHierarchiesRowset.access$13800(), MdschemaHierarchiesRowset.access$13900(), MdschemaHierarchiesRowset.access$14000(), MdschemaHierarchiesRowset.access$14100(), MdschemaHierarchiesRowset.access$14200(), MdschemaHierarchiesRowset.access$14300(), MdschemaHierarchiesRowset.access$14400(), MdschemaHierarchiesRowset.access$14500(), MdschemaHierarchiesRowset.access$14600()}, new Column[]{MdschemaHierarchiesRowset.access$12600(), MdschemaHierarchiesRowset.access$12700(), MdschemaHierarchiesRowset.access$12800(), MdschemaHierarchiesRowset.access$12900(), MdschemaHierarchiesRowset.access$13000()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaHierarchiesRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_LEVELS("MDSCHEMA_LEVELS", 16, null, new Column[]{MdschemaLevelsRowset.access$14700(), MdschemaLevelsRowset.access$14800(), MdschemaLevelsRowset.access$14900(), MdschemaLevelsRowset.access$15000(), MdschemaLevelsRowset.access$15100(), MdschemaLevelsRowset.access$15200(), MdschemaLevelsRowset.access$15300(), MdschemaLevelsRowset.access$15400(), MdschemaLevelsRowset.access$15500(), MdschemaLevelsRowset.access$15600(), MdschemaLevelsRowset.access$15700(), MdschemaLevelsRowset.access$15800(), MdschemaLevelsRowset.access$15900(), MdschemaLevelsRowset.access$16000(), MdschemaLevelsRowset.access$16100(), MdschemaLevelsRowset.access$16200()}, new Column[]{MdschemaLevelsRowset.access$14700(), MdschemaLevelsRowset.access$14800(), MdschemaLevelsRowset.access$14900(), MdschemaLevelsRowset.access$15000(), MdschemaLevelsRowset.access$15100(), MdschemaLevelsRowset.access$15600()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaLevelsRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_MEASURES("MDSCHEMA_MEASURES", 17, null, new Column[]{MdschemaMeasuresRowset.access$16300(), MdschemaMeasuresRowset.access$16400(), MdschemaMeasuresRowset.access$16500(), MdschemaMeasuresRowset.access$16600(), MdschemaMeasuresRowset.access$16700(), MdschemaMeasuresRowset.access$16800(), MdschemaMeasuresRowset.access$16900(), MdschemaMeasuresRowset.access$17000(), MdschemaMeasuresRowset.access$17100(), MdschemaMeasuresRowset.access$17200(), MdschemaMeasuresRowset.access$17300(), MdschemaMeasuresRowset.access$17400()}, new Column[]{MdschemaMeasuresRowset.access$16300(), MdschemaMeasuresRowset.access$16400(), MdschemaMeasuresRowset.access$16500(), MdschemaMeasuresRowset.access$16600()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaMeasuresRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_MEMBERS("MDSCHEMA_MEMBERS", 18, null, new Column[]{MdschemaMembersRowset.access$17500(), MdschemaMembersRowset.access$17600(), MdschemaMembersRowset.access$17700(), MdschemaMembersRowset.access$17800(), MdschemaMembersRowset.access$17900(), MdschemaMembersRowset.access$18000(), MdschemaMembersRowset.access$18100(), MdschemaMembersRowset.access$18200(), MdschemaMembersRowset.access$18300(), MdschemaMembersRowset.access$18400(), MdschemaMembersRowset.access$18500(), MdschemaMembersRowset.access$18600(), MdschemaMembersRowset.access$18700(), MdschemaMembersRowset.access$18800(), MdschemaMembersRowset.access$18900(), MdschemaMembersRowset.access$19000(), MdschemaMembersRowset.access$19100(), MdschemaMembersRowset.access$19200(), MdschemaMembersRowset.access$19300()}, new Column[]{MdschemaMembersRowset.access$17500(), MdschemaMembersRowset.access$17600(), MdschemaMembersRowset.access$17700(), MdschemaMembersRowset.access$17800(), MdschemaMembersRowset.access$17900(), MdschemaMembersRowset.access$18000(), MdschemaMembersRowset.access$18100(), MdschemaMembersRowset.access$18200()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaMembersRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_PROPERTIES("MDSCHEMA_PROPERTIES", 19, null, new Column[]{MdschemaPropertiesRowset.access$19400(), MdschemaPropertiesRowset.access$19500(), MdschemaPropertiesRowset.access$19600(), MdschemaPropertiesRowset.access$19700(), MdschemaPropertiesRowset.access$19800(), MdschemaPropertiesRowset.access$19900(), MdschemaPropertiesRowset.access$20000(), MdschemaPropertiesRowset.access$20100(), MdschemaPropertiesRowset.access$20200(), MdschemaPropertiesRowset.access$20300(), MdschemaPropertiesRowset.access$20400(), MdschemaPropertiesRowset.access$20500(), MdschemaPropertiesRowset.access$20600()}, null){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaPropertiesRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_SETS("MDSCHEMA_SETS", 20, null, new Column[]{MdschemaSetsRowset.access$20700(), MdschemaSetsRowset.access$20800(), MdschemaSetsRowset.access$20900(), MdschemaSetsRowset.access$21000(), MdschemaSetsRowset.access$21100()}, new Column[]{MdschemaSetsRowset.access$20700(), MdschemaSetsRowset.access$20800(), MdschemaSetsRowset.access$20900()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaSetsRowset(request, handler);
        }
    };

    final Column[] columnDefinitions;
    final Column[] sortColumnDefinitions;
    private static final String dateModified = "2005-01-25T17:35:32";
    private final String description;

    private RowsetDefinition(String name, int ordinal, String description, Column[] columnDefinitions, Column[] sortColumnDefinitions) {
        this.columnDefinitions = columnDefinitions;
        this.sortColumnDefinitions = sortColumnDefinitions;
        this.description = description;
    }

    public abstract Rowset getRowset(XmlaRequest var1, XmlaHandler var2);

    public Column lookupColumn(String name) {
        for (Column columnDefinition : this.columnDefinitions) {
            if (!columnDefinition.name.equals(name)) continue;
            return columnDefinition;
        }
        return null;
    }

    Comparator<Rowset.Row> getComparator() {
        if (this.sortColumnDefinitions == null) {
            return null;
        }
        return new Comparator<Rowset.Row>(){

            @Override
            public int compare(Rowset.Row row1, Rowset.Row row2) {
                for (Column sortColumn : RowsetDefinition.this.sortColumnDefinitions) {
                    int v;
                    Comparable val1 = (Comparable)row1.get(sortColumn.name);
                    Comparable val2 = (Comparable)row2.get(sortColumn.name);
                    if (val1 == null && val2 == null) continue;
                    if (val1 == null) {
                        return -1;
                    }
                    if (val2 == null) {
                        return 1;
                    }
                    if (!(val1 instanceof String && val2 instanceof String ? (v = ((String)((Object)val1)).compareToIgnoreCase((String)((Object)val2))) != 0 : (v = val1.compareTo(val2)) != 0)) continue;
                    return v;
                }
                return 0;
            }
        };
    }

    void writeRowsetXmlSchema(SaxWriter writer) {
        this.writeRowsetXmlSchemaTop(writer);
        this.writeRowsetXmlSchemaRowDef(writer);
        this.writeRowsetXmlSchemaBottom(writer);
    }

    protected void writeRowsetXmlSchemaTop(SaxWriter writer) {
        writer.startElement("xsd:schema", new String[]{"xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "xmlns", "urn:schemas-microsoft-com:xml-analysis:rowset", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:sql", "urn:schemas-microsoft-com:xml-sql", "targetNamespace", "urn:schemas-microsoft-com:xml-analysis:rowset", "elementFormDefault", "qualified"});
        writer.startElement("xsd:element", new String[]{"name", "root"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.element("xsd:element", new String[]{"name", "row", "type", "row", "minOccurs", "0", "maxOccurs", "unbounded"});
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:simpleType", new String[]{"name", "uuid"});
        writer.startElement("xsd:restriction", new String[]{"base", "xsd:string"});
        writer.element("xsd:pattern", new String[]{"value", "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}"});
        writer.endElement();
        writer.endElement();
    }

    protected void writeRowsetXmlSchemaRowDef(SaxWriter writer) {
        writer.startElement("xsd:complexType", new String[]{"name", "row"});
        writer.startElement("xsd:sequence");
        for (Column column : this.columnDefinitions) {
            String name = XmlaUtil.encodeElementName(column.name);
            String xsdType = column.type.columnType;
            String[] attrs = column.nullable ? (column.unbounded ? new String[]{"sql:field", column.name, "name", name, "type", xsdType, "minOccurs", "0", "maxOccurs", "unbounded"} : new String[]{"sql:field", column.name, "name", name, "type", xsdType, "minOccurs", "0"}) : (column.unbounded ? new String[]{"sql:field", column.name, "name", name, "type", xsdType, "maxOccurs", "unbounded"} : new String[]{"sql:field", column.name, "name", name, "type", xsdType});
            writer.element("xsd:element", attrs);
        }
        writer.endElement();
        writer.endElement();
    }

    protected void writeRowsetXmlSchemaBottom(SaxWriter writer) {
        writer.endElement();
    }

    private static DBType getDBTypeFromProperty(Property prop) {
        switch (prop.getType()) {
            case TYPE_STRING: {
                return DBType.WSTR;
            }
            case TYPE_NUMERIC: {
                return DBType.R8;
            }
            case TYPE_BOOLEAN: {
                return DBType.BOOL;
            }
        }
        return DBType.WSTR;
    }

    public String getDescription() {
        return this.description;
    }

    static int getDimensionType(Dimension dim) {
        if (dim.isMeasures()) {
            return 2;
        }
        if (DimensionType.TimeDimension.equals((Object)dim.getDimensionType())) {
            return 1;
        }
        return 3;
    }

    private static boolean canAccess(SchemaReader schemaReader, OlapElement elem) {
        Role role = schemaReader.getRole();
        return role.canAccess(elem);
    }

    private static <T extends Comparable> List<T> sort(Collection<T> collection) {
        Object[] a = collection.toArray(new Object[collection.size()]);
        Arrays.sort(a);
        return Arrays.asList(a);
    }

    private static <T> List<T> sortArray(T[] a, Comparator<T> comparator) {
        Object[] a2 = (Object[])a.clone();
        Arrays.sort(a2, comparator);
        return Arrays.asList(a2);
    }

    static void serialize(StringBuilder buf, Collection<String> strings) {
        int k = 0;
        for (String name : RowsetDefinition.sort(strings)) {
            if (k++ > 0) {
                buf.append(',');
            }
            buf.append(name);
        }
    }

    static List<Cube> sortedCubes(Schema schema) {
        Cube[] cubes = schema.getCubes();
        List<Cube> cubeList = RowsetDefinition.sortArray(cubes, new Comparator<Cube>(){

            @Override
            public int compare(Cube o1, Cube o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return cubeList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaPropertiesRowset
    extends Rowset {
        private final Rowset.RestrictionTest schemaNameRT = this.getRestrictionTest(SchemaName);
        private final Rowset.RestrictionTest cubeNameRT = this.getRestrictionTest(CubeName);
        private final Rowset.RestrictionTest dimensionUniqueNameRT = this.getRestrictionTest(DimensionUniqueName);
        private final Rowset.RestrictionTest hierarchyUniqueNameRT = this.getRestrictionTest(HierarchyUniqueName);
        private final Rowset.RestrictionTest propertyNameRT = this.getRestrictionTest(PropertyName);
        private static final int MDPROP_MEMBER = 1;
        private static final int MDPROP_CELL = 2;
        private static final int MDPROP_SYSTEM = 4;
        private static final int MDPROP_BLOB = 8;
        private static final int MD_PROPTYPE_REGULAR = 0;
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the database.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this property belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the dimension.");
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the hierarchy.");
        private static final Column LevelUniqueName = new Column("LEVEL_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the level to which this property belongs.");
        private static final Column MemberUniqueName = new Column("MEMBER_UNIQUE_NAME", Type.String, null, true, true, "The unique name of the member to which the property belongs.");
        private static final Column PropertyName = new Column("PROPERTY_NAME", Type.String, null, true, false, "Name of the property.");
        private static final Column PropertyType = new Column("PROPERTY_TYPE", Type.Short, null, true, false, "A bitmap that specifies the type of the property");
        private static final Column PropertyCaption = new Column("PROPERTY_CAPTION", Type.String, null, false, false, "A label or caption associated with the property, used primarily for display purposes.");
        private static final Column DataType = new Column("DATA_TYPE", Type.UnsignedShort, null, false, false, "Data type of the property.");
        private static final Column PropertyContentType = new Column("PROPERTY_CONTENT_TYPE", Type.Short, null, true, true, "The type of the property. ");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the measure. ");

        MdschemaPropertiesRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_PROPERTIES, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.Catalog[] catalogs;
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            String roleStr = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs = this.handler.getCatalogs(this.request, ds)) {
                String catalogName;
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null || !this.schemaNameRT.passes(catalogName = dsCatalog.name)) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                this.populateCatalog(connection, role, catalogName, rows);
            }
        }

        protected void populateCatalog(Connection connection, Role role, String catalogName, List<Rowset.Row> rows) throws XmlaException {
            for (Cube cube : RowsetDefinition.sortedCubes(connection.getSchema())) {
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                SchemaReader schemaReader = cube.getSchemaReader(role);
                this.populateCube(schemaReader, catalogName, cube, rows);
            }
        }

        protected void populateCube(SchemaReader schemaReader, String catalogName, Cube cube, List<Rowset.Row> rows) throws XmlaException {
            if (this.isRestricted(LevelUniqueName)) {
                Level[] levels;
                String levelUniqueName = this.getRestrictionValueAsString(LevelUniqueName);
                if (levelUniqueName == null) {
                    return;
                }
                String[] nameParts = Util.explode(levelUniqueName);
                Hierarchy hier = cube.lookupHierarchy(nameParts[0], false);
                if (hier == null) {
                    return;
                }
                for (Level level : levels = hier.getLevels()) {
                    if (!level.getUniqueName().equals(levelUniqueName)) continue;
                    this.populateLevel(schemaReader, catalogName, cube, level, rows);
                    break;
                }
            } else {
                for (Dimension dimension : cube.getDimensions()) {
                    String uniqueName = dimension.getUniqueName();
                    if (!this.dimensionUniqueNameRT.passes(uniqueName)) continue;
                    this.populateDimension(schemaReader, catalogName, cube, dimension, rows);
                }
            }
        }

        private void populateDimension(SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, List<Rowset.Row> rows) {
            Hierarchy[] hierarchies;
            for (Hierarchy hierarchy : hierarchies = dimension.getHierarchies()) {
                String unique = hierarchy.getUniqueName();
                if (!this.hierarchyUniqueNameRT.passes(unique)) continue;
                this.populateHierarchy(schemaReader, catalogName, cube, hierarchy, rows);
            }
        }

        private void populateHierarchy(SchemaReader schemaReader, String catalogName, Cube cube, Hierarchy hierarchy, List<Rowset.Row> rows) {
            Level[] levels;
            for (Level level : levels = hierarchy.getLevels()) {
                this.populateLevel(schemaReader, catalogName, cube, level, rows);
            }
        }

        private void populateLevel(SchemaReader schemaReader, String catalogName, Cube cube, Level level, List<Rowset.Row> rows) {
            Property[] properties;
            for (Property property : properties = level.getProperties()) {
                if (!this.propertyNameRT.passes(property.getName())) continue;
                this.outputProperty(schemaReader, property, catalogName, cube, level, rows);
            }
        }

        private void outputProperty(SchemaReader schemaReader, Property property, String catalogName, Cube cube, Level level, List<Rowset.Row> rows) {
            Hierarchy hierarchy = level.getHierarchy();
            Dimension dimension = hierarchy.getDimension();
            String propertyName = property.getName();
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaPropertiesRowset.CatalogName.name, catalogName);
            row.set(MdschemaPropertiesRowset.SchemaName.name, catalogName);
            row.set(MdschemaPropertiesRowset.CubeName.name, cube.getName());
            row.set(MdschemaPropertiesRowset.DimensionUniqueName.name, dimension.getUniqueName());
            row.set(MdschemaPropertiesRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
            row.set(MdschemaPropertiesRowset.LevelUniqueName.name, level.getUniqueName());
            row.set(MdschemaPropertiesRowset.PropertyName.name, propertyName);
            row.set(MdschemaPropertiesRowset.PropertyType.name, 1);
            row.set(MdschemaPropertiesRowset.PropertyContentType.name, 0);
            row.set(MdschemaPropertiesRowset.PropertyCaption.name, property.getCaption());
            DBType dbType = RowsetDefinition.getDBTypeFromProperty(property);
            row.set(MdschemaPropertiesRowset.DataType.name, dbType.userOrdinal);
            String desc = cube.getName() + " Cube - " + hierarchy.getName() + " Hierarchy - " + level.getName() + " Level - " + property.getName() + " Property";
            row.set(MdschemaPropertiesRowset.Description.name, desc);
            this.addRow(row, rows);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$19400() {
            return CatalogName;
        }

        static /* synthetic */ Column access$19500() {
            return SchemaName;
        }

        static /* synthetic */ Column access$19600() {
            return CubeName;
        }

        static /* synthetic */ Column access$19700() {
            return DimensionUniqueName;
        }

        static /* synthetic */ Column access$19800() {
            return HierarchyUniqueName;
        }

        static /* synthetic */ Column access$19900() {
            return LevelUniqueName;
        }

        static /* synthetic */ Column access$20000() {
            return MemberUniqueName;
        }

        static /* synthetic */ Column access$20100() {
            return PropertyName;
        }

        static /* synthetic */ Column access$20200() {
            return PropertyCaption;
        }

        static /* synthetic */ Column access$20300() {
            return PropertyType;
        }

        static /* synthetic */ Column access$20400() {
            return DataType;
        }

        static /* synthetic */ Column access$20500() {
            return PropertyContentType;
        }

        static /* synthetic */ Column access$20600() {
            return Description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaSetsRowset
    extends Rowset {
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, null);
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, null);
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, null);
        private static final Column SetName = new Column("SET_NAME", Type.String, null, true, false, null);
        private static final Column SetCaption = new Column("SET_CAPTION", Type.String, null, true, true, null);
        private static final Column Scope = new Column("SCOPE", Type.Integer, null, true, false, null);
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the measure.");

        MdschemaSetsRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_SETS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            throw new XmlaException("Client", "00HSBG01", "XMLA unsupported operation", new UnsupportedOperationException("MDSCHEMA_SETS"));
        }

        static /* synthetic */ Column access$20700() {
            return CatalogName;
        }

        static /* synthetic */ Column access$20800() {
            return SchemaName;
        }

        static /* synthetic */ Column access$20900() {
            return CubeName;
        }

        static /* synthetic */ Column access$21000() {
            return SetName;
        }

        static /* synthetic */ Column access$21100() {
            return Scope;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaMembersRowset
    extends Rowset {
        private final Rowset.RestrictionTest schemaNameRT = this.getRestrictionTest(SchemaName);
        private final Rowset.RestrictionTest cubeNameRT = this.getRestrictionTest(CubeName);
        private final Rowset.RestrictionTest dimensionUniqueNameRT = this.getRestrictionTest(DimensionUniqueName);
        private final Rowset.RestrictionTest hierarchyUniqueNameRT = this.getRestrictionTest(HierarchyUniqueName);
        private final Rowset.RestrictionTest memberNameRT = this.getRestrictionTest(MemberName);
        private final Rowset.RestrictionTest memberUniqueNameRT = this.getRestrictionTest(MemberUniqueName);
        private final Rowset.RestrictionTest memberTypeRT = this.getRestrictionTest(MemberType);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this member belongs. ");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this member belongs. ");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "Name of the cube to which this member belongs.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "Unique name of the dimension to which this member belongs. ");
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, "Unique name of the hierarchy. If the member belongs to more than one hierarchy, there is one row for each hierarchy to which it belongs.");
        private static final Column LevelUniqueName = new Column("LEVEL_UNIQUE_NAME", Type.String, null, true, false, " Unique name of the level to which the member belongs.");
        private static final Column LevelNumber = new Column("LEVEL_NUMBER", Type.UnsignedInteger, null, true, false, "The distance of the member from the root of the hierarchy.");
        private static final Column MemberOrdinal = new Column("MEMBER_ORDINAL", Type.UnsignedInteger, null, false, false, "Ordinal number of the member. Sort rank of the member when members of this dimension are sorted in their natural sort order. If providers do not have the concept of natural ordering, this should be the rank when sorted by MEMBER_NAME.");
        private static final Column MemberName = new Column("MEMBER_NAME", Type.String, null, true, false, "Name of the member.");
        private static final Column MemberUniqueName = new Column("MEMBER_UNIQUE_NAME", Type.String, null, true, false, " Unique name of the member.");
        private static final Column MemberType = new Column("MEMBER_TYPE", Type.Integer, null, true, false, "Type of the member.");
        private static final Column MemberGuid = new Column("MEMBER_GUID", Type.UUID, null, false, true, "Memeber GUID.");
        private static final Column MemberCaption = new Column("MEMBER_CAPTION", Type.String, null, true, false, "A label or caption associated with the member.");
        private static final Column ChildrenCardinality = new Column("CHILDREN_CARDINALITY", Type.UnsignedInteger, null, false, false, "Number of children that the member has.");
        private static final Column ParentLevel = new Column("PARENT_LEVEL", Type.UnsignedInteger, null, false, false, "The distance of the member's parent from the root level of the hierarchy. ");
        private static final Column ParentUniqueName = new Column("PARENT_UNIQUE_NAME", Type.String, null, false, true, "Unique name of the member's parent.");
        private static final Column ParentCount = new Column("PARENT_COUNT", Type.UnsignedInteger, null, false, false, "Number of parents that this member has.");
        private static final Column TreeOp = new Column("TREE_OP", Type.Enumeration, Enumeration.TreeOp.enumeration, true, true, "Tree Operation");
        private static final Column Depth = new Column("DEPTH", Type.Integer, null, false, true, "depth");

        MdschemaMembersRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_MEMBERS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.Catalog[] catalogs;
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            String roleStr = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs = this.handler.getCatalogs(this.request, ds)) {
                String catalogName;
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null || !this.schemaNameRT.passes(catalogName = dsCatalog.name)) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                this.populateCatalog(connection, role, catalogName, rows);
            }
        }

        protected void populateCatalog(Connection connection, Role role, String catalogName, List<Rowset.Row> rows) throws XmlaException {
            for (Cube cube : RowsetDefinition.sortedCubes(connection.getSchema())) {
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                SchemaReader schemaReader = cube.getSchemaReader(role);
                this.populateCube(schemaReader, catalogName, cube, rows);
            }
        }

        protected void populateCube(SchemaReader schemaReader, String catalogName, Cube cube, List<Rowset.Row> rows) throws XmlaException {
            if (this.isRestricted(MemberUniqueName)) {
                this.outputUniqueMemberName(schemaReader, catalogName, cube, rows);
            } else if (this.isRestricted(LevelUniqueName)) {
                Level[] levels;
                String levelUniqueName = this.getRestrictionValueAsString(LevelUniqueName);
                if (levelUniqueName == null) {
                    return;
                }
                String[] nameParts = Util.explode(levelUniqueName);
                Hierarchy hier = cube.lookupHierarchy(nameParts[0], false);
                if (hier == null) {
                    return;
                }
                for (Level level : levels = hier.getLevels()) {
                    if (!level.getUniqueName().equals(levelUniqueName)) continue;
                    Member[] members = cube.getSchemaReader(null).getLevelMembers(level, true);
                    this.outputMembers(schemaReader, members, catalogName, cube, rows);
                }
            } else {
                for (Dimension dimension : cube.getDimensions()) {
                    String uniqueName = dimension.getUniqueName();
                    if (!this.dimensionUniqueNameRT.passes(uniqueName)) continue;
                    this.populateDimension(schemaReader, catalogName, cube, dimension, rows);
                }
            }
        }

        protected void populateDimension(SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, List<Rowset.Row> rows) throws XmlaException {
            Hierarchy[] hierarchies;
            for (Hierarchy hierarchy : hierarchies = dimension.getHierarchies()) {
                String uniqueName = hierarchy.getUniqueName();
                if (!this.hierarchyUniqueNameRT.passes(uniqueName)) continue;
                this.populateHierarchy(schemaReader, catalogName, cube, hierarchy, rows);
            }
        }

        protected void populateHierarchy(SchemaReader schemaReader, String catalogName, Cube cube, Hierarchy hierarchy, List<Rowset.Row> rows) throws XmlaException {
            if (this.isRestricted(LevelNumber)) {
                int levelNumber = this.getRestrictionValueAsInt(LevelNumber);
                if (levelNumber == -1) {
                    LOGGER.warn((Object)"RowsetDefinition.populateHierarchy: LevelNumber invalid");
                    return;
                }
                Level[] levels = hierarchy.getLevels();
                if (levelNumber >= levels.length) {
                    LOGGER.warn((Object)("RowsetDefinition.populateHierarchy: LevelNumber (" + levelNumber + ") is greater than number of levels (" + levels.length + ") for hierarchy \"" + hierarchy.getUniqueName() + "\""));
                    return;
                }
                Level level = levels[levelNumber];
                Member[] members = schemaReader.getLevelMembers(level, false);
                this.outputMembers(schemaReader, members, catalogName, cube, rows);
            } else {
                Member[][] membersArray;
                for (Member[] members : membersArray = RolapMember.getAllMembers(schemaReader, hierarchy)) {
                    this.outputMembers(schemaReader, members, catalogName, cube, rows);
                }
            }
        }

        private static boolean mask(int value, int mask) {
            return (value & mask) == mask;
        }

        private void populateMember(SchemaReader schemaReader, String catalogName, Cube cube, Member member, int treeOp, List<Rowset.Row> rows) {
            Member[] children;
            Member parent;
            if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Self.userOrdinal())) {
                this.outputMember(schemaReader, member, catalogName, cube, rows);
            }
            if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Siblings.userOrdinal())) {
                Member[] siblings;
                parent = schemaReader.getMemberParent(member);
                for (Member sibling : siblings = parent == null ? schemaReader.getHierarchyRootMembers(member.getHierarchy()) : schemaReader.getMemberChildren(parent)) {
                    if (sibling == member) continue;
                    this.populateMember(schemaReader, catalogName, cube, sibling, Enumeration.TreeOp.Self.userOrdinal(), rows);
                }
            }
            if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Descendants.userOrdinal())) {
                for (Member child : children = schemaReader.getMemberChildren(member)) {
                    this.populateMember(schemaReader, catalogName, cube, child, Enumeration.TreeOp.Self.userOrdinal() | Enumeration.TreeOp.Descendants.userOrdinal(), rows);
                }
            } else if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Children.userOrdinal())) {
                for (Member child : children = schemaReader.getMemberChildren(member)) {
                    this.populateMember(schemaReader, catalogName, cube, child, Enumeration.TreeOp.Self.userOrdinal(), rows);
                }
            }
            if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Ancestors.userOrdinal())) {
                parent = schemaReader.getMemberParent(member);
                if (parent != null) {
                    this.populateMember(schemaReader, catalogName, cube, parent, Enumeration.TreeOp.Self.userOrdinal() | Enumeration.TreeOp.Ancestors.userOrdinal(), rows);
                }
            } else if (MdschemaMembersRowset.mask(treeOp, Enumeration.TreeOp.Parent.userOrdinal()) && (parent = schemaReader.getMemberParent(member)) != null) {
                this.populateMember(schemaReader, catalogName, cube, parent, Enumeration.TreeOp.Self.userOrdinal(), rows);
            }
        }

        @Override
        protected ArrayList<Column> pruneRestrictions(ArrayList<Column> list) {
            if (list.contains(TreeOp)) {
                list.remove(TreeOp);
                list.remove(MemberUniqueName);
            }
            return list;
        }

        private void outputMembers(SchemaReader schemaReader, Member[] members, String catalogName, Cube cube, List<Rowset.Row> rows) {
            for (Member member : members) {
                this.outputMember(schemaReader, member, catalogName, cube, rows);
            }
        }

        private void outputUniqueMemberName(SchemaReader schemaReader, String catalogName, Cube cube, List<Rowset.Row> rows) {
            String memberUniqueName = this.getRestrictionValueAsString(MemberUniqueName);
            if (memberUniqueName == null) {
                return;
            }
            String[] nameParts = Util.explode(memberUniqueName);
            Member member = schemaReader.getMemberByUniqueName(nameParts, false);
            if (member == null) {
                return;
            }
            if (this.isRestricted(TreeOp)) {
                int treeOp = this.getRestrictionValueAsInt(TreeOp);
                if (treeOp == -1) {
                    return;
                }
                this.populateMember(schemaReader, catalogName, cube, member, treeOp, rows);
            } else {
                this.outputMember(schemaReader, member, catalogName, cube, rows);
            }
        }

        private void outputMember(SchemaReader schemaReader, Member member, String catalogName, Cube cube, List<Rowset.Row> rows) {
            Boolean isVisible;
            if (!RowsetDefinition.canAccess(schemaReader, member)) {
                return;
            }
            if (!this.memberNameRT.passes(member.getName())) {
                return;
            }
            if (!this.memberTypeRT.passes((Object)member.getMemberType())) {
                return;
            }
            if (member.getOrdinal() == -1) {
                RolapMember.setOrdinals(schemaReader, member);
            }
            if ((isVisible = (Boolean)member.getPropertyValue(Property.VISIBLE.name)) != null && !isVisible.booleanValue()) {
                return;
            }
            Level level = member.getLevel();
            Hierarchy hierarchy = level.getHierarchy();
            Dimension dimension = hierarchy.getDimension();
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaMembersRowset.CatalogName.name, catalogName);
            row.set(MdschemaMembersRowset.SchemaName.name, catalogName);
            row.set(MdschemaMembersRowset.CubeName.name, cube.getName());
            row.set(MdschemaMembersRowset.DimensionUniqueName.name, dimension.getUniqueName());
            row.set(MdschemaMembersRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
            row.set(MdschemaMembersRowset.LevelUniqueName.name, level.getUniqueName());
            row.set(MdschemaMembersRowset.LevelNumber.name, level.getDepth());
            row.set(MdschemaMembersRowset.MemberOrdinal.name, member.getOrdinal());
            row.set(MdschemaMembersRowset.MemberName.name, member.getName());
            row.set(MdschemaMembersRowset.MemberUniqueName.name, member.getUniqueName());
            row.set(MdschemaMembersRowset.MemberType.name, member.getMemberType().ordinal());
            row.set(MdschemaMembersRowset.MemberCaption.name, member.getCaption());
            row.set(MdschemaMembersRowset.ChildrenCardinality.name, member.getPropertyValue(Property.CHILDREN_CARDINALITY.name));
            row.set(MdschemaMembersRowset.ChildrenCardinality.name, 100);
            row.set(MdschemaMembersRowset.ParentLevel.name, member.getParentMember() == null ? 0 : member.getParentMember().getDepth());
            String parentUniqueName = member.getParentUniqueName();
            if (parentUniqueName != null) {
                row.set(MdschemaMembersRowset.ParentUniqueName.name, parentUniqueName);
            }
            row.set(MdschemaMembersRowset.ParentCount.name, member.getParentMember() == null ? 0 : 1);
            row.set(MdschemaMembersRowset.Depth.name, member.getDepth());
            this.addRow(row, rows);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$17500() {
            return CatalogName;
        }

        static /* synthetic */ Column access$17600() {
            return SchemaName;
        }

        static /* synthetic */ Column access$17700() {
            return CubeName;
        }

        static /* synthetic */ Column access$17800() {
            return DimensionUniqueName;
        }

        static /* synthetic */ Column access$17900() {
            return HierarchyUniqueName;
        }

        static /* synthetic */ Column access$18000() {
            return LevelUniqueName;
        }

        static /* synthetic */ Column access$18100() {
            return LevelNumber;
        }

        static /* synthetic */ Column access$18200() {
            return MemberOrdinal;
        }

        static /* synthetic */ Column access$18300() {
            return MemberName;
        }

        static /* synthetic */ Column access$18400() {
            return MemberUniqueName;
        }

        static /* synthetic */ Column access$18500() {
            return MemberType;
        }

        static /* synthetic */ Column access$18600() {
            return MemberGuid;
        }

        static /* synthetic */ Column access$18700() {
            return MemberCaption;
        }

        static /* synthetic */ Column access$18800() {
            return ChildrenCardinality;
        }

        static /* synthetic */ Column access$18900() {
            return ParentLevel;
        }

        static /* synthetic */ Column access$19000() {
            return ParentUniqueName;
        }

        static /* synthetic */ Column access$19100() {
            return ParentCount;
        }

        static /* synthetic */ Column access$19200() {
            return TreeOp;
        }

        static /* synthetic */ Column access$19300() {
            return Depth;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaMeasuresRowset
    extends Rowset {
        public static final int MDMEASURE_AGGR_UNKNOWN = 0;
        public static final int MDMEASURE_AGGR_SUM = 1;
        public static final int MDMEASURE_AGGR_COUNT = 2;
        public static final int MDMEASURE_AGGR_MIN = 3;
        public static final int MDMEASURE_AGGR_MAX = 4;
        public static final int MDMEASURE_AGGR_AVG = 5;
        public static final int MDMEASURE_AGGR_VAR = 6;
        public static final int MDMEASURE_AGGR_STD = 7;
        public static final int MDMEASURE_AGGR_CALCULATED = 127;
        private final Rowset.RestrictionTest schemaNameRT = this.getRestrictionTest(SchemaName);
        private final Rowset.RestrictionTest cubeNameRT = this.getRestrictionTest(CubeName);
        private final Rowset.RestrictionTest measureUniqueNameRT;
        private final Rowset.RestrictionTest measureNameRT = this.getRestrictionTest(MeasureName);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this measure belongs. ");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this measure belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube to which this measure belongs.");
        private static final Column MeasureName = new Column("MEASURE_NAME", Type.String, null, true, false, "The name of the measure.");
        private static final Column MeasureUniqueName = new Column("MEASURE_UNIQUE_NAME", Type.String, null, true, false, "The Unique name of the measure.");
        private static final Column MeasureCaption = new Column("MEASURE_CAPTION", Type.String, null, false, false, "A label or caption associated with the measure. ");
        private static final Column MeasureGuid = new Column("MEASURE_GUID", Type.UUID, null, false, true, "Measure GUID.");
        private static final Column MeasureAggregator = new Column("MEASURE_AGGREGATOR", Type.Integer, null, false, false, "How a measure was derived. ");
        private static final Column DataType = new Column("DATA_TYPE", Type.UnsignedShort, null, false, false, "Data type of the measure.");
        private static final Column MeasureIsVisible = new Column("MEASURE_IS_VISIBLE", Type.Boolean, null, false, false, "A Boolean that always returns True. If the measure is not visible, it will not be included in the schema rowset.");
        private static final Column LevelsList = new Column("LEVELS_LIST", Type.String, null, false, true, "A string that always returns NULL. EXCEPT that SQL Server returns non-null values!!!");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the measure. ");

        MdschemaMeasuresRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_MEASURES, request, handler);
            this.measureUniqueNameRT = this.getRestrictionTest(MeasureUniqueName);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.Catalog[] catalogs;
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            String roleStr = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs = this.handler.getCatalogs(this.request, ds)) {
                String catalogName;
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null || !this.schemaNameRT.passes(catalogName = dsCatalog.name)) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                this.populateCatalog(connection, role, catalogName, rows);
            }
        }

        protected void populateCatalog(Connection connection, Role role, String catalogName, List<Rowset.Row> rows) throws XmlaException {
            StringBuilder buf = new StringBuilder(100);
            for (Cube cube : RowsetDefinition.sortedCubes(connection.getSchema())) {
                Member[] storedMembers;
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                SchemaReader schemaReader = cube.getSchemaReader(role);
                Dimension measuresDimension = cube.getDimensions()[0];
                Hierarchy measuresHierarchy = measuresDimension.getHierarchies()[0];
                Level measuresLevel = measuresHierarchy.getLevels()[0];
                buf.setLength(0);
                int j = 0;
                for (Dimension dimension : cube.getDimensions()) {
                    if (dimension.isMeasures()) continue;
                    for (Hierarchy hierarchy : dimension.getHierarchies()) {
                        Level[] levels = hierarchy.getLevels();
                        Level lastLevel = levels[levels.length - 1];
                        if (j++ > 0) {
                            buf.append(',');
                        }
                        buf.append(lastLevel.getUniqueName());
                    }
                }
                String levelListStr = buf.toString();
                for (Member member : storedMembers = schemaReader.getLevelMembers(measuresLevel, false)) {
                    String name = member.getName();
                    String unique = member.getUniqueName();
                    if (!this.measureNameRT.passes(name) || !this.measureUniqueNameRT.passes(unique)) continue;
                    this.populateMember(schemaReader, catalogName, member, cube, levelListStr, rows);
                }
                for (Member member : schemaReader.getCalculatedMembers(measuresHierarchy)) {
                    String name = member.getName();
                    String unique = member.getUniqueName();
                    if (!this.measureNameRT.passes(name) || !this.measureUniqueNameRT.passes(unique)) continue;
                    this.populateMember(schemaReader, catalogName, member, cube, null, rows);
                }
            }
        }

        private void populateMember(SchemaReader schemaReader, String catalogName, Member member, Cube cube, String levelListStr, List<Rowset.Row> rows) {
            MemberBase mb;
            Boolean isVisible;
            if (!RowsetDefinition.canAccess(schemaReader, member)) {
                return;
            }
            if (member instanceof MemberBase && (isVisible = (Boolean)(mb = (MemberBase)member).getPropertyValue(Property.VISIBLE.name)) != null && !isVisible.booleanValue()) {
                return;
            }
            String desc = member.getDescription();
            if (desc == null) {
                desc = cube.getName() + " Cube - " + member.getName() + " Member";
            }
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaMeasuresRowset.CatalogName.name, catalogName);
            row.set(MdschemaMeasuresRowset.CubeName.name, cube.getName());
            row.set(MdschemaMeasuresRowset.MeasureName.name, member.getName());
            row.set(MdschemaMeasuresRowset.MeasureUniqueName.name, member.getUniqueName());
            row.set(MdschemaMeasuresRowset.MeasureCaption.name, member.getCaption());
            Object aggProp = member.getPropertyValue(Property.AGGREGATION_TYPE.getName());
            int aggNumber = 0;
            if (aggProp != null) {
                RolapAggregator agg = (RolapAggregator)aggProp;
                if (agg == RolapAggregator.Sum) {
                    aggNumber = 1;
                } else if (agg == RolapAggregator.Count) {
                    aggNumber = 2;
                } else if (agg == RolapAggregator.Min) {
                    aggNumber = 3;
                } else if (agg == RolapAggregator.Max) {
                    aggNumber = 4;
                } else if (agg == RolapAggregator.Avg) {
                    aggNumber = 5;
                }
            } else {
                aggNumber = 127;
            }
            row.set(MdschemaMeasuresRowset.MeasureAggregator.name, aggNumber);
            int dbType = DBType.WSTR.userOrdinal;
            String datatype = (String)member.getPropertyValue(Property.DATATYPE.getName());
            if (datatype != null) {
                dbType = datatype.equals("Integer") ? DBType.I4.userOrdinal : (datatype.equals("Numeric") ? DBType.R8.userOrdinal : DBType.WSTR.userOrdinal);
            }
            row.set(MdschemaMeasuresRowset.DataType.name, dbType);
            row.set(MdschemaMeasuresRowset.MeasureIsVisible.name, true);
            if (levelListStr != null) {
                row.set(MdschemaMeasuresRowset.LevelsList.name, levelListStr);
            }
            row.set(MdschemaMeasuresRowset.Description.name, desc);
            this.addRow(row, rows);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$16300() {
            return CatalogName;
        }

        static /* synthetic */ Column access$16400() {
            return SchemaName;
        }

        static /* synthetic */ Column access$16500() {
            return CubeName;
        }

        static /* synthetic */ Column access$16600() {
            return MeasureName;
        }

        static /* synthetic */ Column access$16700() {
            return MeasureUniqueName;
        }

        static /* synthetic */ Column access$16800() {
            return MeasureCaption;
        }

        static /* synthetic */ Column access$16900() {
            return MeasureGuid;
        }

        static /* synthetic */ Column access$17000() {
            return MeasureAggregator;
        }

        static /* synthetic */ Column access$17100() {
            return DataType;
        }

        static /* synthetic */ Column access$17200() {
            return MeasureIsVisible;
        }

        static /* synthetic */ Column access$17300() {
            return LevelsList;
        }

        static /* synthetic */ Column access$17400() {
            return Description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaLevelsRowset
    extends Rowset {
        private final Rowset.RestrictionTest schemaNameRT = this.getRestrictionTest(SchemaName);
        private final Rowset.RestrictionTest cubeNameRT = this.getRestrictionTest(CubeName);
        private final Rowset.RestrictionTest dimensionUniqueNameRT = this.getRestrictionTest(DimensionUniqueName);
        private final Rowset.RestrictionTest hierarchyUniqueNameRT = this.getRestrictionTest(HierarchyUniqueName);
        private final Rowset.RestrictionTest levelUniqueNameRT = this.getRestrictionTest(LevelUniqueName);
        private final Rowset.RestrictionTest levelNameRT = this.getRestrictionTest(LevelName);
        public static final int MDLEVEL_TYPE_UNKNOWN = 0;
        public static final int MDLEVEL_TYPE_REGULAR = 0;
        public static final int MDLEVEL_TYPE_ALL = 1;
        public static final int MDLEVEL_TYPE_CALCULATED = 2;
        public static final int MDLEVEL_TYPE_TIME = 4;
        public static final int MDLEVEL_TYPE_RESERVED1 = 8;
        public static final int MDLEVEL_TYPE_TIME_YEARS = 20;
        public static final int MDLEVEL_TYPE_TIME_HALF_YEAR = 36;
        public static final int MDLEVEL_TYPE_TIME_QUARTERS = 68;
        public static final int MDLEVEL_TYPE_TIME_MONTHS = 132;
        public static final int MDLEVEL_TYPE_TIME_WEEKS = 260;
        public static final int MDLEVEL_TYPE_TIME_DAYS = 516;
        public static final int MDLEVEL_TYPE_TIME_HOURS = 772;
        public static final int MDLEVEL_TYPE_TIME_MINUTES = 1028;
        public static final int MDLEVEL_TYPE_TIME_SECONDS = 2052;
        public static final int MDLEVEL_TYPE_TIME_UNDEFINED = 4100;
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this level belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this level belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube to which this level belongs.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the dimension to which this level belongs.");
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the hierarchy.");
        private static final Column LevelName = new Column("LEVEL_NAME", Type.String, null, true, false, "The name of the level.");
        private static final Column LevelUniqueName = new Column("LEVEL_UNIQUE_NAME", Type.String, null, true, false, "The properly escaped unique name of the level.");
        private static final Column LevelGuid = new Column("LEVEL_GUID", Type.UUID, null, false, true, "Level GUID.");
        private static final Column LevelCaption = new Column("LEVEL_CAPTION", Type.String, null, false, false, "A label or caption associated with the hierarchy.");
        private static final Column LevelNumber = new Column("LEVEL_NUMBER", Type.UnsignedInteger, null, false, false, "The distance of the level from the root of the hierarchy. Root level is zero (0).");
        private static final Column LevelCardinality = new Column("LEVEL_CARDINALITY", Type.UnsignedInteger, null, false, false, "The number of members in the level. This value can be an approximation of the real cardinality.");
        private static final Column LevelType = new Column("LEVEL_TYPE", Type.Integer, null, false, false, "Type of the level");
        private static final Column CustomRollupSettings = new Column("CUSTOM_ROLLUP_SETTINGS", Type.Integer, null, false, false, "A bitmap that specifies the custom rollup options.");
        private static final Column LevelUniqueSettings = new Column("LEVEL_UNIQUE_SETTINGS", Type.Integer, null, false, false, "A bitmap that specifies which columns contain unique values, if the level only has members with unique names or keys.");
        private static final Column LevelIsVisible = new Column("LEVEL_IS_VISIBLE", Type.Boolean, null, false, false, "A Boolean that indicates whether the level is visible.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the level. NULL if no description exists.");

        MdschemaLevelsRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_LEVELS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.Catalog[] catalogs;
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            String roleStr = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs = this.handler.getCatalogs(this.request, ds)) {
                Connection connection;
                String catalogName;
                if (dsCatalog == null || dsCatalog.definition == null || !this.schemaNameRT.passes(catalogName = dsCatalog.name) || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                this.populateCatalog(connection, role, catalogName, rows);
            }
        }

        protected void populateCatalog(Connection connection, Role role, String catalogName, List<Rowset.Row> rows) throws XmlaException {
            for (Cube cube : RowsetDefinition.sortedCubes(connection.getSchema())) {
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                SchemaReader schemaReader = cube.getSchemaReader(role);
                this.populateCube(schemaReader, catalogName, cube, rows);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void populateCube(SchemaReader schemaReader, String catalogName, Cube cube, List<Rowset.Row> rows) throws XmlaException {
            for (Dimension dimension : cube.getDimensions()) {
                String uniqueName = dimension.getUniqueName();
                if (!this.dimensionUniqueNameRT.passes(uniqueName)) continue;
                this.populateDimension(schemaReader, catalogName, cube, dimension, rows);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void populateDimension(SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, List<Rowset.Row> rows) throws XmlaException {
            Hierarchy[] hierarchies;
            for (Hierarchy hierarchy : hierarchies = dimension.getHierarchies()) {
                String uniqueName = hierarchy.getUniqueName();
                if (!this.hierarchyUniqueNameRT.passes(uniqueName)) continue;
                this.populateHierarchy(schemaReader, catalogName, cube, hierarchy, rows);
            }
        }

        protected void populateHierarchy(SchemaReader schemaReader, String catalogName, Cube cube, Hierarchy hierarchy, List<Rowset.Row> rows) throws XmlaException {
            Level[] levels;
            for (Level level : levels = hierarchy.getLevels()) {
                String uniqueName = level.getUniqueName();
                String name = level.getName();
                if (!this.levelUniqueNameRT.passes(uniqueName) || !this.levelNameRT.passes(name)) continue;
                this.outputLevel(schemaReader, catalogName, cube, hierarchy, level, rows);
            }
        }

        protected void outputLevel(SchemaReader schemaReader, String catalogName, Cube cube, Hierarchy hierarchy, Level level, List<Rowset.Row> rows) throws XmlaException {
            if (!RowsetDefinition.canAccess(schemaReader, level)) {
                return;
            }
            String desc = level.getDescription();
            if (desc == null) {
                desc = cube.getName() + " Cube - " + hierarchy.getName() + " Hierarchy" + level.getName() + " Level";
            }
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaLevelsRowset.CatalogName.name, catalogName);
            row.set(MdschemaLevelsRowset.SchemaName.name, catalogName);
            row.set(MdschemaLevelsRowset.CubeName.name, cube.getName());
            row.set(MdschemaLevelsRowset.DimensionUniqueName.name, hierarchy.getDimension().getUniqueName());
            row.set(MdschemaLevelsRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
            row.set(MdschemaLevelsRowset.LevelName.name, level.getName());
            row.set(MdschemaLevelsRowset.LevelUniqueName.name, level.getUniqueName());
            row.set(MdschemaLevelsRowset.LevelCaption.name, level.getCaption());
            row.set(MdschemaLevelsRowset.LevelNumber.name, level.getDepth());
            int n = schemaReader.getLevelCardinality(level, true, true);
            row.set(MdschemaLevelsRowset.LevelCardinality.name, n);
            row.set(MdschemaLevelsRowset.LevelType.name, this.getLevelType(level));
            row.set(MdschemaLevelsRowset.CustomRollupSettings.name, 0);
            if (level instanceof RolapLevel) {
                RolapLevel rl = (RolapLevel)level;
                row.set(MdschemaLevelsRowset.LevelUniqueSettings.name, (rl.isUnique() ? 1 : 0) + (rl.isAll() ? 2 : 0));
            } else {
                row.set(MdschemaLevelsRowset.LevelUniqueSettings.name, level.isAll() ? 2 : 0);
            }
            row.set(MdschemaLevelsRowset.LevelIsVisible.name, true);
            row.set(MdschemaLevelsRowset.Description.name, desc);
            this.addRow(row, rows);
        }

        private int getLevelType(Level lev) {
            int ret = 0;
            if (lev.isAll()) {
                ret |= 1;
            }
            LevelType type = lev.getLevelType();
            switch (type) {
                case Regular: {
                    ret |= 0;
                    break;
                }
                case TimeDays: {
                    ret |= 0x204;
                    break;
                }
                case TimeMonths: {
                    ret |= 0x84;
                    break;
                }
                case TimeQuarters: {
                    ret |= 0x44;
                    break;
                }
                case TimeWeeks: {
                    ret |= 0x104;
                    break;
                }
                case TimeYears: {
                    ret |= 0x14;
                    break;
                }
                default: {
                    ret |= 0;
                }
            }
            return ret;
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$14700() {
            return CatalogName;
        }

        static /* synthetic */ Column access$14800() {
            return SchemaName;
        }

        static /* synthetic */ Column access$14900() {
            return CubeName;
        }

        static /* synthetic */ Column access$15000() {
            return DimensionUniqueName;
        }

        static /* synthetic */ Column access$15100() {
            return HierarchyUniqueName;
        }

        static /* synthetic */ Column access$15200() {
            return LevelName;
        }

        static /* synthetic */ Column access$15300() {
            return LevelUniqueName;
        }

        static /* synthetic */ Column access$15400() {
            return LevelGuid;
        }

        static /* synthetic */ Column access$15500() {
            return LevelCaption;
        }

        static /* synthetic */ Column access$15600() {
            return LevelNumber;
        }

        static /* synthetic */ Column access$15700() {
            return LevelCardinality;
        }

        static /* synthetic */ Column access$15800() {
            return LevelType;
        }

        static /* synthetic */ Column access$15900() {
            return CustomRollupSettings;
        }

        static /* synthetic */ Column access$16000() {
            return LevelUniqueSettings;
        }

        static /* synthetic */ Column access$16100() {
            return LevelIsVisible;
        }

        static /* synthetic */ Column access$16200() {
            return Description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaHierarchiesRowset
    extends Rowset {
        private final Rowset.RestrictionTest schemaNameRT = this.getRestrictionTest(SchemaName);
        private final Rowset.RestrictionTest cubeNameRT = this.getRestrictionTest(CubeName);
        private final Rowset.RestrictionTest dimensionUniqueNameRT = this.getRestrictionTest(DimensionUniqueName);
        private final Rowset.RestrictionTest hierarchyUniqueNameRT = this.getRestrictionTest(HierarchyUniqueName);
        private final Rowset.RestrictionTest hierarchyNameRT = this.getRestrictionTest(HierarchyName);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this hierarchy belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "Not supported");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube to which this hierarchy belongs.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the dimension to which this hierarchy belongs. ");
        private static final Column HierarchyName = new Column("HIERARCHY_NAME", Type.String, null, true, false, "The name of the hierarchy. Blank if there is only a single hierarchy in the dimension.");
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the hierarchy.");
        private static final Column HierarchyGuid = new Column("HIERARCHY_GUID", Type.UUID, null, false, true, "Hierarchy GUID.");
        private static final Column HierarchyCaption = new Column("HIERARCHY_CAPTION", Type.String, null, false, false, "A label or a caption associated with the hierarchy.");
        private static final Column DimensionType = new Column("DIMENSION_TYPE", Type.Short, null, false, false, "The type of the dimension. ");
        private static final Column HierarchyCardinality = new Column("HIERARCHY_CARDINALITY", Type.UnsignedInteger, null, false, false, "The number of members in the hierarchy.");
        private static final Column DefaultMember = new Column("DEFAULT_MEMBER", Type.String, null, false, true, "The default member for this hierarchy. ");
        private static final Column AllMember = new Column("ALL_MEMBER", Type.String, null, false, true, "The member at the highest level of rollup in the hierarchy.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the hierarchy. NULL if no description exists.");
        private static final Column Structure = new Column("STRUCTURE", Type.Short, null, false, false, "The structure of the hierarchy.");
        private static final Column IsVirtual = new Column("IS_VIRTUAL", Type.Boolean, null, false, false, "Always returns False.");
        private static final Column IsReadWrite = new Column("IS_READWRITE", Type.Boolean, null, false, false, "A Boolean that indicates whether the Write Back to dimension column is enabled.");
        private static final Column DimensionUniqueSettings = new Column("DIMENSION_UNIQUE_SETTINGS", Type.Integer, null, false, false, "Always returns MDDIMENSIONS_MEMBER_KEY_UNIQUE (1).");
        private static final Column DimensionIsVisible = new Column("DIMENSION_IS_VISIBLE", Type.Boolean, null, false, false, "Always returns true.");
        private static final Column HierarchyOrdinal = new Column("HIERARCHY_ORDINAL", Type.UnsignedInteger, null, false, false, "The ordinal number of the hierarchy across all hierarchies of the cube.");
        private static final Column DimensionIsShared = new Column("DIMENSION_IS_SHARED", Type.Boolean, null, false, false, "Always returns true.");
        private static final Column ParentChild = new Column("PARENT_CHILD", Type.Boolean, null, false, true, "Is hierarchy a parent.");

        MdschemaHierarchiesRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_HIERARCHIES, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.Catalog[] catalogs;
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            String roleStr = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs = this.handler.getCatalogs(this.request, ds)) {
                Connection connection;
                String catalogName;
                if (dsCatalog == null || dsCatalog.definition == null || !this.schemaNameRT.passes(catalogName = dsCatalog.name) || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                this.populateCatalog(connection, role, catalogName, rows);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void populateCatalog(Connection connection, Role role, String catalogName, List<Rowset.Row> rows) throws XmlaException {
            for (Cube cube : RowsetDefinition.sortedCubes(connection.getSchema())) {
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                SchemaReader schemaReader = cube.getSchemaReader(role);
                this.populateCube(schemaReader, catalogName, cube, rows);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void populateCube(SchemaReader schemaReader, String catalogName, Cube cube, List<Rowset.Row> rows) throws XmlaException {
            int ordinal = 0;
            for (Dimension dimension : cube.getDimensions()) {
                String unique = dimension.getUniqueName();
                boolean genOutput = this.dimensionUniqueNameRT.passes(unique);
                ordinal = this.populateDimension(genOutput, schemaReader, catalogName, cube, dimension, ordinal, rows);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int populateDimension(boolean genOutput, SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, int ordinal, List<Rowset.Row> rows) throws XmlaException {
            Hierarchy[] hierarchies;
            for (Hierarchy hierarchy : hierarchies = dimension.getHierarchies()) {
                if (genOutput) {
                    String unique = hierarchy.getUniqueName();
                    if (this.hierarchyNameRT.passes(hierarchy.getName()) && this.hierarchyUniqueNameRT.passes(unique)) {
                        this.populateHierarchy(schemaReader, catalogName, cube, dimension, (HierarchyBase)hierarchy, ordinal++, rows);
                        continue;
                    }
                    ++ordinal;
                    continue;
                }
                ++ordinal;
            }
            int n = ordinal;
            return n;
        }

        protected void populateHierarchy(SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, HierarchyBase hierarchy, int ordinal, List<Rowset.Row> rows) throws XmlaException {
            if (!RowsetDefinition.canAccess(schemaReader, hierarchy)) {
                return;
            }
            String desc = hierarchy.getDescription();
            if (desc == null) {
                desc = cube.getName() + " Cube - " + hierarchy.getName() + " Hierarchy";
            }
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaHierarchiesRowset.CatalogName.name, catalogName);
            row.set(MdschemaHierarchiesRowset.CubeName.name, cube.getName());
            row.set(MdschemaHierarchiesRowset.DimensionUniqueName.name, dimension.getUniqueName());
            row.set(MdschemaHierarchiesRowset.HierarchyName.name, hierarchy.getName());
            row.set(MdschemaHierarchiesRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
            row.set(MdschemaHierarchiesRowset.HierarchyCaption.name, hierarchy.getCaption());
            row.set(MdschemaHierarchiesRowset.DimensionType.name, RowsetDefinition.getDimensionType(dimension));
            int cardinality = RolapMember.getHierarchyCardinality(schemaReader, hierarchy);
            row.set(MdschemaHierarchiesRowset.HierarchyCardinality.name, cardinality);
            row.set(MdschemaHierarchiesRowset.DefaultMember.name, hierarchy.getDefaultMember());
            if (hierarchy.hasAll()) {
                row.set(MdschemaHierarchiesRowset.AllMember.name, Util.makeFqName(hierarchy, hierarchy.getAllMemberName()));
            }
            row.set(MdschemaHierarchiesRowset.Description.name, desc);
            row.set(MdschemaHierarchiesRowset.Structure.name, hierarchy.isRagged() ? 1 : 0);
            row.set(MdschemaHierarchiesRowset.IsVirtual.name, false);
            row.set(MdschemaHierarchiesRowset.IsReadWrite.name, false);
            row.set(MdschemaHierarchiesRowset.DimensionUniqueSettings.name, 0);
            row.set(MdschemaHierarchiesRowset.DimensionIsVisible.name, true);
            row.set(MdschemaHierarchiesRowset.HierarchyOrdinal.name, ordinal);
            row.set(MdschemaHierarchiesRowset.DimensionIsShared.name, true);
            RolapLevel nonAllFirstLevel = (RolapLevel)hierarchy.getLevels()[hierarchy.hasAll() ? 1 : 0];
            row.set(MdschemaHierarchiesRowset.ParentChild.name, nonAllFirstLevel.isParentChild());
            this.addRow(row, rows);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$12600() {
            return CatalogName;
        }

        static /* synthetic */ Column access$12700() {
            return SchemaName;
        }

        static /* synthetic */ Column access$12800() {
            return CubeName;
        }

        static /* synthetic */ Column access$12900() {
            return DimensionUniqueName;
        }

        static /* synthetic */ Column access$13000() {
            return HierarchyName;
        }

        static /* synthetic */ Column access$13100() {
            return HierarchyUniqueName;
        }

        static /* synthetic */ Column access$13200() {
            return HierarchyGuid;
        }

        static /* synthetic */ Column access$13300() {
            return HierarchyCaption;
        }

        static /* synthetic */ Column access$13400() {
            return DimensionType;
        }

        static /* synthetic */ Column access$13500() {
            return HierarchyCardinality;
        }

        static /* synthetic */ Column access$13600() {
            return DefaultMember;
        }

        static /* synthetic */ Column access$13700() {
            return AllMember;
        }

        static /* synthetic */ Column access$13800() {
            return Description;
        }

        static /* synthetic */ Column access$13900() {
            return Structure;
        }

        static /* synthetic */ Column access$14000() {
            return IsVirtual;
        }

        static /* synthetic */ Column access$14100() {
            return IsReadWrite;
        }

        static /* synthetic */ Column access$14200() {
            return DimensionUniqueSettings;
        }

        static /* synthetic */ Column access$14300() {
            return DimensionIsVisible;
        }

        static /* synthetic */ Column access$14400() {
            return HierarchyOrdinal;
        }

        static /* synthetic */ Column access$14500() {
            return DimensionIsShared;
        }

        static /* synthetic */ Column access$14600() {
            return ParentChild;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaFunctionsRowset
    extends Rowset {
        private final Rowset.RestrictionTest functionNameRT = this.getRestrictionTest(FunctionName);
        private static final Column FunctionName = new Column("FUNCTION_NAME", Type.String, null, true, false, "The name of the function.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A description of the function.");
        private static final Column ParameterList = new Column("PARAMETER_LIST", Type.String, null, false, true, "A comma delimited list of parameters.");
        private static final Column ReturnType = new Column("RETURN_TYPE", Type.Integer, null, false, false, "The VARTYPE of the return data type of the function.");
        private static final Column Origin = new Column("ORIGIN", Type.Integer, null, true, false, "The origin of the function:  1 for MDX functions.  2 for user-defined functions.");
        private static final Column InterfaceName = new Column("INTERFACE_NAME", Type.String, null, true, false, "The name of the interface for user-defined functions");
        private static final Column LibraryName = new Column("LIBRARY_NAME", Type.String, null, true, true, "The name of the type library for user-defined functions. NULL for MDX functions.");
        private static final Column Caption = new Column("CAPTION", Type.String, null, false, true, "The display caption for the function.");

        MdschemaFunctionsRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_FUNCTIONS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String role = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, role)) == null) continue;
                RolapSchema schema = (RolapSchema)connection.getSchema();
                FunTable funTable = schema.getFunTable();
                StringBuilder buf = new StringBuilder(50);
                List<FunInfo> functions = funTable.getFunInfoList();
                for (FunInfo fi : functions) {
                    if (!this.functionNameRT.passes(fi.getName())) continue;
                    int[][] paramCategories = fi.getParameterCategories();
                    int[] returnCategories = fi.getReturnCategories();
                    String description = fi.getDescription();
                    if (description != null) {
                        description = Util.replace(fi.getDescription(), "\r", "");
                    }
                    if (paramCategories == null || paramCategories.length == 0) {
                        Rowset.Row row = new Rowset.Row();
                        row.set(MdschemaFunctionsRowset.FunctionName.name, fi.getName());
                        row.set(MdschemaFunctionsRowset.Description.name, description);
                        row.set(MdschemaFunctionsRowset.ParameterList.name, "(none)");
                        row.set(MdschemaFunctionsRowset.ReturnType.name, 1);
                        row.set(MdschemaFunctionsRowset.Origin.name, 1);
                        row.set(MdschemaFunctionsRowset.InterfaceName.name, "");
                        row.set(MdschemaFunctionsRowset.Caption.name, fi.getName());
                        this.addRow(row, rows);
                        continue;
                    }
                    for (int i = 0; i < paramCategories.length; ++i) {
                        int[] pc = paramCategories[i];
                        int returnCategory = returnCategories[i];
                        Rowset.Row row = new Rowset.Row();
                        row.set(MdschemaFunctionsRowset.FunctionName.name, fi.getName());
                        row.set(MdschemaFunctionsRowset.Description.name, description);
                        buf.setLength(0);
                        for (int j = 0; j < pc.length; ++j) {
                            int v = pc[j];
                            if (j > 0) {
                                buf.append(", ");
                            }
                            buf.append(Category.instance.getDescription(v & 0x1F));
                        }
                        row.set(MdschemaFunctionsRowset.ParameterList.name, buf.toString());
                        VarType varType = VarType.forCategory(returnCategory);
                        row.set(MdschemaFunctionsRowset.ReturnType.name, varType.ordinal());
                        row.set(MdschemaFunctionsRowset.Origin.name, 1);
                        row.set(MdschemaFunctionsRowset.InterfaceName.name, "");
                        row.set(MdschemaFunctionsRowset.Caption.name, fi.getName());
                        this.addRow(row, rows);
                    }
                }
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$11800() {
            return FunctionName;
        }

        static /* synthetic */ Column access$11900() {
            return Description;
        }

        static /* synthetic */ Column access$12000() {
            return ParameterList;
        }

        static /* synthetic */ Column access$12100() {
            return ReturnType;
        }

        static /* synthetic */ Column access$12200() {
            return Origin;
        }

        static /* synthetic */ Column access$12300() {
            return InterfaceName;
        }

        static /* synthetic */ Column access$12400() {
            return LibraryName;
        }

        static /* synthetic */ Column access$12500() {
            return Caption;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum VarType {
            Empty("Uninitialized (default)"),
            Null("Contains no valid data"),
            Integer("Integer subtype"),
            Long("Long subtype"),
            Single("Single subtype"),
            Double("Double subtype"),
            Currency("Currency subtype"),
            Date("Date subtype"),
            String("String subtype"),
            Object("Object subtype"),
            Error("Error subtype"),
            Boolean("Boolean subtype"),
            Variant("Variant subtype"),
            DataObject("DataObject subtype"),
            Decimal("Decimal subtype"),
            Byte("Byte subtype"),
            Array("Array subtype");


            static VarType forCategory(int category) {
                switch (category) {
                    case 0: {
                        return Empty;
                    }
                    case 1: {
                        return Array;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 8: 
                    case 10: 
                    case 12: 
                    case 13: {
                        return Variant;
                    }
                    case 5: {
                        return Boolean;
                    }
                    case 7: {
                        return Double;
                    }
                    case 9: 
                    case 11: 
                    case 64: {
                        return String;
                    }
                    case 15: 
                    case 31: {
                        return Integer;
                    }
                }
                return Empty;
            }

            private VarType(String description) {
                Util.discard((Object)description);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaDimensionsRowset
    extends Rowset {
        private final Rowset.RestrictionTest schemaNameRT = this.getRestrictionTest(SchemaName);
        private final Rowset.RestrictionTest cubeNameRT = this.getRestrictionTest(CubeName);
        private final Rowset.RestrictionTest dimensionUniqueNameRT = this.getRestrictionTest(DimensionUniqueName);
        private final Rowset.RestrictionTest dimensionNameRT = this.getRestrictionTest(DimensionName);
        public static final int MD_DIMTYPE_OTHER = 3;
        public static final int MD_DIMTYPE_MEASURE = 2;
        public static final int MD_DIMTYPE_TIME = 1;
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the database.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "Not supported.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube.");
        private static final Column DimensionName = new Column("DIMENSION_NAME", Type.String, null, true, false, "The name of the dimension. ");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the dimension.");
        private static final Column DimensionGuid = new Column("DIMENSION_GUID", Type.UUID, null, false, true, "Not supported.");
        private static final Column DimensionCaption = new Column("DIMENSION_CAPTION", Type.String, null, false, false, "The caption of the dimension.");
        private static final Column DimensionOrdinal = new Column("DIMENSION_ORDINAL", Type.UnsignedInteger, null, false, false, "The position of the dimension within the cube.");
        private static final Column DimensionType = new Column("DIMENSION_TYPE", Type.Short, null, false, false, "The type of the dimension.");
        private static final Column DimensionCardinality = new Column("DIMENSION_CARDINALITY", Type.UnsignedInteger, null, false, false, "The number of members in the key attribute.");
        private static final Column DefaultHierarchy = new Column("DEFAULT_HIERARCHY", Type.String, null, false, false, "A hierarchy from the dimension. Preserved for backwards compatibility.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A user-friendly description of the dimension.");
        private static final Column IsVirtual = new Column("IS_VIRTUAL", Type.Boolean, null, false, true, "Always FALSE.");
        private static final Column IsReadWrite = new Column("IS_READWRITE", Type.Boolean, null, false, true, "A Boolean that indicates whether the dimension is write-enabled.");
        private static final Column DimensionUniqueSettings = new Column("DIMENSION_UNIQUE_SETTINGS", Type.Integer, null, false, true, "A bitmap that specifies which columns contain unique values if the dimension contains only members with unique names.");
        private static final Column DimensionMasterUniqueName = new Column("DIMENSION_MASTER_UNIQUE_NAME", Type.String, null, false, true, "Always NULL.");
        private static final Column DimensionIsVisible = new Column("DIMENSION_IS_VISIBLE", Type.Boolean, null, false, true, "Always TRUE.");

        MdschemaDimensionsRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_DIMENSIONS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.Catalog[] catalogs;
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            String roleStr = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs = this.handler.getCatalogs(this.request, ds)) {
                Connection connection;
                String catalogName;
                if (dsCatalog == null || dsCatalog.definition == null || !this.schemaNameRT.passes(catalogName = dsCatalog.name) || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                this.populateCatalog(connection, role, catalogName, rows);
            }
        }

        protected void populateCatalog(Connection connection, Role role, String catalogName, List<Rowset.Row> rows) throws XmlaException {
            for (Cube cube : RowsetDefinition.sortedCubes(connection.getSchema())) {
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                SchemaReader schemaReader = cube.getSchemaReader(role);
                this.populateCube(schemaReader, catalogName, cube, rows);
            }
        }

        protected void populateCube(SchemaReader schemaReader, String catalogName, Cube cube, List<Rowset.Row> rows) throws XmlaException {
            for (Dimension dimension : cube.getDimensions()) {
                String name = dimension.getName();
                String unique = dimension.getUniqueName();
                if (!this.dimensionNameRT.passes(name) || !this.dimensionUniqueNameRT.passes(unique)) continue;
                this.populateDimension(schemaReader, catalogName, cube, dimension, rows);
            }
        }

        protected void populateDimension(SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, List<Rowset.Row> rows) throws XmlaException {
            if (!RowsetDefinition.canAccess(schemaReader, dimension)) {
                return;
            }
            String desc = dimension.getDescription();
            if (desc == null) {
                desc = cube.getName() + " Cube - " + dimension.getName() + " Dimension";
            }
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaDimensionsRowset.CatalogName.name, catalogName);
            row.set(MdschemaDimensionsRowset.CubeName.name, cube.getName());
            row.set(MdschemaDimensionsRowset.DimensionName.name, dimension.getName());
            row.set(MdschemaDimensionsRowset.DimensionUniqueName.name, dimension.getUniqueName());
            row.set(MdschemaDimensionsRowset.DimensionCaption.name, dimension.getCaption());
            row.set(MdschemaDimensionsRowset.DimensionOrdinal.name, dimension.getOrdinal(cube));
            row.set(MdschemaDimensionsRowset.DimensionType.name, RowsetDefinition.getDimensionType(dimension));
            Hierarchy firstHierarchy = dimension.getHierarchies()[0];
            Level[] levels = firstHierarchy.getLevels();
            Level lastLevel = levels[levels.length - 1];
            int n = schemaReader.getLevelCardinality(lastLevel, true, true);
            row.set(MdschemaDimensionsRowset.DimensionCardinality.name, n + 1);
            row.set(MdschemaDimensionsRowset.DefaultHierarchy.name, dimension.getUniqueName());
            row.set(MdschemaDimensionsRowset.Description.name, desc);
            row.set(MdschemaDimensionsRowset.IsVirtual.name, false);
            row.set(MdschemaDimensionsRowset.IsReadWrite.name, false);
            row.set(MdschemaDimensionsRowset.DimensionUniqueSettings.name, 0);
            row.set(MdschemaDimensionsRowset.DimensionIsVisible.name, true);
            this.addRow(row, rows);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$10100() {
            return CatalogName;
        }

        static /* synthetic */ Column access$10200() {
            return SchemaName;
        }

        static /* synthetic */ Column access$10300() {
            return CubeName;
        }

        static /* synthetic */ Column access$10400() {
            return DimensionName;
        }

        static /* synthetic */ Column access$10500() {
            return DimensionUniqueName;
        }

        static /* synthetic */ Column access$10600() {
            return DimensionGuid;
        }

        static /* synthetic */ Column access$10700() {
            return DimensionCaption;
        }

        static /* synthetic */ Column access$10800() {
            return DimensionOrdinal;
        }

        static /* synthetic */ Column access$10900() {
            return DimensionType;
        }

        static /* synthetic */ Column access$11000() {
            return DimensionCardinality;
        }

        static /* synthetic */ Column access$11100() {
            return DefaultHierarchy;
        }

        static /* synthetic */ Column access$11200() {
            return Description;
        }

        static /* synthetic */ Column access$11300() {
            return IsVirtual;
        }

        static /* synthetic */ Column access$11400() {
            return IsReadWrite;
        }

        static /* synthetic */ Column access$11500() {
            return DimensionUniqueSettings;
        }

        static /* synthetic */ Column access$11600() {
            return DimensionMasterUniqueName;
        }

        static /* synthetic */ Column access$11700() {
            return DimensionIsVisible;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaCubesRowset
    extends Rowset {
        private final Rowset.RestrictionTest catalogNameRT = this.getRestrictionTest(CatalogName);
        private final Rowset.RestrictionTest cubeNameRT = this.getRestrictionTest(CubeName);
        private static final String MD_CUBTYPE_CUBE = "CUBE";
        private static final String MD_CUBTYPE_VIRTUAL_CUBE = "VIRTUAL CUBE";
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this cube belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this cube belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "Name of the cube.");
        private static final Column CubeType = new Column("CUBE_TYPE", Type.String, null, true, false, "Cube type.");
        private static final Column CubeGuid = new Column("CUBE_GUID", Type.UUID, null, false, true, "Cube type.");
        private static final Column CreatedOn = new Column("CREATED_ON", Type.DateTime, null, false, true, "Date and time of cube creation.");
        private static final Column LastSchemaUpdate = new Column("LAST_SCHEMA_UPDATE", Type.DateTime, null, false, true, "Date and time of last schema update.");
        private static final Column SchemaUpdatedBy = new Column("SCHEMA_UPDATED_BY", Type.String, null, false, true, "User ID of the person who last updated the schema.");
        private static final Column LastDataUpdate = new Column("LAST_DATA_UPDATE", Type.DateTime, null, false, true, "Date and time of last data update.");
        private static final Column DataUpdatedBy = new Column("DATA_UPDATED_BY", Type.String, null, false, true, "User ID of the person who last updated the data. ");
        private static final Column IsDrillthroughEnabled = new Column("IS_DRILLTHROUGH_ENABLED", Type.Boolean, null, false, false, "Describes whether DRILLTHROUGH can be performed on the members of a cube");
        private static final Column IsWriteEnabled = new Column("IS_WRITE_ENABLED", Type.Boolean, null, false, false, "Describes whether a cube is write-enabled");
        private static final Column IsLinkable = new Column("IS_LINKABLE", Type.Boolean, null, false, false, "Describes whether a cube can be used in a linked cube");
        private static final Column IsSqlEnabled = new Column("IS_SQL_ENABLED", Type.Boolean, null, false, false, "Describes whether or not SQL can be used on the cube");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A user-friendly description of the dimension.");

        MdschemaCubesRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_CUBES, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String roleStr = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                String catalogName = dsCatalog.name;
                if (!this.catalogNameRT.passes(catalogName)) continue;
                RolapSchema schema = (RolapSchema)connection.getSchema();
                for (Cube cube : RowsetDefinition.sortedCubes(schema)) {
                    SchemaReader schemaReader = cube.getSchemaReader(role);
                    if (!RowsetDefinition.canAccess(schemaReader, cube) || !this.cubeNameRT.passes(cube.getName())) continue;
                    String desc = cube.getDescription();
                    if (desc == null) {
                        desc = catalogName + " Schema - " + cube.getName() + " Cube";
                    }
                    Rowset.Row row = new Rowset.Row();
                    row.set(MdschemaCubesRowset.CatalogName.name, catalogName);
                    row.set(MdschemaCubesRowset.CubeName.name, cube.getName());
                    row.set(MdschemaCubesRowset.CubeType.name, ((RolapCube)cube).isVirtual() ? MD_CUBTYPE_VIRTUAL_CUBE : MD_CUBTYPE_CUBE);
                    row.set(MdschemaCubesRowset.IsDrillthroughEnabled.name, true);
                    row.set(MdschemaCubesRowset.IsWriteEnabled.name, false);
                    row.set(MdschemaCubesRowset.IsLinkable.name, false);
                    row.set(MdschemaCubesRowset.IsSqlEnabled.name, false);
                    row.set(MdschemaCubesRowset.Description.name, desc);
                    row.set(MdschemaCubesRowset.LastSchemaUpdate.name, this.lastUpdateDate(schema));
                    this.addRow(row, rows);
                }
            }
        }

        private String lastUpdateDate(RolapSchema schema) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            return formatter.format((Object)schema.getSchemaLoadDate());
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$8600() {
            return CatalogName;
        }

        static /* synthetic */ Column access$8700() {
            return SchemaName;
        }

        static /* synthetic */ Column access$8800() {
            return CubeName;
        }

        static /* synthetic */ Column access$8900() {
            return CubeType;
        }

        static /* synthetic */ Column access$9000() {
            return CubeGuid;
        }

        static /* synthetic */ Column access$9100() {
            return CreatedOn;
        }

        static /* synthetic */ Column access$9200() {
            return LastSchemaUpdate;
        }

        static /* synthetic */ Column access$9300() {
            return SchemaUpdatedBy;
        }

        static /* synthetic */ Column access$9400() {
            return LastDataUpdate;
        }

        static /* synthetic */ Column access$9500() {
            return DataUpdatedBy;
        }

        static /* synthetic */ Column access$9600() {
            return IsDrillthroughEnabled;
        }

        static /* synthetic */ Column access$9700() {
            return IsWriteEnabled;
        }

        static /* synthetic */ Column access$9800() {
            return IsLinkable;
        }

        static /* synthetic */ Column access$9900() {
            return IsSqlEnabled;
        }

        static /* synthetic */ Column access$10000() {
            return Description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaActionsRowset
    extends Rowset {
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, null);
        private static final Column Coordinate = new Column("COORDINATE", Type.String, null, true, false, null);
        private static final Column CoordinateType = new Column("COORDINATE_TYPE", Type.Integer, null, true, false, null);

        MdschemaActionsRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_ACTIONS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            throw new XmlaException("Client", "00HSBG01", "XMLA unsupported operation", new UnsupportedOperationException("MDSCHEMA_ACTIONS"));
        }

        static /* synthetic */ Column access$8300() {
            return CubeName;
        }

        static /* synthetic */ Column access$8400() {
            return Coordinate;
        }

        static /* synthetic */ Column access$8500() {
            return CoordinateType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DbschemaTablesInfoRowset
    extends Rowset {
        private static final Column TableCatalog = new Column("TABLE_CATALOG", Type.String, null, true, true, "Catalog name. NULL if the provider does not support catalogs.");
        private static final Column TableSchema = new Column("TABLE_SCHEMA", Type.String, null, true, true, "Unqualified schema name. NULL if the provider does not support schemas.");
        private static final Column TableName = new Column("TABLE_NAME", Type.String, null, true, false, "Table name.");
        private static final Column TableType = new Column("TABLE_TYPE", Type.String, null, true, false, "Table type. One of the following or a provider-specific value: ALIAS, TABLE, SYNONYM, SYSTEM TABLE, VIEW, GLOBAL TEMPORARY, LOCAL TEMPORARY, EXTERNAL TABLE, SYSTEM VIEW");
        private static final Column TableGuid = new Column("TABLE_GUID", Type.UUID, null, false, true, "GUID that uniquely identifies the table. Providers that do not use GUIDs to identify tables should return NULL in this column.");
        private static final Column Bookmarks = new Column("BOOKMARKS", Type.Boolean, null, false, false, "Whether this table supports bookmarks. Allways is false.");
        private static final Column BookmarkType = new Column("BOOKMARK_TYPE", Type.Integer, null, false, true, "Default bookmark type supported on this table.");
        private static final Column BookmarkDataType = new Column("BOOKMARK_DATATYPE", Type.UnsignedShort, null, false, true, "The indicator of the bookmark's native data type.");
        private static final Column BookmarkMaximumLength = new Column("BOOKMARK_MAXIMUM_LENGTH", Type.UnsignedInteger, null, false, true, "Maximum length of the bookmark in bytes.");
        private static final Column BookmarkInformation = new Column("BOOKMARK_INFORMATION", Type.UnsignedInteger, null, false, true, "A bitmask specifying additional information about bookmarks over the rowset. ");
        private static final Column TableVersion = new Column("TABLE_VERSION", Type.Long, null, false, true, "Version number for this table or NULL if the provider does not support returning table version information.");
        private static final Column Cardinality = new Column("CARDINALITY", Type.UnsignedLong, null, false, false, "Cardinality (number of rows) of the table.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "Human-readable description of the table.");
        private static final Column TablePropId = new Column("TABLE_PROPID", Type.UnsignedInteger, null, false, true, "Property ID of the table. Return null.");

        DbschemaTablesInfoRowset(XmlaRequest request, XmlaHandler handler) {
            super(DBSCHEMA_TABLES_INFO, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String role = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, role)) == null) continue;
                RolapSchema schema = (RolapSchema)connection.getSchema();
                String catalogName = dsCatalog.name;
                for (Cube cube1 : RowsetDefinition.sortedCubes(schema)) {
                    RolapCube cube = (RolapCube)cube1;
                    String cubeName = cube.getName();
                    String desc = cube.getDescription();
                    if (desc == null) {
                        desc = catalogName + " - " + cubeName + " Cube";
                    }
                    int cardinality = 1000000;
                    String version = "null";
                    Rowset.Row row = new Rowset.Row();
                    row.set(DbschemaTablesInfoRowset.TableCatalog.name, catalogName);
                    row.set(DbschemaTablesInfoRowset.TableName.name, cubeName);
                    row.set(DbschemaTablesInfoRowset.TableType.name, "TABLE");
                    row.set(DbschemaTablesInfoRowset.Bookmarks.name, false);
                    row.set(DbschemaTablesInfoRowset.TableVersion.name, version);
                    row.set(DbschemaTablesInfoRowset.Cardinality.name, cardinality);
                    row.set(DbschemaTablesInfoRowset.Description.name, desc);
                    this.addRow(row, rows);
                }
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$6900() {
            return TableCatalog;
        }

        static /* synthetic */ Column access$7000() {
            return TableSchema;
        }

        static /* synthetic */ Column access$7100() {
            return TableName;
        }

        static /* synthetic */ Column access$7200() {
            return TableType;
        }

        static /* synthetic */ Column access$7300() {
            return TableGuid;
        }

        static /* synthetic */ Column access$7400() {
            return Bookmarks;
        }

        static /* synthetic */ Column access$7500() {
            return BookmarkType;
        }

        static /* synthetic */ Column access$7600() {
            return BookmarkDataType;
        }

        static /* synthetic */ Column access$7700() {
            return BookmarkMaximumLength;
        }

        static /* synthetic */ Column access$7800() {
            return BookmarkInformation;
        }

        static /* synthetic */ Column access$7900() {
            return TableVersion;
        }

        static /* synthetic */ Column access$8000() {
            return Cardinality;
        }

        static /* synthetic */ Column access$8100() {
            return Description;
        }

        static /* synthetic */ Column access$8200() {
            return TablePropId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DbschemaTablesRowset
    extends Rowset {
        private final Rowset.RestrictionTest tableCatalogRT = this.getRestrictionTest(TableCatalog);
        private final Rowset.RestrictionTest tableNameRT = this.getRestrictionTest(TableName);
        private final Rowset.RestrictionTest tableTypeRT = this.getRestrictionTest(TableType);
        private static final Column TableCatalog = new Column("TABLE_CATALOG", Type.String, null, true, false, "The name of the catalog to which this object belongs.");
        private static final Column TableSchema = new Column("TABLE_SCHEMA", Type.String, null, true, true, "The name of the cube to which this object belongs.");
        private static final Column TableName = new Column("TABLE_NAME", Type.String, null, true, false, "The name of the object, if TABLE_TYPE is TABLE.");
        private static final Column TableType = new Column("TABLE_TYPE", Type.String, null, true, false, "The type of the table. TABLE indicates the object is a measure group. SYSTEM TABLE indicates the object is a dimension.");
        private static final Column TableGuid = new Column("TABLE_GUID", Type.UUID, null, false, true, "Not supported.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the object.");
        private static final Column TablePropId = new Column("TABLE_PROPID", Type.UnsignedInteger, null, false, true, "Not supported.");
        private static final Column DateCreated = new Column("DATE_CREATED", Type.DateTime, null, false, true, "Not supported.");
        private static final Column DateModified = new Column("DATE_MODIFIED", Type.DateTime, null, false, true, "The date the object was last modified.");

        DbschemaTablesRowset(XmlaRequest request, XmlaHandler handler) {
            super(DBSCHEMA_TABLES, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String roleStr = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                RolapSchema schema = (RolapSchema)connection.getSchema();
                String catalogName = dsCatalog.name;
                if (!this.tableCatalogRT.passes(catalogName)) continue;
                for (Cube cube1 : RowsetDefinition.sortedCubes(schema)) {
                    RolapCube cube = (RolapCube)cube1;
                    String cubeName = cube.getName();
                    String tableName = cubeName;
                    if (!this.tableNameRT.passes(tableName)) continue;
                    SchemaReader schemaReader = cube.getSchemaReader(role);
                    String desc = cube.getDescription();
                    if (desc == null) {
                        desc = catalogName + " - " + cubeName + " Cube";
                    }
                    if (this.tableTypeRT.passes("TABLE")) {
                        Rowset.Row row = new Rowset.Row();
                        row.set(DbschemaTablesRowset.TableCatalog.name, catalogName);
                        row.set(DbschemaTablesRowset.TableName.name, tableName);
                        row.set(DbschemaTablesRowset.TableType.name, "TABLE");
                        row.set(DbschemaTablesRowset.Description.name, desc);
                        this.addRow(row, rows);
                    }
                    if (!this.tableTypeRT.passes("SYSTEM TABLE")) continue;
                    for (Dimension dimension : cube.getDimensions()) {
                        Hierarchy[] hierarchies;
                        if (dimension.isMeasures()) continue;
                        for (Hierarchy hierarchy1 : hierarchies = dimension.getHierarchies()) {
                            HierarchyBase hierarchy = (HierarchyBase)hierarchy1;
                            this.populateHierarchy(schemaReader, cube, hierarchy, rows);
                        }
                    }
                }
            }
        }

        private void populateHierarchy(SchemaReader schemaReader, RolapCube cube, HierarchyBase hierarchy, List<Rowset.Row> rows) {
            Level[] levels;
            if (!RowsetDefinition.canAccess(schemaReader, hierarchy)) {
                return;
            }
            for (Level level : levels = hierarchy.getLevels()) {
                this.populateLevel(cube, hierarchy, level, rows);
            }
        }

        private void populateLevel(RolapCube cube, HierarchyBase hierarchy, Level level, List<Rowset.Row> rows) {
            String schemaName = cube.getSchema().getName();
            String cubeName = cube.getName();
            String hierarchyName = hierarchy.getName();
            String levelName = level.getName();
            String tableName = cubeName + ':' + hierarchyName + ':' + levelName;
            String desc = level.getDescription();
            if (desc == null) {
                desc = schemaName + " - " + cubeName + " Cube - " + hierarchyName + " Hierarchy - " + levelName + " Level";
            }
            Rowset.Row row = new Rowset.Row();
            row.set(DbschemaTablesRowset.TableCatalog.name, schemaName);
            row.set(DbschemaTablesRowset.TableName.name, tableName);
            row.set(DbschemaTablesRowset.TableType.name, "SYSTEM TABLE");
            row.set(DbschemaTablesRowset.Description.name, desc);
            this.addRow(row, rows);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$6000() {
            return TableCatalog;
        }

        static /* synthetic */ Column access$6100() {
            return TableSchema;
        }

        static /* synthetic */ Column access$6200() {
            return TableName;
        }

        static /* synthetic */ Column access$6300() {
            return TableType;
        }

        static /* synthetic */ Column access$6400() {
            return TableGuid;
        }

        static /* synthetic */ Column access$6500() {
            return Description;
        }

        static /* synthetic */ Column access$6600() {
            return TablePropId;
        }

        static /* synthetic */ Column access$6700() {
            return DateCreated;
        }

        static /* synthetic */ Column access$6800() {
            return DateModified;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DbschemaProviderTypesRowset
    extends Rowset {
        private final Rowset.RestrictionTest dataTypeRT = this.getRestrictionTest(DataType);
        private static final Column TypeName = new Column("TYPE_NAME", Type.String, null, false, false, "The provider-specific data type name.");
        private static final Column DataType = new Column("DATA_TYPE", Type.UnsignedShort, null, true, false, "The indicator of the data type.");
        private static final Column ColumnSize = new Column("COLUMN_SIZE", Type.UnsignedInteger, null, false, false, "The length of a non-numeric column. If the data type is numeric, this is the upper bound on the maximum precision of the data type.");
        private static final Column LiteralPrefix = new Column("LITERAL_PREFIX", Type.String, null, false, true, "The character or characters used to prefix a literal of this type in a text command.");
        private static final Column LiteralSuffix = new Column("LITERAL_SUFFIX", Type.String, null, false, true, "The character or characters used to suffix a literal of this type in a text command.");
        private static final Column IsNullable = new Column("IS_NULLABLE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is nullable. NULL-- indicates that it is not known whether the data type is nullable.");
        private static final Column CaseSensitive = new Column("CASE_SENSITIVE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is a characters type and case-sensitive.");
        private static final Column Searchable = new Column("SEARCHABLE", Type.UnsignedInteger, null, false, true, "An integer indicating how the data type can be used in searches if the provider supports ICommandText; otherwise, NULL.");
        private static final Column UnsignedAttribute = new Column("UNSIGNED_ATTRIBUTE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is unsigned.");
        private static final Column FixedPrecScale = new Column("FIXED_PREC_SCALE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type has a fixed precision and scale.");
        private static final Column AutoUniqueValue = new Column("AUTO_UNIQUE_VALUE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is autoincrementing.");
        private static final Column IsLong = new Column("IS_LONG", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is a binary large object (BLOB) and has very long data.");
        private static final Column BestMatch = new Column("BEST_MATCH", Type.Boolean, null, true, true, "A Boolean that indicates whether the data type is a best match.");

        DbschemaProviderTypesRowset(XmlaRequest request, XmlaHandler handler) {
            super(DBSCHEMA_PROVIDER_TYPES, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            Rowset.Row row;
            Integer dt = DBType.I4.userOrdinal;
            if (this.dataTypeRT.passes(dt)) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, DBType.I4.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 8);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeRT.passes(dt = Integer.valueOf(DBType.R8.userOrdinal))) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, DBType.R8.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 16);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeRT.passes(dt = Integer.valueOf(DBType.CY.userOrdinal))) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, DBType.CY.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 8);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeRT.passes(dt = Integer.valueOf(DBType.BOOL.userOrdinal))) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, DBType.BOOL.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 1);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeRT.passes(dt = Integer.valueOf(DBType.I8.userOrdinal))) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, DBType.I8.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 16);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeRT.passes(dt = Integer.valueOf(DBType.WSTR.userOrdinal))) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, DBType.WSTR.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 255);
                row.set(DbschemaProviderTypesRowset.LiteralPrefix.name, "\"");
                row.set(DbschemaProviderTypesRowset.LiteralSuffix.name, "\"");
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.CaseSensitive.name, false);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$4700() {
            return TypeName;
        }

        static /* synthetic */ Column access$4800() {
            return DataType;
        }

        static /* synthetic */ Column access$4900() {
            return ColumnSize;
        }

        static /* synthetic */ Column access$5000() {
            return LiteralPrefix;
        }

        static /* synthetic */ Column access$5100() {
            return LiteralSuffix;
        }

        static /* synthetic */ Column access$5200() {
            return IsNullable;
        }

        static /* synthetic */ Column access$5300() {
            return CaseSensitive;
        }

        static /* synthetic */ Column access$5400() {
            return Searchable;
        }

        static /* synthetic */ Column access$5500() {
            return UnsignedAttribute;
        }

        static /* synthetic */ Column access$5600() {
            return FixedPrecScale;
        }

        static /* synthetic */ Column access$5700() {
            return AutoUniqueValue;
        }

        static /* synthetic */ Column access$5800() {
            return IsLong;
        }

        static /* synthetic */ Column access$5900() {
            return BestMatch;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DbschemaColumnsRowset
    extends Rowset {
        private final Rowset.RestrictionTest tableCatalogRT = this.getRestrictionTest(TableCatalog);
        private final Rowset.RestrictionTest tableNameRT = this.getRestrictionTest(TableName);
        private final Rowset.RestrictionTest columnNameRT = this.getRestrictionTest(ColumnName);
        private static final Column TableCatalog = new Column("TABLE_CATALOG", Type.String, null, true, false, "The name of the Database.");
        private static final Column TableSchema = new Column("TABLE_SCHEMA", Type.String, null, true, true, null);
        private static final Column TableName = new Column("TABLE_NAME", Type.String, null, true, false, "The name of the cube.");
        private static final Column ColumnName = new Column("COLUMN_NAME", Type.String, null, true, false, "The name of the attribute hierarchy or measure.");
        private static final Column OrdinalPosition = new Column("ORDINAL_POSITION", Type.UnsignedInteger, null, false, false, "The position of the column, beginning with 1.");
        private static final Column ColumnHasDefault = new Column("COLUMN_HAS_DEFAULT", Type.Boolean, null, false, true, "Not supported.");
        private static final Column ColumnFlags = new Column("COLUMN_FLAGS", Type.UnsignedInteger, null, false, false, "A DBCOLUMNFLAGS bitmask indicating column properties.");
        private static final Column IsNullable = new Column("IS_NULLABLE", Type.Boolean, null, false, false, "Always returns false.");
        private static final Column DataType = new Column("DATA_TYPE", Type.UnsignedShort, null, false, false, "The data type of the column. Returns a string for dimension columns and a variant for measures.");
        private static final Column CharacterMaximumLength = new Column("CHARACTER_MAXIMUM_LENGTH", Type.UnsignedInteger, null, false, true, "The maximum possible length of a value within the column.");
        private static final Column CharacterOctetLength = new Column("CHARACTER_OCTET_LENGTH", Type.UnsignedInteger, null, false, true, "The maximum possible length of a value within the column, in bytes, for character or binary columns.");
        private static final Column NumericPrecision = new Column("NUMERIC_PRECISION", Type.UnsignedShort, null, false, true, "The maximum precision of the column for numeric data types other than DBTYPE_VARNUMERIC.");
        private static final Column NumericScale = new Column("NUMERIC_SCALE", Type.Short, null, false, true, "The number of digits to the right of the decimal point for DBTYPE_DECIMAL, DBTYPE_NUMERIC, DBTYPE_VARNUMERIC. Otherwise, this is NULL.");

        DbschemaColumnsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DBSCHEMA_COLUMNS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = ds.catalogs.catalogs;
            String roleStr = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, roleStr)) == null) continue;
                Role role = connection.getSchema().lookupRole(roleStr);
                RolapSchema schema = (RolapSchema)connection.getSchema();
                String catalogName = dsCatalog.name;
                if (!this.tableCatalogRT.passes(catalogName)) continue;
                int ordinalPosition = 1;
                for (Cube cube1 : RowsetDefinition.sortedCubes(schema)) {
                    RolapCube cube = (RolapCube)cube1;
                    SchemaReader schemaReader = cube.getSchemaReader(role);
                    String cubeName = cube.getName();
                    if (!this.tableNameRT.passes(cubeName)) continue;
                    for (Dimension dimension : cube.getDimensions()) {
                        Hierarchy[] hierarchies;
                        for (Hierarchy hierarchy1 : hierarchies = dimension.getHierarchies()) {
                            HierarchyBase hierarchy = (HierarchyBase)hierarchy1;
                            ordinalPosition = this.populateHierarchy(schemaReader, cube, hierarchy, ordinalPosition, rows);
                        }
                    }
                    RolapMember[] rms = cube.getMeasuresMembers();
                    for (int k = 1; k < rms.length; ++k) {
                        RolapMember member = rms[k];
                        Boolean isVisible = (Boolean)member.getPropertyValue(Property.VISIBLE.name);
                        if (isVisible != null && !isVisible.booleanValue()) continue;
                        String memberName = member.getName();
                        if (!this.columnNameRT.passes("Measures:" + memberName)) continue;
                        Rowset.Row row = new Rowset.Row();
                        row.set(DbschemaColumnsRowset.TableCatalog.name, catalogName);
                        row.set(DbschemaColumnsRowset.TableName.name, cubeName);
                        row.set(DbschemaColumnsRowset.ColumnName.name, "Measures:" + memberName);
                        row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
                        row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
                        row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
                        row.set(DbschemaColumnsRowset.IsNullable.name, false);
                        row.set(DbschemaColumnsRowset.DataType.name, DBType.R8.userOrdinal);
                        row.set(DbschemaColumnsRowset.NumericPrecision.name, 16);
                        row.set(DbschemaColumnsRowset.NumericScale.name, 255);
                        this.addRow(row, rows);
                    }
                }
            }
        }

        private int populateHierarchy(SchemaReader schemaReader, RolapCube cube, HierarchyBase hierarchy, int ordinalPosition, List<Rowset.Row> rows) {
            Level[] levels;
            if (!RowsetDefinition.canAccess(schemaReader, hierarchy)) {
                return ordinalPosition;
            }
            String schemaName = cube.getSchema().getName();
            String cubeName = cube.getName();
            String hierarchyName = hierarchy.getName();
            if (hierarchy.hasAll()) {
                Rowset.Row row = new Rowset.Row();
                row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
                row.set(DbschemaColumnsRowset.TableName.name, cubeName);
                row.set(DbschemaColumnsRowset.ColumnName.name, hierarchyName + ":(All)!NAME");
                row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
                row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
                row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
                row.set(DbschemaColumnsRowset.IsNullable.name, false);
                row.set(DbschemaColumnsRowset.DataType.name, DBType.WSTR.userOrdinal);
                row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
                row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
                this.addRow(row, rows);
                row = new Rowset.Row();
                row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
                row.set(DbschemaColumnsRowset.TableName.name, cubeName);
                row.set(DbschemaColumnsRowset.ColumnName.name, hierarchyName + ":(All)!UNIQUE_NAME");
                row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
                row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
                row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
                row.set(DbschemaColumnsRowset.IsNullable.name, false);
                row.set(DbschemaColumnsRowset.DataType.name, DBType.WSTR.userOrdinal);
                row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
                row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
                this.addRow(row, rows);
            }
            for (Level level : levels = hierarchy.getLevels()) {
                ordinalPosition = this.populateLevel(cube, hierarchy, level, ordinalPosition, rows);
            }
            return ordinalPosition;
        }

        private int populateLevel(Cube cube, HierarchyBase hierarchy, Level level, int ordinalPosition, List<Rowset.Row> rows) {
            Property[] props;
            String schemaName = cube.getSchema().getName();
            String cubeName = cube.getName();
            String hierarchyName = hierarchy.getName();
            String levelName = level.getName();
            Rowset.Row row = new Rowset.Row();
            row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
            row.set(DbschemaColumnsRowset.TableName.name, cubeName);
            row.set(DbschemaColumnsRowset.ColumnName.name, hierarchyName + ':' + levelName + "!NAME");
            row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
            row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
            row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
            row.set(DbschemaColumnsRowset.IsNullable.name, false);
            row.set(DbschemaColumnsRowset.DataType.name, DBType.WSTR.userOrdinal);
            row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
            row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
            this.addRow(row, rows);
            row = new Rowset.Row();
            row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
            row.set(DbschemaColumnsRowset.TableName.name, cubeName);
            row.set(DbschemaColumnsRowset.ColumnName.name, hierarchyName + ':' + levelName + "!UNIQUE_NAME");
            row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
            row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
            row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
            row.set(DbschemaColumnsRowset.IsNullable.name, false);
            row.set(DbschemaColumnsRowset.DataType.name, DBType.WSTR.userOrdinal);
            row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
            row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
            this.addRow(row, rows);
            for (Property prop : props = level.getProperties()) {
                String propName = prop.getName();
                row = new Rowset.Row();
                row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
                row.set(DbschemaColumnsRowset.TableName.name, cubeName);
                row.set(DbschemaColumnsRowset.ColumnName.name, hierarchyName + ':' + levelName + '!' + propName);
                row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
                row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
                row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
                row.set(DbschemaColumnsRowset.IsNullable.name, false);
                DBType dbType = RowsetDefinition.getDBTypeFromProperty(prop);
                row.set(DbschemaColumnsRowset.DataType.name, dbType.userOrdinal);
                switch (prop.getType()) {
                    case TYPE_STRING: {
                        row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
                        row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
                        break;
                    }
                    case TYPE_NUMERIC: {
                        row.set(DbschemaColumnsRowset.NumericPrecision.name, 16);
                        row.set(DbschemaColumnsRowset.NumericScale.name, 255);
                        break;
                    }
                    case TYPE_BOOLEAN: {
                        row.set(DbschemaColumnsRowset.NumericPrecision.name, 255);
                        row.set(DbschemaColumnsRowset.NumericScale.name, 255);
                        break;
                    }
                    case TYPE_OTHER: {
                        row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
                        row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
                    }
                }
                this.addRow(row, rows);
            }
            return ordinalPosition;
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$3400() {
            return TableCatalog;
        }

        static /* synthetic */ Column access$3500() {
            return TableSchema;
        }

        static /* synthetic */ Column access$3600() {
            return TableName;
        }

        static /* synthetic */ Column access$3700() {
            return ColumnName;
        }

        static /* synthetic */ Column access$3800() {
            return OrdinalPosition;
        }

        static /* synthetic */ Column access$3900() {
            return ColumnHasDefault;
        }

        static /* synthetic */ Column access$4000() {
            return ColumnFlags;
        }

        static /* synthetic */ Column access$4100() {
            return IsNullable;
        }

        static /* synthetic */ Column access$4200() {
            return DataType;
        }

        static /* synthetic */ Column access$4300() {
            return CharacterMaximumLength;
        }

        static /* synthetic */ Column access$4400() {
            return CharacterOctetLength;
        }

        static /* synthetic */ Column access$4500() {
            return NumericPrecision;
        }

        static /* synthetic */ Column access$4600() {
            return NumericScale;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DbschemaCatalogsRowset
    extends Rowset {
        private final Rowset.RestrictionTest catalogNameRT = this.getRestrictionTest(CatalogName);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, false, "Catalog name. Cannot be NULL.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, false, "Human-readable description of the catalog.");
        private static final Column Roles = new Column("ROLES", Type.String, null, false, false, "A comma delimited list of roles to which the current user belongs. An asterisk (*) is included as a role if the current user is a server or database administrator. Username is appended to ROLES if one of the roles uses dynamic security.");
        private static final Column DateModified = new Column("DATE_MODIFIED", Type.DateTime, null, false, true, "The date that the catalog was last modified.");

        DbschemaCatalogsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DBSCHEMA_CATALOGS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = ds.catalogs.catalogs;
            String role = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, role)) == null || !this.catalogNameRT.passes(dsCatalog.name)) continue;
                RolapSchema schema = (RolapSchema)connection.getSchema();
                Rowset.Row row = new Rowset.Row();
                row.set(DbschemaCatalogsRowset.CatalogName.name, dsCatalog.name);
                row.set(DbschemaCatalogsRowset.Description.name, "No description available");
                StringBuilder buf = new StringBuilder(100);
                RowsetDefinition.serialize(buf, schema.roleNames());
                row.set(DbschemaCatalogsRowset.Roles.name, buf.toString());
                this.addRow(row, rows);
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$3000() {
            return CatalogName;
        }

        static /* synthetic */ Column access$3100() {
            return Description;
        }

        static /* synthetic */ Column access$3200() {
            return Roles;
        }

        static /* synthetic */ Column access$3300() {
            return DateModified;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiscoverLiteralsRowset
    extends Rowset {
        private static final Column LiteralName = new Column("LiteralName", Type.StringSometimesArray, null, true, false, "The name of the literal described in the row.\nExample: DBLITERAL_LIKE_PERCENT");
        private static final Column LiteralValue = new Column("LiteralValue", Type.String, null, false, false, "Contains the actual literal value.\nExample, if LiteralName is DBLITERAL_LIKE_PERCENT and the percent character (%) is used to match zero or more characters in a LIKE clause, this column's value would be \"%\".");
        private static final Column LiteralInvalidChars = new Column("LiteralInvalidChars", Type.String, null, false, false, "The characters, in the literal, that are not valid.\nFor example, if table names can contain anything other than a numeric character, this string would be \"0123456789\".");
        private static final Column LiteralInvalidStartingChars = new Column("LiteralInvalidStartingChars", Type.String, null, false, false, "The characters that are not valid as the first character of the literal. If the literal can start with any valid character, this is null.");
        private static final Column LiteralMaxLength = new Column("LiteralMaxLength", Type.Integer, null, false, false, "The maximum number of characters in the literal. If there is no maximum or the maximum is unknown, the value is ?1.");

        DiscoverLiteralsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_LITERALS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            this.emit(Enumeration.Literal.class, response);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$2500() {
            return LiteralName;
        }

        static /* synthetic */ Column access$2600() {
            return LiteralValue;
        }

        static /* synthetic */ Column access$2700() {
            return LiteralInvalidChars;
        }

        static /* synthetic */ Column access$2800() {
            return LiteralInvalidStartingChars;
        }

        static /* synthetic */ Column access$2900() {
            return LiteralMaxLength;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiscoverKeywordsRowset
    extends Rowset {
        private static final Column Keyword = new Column("Keyword", Type.StringSometimesArray, null, true, false, "A list of all the keywords reserved by a provider.\nExample: AND");
        private static final String[] keywords = new String[]{"$AdjustedProbability", "$Distance", "$Probability", "$ProbabilityStDev", "$ProbabilityStdDeV", "$ProbabilityVariance", "$StDev", "$StdDeV", "$Support", "$Variance", "AddCalculatedMembers", "Action", "After", "Aggregate", "All", "Alter", "Ancestor", "And", "Append", "As", "ASC", "Axis", "Automatic", "Back_Color", "BASC", "BDESC", "Before", "Before_And_After", "Before_And_Self", "Before_Self_After", "BottomCount", "BottomPercent", "BottomSum", "Break", "Boolean", "Cache", "Calculated", "Call", "Case", "Catalog_Name", "Cell", "Cell_Ordinal", "Cells", "Chapters", "Children", "Children_Cardinality", "ClosingPeriod", "Cluster", "ClusterDistance", "ClusterProbability", "Clusters", "CoalesceEmpty", "Column_Values", "Columns", "Content", "Contingent", "Continuous", "Correlation", "Cousin", "Covariance", "CovarianceN", "Create", "CreatePropertySet", "CrossJoin", "Cube", "Cube_Name", "CurrentMember", "CurrentCube", "Custom", "Cyclical", "DefaultMember", "Default_Member", "DESC", "Descendents", "Description", "Dimension", "Dimension_Unique_Name", "Dimensions", "Discrete", "Discretized", "DrillDownLevel", "DrillDownLevelBottom", "DrillDownLevelTop", "DrillDownMember", "DrillDownMemberBottom", "DrillDownMemberTop", "DrillTrough", "DrillUpLevel", "DrillUpMember", "Drop", "Else", "Empty", "End", "Equal_Areas", "Exclude_Null", "ExcludeEmpty", "Exclusive", "Expression", "Filter", "FirstChild", "FirstRowset", "FirstSibling", "Flattened", "Font_Flags", "Font_Name", "Font_size", "Fore_Color", "Format_String", "Formatted_Value", "Formula", "From", "Generate", "Global", "Head", "Hierarchize", "Hierarchy", "Hierary_Unique_name", "IIF", "IsEmpty", "Include_Null", "Include_Statistics", "Inclusive", "Input_Only", "IsDescendant", "Item", "Lag", "LastChild", "LastPeriods", "LastSibling", "Lead", "Level", "Level_Unique_Name", "Levels", "LinRegIntercept", "LinRegR2", "LinRegPoint", "LinRegSlope", "LinRegVariance", "Long", "MaxRows", "Median", "Member", "Member_Caption", "Member_Guid", "Member_Name", "Member_Ordinal", "Member_Type", "Member_Unique_Name", "Members", "Microsoft_Clustering", "Microsoft_Decision_Trees", "Mining", "Model", "Model_Existence_Only", "Models", "Move", "MTD", "Name", "Nest", "NextMember", "Non", "Normal", "Not", "Ntext", "Nvarchar", "OLAP", "On", "OpeningPeriod", "OpenQuery", "Or", "Ordered", "Ordinal", "Pages", "Pages", "ParallelPeriod", "Parent", "Parent_Level", "Parent_Unique_Name", "PeriodsToDate", "PMML", "Predict", "Predict_Only", "PredictAdjustedProbability", "PredictHistogram", "Prediction", "PredictionScore", "PredictProbability", "PredictProbabilityStDev", "PredictProbabilityVariance", "PredictStDev", "PredictSupport", "PredictVariance", "PrevMember", "Probability", "Probability_StDev", "Probability_StdDev", "Probability_Variance", "Properties", "Property", "QTD", "RangeMax", "RangeMid", "RangeMin", "Rank", "Recursive", "Refresh", "Related", "Rename", "Rollup", "Rows", "Schema_Name", "Sections", "Select", "Self", "Self_And_After", "Sequence_Time", "Server", "Session", "Set", "SetToArray", "SetToStr", "Shape", "Skip", "Solve_Order", "Sort", "StdDev", "Stdev", "StripCalculatedMembers", "StrToSet", "StrToTuple", "SubSet", "Support", "Tail", "Text", "Thresholds", "ToggleDrillState", "TopCount", "TopPercent", "TopSum", "TupleToStr", "Under", "Uniform", "UniqueName", "Use", "Value", "Value", "Var", "Variance", "VarP", "VarianceP", "VisualTotals", "When", "Where", "With", "WTD", "Xor"};

        DiscoverKeywordsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_KEYWORDS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            for (String keyword : keywords) {
                Rowset.Row row = new Rowset.Row();
                row.set(DiscoverKeywordsRowset.Keyword.name, keyword);
                this.addRow(row, rows);
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$2400() {
            return Keyword;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiscoverEnumeratorsRowset
    extends Rowset {
        private static final Column EnumName = new Column("EnumName", Type.StringArray, null, true, false, "The name of the enumerator that contains a set of values.");
        private static final Column EnumDescription = new Column("EnumDescription", Type.String, null, false, true, "A localizable description of the enumerator.");
        private static final Column EnumType = new Column("EnumType", Type.String, null, false, false, "The data type of the Enum values.");
        private static final Column ElementName = new Column("ElementName", Type.String, null, false, false, "The name of one of the value elements in the enumerator set.\nExample: TDP");
        private static final Column ElementDescription = new Column("ElementDescription", Type.String, null, false, true, "A localizable description of the element (optional).");
        private static final Column ElementValue = new Column("ElementValue", Type.String, null, false, true, "The value of the element.\nExample: 01");

        DiscoverEnumeratorsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_ENUMERATORS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            List<Enumeration> enumerators = DiscoverEnumeratorsRowset.getEnumerators();
            for (Enumeration enumerator : enumerators) {
                String[] valueNames;
                for (String valueName : valueNames = enumerator.getNames()) {
                    Enum<?> value = enumerator.getValue(valueName, true);
                    Rowset.Row row = new Rowset.Row();
                    row.set(DiscoverEnumeratorsRowset.EnumName.name, enumerator.name);
                    row.set(DiscoverEnumeratorsRowset.EnumDescription.name, enumerator.description);
                    row.set(DiscoverEnumeratorsRowset.EnumType.name, "string");
                    String name = value instanceof Enumeration.EnumWithName ? ((Enumeration.EnumWithName)((Object)value)).userName() : value.name();
                    row.set(DiscoverEnumeratorsRowset.ElementName.name, name);
                    if (value instanceof Enumeration.EnumWithDesc) {
                        String description = ((Enumeration.EnumWithDesc)((Object)value)).getDescription();
                        row.set(DiscoverEnumeratorsRowset.ElementDescription.name, description);
                    }
                    switch (enumerator.type) {
                        case String: 
                        case StringArray: {
                            break;
                        }
                        default: {
                            int ordinal = value instanceof Enumeration.EnumWithOrdinal ? ((Enumeration.EnumWithOrdinal)((Object)value)).userOrdinal() : value.ordinal();
                            row.set(DiscoverEnumeratorsRowset.ElementValue.name, ordinal);
                        }
                    }
                    this.addRow(row, rows);
                }
            }
        }

        private static List<Enumeration> getEnumerators() {
            TreeSet<Enumeration> enumeratorSet = new TreeSet<Enumeration>(new Comparator<Enumeration>(){

                @Override
                public int compare(Enumeration o1, Enumeration o2) {
                    return o1.name.compareTo(o2.name);
                }
            });
            for (RowsetDefinition rowsetDefinition : (RowsetDefinition[])RowsetDefinition.class.getEnumConstants()) {
                for (Column column : rowsetDefinition.columnDefinitions) {
                    if (column.enumeration == null) continue;
                    enumeratorSet.add(column.enumeration);
                }
            }
            return new ArrayList<Enumeration>(enumeratorSet);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$1200() {
            return EnumName;
        }

        static /* synthetic */ Column access$1300() {
            return EnumDescription;
        }

        static /* synthetic */ Column access$1400() {
            return EnumType;
        }

        static /* synthetic */ Column access$1500() {
            return ElementName;
        }

        static /* synthetic */ Column access$1600() {
            return ElementDescription;
        }

        static /* synthetic */ Column access$1700() {
            return ElementValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiscoverPropertiesRowset
    extends Rowset {
        private final Rowset.RestrictionTest propertyNameRT = this.getRestrictionTest(PropertyName);
        private static final Column PropertyName = new Column("PropertyName", Type.StringSometimesArray, null, true, false, "The name of the property.");
        private static final Column PropertyDescription = new Column("PropertyDescription", Type.String, null, false, false, "A localizable text description of the property.");
        private static final Column PropertyType = new Column("PropertyType", Type.String, null, false, false, "The XML data type of the property.");
        private static final Column PropertyAccessType = new Column("PropertyAccessType", Type.EnumString, Enumeration.Access.enumeration, false, false, "Access for the property. The value can be Read, Write, or ReadWrite.");
        private static final Column IsRequired = new Column("IsRequired", Type.Boolean, null, false, false, "True if a property is required, false if it is not required.");
        private static final Column Value = new Column("Value", Type.String, null, false, false, "The current value of the property.");

        DiscoverPropertiesRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_PROPERTIES, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            for (PropertyDefinition propertyDefinition : (PropertyDefinition[])PropertyDefinition.class.getEnumConstants()) {
                if (!this.propertyNameRT.passes(propertyDefinition.name())) continue;
                Rowset.Row row = new Rowset.Row();
                row.set(DiscoverPropertiesRowset.PropertyName.name, propertyDefinition.name());
                row.set(DiscoverPropertiesRowset.PropertyDescription.name, propertyDefinition.description);
                row.set(DiscoverPropertiesRowset.PropertyType.name, propertyDefinition.type.getName());
                row.set(DiscoverPropertiesRowset.PropertyAccessType.name, propertyDefinition.access);
                row.set(DiscoverPropertiesRowset.IsRequired.name, false);
                row.set(DiscoverPropertiesRowset.Value.name, propertyDefinition.value);
                this.addRow(row, rows);
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$1800() {
            return PropertyName;
        }

        static /* synthetic */ Column access$1900() {
            return PropertyDescription;
        }

        static /* synthetic */ Column access$2000() {
            return PropertyType;
        }

        static /* synthetic */ Column access$2100() {
            return PropertyAccessType;
        }

        static /* synthetic */ Column access$2200() {
            return IsRequired;
        }

        static /* synthetic */ Column access$2300() {
            return Value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiscoverSchemaRowsetsRowset
    extends Rowset {
        private static final Column SchemaName = new Column("SchemaName", Type.StringArray, null, true, false, "The name of the schema/request. This returns the values in the RequestTypes enumeration, plus any additional types supported by the provider. The provider defines rowset structures for the additional types");
        private static final Column SchemaGuid = new Column("SchemaGuid", Type.UUID, null, false, true, "The GUID of the schema.");
        private static final Column Restrictions = new Column("Restrictions", Type.Array, null, false, false, "An array of the restrictions suppoted by provider. An example follows this table.");
        private static final Column Description = new Column("Description", Type.String, null, false, false, "A localizable description of the schema");

        public DiscoverSchemaRowsetsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_SCHEMA_ROWSETS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            RowsetDefinition[] rowsetDefinitions = (RowsetDefinition[])((RowsetDefinition[])RowsetDefinition.class.getEnumConstants()).clone();
            Arrays.sort(rowsetDefinitions, new Comparator<Enum>(){

                @Override
                public int compare(Enum o1, Enum o2) {
                    return o1.name().compareTo(o2.name());
                }
            });
            for (RowsetDefinition rowsetDefinition : rowsetDefinitions) {
                Rowset.Row row = new Rowset.Row();
                row.set(DiscoverSchemaRowsetsRowset.SchemaName.name, rowsetDefinition.name());
                row.set(DiscoverSchemaRowsetsRowset.Restrictions.name, this.getRestrictions(rowsetDefinition));
                String desc = rowsetDefinition.getDescription();
                row.set(DiscoverSchemaRowsetsRowset.Description.name, desc == null ? "" : desc);
                this.addRow(row, rows);
            }
        }

        private List<Rowset.XmlElement> getRestrictions(RowsetDefinition rowsetDefinition) {
            Column[] columns;
            ArrayList<Rowset.XmlElement> restrictionList = new ArrayList<Rowset.XmlElement>();
            for (Column column : columns = rowsetDefinition.columnDefinitions) {
                if (!column.restriction) continue;
                restrictionList.add((Rowset)this.new Rowset.XmlElement(DiscoverSchemaRowsetsRowset.Restrictions.name, null, new Rowset.XmlElement[]{(Rowset)this.new Rowset.XmlElement("Name", null, column.name), (Rowset)this.new Rowset.XmlElement("Type", null, column.getColumnType())}));
            }
            return restrictionList;
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$800() {
            return SchemaName;
        }

        static /* synthetic */ Column access$900() {
            return SchemaGuid;
        }

        static /* synthetic */ Column access$1100() {
            return Description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiscoverDatasourcesRowset
    extends Rowset {
        private static final Column DataSourceName = new Column("DataSourceName", Type.String, null, true, false, "The name of the data source, such as FoodMart 2000.");
        private static final Column DataSourceDescription = new Column("DataSourceDescription", Type.String, null, false, true, "A description of the data source, as entered by the publisher.");
        private static final Column URL = new Column("URL", Type.String, null, true, true, "The unique path that shows where to invoke the XML for Analysis methods for that data source.");
        private static final Column DataSourceInfo = new Column("DataSourceInfo", Type.String, null, false, true, "A string containing any additional information required to connect to the data source. This can include the Initial Catalog property or other information for the provider.\nExample: \"Provider=MSOLAP;Data Source=Local;\"");
        private static final Column ProviderName = new Column("ProviderName", Type.String, null, true, true, "The name of the provider behind the data source. \nExample: \"MSDASQL\"");
        private static final Column ProviderType = new Column("ProviderType", Type.EnumerationArray, Enumeration.ProviderType.enumeration, true, false, true, "The types of data supported by the provider. May include one or more of the following types. Example follows this table.\nTDP: tabular data provider.\nMDP: multidimensional data provider.\nDMP: data mining provider. A DMP provider implements the OLE DB for Data Mining specification.");
        private static final Column AuthenticationMode = new Column("AuthenticationMode", Type.EnumString, Enumeration.AuthenticationMode.enumeration, true, false, "Specification of what type of security mode the data source uses. Values can be one of the following:\nUnauthenticated: no user ID or password needs to be sent.\nAuthenticated: User ID and Password must be included in the information required for the connection.\nIntegrated: the data source uses the underlying security to determine authorization, such as Integrated Security provided by Microsoft Internet Information Services (IIS).");

        public DiscoverDatasourcesRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_DATASOURCES, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            for (DataSourcesConfig.DataSource ds : this.handler.getDataSourceEntries().values()) {
                Rowset.Row row = new Rowset.Row();
                row.set(DiscoverDatasourcesRowset.DataSourceName.name, ds.getDataSourceName());
                row.set(DiscoverDatasourcesRowset.DataSourceDescription.name, ds.getDataSourceDescription());
                row.set(DiscoverDatasourcesRowset.URL.name, ds.getURL());
                row.set(DiscoverDatasourcesRowset.DataSourceInfo.name, ds.getDataSourceName());
                row.set(DiscoverDatasourcesRowset.ProviderName.name, ds.getProviderName());
                row.set(DiscoverDatasourcesRowset.ProviderType.name, ds.getProviderType());
                row.set(DiscoverDatasourcesRowset.AuthenticationMode.name, ds.getAuthenticationMode());
                this.addRow(row, rows);
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$000() {
            return DataSourceName;
        }

        static /* synthetic */ Column access$100() {
            return DataSourceDescription;
        }

        static /* synthetic */ Column access$200() {
            return URL;
        }

        static /* synthetic */ Column access$300() {
            return DataSourceInfo;
        }

        static /* synthetic */ Column access$400() {
            return ProviderName;
        }

        static /* synthetic */ Column access$500() {
            return ProviderType;
        }

        static /* synthetic */ Column access$600() {
            return AuthenticationMode;
        }
    }

    static class Column {
        static final boolean RESTRICTION = true;
        static final boolean NOT_RESTRICTION = false;
        static final boolean REQUIRED = false;
        static final boolean OPTIONAL = true;
        static final boolean ONE_MAX = false;
        static final boolean UNBOUNDED = true;
        final String name;
        final Type type;
        final Enumeration enumeration;
        final String description;
        final boolean restriction;
        final boolean nullable;
        final boolean unbounded;

        Column(String name, Type type, Enumeration enumeratedType, boolean restriction, boolean nullable, String description) {
            this(name, type, enumeratedType, restriction, nullable, false, description);
        }

        Column(String name, Type type, Enumeration enumeratedType, boolean restriction, boolean nullable, boolean unbounded, String description) {
            assert (type != null);
            assert ((type == Type.Enumeration || type == Type.EnumerationArray || type == Type.EnumString) == (enumeratedType != null));
            assert (description == null || description.indexOf(13) == -1);
            this.name = name;
            this.type = type;
            this.enumeration = enumeratedType;
            this.description = description;
            this.restriction = restriction;
            this.nullable = nullable;
            this.unbounded = unbounded;
        }

        protected Object get(Object row) {
            return this.getFromAccessor(row);
        }

        protected final Object getFromField(Object row) {
            try {
                String javaFieldName = this.name.substring(0, 1).toLowerCase() + this.name.substring(1);
                Field field = row.getClass().getField(javaFieldName);
                return field.get(row);
            }
            catch (NoSuchFieldException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (SecurityException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
        }

        protected final Object getFromAccessor(Object row) {
            try {
                String javaMethodName = "get" + this.name;
                Method method = row.getClass().getMethod(javaMethodName, new Class[0]);
                return method.invoke(row, new Object[0]);
            }
            catch (SecurityException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (NoSuchMethodException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (InvocationTargetException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
        }

        public String getColumnType() {
            if (this.type.isEnum()) {
                return this.enumeration.type.columnType;
            }
            return this.type.columnType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DBType {
        I4("INTEGER", 3, "DBTYPE_I4", "A four-byte, signed integer: INTEGER"),
        R8("DOUBLE", 5, "DBTYPE_R8", "A double-precision floating-point value: Double"),
        CY("CURRENCY", 6, "DBTYPE_CY", "A currency value: LARGE_INTEGER, Currency is a fixed-point number with four digits to the right of the decimal point. It is stored in an eight-byte signed integer, scaled by 10,000."),
        BOOL("BOOLEAN", 11, "DBTYPE_BOOL", "A Boolean value stored in the same way as in Automation: VARIANT_BOOL; 0 means false and ~0 (bitwise, the value is not 0; that is, all bits are set to 1) means true."),
        VARIANT("VARIANT", 12, "DBTYPE_VARIANT", "An Automation VARIANT"),
        UI2("UNSIGNED_SHORT", 18, "DBTYPE_UI2", "A two-byte, unsigned integer"),
        UI4("UNSIGNED_INTEGER", 19, "DBTYPE_UI4", "A four-byte, unsigned integer"),
        I8("LARGE_INTEGER", 20, "DBTYPE_I8", "An eight-byte, signed integer: LARGE_INTEGER"),
        WSTR("STRING", 130, "DBTYPE_WSTR", "A null-terminated Unicode character string: wchar_t[length]; If DBTYPE_WSTR is used by itself, the number of bytes allocated for the string, including the null-termination character, is specified by cbMaxLen in the DBBINDING structure. If DBTYPE_WSTR is combined with DBTYPE_BYREF, the number of bytes allocated for the string, including the null-termination character, is at least the length of the string plus two. In either case, the actual length of the string is determined from the bound length value. The maximum length of the string is the number of allocated bytes divided by sizeof(wchar_t) and truncated to the nearest integer.");

        private final String userName;
        private final int userOrdinal;
        private final String description;
        String dbTypeIndicator;

        private DBType(String userName, int userOrdinal, String dbTypeIndicator, String description) {
            this.userName = userName;
            this.userOrdinal = userOrdinal;
            this.description = description;
            this.dbTypeIndicator = dbTypeIndicator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        String("xsd:string"),
        StringArray("xsd:string"),
        Array("xsd:string"),
        Enumeration("xsd:string"),
        EnumerationArray("xsd:string"),
        EnumString("xsd:string"),
        Boolean("xsd:boolean"),
        StringSometimesArray("xsd:string"),
        Integer("xsd:int"),
        UnsignedInteger("xsd:unsignedInt"),
        DateTime("xsd:dateTime"),
        Short("xsd:short"),
        UUID("uuid"),
        UnsignedShort("xsd:unsignedShort"),
        Long("xsd:long"),
        UnsignedLong("xsd:unsignedLong");

        public final String columnType;

        private Type(String columnType) {
            this.columnType = columnType;
        }

        boolean isEnum() {
            return this == Enumeration || this == EnumerationArray || this == EnumString;
        }

        String getName() {
            return this == String ? "string" : this.name();
        }
    }
}

