/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.calc.ParameterSlot;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.NamedSetExpr;
import mondrian.mdx.ParameterExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.CellFormatter;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Parameter;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.ResultBase;
import mondrian.olap.ResultLimitExceededException;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.MondrianEvaluationException;
import mondrian.resource.MondrianResource;
import mondrian.rolap.CellKey;
import mondrian.rolap.CellReader;
import mondrian.rolap.FastBatchingCellReader;
import mondrian.rolap.Modulos;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapAxis;
import mondrian.rolap.RolapCell;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapDependencyTestingEvaluator;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapMeasure;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.agg.AggregationManager;
import mondrian.util.Format;
import mondrian.util.ObjectPool;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapResult
extends ResultBase {
    private static final Logger LOGGER = Logger.getLogger(ResultBase.class);
    private RolapEvaluator evaluator;
    private final CellKey point;
    private CellInfoContainer cellInfos;
    private FastBatchingCellReader batchingReader;
    AggregatingCellReader aggregatingReader = new AggregatingCellReader();
    private Modulos modulos = null;
    private final int maxEvalDepth;
    protected static final Map<Locale, ValueFormatter> formatValueFormatters = Collections.synchronizedMap(new HashMap());
    protected static final Map<CellFormatter, ValueFormatter> cellFormatters = Collections.synchronizedMap(new HashMap());

    RolapResult(Query query, boolean execute) {
        super(query, new Axis[query.axes.length]);
        this.maxEvalDepth = MondrianProperties.instance().MaxEvalDepth.get();
        this.point = CellKey.Generator.newCellKey(query.axes.length);
        int expDeps = MondrianProperties.instance().TestExpDependencies.get();
        if (expDeps > 0) {
            this.evaluator = new RolapDependencyTestingEvaluator(this, expDeps);
        } else {
            RolapResultEvaluatorRoot root = new RolapResultEvaluatorRoot(this);
            this.evaluator = new RolapEvaluator(root);
        }
        RolapCube rcube = (RolapCube)query.getCube();
        this.batchingReader = new FastBatchingCellReader(rcube);
        CellInfoContainer cellInfoContainer = this.cellInfos = query.axes.length > 4 ? new CellInfoMap(this.point) : new CellInfoPool(query.axes.length);
        if (!execute) {
            return;
        }
        boolean normalExecution = true;
        try {
            Calc calc;
            QueryAxis axis;
            rcube.clearCachedAggregations();
            rcube.checkAggregateModifications();
            AxisMember axisMembers = new AxisMember();
            ArrayList<Member> nonDefaultAllMembers = new ArrayList<Member>();
            ArrayList<Member[]> nonAllMembers = new ArrayList<Member[]>();
            ArrayList<Member> measureMembers = new ArrayList<Member>();
            this.loadSpecialMembers(nonDefaultAllMembers, nonAllMembers, measureMembers);
            query.clearEvalCache();
            query.putEvalCache("ALL_MEMBER_LIST", nonDefaultAllMembers);
            List<Member[]> emptyNonAllMembers = Collections.emptyList();
            axisMembers.setSlicer(true);
            this.loadMembers(emptyNonAllMembers, this.evaluator, query.slicerAxis, query.slicerCalc, axisMembers);
            axisMembers.setSlicer(false);
            if (!axisMembers.isEmpty()) {
                for (Member m : axisMembers) {
                    this.evaluator.setContext(m);
                    if (!m.isMeasure()) continue;
                    measureMembers.clear();
                }
                this.replaceNonAllMembers(nonAllMembers, axisMembers);
                axisMembers.clearMembers();
            }
            boolean changed = false;
            axisMembers.clearTotalCellCount();
            for (int i = 0; i < this.axes.length; ++i) {
                axis = query.axes[i];
                calc = query.axisCalcs[i];
                this.loadMembers(emptyNonAllMembers, this.evaluator, axis, calc, axisMembers);
            }
            if (!axisMembers.isEmpty()) {
                for (Member m : axisMembers) {
                    if (!m.isMeasure()) continue;
                    measureMembers.clear();
                }
                changed = this.replaceNonAllMembers(nonAllMembers, axisMembers);
                axisMembers.clearMembers();
            }
            if (changed) {
                axisMembers.countOnly(true);
                axisMembers.clearTotalCellCount();
                for (int i = 0; i < this.axes.length; ++i) {
                    axis = query.axes[i];
                    calc = query.axisCalcs[i];
                    this.loadMembers(nonAllMembers, (RolapEvaluator)this.evaluator.push(), axis, calc, axisMembers);
                }
            }
            axisMembers.checkLimit();
            this.slicerAxis = this.evalExecute(nonAllMembers, nonAllMembers.size() - 1, (RolapEvaluator)this.evaluator.push(), query.slicerAxis, query.slicerCalc);
            switch (this.slicerAxis.getPositions().size()) {
                case 0: {
                    throw MondrianResource.instance().EmptySlicer.ex();
                }
                case 1: {
                    break;
                }
                default: {
                    throw MondrianResource.instance().CompoundSlicer.ex();
                }
            }
            boolean redo = true;
            while (redo) {
                RolapEvaluator e = (RolapEvaluator)this.evaluator.push();
                redo = false;
                for (int i = 0; i < this.axes.length; ++i) {
                    List<Position> pl;
                    Iterator<Position> i$;
                    QueryAxis axis2 = query.axes[i];
                    Calc calc2 = query.axisCalcs[i];
                    Axis axisResult = this.evalExecute(nonAllMembers, nonAllMembers.size() - 1, e, axis2, calc2);
                    if (!nonAllMembers.isEmpty() && (i$ = (pl = axisResult.getPositions()).iterator()).hasNext()) {
                        Position p = i$.next();
                        for (Member m : p) {
                            if (!m.isCalculated()) continue;
                            CalculatedMeasureVisitor visitor = new CalculatedMeasureVisitor();
                            m.getExpression().accept(visitor);
                            Dimension dimension = visitor.dimension;
                            redo = this.removeDimension(dimension, nonAllMembers);
                        }
                    }
                    this.axes[i] = axisResult;
                }
            }
            this.executeBody(query);
            if (this.cellInfos.size() > 10000) {
                this.cellInfos.trimToSize();
            }
        }
        catch (ResultLimitExceededException ex) {
            normalExecution = false;
            this.evaluator = null;
            this.cellInfos = null;
            this.batchingReader = null;
            for (int i = 0; i < this.axes.length; ++i) {
                this.axes[i] = null;
            }
            this.slicerAxis = null;
            query.clearEvalCache();
            throw ex;
        }
        finally {
            if (normalExecution) {
                rcube.pushAggregateModificationsToGlobalCache();
                this.evaluator.clearExpResultCache();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("RolapResult<init>: " + Util.printMemory()));
            }
        }
    }

    protected boolean removeDimension(Dimension dimension, List<Member[]> nonAllMembers) {
        boolean changed = false;
        ListIterator<Member[]> it = nonAllMembers.listIterator();
        while (it.hasNext()) {
            Member[] ms = it.next();
            Dimension d = ms[0].getHierarchy().getDimension();
            if (!d.equals(dimension)) continue;
            it.remove();
        }
        return changed;
    }

    protected boolean replaceNonAllMembers(List<Member[]> nonAllMembers, AxisMember axisMembers) {
        boolean changed = false;
        ArrayList<Member> mList = new ArrayList<Member>();
        ListIterator<Member[]> it = nonAllMembers.listIterator();
        while (it.hasNext()) {
            Member[] ms = it.next();
            Hierarchy h = ms[0].getHierarchy();
            mList.clear();
            for (Member m : axisMembers) {
                if (!m.getHierarchy().equals(h)) continue;
                mList.add(m);
            }
            if (mList.isEmpty()) continue;
            changed = true;
            Member[] ml = mList.toArray(new Member[mList.size()]);
            it.set(ml);
        }
        return changed;
    }

    protected void loadMembers(List<Member[]> nonAllMembers, RolapEvaluator evaluator, QueryAxis axis, Calc calc, AxisMember axisMembers) {
        block1: {
            int attempt = 0;
            evaluator.setCellReader(this.batchingReader);
            do {
                axisMembers.clearAxisCount();
                this.evalLoad(nonAllMembers, nonAllMembers.size() - 1, evaluator, axis, calc, axisMembers);
                evaluator.clearExpResultCache();
                if (!this.batchingReader.loadAggregations(this.query)) break block1;
            } while (attempt++ <= this.maxEvalDepth);
            throw Util.newInternal("Failed to load all aggregations after " + this.maxEvalDepth + "passes; there's probably a cycle");
        }
    }

    void evalLoad(List<Member[]> nonAllMembers, int cnt, Evaluator evaluator, QueryAxis axis, Calc calc, AxisMember axisMembers) {
        if (cnt < 0) {
            this.executeAxis(evaluator.push(), axis, calc, false, axisMembers);
        } else {
            for (Member m : nonAllMembers.get(cnt)) {
                evaluator.setContext(m);
                this.evalLoad(nonAllMembers, cnt - 1, evaluator, axis, calc, axisMembers);
            }
        }
    }

    Axis evalExecute(List<Member[]> nonAllMembers, int cnt, RolapEvaluator evaluator, QueryAxis axis, Calc calc) {
        Axis axisResult = null;
        if (cnt < 0) {
            evaluator.setCellReader(this.aggregatingReader);
            axisResult = this.executeAxis(evaluator.push(), axis, calc, true, null);
            evaluator.clearExpResultCache();
        } else {
            for (Member m : nonAllMembers.get(cnt)) {
                evaluator.setContext(m);
                Axis a = this.evalExecute(nonAllMembers, cnt - 1, evaluator, axis, calc);
                axisResult = RolapResult.mergeAxes(axisResult, a);
            }
        }
        return axisResult;
    }

    protected void loadSpecialMembers(List<Member> nonDefaultAllMembers, List<Member[]> nonAllMembers, List<Member> measureMembers) {
        SchemaReader schemaReader = this.evaluator.getSchemaReader();
        Member[] evalMembers = this.evaluator.getMembers();
        boolean j = false;
        for (int i = 0; i < evalMembers.length; ++i) {
            Hierarchy h;
            Dimension d;
            Member em = evalMembers[i];
            if (em.isCalculated() || (d = (h = em.getHierarchy()).getDimension()).getDimensionType() == DimensionType.TimeDimension || em.isAll()) continue;
            Member[] rootMembers = schemaReader.getHierarchyRootMembers(h);
            if (em.isMeasure()) {
                for (Member mm : rootMembers) {
                    measureMembers.add(mm);
                }
                continue;
            }
            if (h.hasAll()) {
                boolean found = false;
                for (Member m : rootMembers) {
                    if (!m.isAll()) continue;
                    nonDefaultAllMembers.add(m);
                    found = true;
                    break;
                }
                if (found) continue;
            }
            nonAllMembers.add(rootMembers);
        }
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public Cube getCube() {
        return this.evaluator.getCube();
    }

    @Override
    public Axis[] getAxes() {
        return this.axes;
    }

    @Override
    public Cell getCell(int[] pos) {
        if (pos.length != this.point.size()) {
            throw Util.newError("coordinates should have dimension " + this.point.size());
        }
        CellInfo ci = this.cellInfos.lookup(pos);
        if (ci.value == null) {
            ci.value = Util.nullValue;
        }
        return new RolapCell(this, (int[])pos.clone(), ci);
    }

    private Axis executeAxis(Evaluator evaluator, QueryAxis axis, Calc axisCalc, boolean construct, AxisMember axisMembers) {
        RolapAxis axisResult = null;
        if (axis == null) {
            if (construct) {
                axisResult = new RolapAxis.SingleEmptyPosition();
            }
        } else {
            evaluator.setNonEmpty(axis.isNonEmpty());
            evaluator.setEvalAxes(true);
            Object value = axisCalc.evaluate(evaluator);
            evaluator.setNonEmpty(false);
            if (value != null) {
                if (value instanceof List) {
                    List list = (List)value;
                    if (construct) {
                        axisResult = list.size() == 0 ? new RolapAxis.NoPosition() : (list.get(0) instanceof Member[] ? new RolapAxis.MemberArrayList((List)value) : new RolapAxis.MemberList((List)value));
                    } else if (axisMembers != null) {
                        axisMembers.merge(value);
                    }
                } else {
                    Iterable iter = (Iterable)value;
                    Iterator it = iter.iterator();
                    if (construct) {
                        axisResult = !it.hasNext() ? new RolapAxis.NoPosition() : (it.next() instanceof Member[] ? new RolapAxis.MemberArrayIterable((Iterable)value) : new RolapAxis.MemberIterable((Iterable)value));
                    } else if (axisMembers != null) {
                        axisMembers.merge(it);
                    }
                }
            }
            evaluator.setEvalAxes(false);
        }
        return axisResult;
    }

    private void executeBody(Query query) {
        int count = 0;
        while (true) {
            this.evaluator.setCellReader(this.batchingReader);
            this.executeStripe(query.axes.length - 1, (RolapEvaluator)this.evaluator.push());
            this.evaluator.clearExpResultCache();
            if (!this.batchingReader.loadAggregations(query)) {
                return;
            }
            if (count++ > this.maxEvalDepth) {
                if (this.evaluator instanceof RolapDependencyTestingEvaluator) {
                    ((RolapDependencyTestingEvaluator.DteRoot)this.evaluator.root).disabled = true;
                    if (count > this.maxEvalDepth * 2) {
                        throw Util.newInternal("Query required more than " + count + " iterations");
                    }
                } else {
                    throw Util.newInternal("Query required more than " + count + " iterations");
                }
            }
            this.cellInfos.clear();
        }
    }

    boolean isDirty() {
        return this.batchingReader.isDirty();
    }

    private Object evaluateExp(Calc calc, Evaluator evaluator) {
        RolapEvaluator ev;
        boolean dirty;
        block2: {
            int attempt = 0;
            dirty = this.batchingReader.isDirty();
            do {
                ev = (RolapEvaluator)evaluator.push();
                ev.setCellReader(this.batchingReader);
                Object preliminaryValue = calc.evaluate(ev);
                Util.discard((Object)preliminaryValue);
                if (!this.batchingReader.loadAggregations(evaluator.getQuery())) break block2;
            } while (attempt++ <= this.maxEvalDepth);
            throw Util.newInternal("Failed to load all aggregations after " + this.maxEvalDepth + "passes; there's probably a cycle");
        }
        if (dirty) {
            this.batchingReader.setDirty(true);
        }
        ev = (RolapEvaluator)evaluator.push();
        ev.setCellReader(this.aggregatingReader);
        Object value = calc.evaluate(ev);
        return value;
    }

    private void executeStripe(int axisOrdinal, RolapEvaluator revaluator) {
        if (axisOrdinal < 0) {
            Axis axis = this.slicerAxis;
            List<Position> positions = axis.getPositions();
            for (Position position : positions) {
                Object o;
                this.getQuery().checkCancelOrTimeout();
                revaluator.setContext(position);
                try {
                    o = revaluator.evaluateCurrent();
                }
                catch (MondrianEvaluationException e) {
                    o = e;
                }
                CellInfo ci = null;
                try {
                    ValueFormatter valueFormatter;
                    ci = this.cellInfos.create(this.point.getOrdinals());
                    String cachedFormatString = null;
                    RolapCube cube = (RolapCube)this.getCube();
                    Dimension measuresDim = cube.getMeasuresHierarchy().getDimension();
                    RolapMeasure m = (RolapMeasure)revaluator.getContext(measuresDim);
                    CellFormatter cf = m.getFormatter();
                    if (cf != null) {
                        valueFormatter = cellFormatters.get(cf);
                        if (valueFormatter == null) {
                            valueFormatter = new CellFormatterValueFormatter(cf);
                            cellFormatters.put(cf, valueFormatter);
                        }
                    } else {
                        cachedFormatString = revaluator.getFormatString();
                        Locale locale = this.query.getConnection().getLocale();
                        valueFormatter = formatValueFormatters.get(locale);
                        if (valueFormatter == null) {
                            valueFormatter = new FormatValueFormatter(locale);
                            formatValueFormatters.put(locale, valueFormatter);
                        }
                    }
                    ci.formatString = cachedFormatString;
                    ci.valueFormatter = valueFormatter;
                }
                catch (ResultLimitExceededException e) {
                    throw e;
                }
                catch (MondrianEvaluationException e) {
                }
                catch (Throwable e) {
                    Util.discard((Object)e);
                }
                if (o == RolapUtil.valueNotReadyException) continue;
                ci.value = o;
            }
        } else {
            Axis axis = this.axes[axisOrdinal];
            List<Position> positions = axis.getPositions();
            int i = 0;
            for (Position position : positions) {
                this.point.setAxis(axisOrdinal, i);
                revaluator.setContext(position);
                this.getQuery().checkCancelOrTimeout();
                this.executeStripe(axisOrdinal - 1, revaluator);
                ++i;
            }
        }
    }

    int[] getCellPos(int cellOrdinal) {
        if (this.modulos == null) {
            this.makeModulos();
        }
        return this.modulos.getCellPos(cellOrdinal);
    }

    int getCellOrdinal(int[] pos) {
        if (this.modulos == null) {
            this.makeModulos();
        }
        return this.modulos.getCellOrdinal(pos);
    }

    protected void makeModulos() {
        this.modulos = Modulos.Generator.create(this.axes);
    }

    RolapEvaluator getCellEvaluator(int[] pos) {
        RolapEvaluator cellEvaluator = (RolapEvaluator)this.evaluator.push();
        for (int i = 0; i < pos.length; ++i) {
            Position position = this.axes[i].getPositions().get(pos[i]);
            cellEvaluator.setContext(position);
        }
        return cellEvaluator;
    }

    Member[] getCellMembers(int[] pos) {
        Member[] members = (Member[])this.evaluator.getMembers().clone();
        Cube cube = this.getCube();
        for (int i = 0; i < pos.length; ++i) {
            Position position = this.axes[i].getPositions().get(pos[i]);
            for (Member member : position) {
                RolapMember m = (RolapMember)member;
                int ordinal = m.getDimension().getOrdinal(cube);
                members[ordinal] = m;
            }
        }
        return members;
    }

    Evaluator getRootEvaluator() {
        return this.evaluator;
    }

    Evaluator getEvaluator(int[] pos) {
        Evaluator cellEvaluator = this.evaluator.push();
        for (int i = -1; i < this.axes.length; ++i) {
            int index;
            Axis axis;
            if (i < 0) {
                axis = this.slicerAxis;
                index = 0;
            } else {
                axis = this.axes[i];
                index = pos[i];
            }
            Position position = axis.getPositions().get(index);
            cellEvaluator.setContext(position);
        }
        return cellEvaluator;
    }

    static Axis mergeAxes(Axis axis1, Axis axis2) {
        int i;
        ArrayList<Member> list;
        if (axis1 == null) {
            return axis2;
        }
        List<Position> pl1 = axis1.getPositions();
        List<Position> pl2 = axis2.getPositions();
        int arrayLen = -1;
        if (pl1 instanceof RolapAxis.PositionListBase) {
            if (pl1.size() == 0) {
                return axis2;
            }
            arrayLen = pl1.get(0).size();
        }
        if (axis1 instanceof RolapAxis.SingleEmptyPosition) {
            return axis2;
        }
        if (axis1 instanceof RolapAxis.NoPosition) {
            return axis2;
        }
        if (pl2 instanceof RolapAxis.PositionListBase) {
            if (pl2.size() == 0) {
                return axis1;
            }
            arrayLen = pl2.get(0).size();
        }
        if (axis2 instanceof RolapAxis.SingleEmptyPosition) {
            return axis1;
        }
        if (axis2 instanceof RolapAxis.NoPosition) {
            return axis1;
        }
        if (arrayLen == -1) {
            arrayLen = 0;
            Iterator<Position> i$ = pl1.iterator();
            if (i$.hasNext()) {
                Position p1 = i$.next();
                for (Member m1 : p1) {
                    ++arrayLen;
                }
            }
        }
        if (arrayLen == 1) {
            list = new ArrayList<Member>();
            for (Position p1 : pl1) {
                for (Member m1 : p1) {
                    list.add(m1);
                }
            }
            for (Position p2 : pl2) {
                for (Member m2 : p2) {
                    if (list.contains(m2)) continue;
                    list.add(m2);
                }
            }
            return new RolapAxis.MemberList(list);
        }
        list = new ArrayList();
        for (Position p1 : pl1) {
            Member[] members = new Member[arrayLen];
            i = 0;
            for (Member m1 : p1) {
                members[i++] = m1;
            }
            list.add((Member)members);
        }
        ArrayList<Object[]> extras = new ArrayList<Object[]>();
        for (Position p2 : pl2) {
            i = 0;
            Object[] members = new Member[arrayLen];
            for (Member m2 : p2) {
                members[i++] = m2;
            }
            Iterator it1 = list.iterator();
            boolean found = false;
            while (it1.hasNext()) {
                Object[] m1 = (Member[])it1.next();
                if (!Arrays.equals(members, m1)) continue;
                found = true;
                break;
            }
            if (found) continue;
            extras.add(members);
        }
        list.addAll(extras);
        return new RolapAxis.MemberArrayList(list);
    }

    static class CellInfoPool
    implements CellInfoContainer {
        protected static final long MAX_AXIS_SIZE_2 = Integer.MAX_VALUE;
        protected static final long MAX_AXIS_SIZE_3 = 2000000L;
        protected static final long MAX_AXIS_SIZE_4 = 50000L;
        private final ObjectPool<CellInfo> cellInfoPool = new ObjectPool();
        private final CellKeyMaker cellKeyMaker;

        CellInfoPool(int axisLength) {
            switch (axisLength) {
                case 0: {
                    this.cellKeyMaker = new Zero();
                    break;
                }
                case 1: {
                    this.cellKeyMaker = new One();
                    break;
                }
                case 2: {
                    this.cellKeyMaker = new Two();
                    break;
                }
                case 3: {
                    this.cellKeyMaker = new Three();
                    break;
                }
                case 4: {
                    this.cellKeyMaker = new Four();
                    break;
                }
                default: {
                    throw new RuntimeException("Creating CellInfoPool with axisLength=" + axisLength);
                }
            }
        }

        public int size() {
            return this.cellInfoPool.size();
        }

        public void trimToSize() {
            this.cellInfoPool.trimToSize();
        }

        public void clear() {
            this.cellInfoPool.clear();
        }

        public CellInfo create(int[] pos) {
            long key = this.cellKeyMaker.generate(pos);
            return this.cellInfoPool.add(new CellInfo(key));
        }

        public CellInfo lookup(int[] pos) {
            long key = this.cellKeyMaker.generate(pos);
            return this.cellInfoPool.add(new CellInfo(key));
        }

        static class Four
        implements CellKeyMaker {
            Four() {
            }

            public long generate(int[] pos) {
                long l = pos[0];
                l += 50000L * (long)pos[1];
                l += 2500000000L * (long)pos[2];
                return l += 125000000000000L * (long)pos[3];
            }
        }

        static class Three
        implements CellKeyMaker {
            Three() {
            }

            public long generate(int[] pos) {
                long l = pos[0];
                l += 2000000L * (long)pos[1];
                return l += 4000000000000L * (long)pos[2];
            }
        }

        static class Two
        implements CellKeyMaker {
            Two() {
            }

            public long generate(int[] pos) {
                long l = pos[0];
                return l += Integer.MAX_VALUE * (long)pos[1];
            }
        }

        static class One
        implements CellKeyMaker {
            One() {
            }

            public long generate(int[] pos) {
                return pos[0];
            }
        }

        static class Zero
        implements CellKeyMaker {
            Zero() {
            }

            public long generate(int[] pos) {
                return 0L;
            }
        }

        static interface CellKeyMaker {
            public long generate(int[] var1);
        }
    }

    static class CellInfoMap
    implements CellInfoContainer {
        private final Map<CellKey, CellInfo> cellInfoMap;
        private final CellKey point;

        CellInfoMap(CellKey point) {
            this.point = point;
            this.cellInfoMap = new HashMap<CellKey, CellInfo>();
        }

        public int size() {
            return this.cellInfoMap.size();
        }

        public void trimToSize() {
        }

        public void clear() {
            this.cellInfoMap.clear();
        }

        public CellInfo create(int[] pos) {
            CellKey key = this.point.copy();
            CellInfo ci = this.cellInfoMap.get(key);
            if (ci == null) {
                ci = new CellInfo(0L);
                this.cellInfoMap.put(key, ci);
            }
            return ci;
        }

        public CellInfo lookup(int[] pos) {
            CellKey key = CellKey.Generator.newCellKey(pos);
            return this.cellInfoMap.get(key);
        }
    }

    static interface CellInfoContainer {
        public int size();

        public void trimToSize();

        public void clear();

        public CellInfo create(int[] var1);

        public CellInfo lookup(int[] var1);
    }

    static class CellInfo {
        Object value;
        String formatString;
        ValueFormatter valueFormatter;
        long key;

        CellInfo(long key) {
            this(key, null, null, null);
        }

        CellInfo(long key, Object value, String formatString, ValueFormatter valueFormatter) {
            this.key = key;
            this.value = value;
            this.formatString = formatString;
            this.valueFormatter = valueFormatter;
        }

        public int hashCode() {
            return (int)(this.key ^ this.key >>> 32);
        }

        public boolean equals(Object o) {
            if (o instanceof CellInfo) {
                CellInfo that = (CellInfo)o;
                return that.key == this.key;
            }
            return false;
        }

        String getFormatValue() {
            return this.valueFormatter.format(this.value, this.formatString);
        }
    }

    class FormatValueFormatter
    implements ValueFormatter {
        final Locale locale;

        FormatValueFormatter(Locale locale) {
            this.locale = locale;
        }

        public String format(Object value, String formatString) {
            if (value == Util.nullValue) {
                Format format = this.getFormat(formatString);
                return format.format(null);
            }
            if (value instanceof Throwable) {
                return "#ERR: " + value.toString();
            }
            if (value instanceof String) {
                return (String)value;
            }
            Format format = this.getFormat(formatString);
            return format.format(value);
        }

        private Format getFormat(String formatString) {
            return Format.get(formatString, this.locale);
        }
    }

    class CellFormatterValueFormatter
    implements ValueFormatter {
        final CellFormatter cf;

        CellFormatterValueFormatter(CellFormatter cf) {
            this.cf = cf;
        }

        public String format(Object value, String formatString) {
            return this.cf.formatCell(value);
        }
    }

    static interface ValueFormatter {
        public String format(Object var1, String var2);
    }

    protected static class RolapResultEvaluatorRoot
    extends RolapEvaluator.RolapEvaluatorRoot {
        private final Map<String, Object> namedSetValues = new HashMap<String, Object>();
        private RolapEvaluator slicerEvaluator;
        private final RolapResult result;
        private static final Object Sentinel = new Object();

        public RolapResultEvaluatorRoot(RolapResult result) {
            super(result.query);
            this.result = result;
        }

        protected void init(Evaluator evaluator) {
            this.slicerEvaluator = (RolapEvaluator)evaluator;
        }

        protected Object evaluateNamedSet(String name, Exp exp) {
            List value = this.namedSetValues.get(name);
            if (value == null) {
                ArrayList list;
                RolapEvaluator.RolapEvaluatorRoot root = this.slicerEvaluator.root;
                Calc calc = root.getCompiled(exp, false);
                Object o = this.result.evaluateExp(calc, this.slicerEvaluator.push());
                if (o instanceof List) {
                    list = (ArrayList)o;
                } else {
                    Iterable iter = (Iterable)o;
                    list = new ArrayList();
                    for (Object e : iter) {
                        list.add(e);
                    }
                }
                value = Collections.unmodifiableList(list);
                this.namedSetValues.put(name, value);
            }
            return value;
        }

        protected void clearNamedSets() {
            this.namedSetValues.clear();
        }

        public Object getParameterValue(ParameterSlot slot) {
            Object value = slot.getParameterValue();
            if (value != null) {
                return value;
            }
            Parameter.Scope scope = slot.getParameter().getScope();
            switch (scope) {
                case System: 
                case Schema: 
                case Connection: 
                case Statement: {
                    break;
                }
                default: {
                    throw Util.badValue(scope);
                }
            }
            value = slot.getCachedDefaultValue();
            if (value != null) {
                if (value == Sentinel) {
                    throw MondrianResource.instance().CycleDuringParameterEvaluation.ex(slot.getParameter().getName());
                }
                return value;
            }
            slot.setCachedDefaultValue(Sentinel);
            value = this.result.evaluateExp(slot.getDefaultValueCalc(), this.slicerEvaluator.push());
            slot.setCachedDefaultValue(value);
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AxisMember
    implements Iterable<Member> {
        private final List<Member> members = new ArrayList<Member>();
        private final int limit;
        private boolean isSlicer;
        private int totalCellCount = 1;
        private int axisCount = 0;
        private boolean countOnly = false;

        AxisMember() {
            this.limit = MondrianProperties.instance().ResultLimit.get();
        }

        @Override
        public Iterator<Member> iterator() {
            return this.members.iterator();
        }

        void setSlicer(boolean isSlicer) {
            this.isSlicer = isSlicer;
        }

        boolean isEmpty() {
            return this.members.isEmpty();
        }

        void countOnly(boolean countOnly) {
            this.countOnly = countOnly;
        }

        void checkLimit() {
            if (this.limit > 0) {
                this.totalCellCount *= this.axisCount;
                if (this.totalCellCount > this.limit) {
                    throw MondrianResource.instance().TotalMembersLimitExceeded.ex(this.totalCellCount, this.limit);
                }
                this.axisCount = 0;
            }
        }

        void clearAxisCount() {
            this.axisCount = 0;
        }

        void clearTotalCellCount() {
            this.totalCellCount = 1;
        }

        void clearMembers() {
            this.members.clear();
            this.axisCount = 0;
            this.totalCellCount = 1;
        }

        List<Member> members() {
            return this.members;
        }

        void merge(Object value) {
            block4: {
                List list = (List)value;
                if (list.size() == 0) break block4;
                if (list.get(0) instanceof Member[]) {
                    for (Member[] o : (List)value) {
                        this.merge(o);
                    }
                } else {
                    for (Member o : (List)value) {
                        this.merge(o);
                    }
                }
            }
        }

        void merge(Iterator it) {
            block4: {
                if (!it.hasNext()) break block4;
                Object o = it.next();
                if (o instanceof Member[]) {
                    this.merge((Member[])o);
                    while (it.hasNext()) {
                        o = it.next();
                        this.merge((Member[])o);
                    }
                } else {
                    this.merge((Member)o);
                    while (it.hasNext()) {
                        o = it.next();
                        this.merge((Member)o);
                    }
                }
            }
        }

        private Member getTopParent(Member m) {
            Member parent = m.getParentMember();
            return parent == null ? m : this.getTopParent(parent);
        }

        private void merge(List<Member> members) {
            for (Member member : members) {
                this.merge(member);
            }
        }

        private void merge(Member[] members) {
            for (Member member : members) {
                this.merge(member);
            }
        }

        private void merge(Member member) {
            ++this.axisCount;
            if (!this.countOnly) {
                if (this.isSlicer) {
                    if (!this.members.contains(member)) {
                        this.members.add(member);
                    }
                } else {
                    if (member.isNull()) {
                        return;
                    }
                    if (member.isMeasure()) {
                        return;
                    }
                    if (member.isCalculated()) {
                        return;
                    }
                    if (member.isAll()) {
                        return;
                    }
                    Member topParent = this.getTopParent(member);
                    if (!this.members.contains(topParent)) {
                        this.members.add(topParent);
                    }
                }
            }
        }
    }

    private static class AggregatingCellReader
    implements CellReader {
        private final RolapAggregationManager aggMan = AggregationManager.instance();

        private AggregatingCellReader() {
        }

        public Object get(Evaluator evaluator) {
            RolapEvaluator rolapEvaluator = (RolapEvaluator)evaluator;
            return this.aggMan.getCellFromCache(rolapEvaluator.getMembers());
        }

        public int getMissCount() {
            return this.aggMan.getMissCount();
        }
    }

    private static class MeasureVisitor
    extends MdxVisitorImpl {
        List<Member> measures = new ArrayList<Member>();

        MeasureVisitor() {
        }

        public Object visit(Formula formula) {
            return null;
        }

        public Object visit(ResolvedFunCall call) {
            return null;
        }

        public Object visit(Id id) {
            return null;
        }

        public Object visit(ParameterExpr parameterExpr) {
            return null;
        }

        public Object visit(DimensionExpr dimensionExpr) {
            return null;
        }

        public Object visit(HierarchyExpr hierarchyExpr) {
            return null;
        }

        public Object visit(LevelExpr levelExpr) {
            return null;
        }

        public Object visit(MemberExpr memberExpr) {
            Member member = memberExpr.getMember();
            if (member.isMeasure() && !this.measures.contains(member)) {
                this.measures.add(member);
            }
            return null;
        }

        public Object visit(NamedSetExpr namedSetExpr) {
            return null;
        }

        public Object visit(Literal literal) {
            return null;
        }
    }

    private static class CalculatedMeasureVisitor
    extends MdxVisitorImpl {
        Dimension dimension;

        CalculatedMeasureVisitor() {
        }

        public Object visit(Formula formula) {
            return null;
        }

        public Object visit(ResolvedFunCall call) {
            return null;
        }

        public Object visit(Id id) {
            return null;
        }

        public Object visit(ParameterExpr parameterExpr) {
            return null;
        }

        public Object visit(DimensionExpr dimensionExpr) {
            this.dimension = dimensionExpr.getDimension();
            return null;
        }

        public Object visit(HierarchyExpr hierarchyExpr) {
            Hierarchy hierarchy = hierarchyExpr.getHierarchy();
            this.dimension = hierarchy.getDimension();
            return null;
        }

        public Object visit(LevelExpr levelExpr) {
            return null;
        }

        public Object visit(MemberExpr memberExpr) {
            Member member = memberExpr.getMember();
            this.dimension = member.getHierarchy().getDimension();
            return null;
        }

        public Object visit(NamedSetExpr namedSetExpr) {
            return null;
        }

        public Object visit(Literal literal) {
            return null;
        }
    }
}

