/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Literal;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapNativeSql;
import mondrian.rolap.RolapStar;
import mondrian.rolap.sql.SqlQuery;

public class RolapNativeTopCount
extends RolapNativeSet {
    boolean ascending;

    public RolapNativeTopCount() {
        super.setEnabled(MondrianProperties.instance().EnableNativeTopCount.get());
    }

    protected boolean isStrict() {
        return true;
    }

    NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        if (!this.isEnabled()) {
            return null;
        }
        if (!TopCountConstraint.isValidContext(evaluator)) {
            return null;
        }
        String funName = fun.getName();
        if ("TopCount".equalsIgnoreCase(funName)) {
            this.ascending = false;
        } else if ("BottomCount".equalsIgnoreCase(funName)) {
            this.ascending = true;
        } else {
            return null;
        }
        if (args.length < 2 || args.length > 3) {
            return null;
        }
        RolapNativeSet.CrossJoinArg[] cargs = this.checkCrossJoinArg(args[0]);
        if (cargs == null) {
            return null;
        }
        if (this.isPreferInterpreter(cargs)) {
            return null;
        }
        if (!(args[1] instanceof Literal)) {
            return null;
        }
        int count = ((Literal)args[1]).getIntValue();
        SchemaReader schemaReader = evaluator.getSchemaReader();
        DataSource ds = schemaReader.getDataSource();
        SqlQuery sqlQuery = SqlQuery.newQuery(ds, "NativeTopCount");
        RolapNativeSql sql = new RolapNativeSql(sqlQuery);
        String orderByExpr = null;
        if (args.length == 3 && (orderByExpr = sql.generateTopCountOrderBy(args[2])) == null) {
            return null;
        }
        LOGGER.debug((Object)"using native topcount");
        evaluator = this.overrideContext(evaluator, cargs, sql.getStoredMeasure());
        TopCountConstraint constraint = new TopCountConstraint(cargs, evaluator, orderByExpr);
        RolapNativeSet.SetEvaluator sev = new RolapNativeSet.SetEvaluator(cargs, schemaReader, constraint);
        sev.setMaxRows(count);
        return sev;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TopCountConstraint
    extends RolapNativeSet.SetConstraint {
        String orderByExpr;

        public TopCountConstraint(RolapNativeSet.CrossJoinArg[] args, RolapEvaluator evaluator, String orderByExpr) {
            super(args, evaluator, true);
            this.orderByExpr = orderByExpr;
        }

        @Override
        protected boolean isJoinRequired() {
            return true;
        }

        @Override
        public void addConstraint(SqlQuery sqlQuery, Map<RolapLevel, RolapStar.Column> levelToColumnMap) {
            if (this.orderByExpr != null) {
                SqlQuery.Dialect dialect = sqlQuery.getDialect();
                if (dialect.requiresOrderByAlias()) {
                    String alias = sqlQuery.nextColumnAlias();
                    alias = dialect.quoteIdentifier(alias);
                    sqlQuery.addSelect(this.orderByExpr, alias);
                    sqlQuery.addOrderBy(alias, RolapNativeTopCount.this.ascending, true, false);
                } else {
                    sqlQuery.addOrderBy(this.orderByExpr, RolapNativeTopCount.this.ascending, true, false);
                }
            }
            super.addConstraint(sqlQuery, levelToColumnMap);
        }

        @Override
        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            key.add(this.orderByExpr);
            key.add(RolapNativeTopCount.this.ascending);
            return key;
        }
    }
}

