/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.Type;

public class TupleType
implements Type {
    public final Type[] elementTypes;

    public TupleType(Type[] elementTypes) {
        assert (elementTypes != null);
        this.elementTypes = (Type[])elementTypes.clone();
    }

    public boolean usesDimension(Dimension dimension, boolean maybe) {
        for (Type elementType : this.elementTypes) {
            if (!elementType.usesDimension(dimension, maybe)) continue;
            return true;
        }
        return false;
    }

    public Dimension getDimension() {
        throw new UnsupportedOperationException();
    }

    public Hierarchy getHierarchy() {
        throw new UnsupportedOperationException();
    }

    public Level getLevel() {
        throw new UnsupportedOperationException();
    }

    public Type getValueType() {
        for (Type elementType : this.elementTypes) {
            MemberType memberType;
            if (!(elementType instanceof MemberType) || !(memberType = (MemberType)elementType).getDimension().isMeasures()) continue;
            return memberType.getValueType();
        }
        return new ScalarType();
    }
}

