/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Literal;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Id
extends ExpBase
implements Cloneable {
    private final List<Segment> segments;

    public Id(Segment segment) {
        this.segments = Collections.singletonList(segment);
    }

    private Id(List<Segment> segments) {
        this.segments = segments;
    }

    @Override
    public Id clone() {
        return this;
    }

    @Override
    public int getCategory() {
        return 0;
    }

    @Override
    public Type getType() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return Util.quoteMdxIdentifier(this.toStringArray());
    }

    public String[] toStringArray() {
        String[] names = new String[this.segments.size()];
        int k = 0;
        for (Segment segment : this.segments) {
            names[k++] = segment.name;
        }
        return names;
    }

    public String getElement(int i) {
        return this.segments.get((int)i).name;
    }

    public Id append(Segment segment) {
        ArrayList<Segment> newSegments = new ArrayList<Segment>(this.segments);
        newSegments.add(segment);
        return new Id(newSegments);
    }

    @Override
    public Exp accept(Validator validator) {
        if (this.segments.size() == 1) {
            Segment s = this.segments.get(0);
            if (s.quoting == Quoting.UNQUOTED && validator.getFunTable().isReserved(s.name)) {
                return Literal.createSymbol(s.name.toUpperCase());
            }
        }
        String[] names = this.toStringArray();
        Exp element = Util.lookup(validator.getQuery(), names, true);
        if (element == null) {
            return null;
        }
        return element.accept(validator);
    }

    @Override
    public Object accept(MdxVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public void unparse(PrintWriter pw) {
        int k = 0;
        for (Segment s : this.segments) {
            if (k++ > 0) {
                pw.print(".");
            }
            switch (s.quoting) {
                case UNQUOTED: {
                    pw.print(s.name);
                    break;
                }
                case KEY: {
                    pw.print("&[" + Util.mdxEncodeString(s.name) + "]");
                    break;
                }
                case QUOTED: {
                    pw.print("[" + Util.mdxEncodeString(s.name) + "]");
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Quoting {
        UNQUOTED,
        QUOTED,
        KEY;

    }

    public static class Segment {
        public final String name;
        public final Quoting quoting;

        public Segment(String name, Quoting quoting) {
            this.name = name;
            this.quoting = quoting;
        }
    }
}

