/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.ResultModel;
import org.openide.nodes.Node;

final class ResultTreeModel
implements TreeModel {
    final ResultModel resultModel;
    private final TreePath rootPath;
    private String rootDisplayName;
    private boolean selected = true;
    private int objectsCount;
    private List<TreeModelListener> treeModelListeners;
    private final Task UPDATE_NAME_TASK = new Task();

    ResultTreeModel(ResultModel resultModel) {
        this.resultModel = resultModel;
        this.rootPath = new TreePath(this);
        if (resultModel != null) {
            resultModel.setObserver(this);
        }
    }

    public Object getRoot() {
        return this;
    }

    public Object getChild(Object object, int n) {
        MatchingObject matchingObject;
        assert (EventQueue.isDispatchThread());
        if (this.resultModel == null || n < 0) {
            return null;
        }
        if (object == this.getRoot()) {
            if (n >= this.objectsCount) {
                matchingObject = null;
            } else {
                try {
                    matchingObject = this.resultModel.matchingObjects.get(n);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    assert (false);
                    matchingObject = null;
                }
            }
        } else if (object.getClass() == MatchingObject.class) {
            if (this.resultModel.canHaveDetails() == Boolean.FALSE) {
                matchingObject = null;
            } else {
                Node[] nodeArray;
                MatchingObject matchingObject2 = (MatchingObject)object;
                Node[] nodeArray2 = nodeArray = this.resultModel.searchAndReplace ? this.resultModel.basicCriteria.getDetails(matchingObject2.object) : this.resultModel.getDetails(matchingObject2);
                matchingObject = nodeArray == null || n >= nodeArray.length ? null : nodeArray[n];
            }
        } else {
            matchingObject = null;
        }
        return matchingObject;
    }

    public int getChildCount(Object object) {
        assert (EventQueue.isDispatchThread());
        if (this.resultModel == null) {
            return 0;
        }
        int n = object == this.getRoot() ? this.objectsCount : (object.getClass() == MatchingObject.class ? (this.resultModel.searchAndReplace ? this.resultModel.basicCriteria.getDetailsCount(((MatchingObject)object).object) : (this.resultModel.canHaveDetails() == Boolean.FALSE ? 0 : this.resultModel.getDetailsCount((MatchingObject)object))) : 0);
        return n;
    }

    public boolean isLeaf(Object object) {
        Boolean bl;
        assert (EventQueue.isDispatchThread());
        boolean bl2 = object == this.getRoot() ? false : (object.getClass() == MatchingObject.class ? ((bl = this.resultModel.canHaveDetails()) != null ? bl == false : !this.resultModel.hasDetails((MatchingObject)object)) : true);
        return bl2;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        assert (EventQueue.isDispatchThread());
        assert (false);
    }

    public int getIndexOfChild(Object object, Object object2) {
        int n;
        assert (EventQueue.isDispatchThread());
        if (this.resultModel == null || object == null || object2 == null) {
            return -1;
        }
        if (object == this.getRoot()) {
            n = object2.getClass() == MatchingObject.class ? this.resultModel.matchingObjects.indexOf(object2) : -1;
        } else {
            n = -1;
            if (object.getClass() == MatchingObject.class && this.resultModel.canHaveDetails().booleanValue() && object2 instanceof Node) {
                Node[] nodeArray;
                MatchingObject matchingObject = (MatchingObject)object;
                Node[] nodeArray2 = nodeArray = this.resultModel.searchAndReplace ? this.resultModel.basicCriteria.getDetails(matchingObject.object) : this.resultModel.getDetails(matchingObject);
                if (nodeArray != null) {
                    for (int i = 0; i < nodeArray.length; ++i) {
                        if (!nodeArray[i].equals(object2)) continue;
                        n = i;
                        break;
                    }
                }
            }
        }
        return n;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        assert (EventQueue.isDispatchThread());
        if (treeModelListener == null) {
            throw new IllegalArgumentException("null");
        }
        if (this.treeModelListeners == null) {
            this.treeModelListeners = new ArrayList<TreeModelListener>(4);
        }
        this.treeModelListeners.add(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        assert (EventQueue.isDispatchThread());
        if (treeModelListener == null) {
            throw new IllegalArgumentException("null");
        }
        if (this.treeModelListeners != null) {
            this.treeModelListeners.remove(treeModelListener);
        }
    }

    void objectFound(MatchingObject matchingObject, int n) {
        if (this.resultModel == null) {
            throw new IllegalStateException("resultModel is null");
        }
        new Task(matchingObject, n).run();
    }

    void objectBecameInvalid(MatchingObject matchingObject) {
        if (this.resultModel == null) {
            throw new IllegalStateException("resultModel is null");
        }
        new Task(matchingObject).run();
    }

    String getRootDisplayName() {
        assert (EventQueue.isDispatchThread());
        return this.rootDisplayName;
    }

    void setRootDisplayName(String string) {
        assert (EventQueue.isDispatchThread());
        this.rootDisplayName = string;
        this.UPDATE_NAME_TASK.run();
    }

    boolean isSelected() {
        return this.selected;
    }

    void setSelected(boolean bl) {
        if (bl == this.selected) {
            return;
        }
        this.selected = bl;
    }

    private void fireNodeAdded(int n, MatchingObject matchingObject) {
        assert (EventQueue.isDispatchThread());
        if (this.treeModelListeners == null || this.treeModelListeners.isEmpty()) {
            return;
        }
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, this.rootPath, new int[]{n}, new Object[]{matchingObject});
        for (TreeModelListener treeModelListener : this.treeModelListeners) {
            treeModelListener.treeNodesInserted(treeModelEvent);
        }
    }

    private void fireNodeChanged(MatchingObject matchingObject) {
        assert (EventQueue.isDispatchThread());
        if (this.treeModelListeners == null || this.treeModelListeners.isEmpty()) {
            return;
        }
        TreePath treePath = this.rootPath.pathByAddingChild(matchingObject);
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        for (TreeModelListener treeModelListener : this.treeModelListeners) {
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }

    void fireRootNodeChanged() {
        assert (EventQueue.isDispatchThread());
        if (this.treeModelListeners == null || this.treeModelListeners.isEmpty()) {
            return;
        }
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, this.rootPath, null, null);
        for (TreeModelListener treeModelListener : this.treeModelListeners) {
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    void fireFileNodesSelectionChanged(int[] nArray, MatchingObject[] matchingObjectArray) {
        assert (EventQueue.isDispatchThread());
        assert (matchingObjectArray != null);
        assert (nArray != null);
        assert (matchingObjectArray.length == nArray.length);
        if (this.treeModelListeners == null || this.treeModelListeners.isEmpty()) {
            return;
        }
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, this.rootPath, nArray, (Object[])matchingObjectArray);
        for (TreeModelListener treeModelListener : this.treeModelListeners) {
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    void fireFileNodeSelectionChanged(MatchingObject matchingObject, boolean bl) {
        assert (EventQueue.isDispatchThread());
        if (this.treeModelListeners == null || this.treeModelListeners.isEmpty()) {
            return;
        }
        int n = this.resultModel.matchingObjects.indexOf(matchingObject);
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, this.rootPath, new int[]{n}, new Object[]{matchingObject});
        for (TreeModelListener treeModelListener : this.treeModelListeners) {
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
        if (bl) {
            this.fireFileNodeChildrenSelectionChanged(matchingObject);
        }
    }

    void fireFileNodeChildrenSelectionChanged(MatchingObject matchingObject) {
        Object[] objectArray = this.resultModel.basicCriteria.getDetails(matchingObject.object);
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.getRoot(), matchingObject}, nArray, objectArray);
        for (TreeModelListener treeModelListener : this.treeModelListeners) {
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    void fireDetailNodeSelectionChanged(MatchingObject matchingObject, int n) {
        Object[] objectArray;
        assert (EventQueue.isDispatchThread());
        if (this.treeModelListeners == null || this.treeModelListeners.isEmpty()) {
            return;
        }
        int[] nArray = new int[]{n};
        Object[] objectArray2 = this.resultModel.basicCriteria.getDetails(matchingObject.object);
        if (objectArray2.length == 1) {
            objectArray = objectArray2;
        } else {
            Node[] nodeArray = new Node[1];
            objectArray = nodeArray;
            nodeArray[0] = objectArray2[n];
        }
        Object[] objectArray3 = objectArray;
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.getRoot(), matchingObject}, nArray, objectArray3);
        for (TreeModelListener treeModelListener : this.treeModelListeners) {
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    public String toString() {
        return super.toString() + "[" + this.rootDisplayName + "]";
    }

    private final class Task
    implements Runnable {
        private final MatchingObject foundObject;
        private final int foundObjectIndex;

        private Task() {
            this.foundObject = null;
            this.foundObjectIndex = -1;
        }

        private Task(MatchingObject matchingObject) {
            this.foundObject = matchingObject;
            this.foundObjectIndex = -1;
        }

        private Task(MatchingObject matchingObject, int n) {
            assert (matchingObject != null && n >= 0);
            this.foundObject = matchingObject;
            this.foundObjectIndex = n;
        }

        public void run() {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(this);
                return;
            }
            assert (EventQueue.isDispatchThread());
            if (this.foundObject != null) {
                if (this.foundObjectIndex != -1) {
                    ResultTreeModel.this.objectsCount++;
                    ResultTreeModel.this.fireNodeAdded(this.foundObjectIndex, this.foundObject);
                } else {
                    ResultTreeModel.this.fireNodeChanged(this.foundObject);
                }
            } else {
                ResultTreeModel.this.fireRootNodeChanged();
            }
        }
    }
}

