/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentManager;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;

public class JRDesignComponentElement
extends JRDesignElement
implements JRComponentElement {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_COMPONENT = "component";
    public static final String PROPERTY_COMPONENT_KEY = "componentKey";
    private ComponentKey componentKey;
    private Component component;
    private transient JRPropertyChangeSupport eventSupport;

    public JRDesignComponentElement() {
        super(null);
    }

    public JRDesignComponentElement(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRDesignComponentElement jRDesignComponentElement = this;
        synchronized (jRDesignComponentElement) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        ComponentManager manager = ComponentsEnvironment.getComponentManager(this.componentKey);
        manager.getComponentCompiler().collectExpressions(this.component, collector);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitComponentElement(this);
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        Component old = this.component;
        this.component = component;
        this.getEventSupport().firePropertyChange(PROPERTY_COMPONENT, old, this.component);
    }

    public ComponentKey getComponentKey() {
        return this.componentKey;
    }

    public void setComponentKey(ComponentKey componentKey) {
        ComponentKey old = this.componentKey;
        this.componentKey = componentKey;
        this.getEventSupport().firePropertyChange(PROPERTY_COMPONENT_KEY, old, this.componentKey);
    }
}

